# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationMessageContent
    from . import ConversationMessageEvent
    from . import ConversationMessagingChannel
    from . import ConversationReason

class ConversationNormalizedMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationNormalizedMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'channel': 'ConversationMessagingChannel',
            'type': 'str',
            'text': 'str',
            'content': 'list[ConversationMessageContent]',
            'events': 'list[ConversationMessageEvent]',
            'status': 'str',
            'reasons': 'list[ConversationReason]',
            'originating_entity': 'str',
            'is_final_receipt': 'bool',
            'direction': 'str',
            'metadata': 'dict(str, str)',
            'byo_sms_integration_id': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'channel': 'channel',
            'type': 'type',
            'text': 'text',
            'content': 'content',
            'events': 'events',
            'status': 'status',
            'reasons': 'reasons',
            'originating_entity': 'originatingEntity',
            'is_final_receipt': 'isFinalReceipt',
            'direction': 'direction',
            'metadata': 'metadata',
            'byo_sms_integration_id': 'byoSmsIntegrationId'
        }

        self._id = None
        self._channel = None
        self._type = None
        self._text = None
        self._content = None
        self._events = None
        self._status = None
        self._reasons = None
        self._originating_entity = None
        self._is_final_receipt = None
        self._direction = None
        self._metadata = None
        self._byo_sms_integration_id = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ConversationNormalizedMessage.
        Unique ID of the message. Message receipts will have the same ID as the message they reference.

        :return: The id of this ConversationNormalizedMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ConversationNormalizedMessage.
        Unique ID of the message. Message receipts will have the same ID as the message they reference.

        :param id: The id of this ConversationNormalizedMessage.
        :type: str
        """
        

        self._id = id

    @property
    def channel(self) -> 'ConversationMessagingChannel':
        """
        Gets the channel of this ConversationNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :return: The channel of this ConversationNormalizedMessage.
        :rtype: ConversationMessagingChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel: 'ConversationMessagingChannel') -> None:
        """
        Sets the channel of this ConversationNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :param channel: The channel of this ConversationNormalizedMessage.
        :type: ConversationMessagingChannel
        """
        

        self._channel = channel

    @property
    def type(self) -> str:
        """
        Gets the type of this ConversationNormalizedMessage.
        Message type.

        :return: The type of this ConversationNormalizedMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ConversationNormalizedMessage.
        Message type.

        :param type: The type of this ConversationNormalizedMessage.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Text", "Structured", "Receipt", "Event", "Message", "Unknown"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def text(self) -> str:
        """
        Gets the text of this ConversationNormalizedMessage.
        Message text.

        :return: The text of this ConversationNormalizedMessage.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this ConversationNormalizedMessage.
        Message text.

        :param text: The text of this ConversationNormalizedMessage.
        :type: str
        """
        

        self._text = text

    @property
    def content(self) -> List['ConversationMessageContent']:
        """
        Gets the content of this ConversationNormalizedMessage.
        List of content elements.

        :return: The content of this ConversationNormalizedMessage.
        :rtype: list[ConversationMessageContent]
        """
        return self._content

    @content.setter
    def content(self, content: List['ConversationMessageContent']) -> None:
        """
        Sets the content of this ConversationNormalizedMessage.
        List of content elements.

        :param content: The content of this ConversationNormalizedMessage.
        :type: list[ConversationMessageContent]
        """
        

        self._content = content

    @property
    def events(self) -> List['ConversationMessageEvent']:
        """
        Gets the events of this ConversationNormalizedMessage.
        List of event elements.

        :return: The events of this ConversationNormalizedMessage.
        :rtype: list[ConversationMessageEvent]
        """
        return self._events

    @events.setter
    def events(self, events: List['ConversationMessageEvent']) -> None:
        """
        Sets the events of this ConversationNormalizedMessage.
        List of event elements.

        :param events: The events of this ConversationNormalizedMessage.
        :type: list[ConversationMessageEvent]
        """
        

        self._events = events

    @property
    def status(self) -> str:
        """
        Gets the status of this ConversationNormalizedMessage.
        Message receipt status, only used with type Receipt.

        :return: The status of this ConversationNormalizedMessage.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ConversationNormalizedMessage.
        Message receipt status, only used with type Receipt.

        :param status: The status of this ConversationNormalizedMessage.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Sent", "Delivered", "Read", "Failed", "Published", "Removed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def reasons(self) -> List['ConversationReason']:
        """
        Gets the reasons of this ConversationNormalizedMessage.
        List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.

        :return: The reasons of this ConversationNormalizedMessage.
        :rtype: list[ConversationReason]
        """
        return self._reasons

    @reasons.setter
    def reasons(self, reasons: List['ConversationReason']) -> None:
        """
        Sets the reasons of this ConversationNormalizedMessage.
        List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.

        :param reasons: The reasons of this ConversationNormalizedMessage.
        :type: list[ConversationReason]
        """
        

        self._reasons = reasons

    @property
    def originating_entity(self) -> str:
        """
        Gets the originating_entity of this ConversationNormalizedMessage.
        Specifies if this message was sent by a human agent or bot. The platform may use this to apply appropriate provider policies.

        :return: The originating_entity of this ConversationNormalizedMessage.
        :rtype: str
        """
        return self._originating_entity

    @originating_entity.setter
    def originating_entity(self, originating_entity: str) -> None:
        """
        Sets the originating_entity of this ConversationNormalizedMessage.
        Specifies if this message was sent by a human agent or bot. The platform may use this to apply appropriate provider policies.

        :param originating_entity: The originating_entity of this ConversationNormalizedMessage.
        :type: str
        """
        if isinstance(originating_entity, int):
            originating_entity = str(originating_entity)
        allowed_values = ["Human", "Bot"]
        if originating_entity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for originating_entity -> " + originating_entity)
            self._originating_entity = "outdated_sdk_version"
        else:
            self._originating_entity = originating_entity

    @property
    def is_final_receipt(self) -> bool:
        """
        Gets the is_final_receipt of this ConversationNormalizedMessage.
        Indicates if this is the last message receipt for this message, or if another message receipt can be expected.

        :return: The is_final_receipt of this ConversationNormalizedMessage.
        :rtype: bool
        """
        return self._is_final_receipt

    @is_final_receipt.setter
    def is_final_receipt(self, is_final_receipt: bool) -> None:
        """
        Sets the is_final_receipt of this ConversationNormalizedMessage.
        Indicates if this is the last message receipt for this message, or if another message receipt can be expected.

        :param is_final_receipt: The is_final_receipt of this ConversationNormalizedMessage.
        :type: bool
        """
        

        self._is_final_receipt = is_final_receipt

    @property
    def direction(self) -> str:
        """
        Gets the direction of this ConversationNormalizedMessage.
        The direction of the message.

        :return: The direction of this ConversationNormalizedMessage.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this ConversationNormalizedMessage.
        The direction of the message.

        :param direction: The direction of this ConversationNormalizedMessage.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["Inbound", "Outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def metadata(self) -> Dict[str, str]:
        """
        Gets the metadata of this ConversationNormalizedMessage.
        Additional metadata about this message.

        :return: The metadata of this ConversationNormalizedMessage.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: Dict[str, str]) -> None:
        """
        Sets the metadata of this ConversationNormalizedMessage.
        Additional metadata about this message.

        :param metadata: The metadata of this ConversationNormalizedMessage.
        :type: dict(str, str)
        """
        

        self._metadata = metadata

    @property
    def byo_sms_integration_id(self) -> str:
        """
        Gets the byo_sms_integration_id of this ConversationNormalizedMessage.
        The internal id representing the customer supplied sms integration message.

        :return: The byo_sms_integration_id of this ConversationNormalizedMessage.
        :rtype: str
        """
        return self._byo_sms_integration_id

    @byo_sms_integration_id.setter
    def byo_sms_integration_id(self, byo_sms_integration_id: str) -> None:
        """
        Sets the byo_sms_integration_id of this ConversationNormalizedMessage.
        The internal id representing the customer supplied sms integration message.

        :param byo_sms_integration_id: The byo_sms_integration_id of this ConversationNormalizedMessage.
        :type: str
        """
        

        self._byo_sms_integration_id = byo_sms_integration_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

