# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationEventTopicCall
    from . import ConversationEventTopicCallback
    from . import ConversationEventTopicChat
    from . import ConversationEventTopicCobrowse
    from . import ConversationEventTopicConversationRoutingData
    from . import ConversationEventTopicEmail
    from . import ConversationEventTopicMessage
    from . import ConversationEventTopicScreenshare
    from . import ConversationEventTopicSocialExpression
    from . import ConversationEventTopicVideo
    from . import ConversationEventTopicWorkflow
    from . import ConversationEventTopicWrapup

class ConversationEventTopicParticipant(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationEventTopicParticipant - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'connected_time': 'datetime',
            'end_time': 'datetime',
            'user_id': 'str',
            'external_contact_id': 'str',
            'external_organization_id': 'str',
            'name': 'str',
            'queue_id': 'str',
            'group_id': 'str',
            'team_id': 'str',
            'purpose': 'str',
            'consult_participant_id': 'str',
            'address': 'str',
            'wrapup_required': 'bool',
            'wrapup_expected': 'bool',
            'wrapup_prompt': 'str',
            'wrapup_timeout_ms': 'int',
            'wrapup': 'ConversationEventTopicWrapup',
            'start_acw_time': 'datetime',
            'end_acw_time': 'datetime',
            'conversation_routing_data': 'ConversationEventTopicConversationRoutingData',
            'alerting_timeout_ms': 'int',
            'monitored_participant_id': 'str',
            'coached_participant_id': 'str',
            'barged_participant_id': 'str',
            'media_roles': 'list[str]',
            'screen_recording_state': 'str',
            'flagged_reason': 'str',
            'attributes': 'dict(str, str)',
            'calls': 'list[ConversationEventTopicCall]',
            'callbacks': 'list[ConversationEventTopicCallback]',
            'chats': 'list[ConversationEventTopicChat]',
            'cobrowsesessions': 'list[ConversationEventTopicCobrowse]',
            'emails': 'list[ConversationEventTopicEmail]',
            'messages': 'list[ConversationEventTopicMessage]',
            'screenshares': 'list[ConversationEventTopicScreenshare]',
            'social_expressions': 'list[ConversationEventTopicSocialExpression]',
            'videos': 'list[ConversationEventTopicVideo]',
            'workflow': 'ConversationEventTopicWorkflow'
        }

        self.attribute_map = {
            'id': 'id',
            'connected_time': 'connectedTime',
            'end_time': 'endTime',
            'user_id': 'userId',
            'external_contact_id': 'externalContactId',
            'external_organization_id': 'externalOrganizationId',
            'name': 'name',
            'queue_id': 'queueId',
            'group_id': 'groupId',
            'team_id': 'teamId',
            'purpose': 'purpose',
            'consult_participant_id': 'consultParticipantId',
            'address': 'address',
            'wrapup_required': 'wrapupRequired',
            'wrapup_expected': 'wrapupExpected',
            'wrapup_prompt': 'wrapupPrompt',
            'wrapup_timeout_ms': 'wrapupTimeoutMs',
            'wrapup': 'wrapup',
            'start_acw_time': 'startAcwTime',
            'end_acw_time': 'endAcwTime',
            'conversation_routing_data': 'conversationRoutingData',
            'alerting_timeout_ms': 'alertingTimeoutMs',
            'monitored_participant_id': 'monitoredParticipantId',
            'coached_participant_id': 'coachedParticipantId',
            'barged_participant_id': 'bargedParticipantId',
            'media_roles': 'mediaRoles',
            'screen_recording_state': 'screenRecordingState',
            'flagged_reason': 'flaggedReason',
            'attributes': 'attributes',
            'calls': 'calls',
            'callbacks': 'callbacks',
            'chats': 'chats',
            'cobrowsesessions': 'cobrowsesessions',
            'emails': 'emails',
            'messages': 'messages',
            'screenshares': 'screenshares',
            'social_expressions': 'socialExpressions',
            'videos': 'videos',
            'workflow': 'workflow'
        }

        self._id = None
        self._connected_time = None
        self._end_time = None
        self._user_id = None
        self._external_contact_id = None
        self._external_organization_id = None
        self._name = None
        self._queue_id = None
        self._group_id = None
        self._team_id = None
        self._purpose = None
        self._consult_participant_id = None
        self._address = None
        self._wrapup_required = None
        self._wrapup_expected = None
        self._wrapup_prompt = None
        self._wrapup_timeout_ms = None
        self._wrapup = None
        self._start_acw_time = None
        self._end_acw_time = None
        self._conversation_routing_data = None
        self._alerting_timeout_ms = None
        self._monitored_participant_id = None
        self._coached_participant_id = None
        self._barged_participant_id = None
        self._media_roles = None
        self._screen_recording_state = None
        self._flagged_reason = None
        self._attributes = None
        self._calls = None
        self._callbacks = None
        self._chats = None
        self._cobrowsesessions = None
        self._emails = None
        self._messages = None
        self._screenshares = None
        self._social_expressions = None
        self._videos = None
        self._workflow = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ConversationEventTopicParticipant.
        A globally unique identifier for this conversation.

        :return: The id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ConversationEventTopicParticipant.
        A globally unique identifier for this conversation.

        :param id: The id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._id = id

    @property
    def connected_time(self) -> datetime:
        """
        Gets the connected_time of this ConversationEventTopicParticipant.
        The timestamp when this participant was connected to the conversation in the provider clock.

        :return: The connected_time of this ConversationEventTopicParticipant.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time: datetime) -> None:
        """
        Sets the connected_time of this ConversationEventTopicParticipant.
        The timestamp when this participant was connected to the conversation in the provider clock.

        :param connected_time: The connected_time of this ConversationEventTopicParticipant.
        :type: datetime
        """
        

        self._connected_time = connected_time

    @property
    def end_time(self) -> datetime:
        """
        Gets the end_time of this ConversationEventTopicParticipant.
        The timestamp when this participant disconnected from the conversation in the provider clock.

        :return: The end_time of this ConversationEventTopicParticipant.
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time: datetime) -> None:
        """
        Sets the end_time of this ConversationEventTopicParticipant.
        The timestamp when this participant disconnected from the conversation in the provider clock.

        :param end_time: The end_time of this ConversationEventTopicParticipant.
        :type: datetime
        """
        

        self._end_time = end_time

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this ConversationEventTopicParticipant.
        If this participant represents a user, then this will be the globally unique identifier for the user.

        :return: The user_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this ConversationEventTopicParticipant.
        If this participant represents a user, then this will be the globally unique identifier for the user.

        :param user_id: The user_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def external_contact_id(self) -> str:
        """
        Gets the external_contact_id of this ConversationEventTopicParticipant.
        If this participant represents an external contact, then this will be the globally unique identifier for the external contact.

        :return: The external_contact_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._external_contact_id

    @external_contact_id.setter
    def external_contact_id(self, external_contact_id: str) -> None:
        """
        Sets the external_contact_id of this ConversationEventTopicParticipant.
        If this participant represents an external contact, then this will be the globally unique identifier for the external contact.

        :param external_contact_id: The external_contact_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._external_contact_id = external_contact_id

    @property
    def external_organization_id(self) -> str:
        """
        Gets the external_organization_id of this ConversationEventTopicParticipant.
        If this participant represents an external org, then this will be the globally unique identifier for the external org.

        :return: The external_organization_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._external_organization_id

    @external_organization_id.setter
    def external_organization_id(self, external_organization_id: str) -> None:
        """
        Sets the external_organization_id of this ConversationEventTopicParticipant.
        If this participant represents an external org, then this will be the globally unique identifier for the external org.

        :param external_organization_id: The external_organization_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._external_organization_id = external_organization_id

    @property
    def name(self) -> str:
        """
        Gets the name of this ConversationEventTopicParticipant.
        A human readable name identifying the participant.

        :return: The name of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ConversationEventTopicParticipant.
        A human readable name identifying the participant.

        :param name: The name of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._name = name

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this ConversationEventTopicParticipant.
        If present, the queue id that the communication channel came in on.

        :return: The queue_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this ConversationEventTopicParticipant.
        If present, the queue id that the communication channel came in on.

        :param queue_id: The queue_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def group_id(self) -> str:
        """
        Gets the group_id of this ConversationEventTopicParticipant.
        If present, the group id that the participant represents.

        :return: The group_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id: str) -> None:
        """
        Sets the group_id of this ConversationEventTopicParticipant.
        If present, the group id that the participant represents.

        :param group_id: The group_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._group_id = group_id

    @property
    def team_id(self) -> str:
        """
        Gets the team_id of this ConversationEventTopicParticipant.
        The team id that this participant is a member of when added to the conversation.

        :return: The team_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._team_id

    @team_id.setter
    def team_id(self, team_id: str) -> None:
        """
        Sets the team_id of this ConversationEventTopicParticipant.
        The team id that this participant is a member of when added to the conversation.

        :param team_id: The team_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._team_id = team_id

    @property
    def purpose(self) -> str:
        """
        Gets the purpose of this ConversationEventTopicParticipant.
        A well known string that specifies the purpose or type of this participant.

        :return: The purpose of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose: str) -> None:
        """
        Sets the purpose of this ConversationEventTopicParticipant.
        A well known string that specifies the purpose or type of this participant.

        :param purpose: The purpose of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._purpose = purpose

    @property
    def consult_participant_id(self) -> str:
        """
        Gets the consult_participant_id of this ConversationEventTopicParticipant.
        If this participant is part of a consult transfer, then this will be the participant id of the participant being transferred.

        :return: The consult_participant_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._consult_participant_id

    @consult_participant_id.setter
    def consult_participant_id(self, consult_participant_id: str) -> None:
        """
        Sets the consult_participant_id of this ConversationEventTopicParticipant.
        If this participant is part of a consult transfer, then this will be the participant id of the participant being transferred.

        :param consult_participant_id: The consult_participant_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._consult_participant_id = consult_participant_id

    @property
    def address(self) -> str:
        """
        Gets the address of this ConversationEventTopicParticipant.
        The address for the this participant. For a phone call this will be the ANI.

        :return: The address of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str) -> None:
        """
        Sets the address of this ConversationEventTopicParticipant.
        The address for the this participant. For a phone call this will be the ANI.

        :param address: The address of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._address = address

    @property
    def wrapup_required(self) -> bool:
        """
        Gets the wrapup_required of this ConversationEventTopicParticipant.
        True iff this participant is required to enter wrapup for this conversation.

        :return: The wrapup_required of this ConversationEventTopicParticipant.
        :rtype: bool
        """
        return self._wrapup_required

    @wrapup_required.setter
    def wrapup_required(self, wrapup_required: bool) -> None:
        """
        Sets the wrapup_required of this ConversationEventTopicParticipant.
        True iff this participant is required to enter wrapup for this conversation.

        :param wrapup_required: The wrapup_required of this ConversationEventTopicParticipant.
        :type: bool
        """
        

        self._wrapup_required = wrapup_required

    @property
    def wrapup_expected(self) -> bool:
        """
        Gets the wrapup_expected of this ConversationEventTopicParticipant.
        True when a participant is expected to enter a wrapup code once the call connects.

        :return: The wrapup_expected of this ConversationEventTopicParticipant.
        :rtype: bool
        """
        return self._wrapup_expected

    @wrapup_expected.setter
    def wrapup_expected(self, wrapup_expected: bool) -> None:
        """
        Sets the wrapup_expected of this ConversationEventTopicParticipant.
        True when a participant is expected to enter a wrapup code once the call connects.

        :param wrapup_expected: The wrapup_expected of this ConversationEventTopicParticipant.
        :type: bool
        """
        

        self._wrapup_expected = wrapup_expected

    @property
    def wrapup_prompt(self) -> str:
        """
        Gets the wrapup_prompt of this ConversationEventTopicParticipant.
        This field controls how the UI prompts the agent for a wrapup.

        :return: The wrapup_prompt of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._wrapup_prompt

    @wrapup_prompt.setter
    def wrapup_prompt(self, wrapup_prompt: str) -> None:
        """
        Sets the wrapup_prompt of this ConversationEventTopicParticipant.
        This field controls how the UI prompts the agent for a wrapup.

        :param wrapup_prompt: The wrapup_prompt of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._wrapup_prompt = wrapup_prompt

    @property
    def wrapup_timeout_ms(self) -> int:
        """
        Gets the wrapup_timeout_ms of this ConversationEventTopicParticipant.
        Specifies how long a timed ACW session will last.

        :return: The wrapup_timeout_ms of this ConversationEventTopicParticipant.
        :rtype: int
        """
        return self._wrapup_timeout_ms

    @wrapup_timeout_ms.setter
    def wrapup_timeout_ms(self, wrapup_timeout_ms: int) -> None:
        """
        Sets the wrapup_timeout_ms of this ConversationEventTopicParticipant.
        Specifies how long a timed ACW session will last.

        :param wrapup_timeout_ms: The wrapup_timeout_ms of this ConversationEventTopicParticipant.
        :type: int
        """
        

        self._wrapup_timeout_ms = wrapup_timeout_ms

    @property
    def wrapup(self) -> 'ConversationEventTopicWrapup':
        """
        Gets the wrapup of this ConversationEventTopicParticipant.


        :return: The wrapup of this ConversationEventTopicParticipant.
        :rtype: ConversationEventTopicWrapup
        """
        return self._wrapup

    @wrapup.setter
    def wrapup(self, wrapup: 'ConversationEventTopicWrapup') -> None:
        """
        Sets the wrapup of this ConversationEventTopicParticipant.


        :param wrapup: The wrapup of this ConversationEventTopicParticipant.
        :type: ConversationEventTopicWrapup
        """
        

        self._wrapup = wrapup

    @property
    def start_acw_time(self) -> datetime:
        """
        Gets the start_acw_time of this ConversationEventTopicParticipant.
        The timestamp when this participant started after-call work.

        :return: The start_acw_time of this ConversationEventTopicParticipant.
        :rtype: datetime
        """
        return self._start_acw_time

    @start_acw_time.setter
    def start_acw_time(self, start_acw_time: datetime) -> None:
        """
        Sets the start_acw_time of this ConversationEventTopicParticipant.
        The timestamp when this participant started after-call work.

        :param start_acw_time: The start_acw_time of this ConversationEventTopicParticipant.
        :type: datetime
        """
        

        self._start_acw_time = start_acw_time

    @property
    def end_acw_time(self) -> datetime:
        """
        Gets the end_acw_time of this ConversationEventTopicParticipant.
        The timestamp when this participant ended after-call work.

        :return: The end_acw_time of this ConversationEventTopicParticipant.
        :rtype: datetime
        """
        return self._end_acw_time

    @end_acw_time.setter
    def end_acw_time(self, end_acw_time: datetime) -> None:
        """
        Sets the end_acw_time of this ConversationEventTopicParticipant.
        The timestamp when this participant ended after-call work.

        :param end_acw_time: The end_acw_time of this ConversationEventTopicParticipant.
        :type: datetime
        """
        

        self._end_acw_time = end_acw_time

    @property
    def conversation_routing_data(self) -> 'ConversationEventTopicConversationRoutingData':
        """
        Gets the conversation_routing_data of this ConversationEventTopicParticipant.


        :return: The conversation_routing_data of this ConversationEventTopicParticipant.
        :rtype: ConversationEventTopicConversationRoutingData
        """
        return self._conversation_routing_data

    @conversation_routing_data.setter
    def conversation_routing_data(self, conversation_routing_data: 'ConversationEventTopicConversationRoutingData') -> None:
        """
        Sets the conversation_routing_data of this ConversationEventTopicParticipant.


        :param conversation_routing_data: The conversation_routing_data of this ConversationEventTopicParticipant.
        :type: ConversationEventTopicConversationRoutingData
        """
        

        self._conversation_routing_data = conversation_routing_data

    @property
    def alerting_timeout_ms(self) -> int:
        """
        Gets the alerting_timeout_ms of this ConversationEventTopicParticipant.
        Specifies how long the agent has to answer an interaction before being marked as not responding.

        :return: The alerting_timeout_ms of this ConversationEventTopicParticipant.
        :rtype: int
        """
        return self._alerting_timeout_ms

    @alerting_timeout_ms.setter
    def alerting_timeout_ms(self, alerting_timeout_ms: int) -> None:
        """
        Sets the alerting_timeout_ms of this ConversationEventTopicParticipant.
        Specifies how long the agent has to answer an interaction before being marked as not responding.

        :param alerting_timeout_ms: The alerting_timeout_ms of this ConversationEventTopicParticipant.
        :type: int
        """
        

        self._alerting_timeout_ms = alerting_timeout_ms

    @property
    def monitored_participant_id(self) -> str:
        """
        Gets the monitored_participant_id of this ConversationEventTopicParticipant.
        If this participant is a monitor, then this will be the id of the participant that is being monitored.

        :return: The monitored_participant_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._monitored_participant_id

    @monitored_participant_id.setter
    def monitored_participant_id(self, monitored_participant_id: str) -> None:
        """
        Sets the monitored_participant_id of this ConversationEventTopicParticipant.
        If this participant is a monitor, then this will be the id of the participant that is being monitored.

        :param monitored_participant_id: The monitored_participant_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._monitored_participant_id = monitored_participant_id

    @property
    def coached_participant_id(self) -> str:
        """
        Gets the coached_participant_id of this ConversationEventTopicParticipant.
        If this participant is a coach, then this will be the id of the participant that is being coached.

        :return: The coached_participant_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._coached_participant_id

    @coached_participant_id.setter
    def coached_participant_id(self, coached_participant_id: str) -> None:
        """
        Sets the coached_participant_id of this ConversationEventTopicParticipant.
        If this participant is a coach, then this will be the id of the participant that is being coached.

        :param coached_participant_id: The coached_participant_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._coached_participant_id = coached_participant_id

    @property
    def barged_participant_id(self) -> str:
        """
        Gets the barged_participant_id of this ConversationEventTopicParticipant.
        If this participant created a barge in conference, then this will be the id of the participant that is barged in.

        :return: The barged_participant_id of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._barged_participant_id

    @barged_participant_id.setter
    def barged_participant_id(self, barged_participant_id: str) -> None:
        """
        Sets the barged_participant_id of this ConversationEventTopicParticipant.
        If this participant created a barge in conference, then this will be the id of the participant that is barged in.

        :param barged_participant_id: The barged_participant_id of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._barged_participant_id = barged_participant_id

    @property
    def media_roles(self) -> List[str]:
        """
        Gets the media_roles of this ConversationEventTopicParticipant.
        List of roles this participant's media has had on the conversation, ie monitor, coach, etc.

        :return: The media_roles of this ConversationEventTopicParticipant.
        :rtype: list[str]
        """
        return self._media_roles

    @media_roles.setter
    def media_roles(self, media_roles: List[str]) -> None:
        """
        Sets the media_roles of this ConversationEventTopicParticipant.
        List of roles this participant's media has had on the conversation, ie monitor, coach, etc.

        :param media_roles: The media_roles of this ConversationEventTopicParticipant.
        :type: list[str]
        """
        

        self._media_roles = media_roles

    @property
    def screen_recording_state(self) -> str:
        """
        Gets the screen_recording_state of this ConversationEventTopicParticipant.
        The current screen recording state for this participant.

        :return: The screen_recording_state of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._screen_recording_state

    @screen_recording_state.setter
    def screen_recording_state(self, screen_recording_state: str) -> None:
        """
        Sets the screen_recording_state of this ConversationEventTopicParticipant.
        The current screen recording state for this participant.

        :param screen_recording_state: The screen_recording_state of this ConversationEventTopicParticipant.
        :type: str
        """
        if isinstance(screen_recording_state, int):
            screen_recording_state = str(screen_recording_state)
        allowed_values = ["requested", "active", "paused", "stopped", "error", "timeout"]
        if screen_recording_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for screen_recording_state -> " + screen_recording_state)
            self._screen_recording_state = "outdated_sdk_version"
        else:
            self._screen_recording_state = screen_recording_state

    @property
    def flagged_reason(self) -> str:
        """
        Gets the flagged_reason of this ConversationEventTopicParticipant.
        If this participant has flagged the conversation, the reason code given.

        :return: The flagged_reason of this ConversationEventTopicParticipant.
        :rtype: str
        """
        return self._flagged_reason

    @flagged_reason.setter
    def flagged_reason(self, flagged_reason: str) -> None:
        """
        Sets the flagged_reason of this ConversationEventTopicParticipant.
        If this participant has flagged the conversation, the reason code given.

        :param flagged_reason: The flagged_reason of this ConversationEventTopicParticipant.
        :type: str
        """
        

        self._flagged_reason = flagged_reason

    @property
    def attributes(self) -> Dict[str, str]:
        """
        Gets the attributes of this ConversationEventTopicParticipant.
        Additional participant attributes

        :return: The attributes of this ConversationEventTopicParticipant.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, str]) -> None:
        """
        Sets the attributes of this ConversationEventTopicParticipant.
        Additional participant attributes

        :param attributes: The attributes of this ConversationEventTopicParticipant.
        :type: dict(str, str)
        """
        

        self._attributes = attributes

    @property
    def calls(self) -> List['ConversationEventTopicCall']:
        """
        Gets the calls of this ConversationEventTopicParticipant.


        :return: The calls of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicCall]
        """
        return self._calls

    @calls.setter
    def calls(self, calls: List['ConversationEventTopicCall']) -> None:
        """
        Sets the calls of this ConversationEventTopicParticipant.


        :param calls: The calls of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicCall]
        """
        

        self._calls = calls

    @property
    def callbacks(self) -> List['ConversationEventTopicCallback']:
        """
        Gets the callbacks of this ConversationEventTopicParticipant.


        :return: The callbacks of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicCallback]
        """
        return self._callbacks

    @callbacks.setter
    def callbacks(self, callbacks: List['ConversationEventTopicCallback']) -> None:
        """
        Sets the callbacks of this ConversationEventTopicParticipant.


        :param callbacks: The callbacks of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicCallback]
        """
        

        self._callbacks = callbacks

    @property
    def chats(self) -> List['ConversationEventTopicChat']:
        """
        Gets the chats of this ConversationEventTopicParticipant.


        :return: The chats of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicChat]
        """
        return self._chats

    @chats.setter
    def chats(self, chats: List['ConversationEventTopicChat']) -> None:
        """
        Sets the chats of this ConversationEventTopicParticipant.


        :param chats: The chats of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicChat]
        """
        

        self._chats = chats

    @property
    def cobrowsesessions(self) -> List['ConversationEventTopicCobrowse']:
        """
        Gets the cobrowsesessions of this ConversationEventTopicParticipant.


        :return: The cobrowsesessions of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicCobrowse]
        """
        return self._cobrowsesessions

    @cobrowsesessions.setter
    def cobrowsesessions(self, cobrowsesessions: List['ConversationEventTopicCobrowse']) -> None:
        """
        Sets the cobrowsesessions of this ConversationEventTopicParticipant.


        :param cobrowsesessions: The cobrowsesessions of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicCobrowse]
        """
        

        self._cobrowsesessions = cobrowsesessions

    @property
    def emails(self) -> List['ConversationEventTopicEmail']:
        """
        Gets the emails of this ConversationEventTopicParticipant.


        :return: The emails of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicEmail]
        """
        return self._emails

    @emails.setter
    def emails(self, emails: List['ConversationEventTopicEmail']) -> None:
        """
        Sets the emails of this ConversationEventTopicParticipant.


        :param emails: The emails of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicEmail]
        """
        

        self._emails = emails

    @property
    def messages(self) -> List['ConversationEventTopicMessage']:
        """
        Gets the messages of this ConversationEventTopicParticipant.


        :return: The messages of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicMessage]
        """
        return self._messages

    @messages.setter
    def messages(self, messages: List['ConversationEventTopicMessage']) -> None:
        """
        Sets the messages of this ConversationEventTopicParticipant.


        :param messages: The messages of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicMessage]
        """
        

        self._messages = messages

    @property
    def screenshares(self) -> List['ConversationEventTopicScreenshare']:
        """
        Gets the screenshares of this ConversationEventTopicParticipant.


        :return: The screenshares of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicScreenshare]
        """
        return self._screenshares

    @screenshares.setter
    def screenshares(self, screenshares: List['ConversationEventTopicScreenshare']) -> None:
        """
        Sets the screenshares of this ConversationEventTopicParticipant.


        :param screenshares: The screenshares of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicScreenshare]
        """
        

        self._screenshares = screenshares

    @property
    def social_expressions(self) -> List['ConversationEventTopicSocialExpression']:
        """
        Gets the social_expressions of this ConversationEventTopicParticipant.


        :return: The social_expressions of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicSocialExpression]
        """
        return self._social_expressions

    @social_expressions.setter
    def social_expressions(self, social_expressions: List['ConversationEventTopicSocialExpression']) -> None:
        """
        Sets the social_expressions of this ConversationEventTopicParticipant.


        :param social_expressions: The social_expressions of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicSocialExpression]
        """
        

        self._social_expressions = social_expressions

    @property
    def videos(self) -> List['ConversationEventTopicVideo']:
        """
        Gets the videos of this ConversationEventTopicParticipant.


        :return: The videos of this ConversationEventTopicParticipant.
        :rtype: list[ConversationEventTopicVideo]
        """
        return self._videos

    @videos.setter
    def videos(self, videos: List['ConversationEventTopicVideo']) -> None:
        """
        Sets the videos of this ConversationEventTopicParticipant.


        :param videos: The videos of this ConversationEventTopicParticipant.
        :type: list[ConversationEventTopicVideo]
        """
        

        self._videos = videos

    @property
    def workflow(self) -> 'ConversationEventTopicWorkflow':
        """
        Gets the workflow of this ConversationEventTopicParticipant.


        :return: The workflow of this ConversationEventTopicParticipant.
        :rtype: ConversationEventTopicWorkflow
        """
        return self._workflow

    @workflow.setter
    def workflow(self, workflow: 'ConversationEventTopicWorkflow') -> None:
        """
        Sets the workflow of this ConversationEventTopicParticipant.


        :param workflow: The workflow of this ConversationEventTopicParticipant.
        :type: ConversationEventTopicWorkflow
        """
        

        self._workflow = workflow

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

