# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AuthzDivision(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AuthzDivision - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'home_division': 'bool',
            'object_counts': 'dict(str, int)',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'home_division': 'homeDivision',
            'object_counts': 'objectCounts',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._home_division = None
        self._object_counts = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this AuthzDivision.
        The globally unique identifier for the object.

        :return: The id of this AuthzDivision.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this AuthzDivision.
        The globally unique identifier for the object.

        :param id: The id of this AuthzDivision.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this AuthzDivision.


        :return: The name of this AuthzDivision.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this AuthzDivision.


        :param name: The name of this AuthzDivision.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this AuthzDivision.
        A helpful description for the division.

        :return: The description of this AuthzDivision.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this AuthzDivision.
        A helpful description for the division.

        :param description: The description of this AuthzDivision.
        :type: str
        """
        

        self._description = description

    @property
    def home_division(self) -> bool:
        """
        Gets the home_division of this AuthzDivision.
        A flag indicating whether this division is the \"Home\" (default) division. Cannot be modified and any supplied value will be ignored on create or update.

        :return: The home_division of this AuthzDivision.
        :rtype: bool
        """
        return self._home_division

    @home_division.setter
    def home_division(self, home_division: bool) -> None:
        """
        Sets the home_division of this AuthzDivision.
        A flag indicating whether this division is the \"Home\" (default) division. Cannot be modified and any supplied value will be ignored on create or update.

        :param home_division: The home_division of this AuthzDivision.
        :type: bool
        """
        

        self._home_division = home_division

    @property
    def object_counts(self) -> Dict[str, int]:
        """
        Gets the object_counts of this AuthzDivision.
        A count of objects in this division, grouped by type.

        :return: The object_counts of this AuthzDivision.
        :rtype: dict(str, int)
        """
        return self._object_counts

    @object_counts.setter
    def object_counts(self, object_counts: Dict[str, int]) -> None:
        """
        Sets the object_counts of this AuthzDivision.
        A count of objects in this division, grouped by type.

        :param object_counts: The object_counts of this AuthzDivision.
        :type: dict(str, int)
        """
        

        self._object_counts = object_counts

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this AuthzDivision.
        The URI for this object

        :return: The self_uri of this AuthzDivision.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this AuthzDivision.
        The URI for this object

        :param self_uri: The self_uri of this AuthzDivision.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

