# coding: utf-8

"""
WebDeploymentsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import CobrowseWebMessagingSession
from ..models import ErrorBody
from ..models import ExpandableWebDeploymentEntityListing
from ..models import SignedData
from ..models import WebDeployment
from ..models import WebDeploymentActiveConfigurationOnDeployment
from ..models import WebDeploymentConfigurationVersion
from ..models import WebDeploymentConfigurationVersionEntityListing
from ..models import WebDeploymentsAuthorizationResponse
from ..models import WebDeploymentsOAuthExchangeRequest
from ..models import WebDeploymentsRefreshJWTRequest

class WebDeploymentsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_webdeployments_configuration(self, configuration_id: str, **kwargs) -> None:
        """
        Delete all versions of a configuration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_webdeployments_configuration(configuration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str configuration_id: The configuration version ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webdeployments_configuration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'configuration_id' is set
        if ('configuration_id' not in params) or (params['configuration_id'] is None):
            raise ValueError("Missing the required parameter `configuration_id` when calling `delete_webdeployments_configuration`")


        resource_path = '/api/v2/webdeployments/configurations/{configurationId}'.replace('{format}', 'json')
        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_webdeployments_deployment(self, deployment_id: str, **kwargs) -> None:
        """
        Delete a deployment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_webdeployments_deployment(deployment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The deployment ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webdeployments_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `delete_webdeployments_deployment`")


        resource_path = '/api/v2/webdeployments/deployments/{deploymentId}'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_webdeployments_deployment_cobrowse_session_id(self, deployment_id: str, session_id: str, **kwargs) -> object:
        """
        Deletes a cobrowse session
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_webdeployments_deployment_cobrowse_session_id(deployment_id, session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: WebMessaging deployment ID (required)
        :param str session_id: Cobrowse session id or join code (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'session_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webdeployments_deployment_cobrowse_session_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `delete_webdeployments_deployment_cobrowse_session_id`")
        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `delete_webdeployments_deployment_cobrowse_session_id`")


        resource_path = '/api/v2/webdeployments/deployments/{deploymentId}/cobrowse/{sessionId}'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_webdeployments_token_revoke(self, **kwargs) -> None:
        """
        Invalidate JWT
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_webdeployments_token_revoke(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str x_journey_session_id: The Customer's journey sessionId.
        :param str x_journey_session_type: The Customer's journey session type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_journey_session_id', 'x_journey_session_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webdeployments_token_revoke" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/webdeployments/token/revoke'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_journey_session_id' in params:
            header_params['X-Journey-Session-Id'] = params['x_journey_session_id']
        if 'x_journey_session_type' in params:
            header_params['X-Journey-Session-Type'] = params['x_journey_session_type']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_configuration_version(self, configuration_id: str, version_id: str, **kwargs) -> 'WebDeploymentConfigurationVersion':
        """
        Get a configuration version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_configuration_version(configuration_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str configuration_id: The configuration version ID (required)
        :param str version_id: The version of the configuration to get (required)
        :return: WebDeploymentConfigurationVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_configuration_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'configuration_id' is set
        if ('configuration_id' not in params) or (params['configuration_id'] is None):
            raise ValueError("Missing the required parameter `configuration_id` when calling `get_webdeployments_configuration_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_webdeployments_configuration_version`")


        resource_path = '/api/v2/webdeployments/configurations/{configurationId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentConfigurationVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_configuration_versions(self, configuration_id: str, **kwargs) -> 'WebDeploymentConfigurationVersionEntityListing':
        """
        Get the versions of a configuration
        This returns the 50 most recent versions for this configuration

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_configuration_versions(configuration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str configuration_id: The configuration version ID (required)
        :return: WebDeploymentConfigurationVersionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_configuration_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'configuration_id' is set
        if ('configuration_id' not in params) or (params['configuration_id'] is None):
            raise ValueError("Missing the required parameter `configuration_id` when calling `get_webdeployments_configuration_versions`")


        resource_path = '/api/v2/webdeployments/configurations/{configurationId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentConfigurationVersionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_configuration_versions_draft(self, configuration_id: str, **kwargs) -> 'WebDeploymentConfigurationVersion':
        """
        Get the configuration draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_configuration_versions_draft(configuration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str configuration_id: The configuration version ID (required)
        :return: WebDeploymentConfigurationVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_configuration_versions_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'configuration_id' is set
        if ('configuration_id' not in params) or (params['configuration_id'] is None):
            raise ValueError("Missing the required parameter `configuration_id` when calling `get_webdeployments_configuration_versions_draft`")


        resource_path = '/api/v2/webdeployments/configurations/{configurationId}/versions/draft'.replace('{format}', 'json')
        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentConfigurationVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_configurations(self, **kwargs) -> 'WebDeploymentConfigurationVersionEntityListing':
        """
        View configuration drafts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_configurations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool show_only_published: Get only configuration drafts with published versions
        :return: WebDeploymentConfigurationVersionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['show_only_published']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_configurations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/webdeployments/configurations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'show_only_published' in params:
            query_params['showOnlyPublished'] = params['show_only_published']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentConfigurationVersionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_deployment(self, deployment_id: str, **kwargs) -> 'WebDeployment':
        """
        Get a deployment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_deployment(deployment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The deployment ID (required)
        :return: WebDeployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `get_webdeployments_deployment`")


        resource_path = '/api/v2/webdeployments/deployments/{deploymentId}'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_deployment_cobrowse_session_id(self, deployment_id: str, session_id: str, **kwargs) -> 'CobrowseWebMessagingSession':
        """
        Retrieves a cobrowse session
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_deployment_cobrowse_session_id(deployment_id, session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: WebMessaging deployment ID (required)
        :param str session_id: Cobrowse session id or join code (required)
        :return: CobrowseWebMessagingSession
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'session_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_deployment_cobrowse_session_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `get_webdeployments_deployment_cobrowse_session_id`")
        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_webdeployments_deployment_cobrowse_session_id`")


        resource_path = '/api/v2/webdeployments/deployments/{deploymentId}/cobrowse/{sessionId}'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CobrowseWebMessagingSession',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_deployment_configurations(self, deployment_id: str, **kwargs) -> 'WebDeploymentActiveConfigurationOnDeployment':
        """
        Get active configuration for a given deployment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_deployment_configurations(deployment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The deployment ID (required)
        :param str type: Get active configuration on a deployment
        :return: WebDeploymentActiveConfigurationOnDeployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_deployment_configurations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `get_webdeployments_deployment_configurations`")


        resource_path = '/api/v2/webdeployments/deployments/{deploymentId}/configurations'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentActiveConfigurationOnDeployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_webdeployments_deployments(self, **kwargs) -> 'ExpandableWebDeploymentEntityListing':
        """
        Get deployments
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webdeployments_deployments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] expand: The specified entity attributes will be filled. Comma separated values expected. Valid values:
        :return: ExpandableWebDeploymentEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webdeployments_deployments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/webdeployments/deployments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExpandableWebDeploymentEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_webdeployments_configuration_versions_draft_publish(self, configuration_id: str, **kwargs) -> 'WebDeploymentConfigurationVersion':
        """
        Publish the configuration draft and create a new version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_webdeployments_configuration_versions_draft_publish(configuration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str configuration_id: The configuration version ID (required)
        :return: WebDeploymentConfigurationVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_webdeployments_configuration_versions_draft_publish" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'configuration_id' is set
        if ('configuration_id' not in params) or (params['configuration_id'] is None):
            raise ValueError("Missing the required parameter `configuration_id` when calling `post_webdeployments_configuration_versions_draft_publish`")


        resource_path = '/api/v2/webdeployments/configurations/{configurationId}/versions/draft/publish'.replace('{format}', 'json')
        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentConfigurationVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_webdeployments_configurations(self, configuration_version: 'WebDeploymentConfigurationVersion', **kwargs) -> 'WebDeploymentConfigurationVersion':
        """
        Create a configuration draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_webdeployments_configurations(configuration_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WebDeploymentConfigurationVersion configuration_version:  (required)
        :return: WebDeploymentConfigurationVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_webdeployments_configurations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'configuration_version' is set
        if ('configuration_version' not in params) or (params['configuration_version'] is None):
            raise ValueError("Missing the required parameter `configuration_version` when calling `post_webdeployments_configurations`")


        resource_path = '/api/v2/webdeployments/configurations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'configuration_version' in params:
            body_params = params['configuration_version']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentConfigurationVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_webdeployments_deployments(self, deployment: 'WebDeployment', **kwargs) -> 'WebDeployment':
        """
        Create a deployment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_webdeployments_deployments(deployment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WebDeployment deployment:  (required)
        :return: WebDeployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_webdeployments_deployments" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment' is set
        if ('deployment' not in params) or (params['deployment'] is None):
            raise ValueError("Missing the required parameter `deployment` when calling `post_webdeployments_deployments`")


        resource_path = '/api/v2/webdeployments/deployments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'deployment' in params:
            body_params = params['deployment']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_webdeployments_token_oauthcodegrantjwtexchange(self, body: 'WebDeploymentsOAuthExchangeRequest', **kwargs) -> 'WebDeploymentsAuthorizationResponse':
        """
        Exchange an oAuth code (obtained using the Authorization Code Flow) for a JWT that can be used by webdeployments.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_webdeployments_token_oauthcodegrantjwtexchange(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WebDeploymentsOAuthExchangeRequest body: webDeploymentsOAuthExchangeRequest (required)
        :return: WebDeploymentsAuthorizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_webdeployments_token_oauthcodegrantjwtexchange" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_webdeployments_token_oauthcodegrantjwtexchange`")


        resource_path = '/api/v2/webdeployments/token/oauthcodegrantjwtexchange'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentsAuthorizationResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_webdeployments_token_refresh(self, **kwargs) -> 'SignedData':
        """
        Refresh a JWT.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_webdeployments_token_refresh(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WebDeploymentsRefreshJWTRequest body: 
        :return: SignedData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_webdeployments_token_refresh" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/webdeployments/token/refresh'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SignedData',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_webdeployments_configuration_versions_draft(self, configuration_id: str, configuration_version: 'WebDeploymentConfigurationVersion', **kwargs) -> 'WebDeploymentConfigurationVersion':
        """
        Update the configuration draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_webdeployments_configuration_versions_draft(configuration_id, configuration_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str configuration_id: The configuration version ID (required)
        :param WebDeploymentConfigurationVersion configuration_version:  (required)
        :return: WebDeploymentConfigurationVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_id', 'configuration_version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_webdeployments_configuration_versions_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'configuration_id' is set
        if ('configuration_id' not in params) or (params['configuration_id'] is None):
            raise ValueError("Missing the required parameter `configuration_id` when calling `put_webdeployments_configuration_versions_draft`")
        # verify the required parameter 'configuration_version' is set
        if ('configuration_version' not in params) or (params['configuration_version'] is None):
            raise ValueError("Missing the required parameter `configuration_version` when calling `put_webdeployments_configuration_versions_draft`")


        resource_path = '/api/v2/webdeployments/configurations/{configurationId}/versions/draft'.replace('{format}', 'json')
        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'configuration_version' in params:
            body_params = params['configuration_version']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeploymentConfigurationVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_webdeployments_deployment(self, deployment_id: str, deployment: 'WebDeployment', **kwargs) -> 'WebDeployment':
        """
        Update a deployment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_webdeployments_deployment(deployment_id, deployment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The deployment ID (required)
        :param WebDeployment deployment:  (required)
        :return: WebDeployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'deployment']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_webdeployments_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `put_webdeployments_deployment`")
        # verify the required parameter 'deployment' is set
        if ('deployment' not in params) or (params['deployment'] is None):
            raise ValueError("Missing the required parameter `deployment` when calling `put_webdeployments_deployment`")


        resource_path = '/api/v2/webdeployments/deployments/{deploymentId}'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'deployment' in params:
            body_params = params['deployment']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebDeployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
