"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Request objects will be assigned when a request of the relevant type will be
 * made.
 */
exports.actualRequest = {};
/**
 * Responses can be simulated by assigning values here.
 */
exports.simulateResponse = {};
function reset() {
    exports.actualRequest = {};
    exports.simulateResponse = {};
}
exports.reset = reset;
exports.MOCK_UPDATE_STATUS_ID = 'MockEksUpdateStatusId';
exports.client = {
    configureAssumeRole: req => {
        exports.actualRequest.configureAssumeRoleRequest = req;
    },
    createCluster: async (req) => {
        exports.actualRequest.createClusterRequest = req;
        return {
            cluster: {
                name: req.name,
                roleArn: req.roleArn,
                version: '1.0',
                arn: `arn:${req.name}`,
                certificateAuthority: { data: 'certificateAuthority-data' },
                status: 'CREATING',
            },
        };
    },
    deleteCluster: async (req) => {
        exports.actualRequest.deleteClusterRequest = req;
        if (exports.simulateResponse.deleteClusterErrorCode) {
            const e = new Error('mock error');
            e.code = exports.simulateResponse.deleteClusterErrorCode;
            throw e;
        }
        return {
            cluster: {
                name: req.name,
            },
        };
    },
    describeCluster: async (req) => {
        exports.actualRequest.describeClusterRequest = req;
        if (exports.simulateResponse.describeClusterExceptionCode) {
            const e = new Error('mock exception');
            e.code = exports.simulateResponse.describeClusterExceptionCode;
            throw e;
        }
        return {
            cluster: {
                name: req.name,
                version: '1.0',
                roleArn: 'arn:role',
                arn: 'arn:cluster-arn',
                certificateAuthority: { data: 'certificateAuthority-data' },
                endpoint: 'http://endpoint',
                status: exports.simulateResponse.describeClusterResponseMockStatus || 'ACTIVE',
            },
        };
    },
    describeUpdate: async (req) => {
        exports.actualRequest.describeUpdateRequest = req;
        return {
            update: {
                id: req.updateId,
                errors: exports.simulateResponse.describeUpdateResponseMockErrors,
                status: exports.simulateResponse.describeUpdateResponseMockStatus,
            },
        };
    },
    updateClusterConfig: async (req) => {
        exports.actualRequest.updateClusterConfigRequest = req;
        return {
            update: {
                id: exports.MOCK_UPDATE_STATUS_ID,
            },
        };
    },
    updateClusterVersion: async (req) => {
        exports.actualRequest.updateClusterVersionRequest = req;
        return {
            update: {
                id: exports.MOCK_UPDATE_STATUS_ID,
            },
        };
    },
    createFargateProfile: async (req) => {
        exports.actualRequest.createFargateProfile = req;
        return {};
    },
    describeFargateProfile: async (req) => {
        exports.actualRequest.describeFargateProfile = req;
        return {};
    },
    deleteFargateProfile: async (req) => {
        exports.actualRequest.deleteFargateProfile = req;
        return {};
    },
};
exports.MOCK_PROPS = {
    roleArn: 'arn:of:role',
    resourcesVpcConfig: {
        subnetIds: ['subnet1', 'subnet2'],
        securityGroupIds: ['sg1', 'sg2', 'sg3'],
    },
};
exports.MOCK_ASSUME_ROLE_ARN = 'assume:role:arn';
function newRequest(requestType, props, oldProps) {
    return {
        StackId: 'fake-stack-id',
        RequestId: 'fake-request-id',
        ResourceType: 'Custom::EKSCluster',
        ServiceToken: 'boom',
        LogicalResourceId: 'MyResourceId',
        PhysicalResourceId: 'physical-resource-id',
        ResponseURL: 'http://response-url',
        RequestType: requestType,
        OldResourceProperties: {
            Config: oldProps,
            AssumeRoleArn: exports.MOCK_ASSUME_ROLE_ARN,
        },
        ResourceProperties: {
            ServiceToken: 'boom',
            Config: props,
            AssumeRoleArn: exports.MOCK_ASSUME_ROLE_ARN,
        },
    };
}
exports.newRequest = newRequest;
//# sourceMappingURL=data:application/json;base64,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