"use strict";
// tslint:disable:no-console
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const cluster_1 = require("./cluster");
const consts = require("./consts");
const fargate_1 = require("./fargate");
aws.config.logger = console;
let eks;
const defaultEksClient = {
    createCluster: req => getEksClient().createCluster(req).promise(),
    deleteCluster: req => getEksClient().deleteCluster(req).promise(),
    describeCluster: req => getEksClient().describeCluster(req).promise(),
    describeUpdate: req => getEksClient().describeUpdate(req).promise(),
    updateClusterConfig: req => getEksClient().updateClusterConfig(req).promise(),
    updateClusterVersion: req => getEksClient().updateClusterVersion(req).promise(),
    createFargateProfile: req => getEksClient().createFargateProfile(req).promise(),
    deleteFargateProfile: req => getEksClient().deleteFargateProfile(req).promise(),
    describeFargateProfile: req => getEksClient().describeFargateProfile(req).promise(),
    configureAssumeRole: req => {
        console.log(JSON.stringify({ assumeRole: req }, undefined, 2));
        const creds = new aws.ChainableTemporaryCredentials({
            params: req,
        });
        eks = new aws.EKS({ credentials: creds });
    },
};
function getEksClient() {
    if (!eks) {
        throw new Error('EKS client not initialized (call "configureAssumeRole")');
    }
    return eks;
}
async function onEvent(event) {
    const provider = createResourceHandler(event);
    return provider.onEvent();
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const provider = createResourceHandler(event);
    return provider.isComplete();
}
exports.isComplete = isComplete;
function createResourceHandler(event) {
    switch (event.ResourceType) {
        case consts.CLUSTER_RESOURCE_TYPE: return new cluster_1.ClusterResourceHandler(defaultEksClient, event);
        case consts.FARGATE_PROFILE_RESOURCE_TYPE: return new fargate_1.FargateProfileResourceHandler(defaultEksClient, event);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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