"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnvironmentConfig = exports.getProjectName = void 0;
exports.getProjectName = (scope) => {
    const projectName = scope.node.tryGetContext('projectName');
    if (!projectName) {
        throw new Error('Context parameter "projectName" not found');
    }
    return projectName;
};
exports.getEnvironmentConfig = (scope, name) => {
    const environments = scope.node.tryGetContext('environments');
    if (!environments) {
        throw new Error('Context parameter "environments" not found');
    }
    if (name in environments) {
        return environments[name];
    }
    else {
        return environments['default'];
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29udGV4dC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL2NvbnRleHQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR2EsUUFBQSxjQUFjLEdBQUcsQ0FBQyxLQUFnQixFQUFVLEVBQUU7SUFDdkQsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUF1QixDQUFDO0lBQ2xGLElBQUksQ0FBQyxXQUFXLEVBQUU7UUFDZCxNQUFNLElBQUksS0FBSyxDQUFDLDJDQUEyQyxDQUFDLENBQUM7S0FDaEU7SUFDRCxPQUFPLFdBQVcsQ0FBQztBQUN2QixDQUFDLENBQUM7QUFFVyxRQUFBLG9CQUFvQixHQUFHLENBQUMsS0FBZ0IsRUFBRSxJQUFZLEVBQWUsRUFBRTtJQUNoRixNQUFNLFlBQVksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQTRDLENBQUM7SUFDekcsSUFBSSxDQUFDLFlBQVksRUFBRTtRQUNmLE1BQU0sSUFBSSxLQUFLLENBQUMsNENBQTRDLENBQUMsQ0FBQztLQUNqRTtJQUVELElBQUksSUFBSSxJQUFJLFlBQVksRUFBRTtRQUN0QixPQUFPLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUM3QjtTQUFNO1FBQ0gsT0FBTyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUM7S0FDbEM7QUFDTCxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge0Vudmlyb25tZW50fSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQge0NvbnN0cnVjdH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmV4cG9ydCBjb25zdCBnZXRQcm9qZWN0TmFtZSA9IChzY29wZTogQ29uc3RydWN0KTogc3RyaW5nID0+IHtcbiAgICBjb25zdCBwcm9qZWN0TmFtZSA9IHNjb3BlLm5vZGUudHJ5R2V0Q29udGV4dCgncHJvamVjdE5hbWUnKSBhcyBzdHJpbmcgfCB1bmRlZmluZWQ7XG4gICAgaWYgKCFwcm9qZWN0TmFtZSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0NvbnRleHQgcGFyYW1ldGVyIFwicHJvamVjdE5hbWVcIiBub3QgZm91bmQnKTtcbiAgICB9XG4gICAgcmV0dXJuIHByb2plY3ROYW1lO1xufTtcblxuZXhwb3J0IGNvbnN0IGdldEVudmlyb25tZW50Q29uZmlnID0gKHNjb3BlOiBDb25zdHJ1Y3QsIG5hbWU6IHN0cmluZyk6IEVudmlyb25tZW50ID0+IHtcbiAgICBjb25zdCBlbnZpcm9ubWVudHMgPSBzY29wZS5ub2RlLnRyeUdldENvbnRleHQoJ2Vudmlyb25tZW50cycpIGFzIFJlY29yZDxzdHJpbmcsIEVudmlyb25tZW50PiB8IHVuZGVmaW5lZDtcbiAgICBpZiAoIWVudmlyb25tZW50cykge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0NvbnRleHQgcGFyYW1ldGVyIFwiZW52aXJvbm1lbnRzXCIgbm90IGZvdW5kJyk7XG4gICAgfVxuXG4gICAgaWYgKG5hbWUgaW4gZW52aXJvbm1lbnRzKSB7XG4gICAgICAgIHJldHVybiBlbnZpcm9ubWVudHNbbmFtZV07XG4gICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIGVudmlyb25tZW50c1snZGVmYXVsdCddO1xuICAgIH1cbn07XG4iXX0=