"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationsTopic = void 0;
const constructs_1 = require("constructs");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const aws_ssm_1 = require("aws-cdk-lib/aws-ssm");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class NotificationsTopic extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.topic = new aws_sns_1.Topic(this, 'Topic');
        new aws_ssm_1.StringParameter(this, 'TopicArnParam', {
            parameterName: `/${props.projectName}/ci/${props.notificationName}TopicArn`,
            stringValue: this.topic.topicArn,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'TopicArn', {
            value: this.topic.topicArn,
            exportName: `${props.projectName}-ci-${props.notificationName}TopicArn`,
        });
    }
}
exports.NotificationsTopic = NotificationsTopic;
//# sourceMappingURL=data:application/json;base64,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