import { Repository } from 'aws-cdk-lib/aws-codecommit';
import { Construct } from 'constructs';
import { ResolvedApplicationProps } from '../applicationProps';
import { Topic } from 'aws-cdk-lib/aws-sns';
import { IStringParameter } from 'aws-cdk-lib/aws-ssm';
export interface FeatureBranchBuildsProps extends Pick<ResolvedApplicationProps, 'repository' | 'commands' | 'codeBuild'> {
    codeCommitRepository: Repository;
    repositoryTokenParam: IStringParameter;
}
export declare class FeatureBranchBuilds extends Construct {
    readonly failuresTopic: Topic;
    constructor(scope: Construct, id: string, props: FeatureBranchBuildsProps);
    private createDeployProject;
    private createDeployNotifications;
    private createBuildFailuresTopic;
    private createDestroyProject;
    private createProjectTriggerOptions;
    private grantAssumeCDKRoles;
}
