"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultProps = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
exports.defaultProps = {
    repository: {
        defaultBranch: 'main',
    },
    commands: {
        install: ['npm install --location=global aws-cdk@2'],
        synthPipeline: ['cdk synth -c ci=true'],
        deployEnvironment: ['cdk deploy -c env=${ENV_NAME} --all'],
        destroyEnvironment: ['yes | cdk destroy -c env=${ENV_NAME} --all'],
    },
    codeBuild: {
        timeout: aws_cdk_lib_1.Duration.minutes(30),
        buildEnvironment: {
            computeType: aws_codebuild_1.ComputeType.MEDIUM,
            buildImage: aws_codebuild_1.LinuxBuildImage.STANDARD_6_0,
        },
    },
    slackNotifications: {
        mainPipelineFailures: true,
    },
}; // "satisfies PartialDeep<CIStackProps>" would be great here if jsii supported TypeScript 4.9 (PartialDeep from type-fest lib)
//# sourceMappingURL=data:application/json;base64,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