"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureCloudFrontOriginBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_bucket_1 = require("@gammarer/aws-secure-bucket");
const iam = require("aws-cdk-lib/aws-iam");
class SecureCloudFrontOriginBucket extends aws_secure_bucket_1.SecureBucket {
    constructor(scope, id, props) {
        super(scope, id, {
            bucketName: props.bucketName,
            encryption: aws_secure_bucket_1.SecureBucketEncryption.S3_MANAGED,
            versioned: false,
        });
        // 👇Allow CloudFront access
        this.addToResourcePolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['s3:GetObject'],
            principals: [
                new iam.CanonicalUserPrincipal(props.cloudFrontOriginAccessIdentityS3CanonicalUserId),
            ],
            resources: [`${this.bucketArn}/*`],
        }));
    }
}
exports.SecureCloudFrontOriginBucket = SecureCloudFrontOriginBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureCloudFrontOriginBucket[_a] = { fqn: "@gammarer/aws-secure-cloudfront-origin-bucket.SecureCloudFrontOriginBucket", version: "0.6.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxtRUFBbUY7QUFDbkYsMkNBQTJDO0FBUTNDLE1BQWEsNEJBQTZCLFNBQVEsZ0NBQVk7SUFFNUQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QztRQUNoRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixVQUFVLEVBQUUsMENBQXNCLENBQUMsVUFBVTtZQUM3QyxTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDLENBQUM7UUFFSCw0QkFBNEI7UUFDNUIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUMvQyxNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLO1lBQ3hCLE9BQU8sRUFBRSxDQUFDLGNBQWMsQ0FBQztZQUN6QixVQUFVLEVBQUU7Z0JBQ1YsSUFBSSxHQUFHLENBQUMsc0JBQXNCLENBQzVCLEtBQUssQ0FBQywrQ0FBK0MsQ0FDdEQ7YUFDRjtZQUNELFNBQVMsRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLFNBQVMsSUFBSSxDQUFDO1NBQ25DLENBQUMsQ0FBQyxDQUFDO0lBQ04sQ0FBQzs7QUFwQkgsb0VBcUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU2VjdXJlQnVja2V0LCBTZWN1cmVCdWNrZXRFbmNyeXB0aW9uIH0gZnJvbSAnQGdhbW1hcmVyL2F3cy1zZWN1cmUtYnVja2V0JztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFNlY3VyZUNsb3VkRnJvbnRPcmlnaW5CdWNrZXRQcm9wcyB7XG4gIHJlYWRvbmx5IGJ1Y2tldE5hbWU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGNsb3VkRnJvbnRPcmlnaW5BY2Nlc3NJZGVudGl0eVMzQ2Fub25pY2FsVXNlcklkOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBTZWN1cmVDbG91ZEZyb250T3JpZ2luQnVja2V0IGV4dGVuZHMgU2VjdXJlQnVja2V0IHtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU2VjdXJlQ2xvdWRGcm9udE9yaWdpbkJ1Y2tldFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBidWNrZXROYW1lOiBwcm9wcy5idWNrZXROYW1lLFxuICAgICAgZW5jcnlwdGlvbjogU2VjdXJlQnVja2V0RW5jcnlwdGlvbi5TM19NQU5BR0VELCAvLyBOb3RpY2XvvIlPbmx5IFMzIE1hbmFnZWRcbiAgICAgIHZlcnNpb25lZDogZmFsc2UsXG4gICAgfSk7XG5cbiAgICAvLyDwn5GHQWxsb3cgQ2xvdWRGcm9udCBhY2Nlc3NcbiAgICB0aGlzLmFkZFRvUmVzb3VyY2VQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgZWZmZWN0OiBpYW0uRWZmZWN0LkFMTE9XLFxuICAgICAgYWN0aW9uczogWydzMzpHZXRPYmplY3QnXSxcbiAgICAgIHByaW5jaXBhbHM6IFtcbiAgICAgICAgbmV3IGlhbS5DYW5vbmljYWxVc2VyUHJpbmNpcGFsKFxuICAgICAgICAgIHByb3BzLmNsb3VkRnJvbnRPcmlnaW5BY2Nlc3NJZGVudGl0eVMzQ2Fub25pY2FsVXNlcklkLFxuICAgICAgICApLFxuICAgICAgXSxcbiAgICAgIHJlc291cmNlczogW2Ake3RoaXMuYnVja2V0QXJufS8qYF0sXG4gICAgfSkpO1xuICB9XG59XG4iXX0=