"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from synctera_client.exceptions import ApiAttributeError


def lazy_import():
    from synctera_client.model.ach_transaction import AchTransaction
    from synctera_client.model.ach_transaction_data import AchTransactionData
    from synctera_client.model.base_transaction_decline import BaseTransactionDecline
    from synctera_client.model.card_transaction import CardTransaction
    from synctera_client.model.card_transaction_data import CardTransactionData
    from synctera_client.model.check_transaction import CheckTransaction
    from synctera_client.model.check_transaction_data import CheckTransactionData
    from synctera_client.model.enhanced_transaction_data import EnhancedTransactionData
    from synctera_client.model.external_card_transaction import ExternalCardTransaction
    from synctera_client.model.internal_transfer_transaction import InternalTransferTransaction
    from synctera_client.model.internal_transfer_transaction_data import InternalTransferTransactionData
    from synctera_client.model.wire_transaction import WireTransaction
    from synctera_client.model.wire_transaction_data import WireTransactionData
    from synctera_client.model.wire_transaction_subtypes import WireTransactionSubtypes
    globals()['AchTransaction'] = AchTransaction
    globals()['AchTransactionData'] = AchTransactionData
    globals()['BaseTransactionDecline'] = BaseTransactionDecline
    globals()['CardTransaction'] = CardTransaction
    globals()['CardTransactionData'] = CardTransactionData
    globals()['CheckTransaction'] = CheckTransaction
    globals()['CheckTransactionData'] = CheckTransactionData
    globals()['EnhancedTransactionData'] = EnhancedTransactionData
    globals()['ExternalCardTransaction'] = ExternalCardTransaction
    globals()['InternalTransferTransaction'] = InternalTransferTransaction
    globals()['InternalTransferTransactionData'] = InternalTransferTransactionData
    globals()['WireTransaction'] = WireTransaction
    globals()['WireTransactionData'] = WireTransactionData
    globals()['WireTransactionSubtypes'] = WireTransactionSubtypes


class Transaction1(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('type',): {
            'ACH': "ACH",
            'CARD': "CARD",
            'CHECK': "CHECK",
            'EXTERNAL_CARD': "EXTERNAL_CARD",
            'INTERNAL_TRANSFER': "INTERNAL_TRANSFER",
            'WIRE': "WIRE",
        },
        ('dc_sign',): {
            'DEBIT': "DEBIT",
            'CREDIT': "CREDIT",
        },
        ('status',): {
            'PENDING': "PENDING",
            'DECLINED': "DECLINED",
            'COMPLETE': "COMPLETE",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'type': (str,),  # noqa: E501
            'account_id': (str,),  # noqa: E501
            'customer_id': (str,),  # noqa: E501
            'decline': (BaseTransactionDecline,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'enhanced_transaction': (EnhancedTransactionData,),  # noqa: E501
            'hold_expiration_time': (datetime,),  # noqa: E501
            'internal_account_id': (str,),  # noqa: E501
            'posted_date': (date,),  # noqa: E501
            'reference_id': (str,),  # noqa: E501
            'system_description': (str,),  # noqa: E501
            'internal_transfer_transaction': (InternalTransferTransactionData,),  # noqa: E501
            'amount': (int,),  # noqa: E501
            'creation_time': (datetime,),  # noqa: E501
            'currency': (str,),  # noqa: E501
            'dc_sign': (str,),  # noqa: E501
            'effective_date': (date,),  # noqa: E501
            'force_post': (bool,),  # noqa: E501
            'group_id': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'last_updated_time': (datetime,),  # noqa: E501
            'partial_hold': (bool,),  # noqa: E501
            'pending_amount': (int,),  # noqa: E501
            'posted_amount': (int,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'transaction_time': (datetime,),  # noqa: E501
            'ach_transaction': (AchTransactionData,),  # noqa: E501
            'subtype': (WireTransactionSubtypes,),  # noqa: E501
            'card_transaction': (CardTransactionData,),  # noqa: E501
            'check_transaction': (CheckTransactionData,),  # noqa: E501
            'external_card_transaction': (CardTransactionData,),  # noqa: E501
            'wire_transaction': (WireTransactionData,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'ACH': AchTransaction,
            'CARD': CardTransaction,
            'CHECK': CheckTransaction,
            'EXTERNAL_CARD': ExternalCardTransaction,
            'INTERNAL_TRANSFER': InternalTransferTransaction,
            'WIRE': WireTransaction,
            'ach_transaction': AchTransaction,
            'card_transaction': CardTransaction,
            'check_transaction': CheckTransaction,
            'external_card_transaction': ExternalCardTransaction,
            'internal_transfer_transaction': InternalTransferTransaction,
            'wire_transaction': WireTransaction,
        }
        if not val:
            return None
        return {'type': val}

    attribute_map = {
        'type': 'type',  # noqa: E501
        'account_id': 'account_id',  # noqa: E501
        'customer_id': 'customer_id',  # noqa: E501
        'decline': 'decline',  # noqa: E501
        'description': 'description',  # noqa: E501
        'enhanced_transaction': 'enhanced_transaction',  # noqa: E501
        'hold_expiration_time': 'hold_expiration_time',  # noqa: E501
        'internal_account_id': 'internal_account_id',  # noqa: E501
        'posted_date': 'posted_date',  # noqa: E501
        'reference_id': 'reference_id',  # noqa: E501
        'system_description': 'system_description',  # noqa: E501
        'internal_transfer_transaction': 'internal_transfer_transaction',  # noqa: E501
        'amount': 'amount',  # noqa: E501
        'creation_time': 'creation_time',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'dc_sign': 'dc_sign',  # noqa: E501
        'effective_date': 'effective_date',  # noqa: E501
        'force_post': 'force_post',  # noqa: E501
        'group_id': 'group_id',  # noqa: E501
        'id': 'id',  # noqa: E501
        'last_updated_time': 'last_updated_time',  # noqa: E501
        'partial_hold': 'partial_hold',  # noqa: E501
        'pending_amount': 'pending_amount',  # noqa: E501
        'posted_amount': 'posted_amount',  # noqa: E501
        'status': 'status',  # noqa: E501
        'transaction_time': 'transaction_time',  # noqa: E501
        'ach_transaction': 'ach_transaction',  # noqa: E501
        'subtype': 'subtype',  # noqa: E501
        'card_transaction': 'card_transaction',  # noqa: E501
        'check_transaction': 'check_transaction',  # noqa: E501
        'external_card_transaction': 'external_card_transaction',  # noqa: E501
        'wire_transaction': 'wire_transaction',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Transaction1 - a model defined in OpenAPI

        Keyword Args:
            type (str): The type of the transaction. This typically represents the \"payment\" rail that is used. For example, for ACH payments this will be `ach`, while debit card transactions will use `card`.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account_id (str): The account uuid associated with the transaction. `account_id` and `internal_account_id` are mutually exclusive. [optional]  # noqa: E501
            customer_id (str): The uuid of the customer that initiated the transaction (if any) . [optional]  # noqa: E501
            decline (BaseTransactionDecline): [optional]  # noqa: E501
            description (str): A human-friendly description of the transaction, provided by the integrator. [optional]  # noqa: E501
            enhanced_transaction (EnhancedTransactionData): [optional]  # noqa: E501
            hold_expiration_time (datetime): The date and time any pending amount is expected to be released back to the account.. [optional]  # noqa: E501
            internal_account_id (str): The internal account uuid associated with the transaction. `account_id` and `internal_account_id` are mutually exclusive. [optional]  # noqa: E501
            posted_date (date): The date the transaction was posted (based on the bank calendar and end-of-day). For transaction with multiple postings, this is the date of the earliest posting. This will be omitted for transactions with a `posted_amount` of `0`.. [optional]  # noqa: E501
            reference_id (str): An external ID provided by the payment network to represent this transaction. This is not guaranteed to be globally unique. This will always be omitted for internal transfers.. [optional]  # noqa: E501
            system_description (str): A human-friendly description of the transaction, provided by the Synctera platform. [optional]  # noqa: E501
            internal_transfer_transaction (InternalTransferTransactionData): [optional]  # noqa: E501
            amount (int): The total amount of the transaction including both pending and already posted amounts. The value is represented as the smallest denomination of the applicable currency.. [optional]  # noqa: E501
            creation_time (datetime): The exact time the transaction was recorded in the ledger. [optional]  # noqa: E501
            currency (str): ISO 4217 alphabetic currency code of the transfer amount. [optional]  # noqa: E501
            dc_sign (str): The `dc_sign` represents the direction money was moved. A value of `DEBIT` is money moving out of an account, a value of `CREDIT` is money moving into an account. [optional]  # noqa: E501
            effective_date (date): The effective date of the transaction. This usually aligns with network settlement date, which differs between transaction types. The effective date is also used to determine effective daily balances for the purposes of interest calculation.. [optional]  # noqa: E501
            force_post (bool): Determines whether or not a transaction or auth was \"forced\" or not. A forced transaction skips any account balance checks. [optional]  # noqa: E501
            group_id (str): The group id of the transaction. Every transaction in the ledger is one entry in a double-entry system and the primary and offset transactions share the same `group_id`. [optional]  # noqa: E501
            id (str): The unique identifier of the transaction. [optional]  # noqa: E501
            last_updated_time (datetime): The date and time the transaction was last modified. [optional]  # noqa: E501
            partial_hold (bool): Determines whether or not the funds on hold were the result of a partial auth or not. If `true` the `pending_amount` of the transaction will be less than the requested amount. This is primarily used for certain types of card transactions.. [optional]  # noqa: E501
            pending_amount (int): The amount amount of the transaction currently authorized or on hold. [optional]  # noqa: E501
            posted_amount (int): The amount of the transaction that has been fully posted to the account. [optional]  # noqa: E501
            status (str): The status of the transaction. [optional]  # noqa: E501
            transaction_time (datetime): The time the transaction occurred. In most cases this will be roughly identical to creation_time, but it can differ in some situations if the payment doesn't appear in the ledger in real-time.. [optional]  # noqa: E501
            ach_transaction (AchTransactionData): [optional]  # noqa: E501
            subtype (WireTransactionSubtypes): [optional]  # noqa: E501
            card_transaction (CardTransactionData): [optional]  # noqa: E501
            check_transaction (CheckTransactionData): [optional]  # noqa: E501
            external_card_transaction (CardTransactionData): [optional]  # noqa: E501
            wire_transaction (WireTransactionData): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Transaction1 - a model defined in OpenAPI

        Keyword Args:
            type (str): The type of the transaction. This typically represents the \"payment\" rail that is used. For example, for ACH payments this will be `ach`, while debit card transactions will use `card`.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account_id (str): The account uuid associated with the transaction. `account_id` and `internal_account_id` are mutually exclusive. [optional]  # noqa: E501
            customer_id (str): The uuid of the customer that initiated the transaction (if any) . [optional]  # noqa: E501
            decline (BaseTransactionDecline): [optional]  # noqa: E501
            description (str): A human-friendly description of the transaction, provided by the integrator. [optional]  # noqa: E501
            enhanced_transaction (EnhancedTransactionData): [optional]  # noqa: E501
            hold_expiration_time (datetime): The date and time any pending amount is expected to be released back to the account.. [optional]  # noqa: E501
            internal_account_id (str): The internal account uuid associated with the transaction. `account_id` and `internal_account_id` are mutually exclusive. [optional]  # noqa: E501
            posted_date (date): The date the transaction was posted (based on the bank calendar and end-of-day). For transaction with multiple postings, this is the date of the earliest posting. This will be omitted for transactions with a `posted_amount` of `0`.. [optional]  # noqa: E501
            reference_id (str): An external ID provided by the payment network to represent this transaction. This is not guaranteed to be globally unique. This will always be omitted for internal transfers.. [optional]  # noqa: E501
            system_description (str): A human-friendly description of the transaction, provided by the Synctera platform. [optional]  # noqa: E501
            internal_transfer_transaction (InternalTransferTransactionData): [optional]  # noqa: E501
            amount (int): The total amount of the transaction including both pending and already posted amounts. The value is represented as the smallest denomination of the applicable currency.. [optional]  # noqa: E501
            creation_time (datetime): The exact time the transaction was recorded in the ledger. [optional]  # noqa: E501
            currency (str): ISO 4217 alphabetic currency code of the transfer amount. [optional]  # noqa: E501
            dc_sign (str): The `dc_sign` represents the direction money was moved. A value of `DEBIT` is money moving out of an account, a value of `CREDIT` is money moving into an account. [optional]  # noqa: E501
            effective_date (date): The effective date of the transaction. This usually aligns with network settlement date, which differs between transaction types. The effective date is also used to determine effective daily balances for the purposes of interest calculation.. [optional]  # noqa: E501
            force_post (bool): Determines whether or not a transaction or auth was \"forced\" or not. A forced transaction skips any account balance checks. [optional]  # noqa: E501
            group_id (str): The group id of the transaction. Every transaction in the ledger is one entry in a double-entry system and the primary and offset transactions share the same `group_id`. [optional]  # noqa: E501
            id (str): The unique identifier of the transaction. [optional]  # noqa: E501
            last_updated_time (datetime): The date and time the transaction was last modified. [optional]  # noqa: E501
            partial_hold (bool): Determines whether or not the funds on hold were the result of a partial auth or not. If `true` the `pending_amount` of the transaction will be less than the requested amount. This is primarily used for certain types of card transactions.. [optional]  # noqa: E501
            pending_amount (int): The amount amount of the transaction currently authorized or on hold. [optional]  # noqa: E501
            posted_amount (int): The amount of the transaction that has been fully posted to the account. [optional]  # noqa: E501
            status (str): The status of the transaction. [optional]  # noqa: E501
            transaction_time (datetime): The time the transaction occurred. In most cases this will be roughly identical to creation_time, but it can differ in some situations if the payment doesn't appear in the ledger in real-time.. [optional]  # noqa: E501
            ach_transaction (AchTransactionData): [optional]  # noqa: E501
            subtype (WireTransactionSubtypes): [optional]  # noqa: E501
            card_transaction (CardTransactionData): [optional]  # noqa: E501
            check_transaction (CheckTransactionData): [optional]  # noqa: E501
            external_card_transaction (CardTransactionData): [optional]  # noqa: E501
            wire_transaction (WireTransactionData): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
          ],
          'oneOf': [
              AchTransaction,
              CardTransaction,
              CheckTransaction,
              ExternalCardTransaction,
              InternalTransferTransaction,
              WireTransaction,
          ],
        }
