"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from synctera_client.exceptions import ApiAttributeError


def lazy_import():
    from synctera_client.model.card_brand import CardBrand
    from synctera_client.model.card_fulfillment_status import CardFulfillmentStatus
    from synctera_client.model.card_metadata import CardMetadata
    from synctera_client.model.card_status import CardStatus
    from synctera_client.model.card_status_reason_code import CardStatusReasonCode
    from synctera_client.model.card_status_reason_memo import CardStatusReasonMemo
    from synctera_client.model.emboss_name import EmbossName
    from synctera_client.model.fulfillment_details import FulfillmentDetails
    from synctera_client.model.physical_card_format import PhysicalCardFormat
    from synctera_client.model.physical_card_plus_status import PhysicalCardPlusStatus
    from synctera_client.model.physical_card_response_all_of import PhysicalCardResponseAllOf
    from synctera_client.model.shipping import Shipping
    globals()['CardBrand'] = CardBrand
    globals()['CardFulfillmentStatus'] = CardFulfillmentStatus
    globals()['CardMetadata'] = CardMetadata
    globals()['CardStatus'] = CardStatus
    globals()['CardStatusReasonCode'] = CardStatusReasonCode
    globals()['CardStatusReasonMemo'] = CardStatusReasonMemo
    globals()['EmbossName'] = EmbossName
    globals()['FulfillmentDetails'] = FulfillmentDetails
    globals()['PhysicalCardFormat'] = PhysicalCardFormat
    globals()['PhysicalCardPlusStatus'] = PhysicalCardPlusStatus
    globals()['PhysicalCardResponseAllOf'] = PhysicalCardResponseAllOf
    globals()['Shipping'] = Shipping


class PhysicalCardResponse(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('form',): {
            'PHYSICAL': "PHYSICAL",
            'VIRTUAL': "VIRTUAL",
        },
        ('type',): {
            'DEBIT': "DEBIT",
        },
        ('reissue_reason',): {
            'EXPIRATION': "EXPIRATION",
            'LOST': "LOST",
            'STOLEN': "STOLEN",
            'DAMAGED': "DAMAGED",
            'NAME_CHANGE': "NAME_CHANGE",
            'VIRTUAL_TO_PHYSICAL': "VIRTUAL_TO_PHYSICAL",
            'PRODUCT_CHANGE': "PRODUCT_CHANGE",
            'APPEARANCE': "APPEARANCE",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'form': (str,),  # noqa: E501
            'account_id': (str,),  # noqa: E501
            'card_product_id': (str,),  # noqa: E501
            'creation_time': (datetime,),  # noqa: E501
            'customer_id': (str,),  # noqa: E501
            'emboss_name': (EmbossName,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'shipping': (Shipping,),  # noqa: E501
            'card_status': (CardStatus,),  # noqa: E501
            'status_reason': (CardStatusReasonCode,),  # noqa: E501
            'card_fulfillment_status': (CardFulfillmentStatus,),  # noqa: E501
            'card_brand': (CardBrand,),  # noqa: E501
            'physical_card_format': (PhysicalCardFormat,),  # noqa: E501
            'expiration_month': (str,),  # noqa: E501
            'expiration_time': (datetime,),  # noqa: E501
            'expiration_year': (str,),  # noqa: E501
            'is_pin_set': (bool,),  # noqa: E501
            'last_four': (str,),  # noqa: E501
            'last_modified_time': (datetime,),  # noqa: E501
            'metadata': (CardMetadata,),  # noqa: E501
            'reissue_reason': (str,),  # noqa: E501
            'reissued_from_id': (str,),  # noqa: E501
            'reissued_to_id': (str,),  # noqa: E501
            'card_image_id': (str,),  # noqa: E501
            'memo': (CardStatusReasonMemo,),  # noqa: E501
            'fulfillment_details': (FulfillmentDetails,),  # noqa: E501
            'tracking_number': (str,),  # noqa: E501
            'bin': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'form': 'form',  # noqa: E501
        'account_id': 'account_id',  # noqa: E501
        'card_product_id': 'card_product_id',  # noqa: E501
        'creation_time': 'creation_time',  # noqa: E501
        'customer_id': 'customer_id',  # noqa: E501
        'emboss_name': 'emboss_name',  # noqa: E501
        'id': 'id',  # noqa: E501
        'type': 'type',  # noqa: E501
        'shipping': 'shipping',  # noqa: E501
        'card_status': 'card_status',  # noqa: E501
        'status_reason': 'status_reason',  # noqa: E501
        'card_fulfillment_status': 'card_fulfillment_status',  # noqa: E501
        'card_brand': 'card_brand',  # noqa: E501
        'physical_card_format': 'physical_card_format',  # noqa: E501
        'expiration_month': 'expiration_month',  # noqa: E501
        'expiration_time': 'expiration_time',  # noqa: E501
        'expiration_year': 'expiration_year',  # noqa: E501
        'is_pin_set': 'is_pin_set',  # noqa: E501
        'last_four': 'last_four',  # noqa: E501
        'last_modified_time': 'last_modified_time',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'reissue_reason': 'reissue_reason',  # noqa: E501
        'reissued_from_id': 'reissued_from_id',  # noqa: E501
        'reissued_to_id': 'reissued_to_id',  # noqa: E501
        'card_image_id': 'card_image_id',  # noqa: E501
        'memo': 'memo',  # noqa: E501
        'fulfillment_details': 'fulfillment_details',  # noqa: E501
        'tracking_number': 'tracking_number',  # noqa: E501
        'bin': 'bin',  # noqa: E501
    }

    read_only_vars = {
        'creation_time',  # noqa: E501
        'id',  # noqa: E501
        'expiration_month',  # noqa: E501
        'expiration_time',  # noqa: E501
        'expiration_year',  # noqa: E501
        'is_pin_set',  # noqa: E501
        'last_four',  # noqa: E501
        'last_modified_time',  # noqa: E501
        'reissued_to_id',  # noqa: E501
        'tracking_number',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """PhysicalCardResponse - a model defined in OpenAPI

        Keyword Args:
            form (str): PHYSICAL or VIRTUAL.
            account_id (str): The ID of the account to which the card will be linked
            card_product_id (str): The card product to which the card is attached
            creation_time (datetime): The timestamp representing when the card issuance request was made
            customer_id (str): The ID of the customer to whom the card will be issued
            emboss_name (EmbossName):
            id (str): Card ID
            type (str): Indicates the type of card to be issued. defaults to "DEBIT", must be one of ["DEBIT", ]  # noqa: E501
            shipping (Shipping):
            card_status (CardStatus):
            status_reason (CardStatusReasonCode):
            card_fulfillment_status (CardFulfillmentStatus):
            card_brand (CardBrand):
            physical_card_format (PhysicalCardFormat):
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            expiration_month (str): [optional]  # noqa: E501
            expiration_time (datetime): The timestamp representing when the card would expire at. [optional]  # noqa: E501
            expiration_year (str): [optional]  # noqa: E501
            is_pin_set (bool): indicates whether a pin has been set on the card. [optional] if omitted the server will use the default value of False  # noqa: E501
            last_four (str): The last 4 digits of the card PAN. [optional]  # noqa: E501
            last_modified_time (datetime): The timestamp representing when the card was last modified at. [optional]  # noqa: E501
            metadata (CardMetadata): [optional]  # noqa: E501
            reissue_reason (str): This is the reason the card needs to be reissued, if any. The reason determines several behaviours:   - whether or not the new card will use the same PAN as the original card   - the old card will be terminated and if so, when it will be terminated  Reason                 | Same PAN | Terminate Old Card ---------------------- | -------- | ------------------ EXPIRATION             | yes      | on activation LOST                   | no       | immediately STOLEN                 | no       | immediately DAMAGED                | yes      | on activation VIRTUAL_TO_PHYSICAL(*) | yes      | on activation PRODUCT_CHANGE         | yes      | on activation NAME_CHANGE(**)        | yes      | on activation APPEARANCE             | yes      | on activation  (*) VIRTUAL_TO_PHYSICAL is deprecated. Please use PRODUCT_CHANGE whenever reissuing from one card product to another, including from a virtual product to a physical product.  (**) NAME_CHANGE is deprecated. Please use APPEARANCE whenever reissuing in order to change the appearance of a card, such as the printed name or custom image.  For all reasons, the new card will use the same PIN as the original card and digital wallet tokens will reassigned to the new card . [optional]  # noqa: E501
            reissued_from_id (str): When reissuing a card, specify the card to be replaced here. When getting a card's details, if this card was issued as a reissuance of another card, this ID refers to the card was replaced. If this field is set, then reissue_reason must also be set. . [optional]  # noqa: E501
            reissued_to_id (str): If this card was reissued, this ID refers to the card that replaced it.. [optional]  # noqa: E501
            card_image_id (str): The ID of the custom card image used for this card. [optional]  # noqa: E501
            memo (CardStatusReasonMemo): [optional]  # noqa: E501
            fulfillment_details (FulfillmentDetails): [optional]  # noqa: E501
            tracking_number (str): This contains all shipping details as provided by the card fulfillment provider, including the tracking number. This field is deprecated. Instead, please use the fulfillment_details object, which includes a field for just the tracking number. . [optional]  # noqa: E501
            bin (str): The bin number. [optional]  # noqa: E501
        """

        type = kwargs.get('type', "DEBIT")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PhysicalCardResponse - a model defined in OpenAPI

        Keyword Args:
            form (str): PHYSICAL or VIRTUAL.
            account_id (str): The ID of the account to which the card will be linked
            card_product_id (str): The card product to which the card is attached
            customer_id (str): The ID of the customer to whom the card will be issued
            emboss_name (EmbossName):
            type (str): Indicates the type of card to be issued. defaults to "DEBIT", must be one of ["DEBIT", ]  # noqa: E501
            shipping (Shipping):
            card_status (CardStatus):
            status_reason (CardStatusReasonCode):
            card_fulfillment_status (CardFulfillmentStatus):
            card_brand (CardBrand):
            physical_card_format (PhysicalCardFormat):
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            expiration_month (str): [optional]  # noqa: E501
            expiration_time (datetime): The timestamp representing when the card would expire at. [optional]  # noqa: E501
            expiration_year (str): [optional]  # noqa: E501
            is_pin_set (bool): indicates whether a pin has been set on the card. [optional] if omitted the server will use the default value of False  # noqa: E501
            last_four (str): The last 4 digits of the card PAN. [optional]  # noqa: E501
            last_modified_time (datetime): The timestamp representing when the card was last modified at. [optional]  # noqa: E501
            metadata (CardMetadata): [optional]  # noqa: E501
            reissue_reason (str): This is the reason the card needs to be reissued, if any. The reason determines several behaviours:   - whether or not the new card will use the same PAN as the original card   - the old card will be terminated and if so, when it will be terminated  Reason                 | Same PAN | Terminate Old Card ---------------------- | -------- | ------------------ EXPIRATION             | yes      | on activation LOST                   | no       | immediately STOLEN                 | no       | immediately DAMAGED                | yes      | on activation VIRTUAL_TO_PHYSICAL(*) | yes      | on activation PRODUCT_CHANGE         | yes      | on activation NAME_CHANGE(**)        | yes      | on activation APPEARANCE             | yes      | on activation  (*) VIRTUAL_TO_PHYSICAL is deprecated. Please use PRODUCT_CHANGE whenever reissuing from one card product to another, including from a virtual product to a physical product.  (**) NAME_CHANGE is deprecated. Please use APPEARANCE whenever reissuing in order to change the appearance of a card, such as the printed name or custom image.  For all reasons, the new card will use the same PIN as the original card and digital wallet tokens will reassigned to the new card . [optional]  # noqa: E501
            reissued_from_id (str): When reissuing a card, specify the card to be replaced here. When getting a card's details, if this card was issued as a reissuance of another card, this ID refers to the card was replaced. If this field is set, then reissue_reason must also be set. . [optional]  # noqa: E501
            reissued_to_id (str): If this card was reissued, this ID refers to the card that replaced it.. [optional]  # noqa: E501
            card_image_id (str): The ID of the custom card image used for this card. [optional]  # noqa: E501
            memo (CardStatusReasonMemo): [optional]  # noqa: E501
            fulfillment_details (FulfillmentDetails): [optional]  # noqa: E501
            tracking_number (str): This contains all shipping details as provided by the card fulfillment provider, including the tracking number. This field is deprecated. Instead, please use the fulfillment_details object, which includes a field for just the tracking number. . [optional]  # noqa: E501
            bin (str): The bin number. [optional]  # noqa: E501
        """

        type = kwargs.get('type', "DEBIT")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              PhysicalCardPlusStatus,
              PhysicalCardResponseAllOf,
          ],
          'oneOf': [
          ],
        }
