"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from synctera_client.exceptions import ApiAttributeError


def lazy_import():
    from synctera_client.model.address import Address
    from synctera_client.model.base import Base
    from synctera_client.model.verification_status import VerificationStatus
    globals()['Address'] = Address
    globals()['Base'] = Base
    globals()['VerificationStatus'] = VerificationStatus


class PatchBusiness(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'PROSPECT': "PROSPECT",
            'ACTIVE': "ACTIVE",
            'FROZEN': "FROZEN",
            'SANCTION': "SANCTION",
            'DISSOLVED': "DISSOLVED",
            'CANCELLED': "CANCELLED",
            'SUSPENDED': "SUSPENDED",
            'MERGED': "MERGED",
            'INACTIVE': "INACTIVE",
            'CONVERTED': "CONVERTED",
        },
        ('structure',): {
            'SOLE_PROPRIETORSHIP': "SOLE_PROPRIETORSHIP",
            'PARTNERSHIP': "PARTNERSHIP",
            'LLC': "LLC",
            'CORPORATION': "CORPORATION",
            'S_CORPORATION': "S_CORPORATION",
            'NON_PROFIT': "NON_PROFIT",
            'OTHER': "OTHER",
        },
    }

    validations = {
        ('phone_number',): {
            'regex': {
                'pattern': r'^\+[1-9]\d{1,14}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'creation_time': (datetime,),  # noqa: E501
            'ein': (str,),  # noqa: E501
            'email': (str,),  # noqa: E501
            'entity_name': (str,),  # noqa: E501
            'formation_date': (date,),  # noqa: E501
            'formation_state': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'is_customer': (bool,),  # noqa: E501
            'last_updated_time': (datetime,),  # noqa: E501
            'legal_address': (Address,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'phone_number': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'structure': (str,),  # noqa: E501
            'tenant': (str,),  # noqa: E501
            'trade_names': ([str],),  # noqa: E501
            'verification_last_run': (datetime,),  # noqa: E501
            'verification_status': (VerificationStatus,),  # noqa: E501
            'website': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'creation_time': 'creation_time',  # noqa: E501
        'ein': 'ein',  # noqa: E501
        'email': 'email',  # noqa: E501
        'entity_name': 'entity_name',  # noqa: E501
        'formation_date': 'formation_date',  # noqa: E501
        'formation_state': 'formation_state',  # noqa: E501
        'id': 'id',  # noqa: E501
        'is_customer': 'is_customer',  # noqa: E501
        'last_updated_time': 'last_updated_time',  # noqa: E501
        'legal_address': 'legal_address',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'phone_number': 'phone_number',  # noqa: E501
        'status': 'status',  # noqa: E501
        'structure': 'structure',  # noqa: E501
        'tenant': 'tenant',  # noqa: E501
        'trade_names': 'trade_names',  # noqa: E501
        'verification_last_run': 'verification_last_run',  # noqa: E501
        'verification_status': 'verification_status',  # noqa: E501
        'website': 'website',  # noqa: E501
    }

    read_only_vars = {
        'creation_time',  # noqa: E501
        'id',  # noqa: E501
        'last_updated_time',  # noqa: E501
        'verification_last_run',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """PatchBusiness - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            creation_time (datetime): The date and time the resource was created.. [optional]  # noqa: E501
            ein (str): U.S. Employer Identification Number (EIN) for this business, in the format xx-xxxxxxx.. [optional]  # noqa: E501
            email (str): Business's email.. [optional]  # noqa: E501
            entity_name (str): Business's legal name.. [optional]  # noqa: E501
            formation_date (date): Date the business was legally registered in RFC 3339 full-date format (YYYY-MM-DD).. [optional]  # noqa: E501
            formation_state (str): U.S. state where the business is legally registered (2-letter abbreviation).. [optional]  # noqa: E501
            id (str): Business's unique identifier.. [optional]  # noqa: E501
            is_customer (bool): True for personal and business customers with a direct relationship with the fintech or bank. Set this to true for any customer related to an account. . [optional]  # noqa: E501
            last_updated_time (datetime): The date and time the resource was last updated.. [optional]  # noqa: E501
            legal_address (Address): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. . [optional]  # noqa: E501
            phone_number (str): Business's phone number with country code in E.164 format. Must have a valid country code. Area code and local phone number are not validated.. [optional]  # noqa: E501
            status (str): Status of the business. One of the following: * `PROSPECT` – a potential customer, used for information-gathering and disclosures. * `ACTIVE` –  is an integrator defined status.  Integrators should set a business to active if they believe the person to be qualified for conducting business.  Synctera will combine this status with other statuses such a verification to determine if the business is eligible for specific actions such as initiating transactions or issuing a card. * `FROZEN` – business's actions are blocked for security, legal, or other reasons. * `SANCTION` – business is on a sanctions list and should be carefully monitored. * `DISSOLVED` – an inactive status indicating a business entity has filed articles of dissolution or a certificate of termination to terminate its existence. * `CANCELLED` – an inactive status indicating that a business entity has filed a cancellation or has failed to file its periodic report after notice of forfeiture of its rights to do business. * `SUSPENDED` – an inactive status indicating that the business entity has lost the right to operate in it's registered jurisdiction. * `MERGED` – an inactive status indicating that the business entity has terminated existence by merging into another entity. * `INACTIVE` – an inactive status indicating that the business entity is no longer active. * `CONVERTED` – An inactive status indicating that the business entity has been converted to another type of business entity in the same jurisdiction. . [optional]  # noqa: E501
            structure (str): Business's legal structure.. [optional]  # noqa: E501
            tenant (str): The id of the tenant containing the resource. . [optional]  # noqa: E501
            trade_names ([str]): Other names by which this business is known.. [optional]  # noqa: E501
            verification_last_run (datetime): Date and time KYB verification was last run on the business.. [optional]  # noqa: E501
            verification_status (VerificationStatus): [optional]  # noqa: E501
            website (str): Business's website.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PatchBusiness - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            creation_time (datetime): The date and time the resource was created.. [optional]  # noqa: E501
            ein (str): U.S. Employer Identification Number (EIN) for this business, in the format xx-xxxxxxx.. [optional]  # noqa: E501
            email (str): Business's email.. [optional]  # noqa: E501
            entity_name (str): Business's legal name.. [optional]  # noqa: E501
            formation_date (date): Date the business was legally registered in RFC 3339 full-date format (YYYY-MM-DD).. [optional]  # noqa: E501
            formation_state (str): U.S. state where the business is legally registered (2-letter abbreviation).. [optional]  # noqa: E501
            id (str): Business's unique identifier.. [optional]  # noqa: E501
            is_customer (bool): True for personal and business customers with a direct relationship with the fintech or bank. Set this to true for any customer related to an account. . [optional]  # noqa: E501
            last_updated_time (datetime): The date and time the resource was last updated.. [optional]  # noqa: E501
            legal_address (Address): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. . [optional]  # noqa: E501
            phone_number (str): Business's phone number with country code in E.164 format. Must have a valid country code. Area code and local phone number are not validated.. [optional]  # noqa: E501
            status (str): Status of the business. One of the following: * `PROSPECT` – a potential customer, used for information-gathering and disclosures. * `ACTIVE` –  is an integrator defined status.  Integrators should set a business to active if they believe the person to be qualified for conducting business.  Synctera will combine this status with other statuses such a verification to determine if the business is eligible for specific actions such as initiating transactions or issuing a card. * `FROZEN` – business's actions are blocked for security, legal, or other reasons. * `SANCTION` – business is on a sanctions list and should be carefully monitored. * `DISSOLVED` – an inactive status indicating a business entity has filed articles of dissolution or a certificate of termination to terminate its existence. * `CANCELLED` – an inactive status indicating that a business entity has filed a cancellation or has failed to file its periodic report after notice of forfeiture of its rights to do business. * `SUSPENDED` – an inactive status indicating that the business entity has lost the right to operate in it's registered jurisdiction. * `MERGED` – an inactive status indicating that the business entity has terminated existence by merging into another entity. * `INACTIVE` – an inactive status indicating that the business entity is no longer active. * `CONVERTED` – An inactive status indicating that the business entity has been converted to another type of business entity in the same jurisdiction. . [optional]  # noqa: E501
            structure (str): Business's legal structure.. [optional]  # noqa: E501
            tenant (str): The id of the tenant containing the resource. . [optional]  # noqa: E501
            trade_names ([str]): Other names by which this business is known.. [optional]  # noqa: E501
            verification_last_run (datetime): Date and time KYB verification was last run on the business.. [optional]  # noqa: E501
            verification_status (VerificationStatus): [optional]  # noqa: E501
            website (str): Business's website.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              Base,
          ],
          'oneOf': [
          ],
        }
