"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from synctera_client.exceptions import ApiAttributeError



class ExternalAccountLinkToken(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('country_codes',): {
            'US': "US",
        },
        ('language',): {
            'EN': "EN",
            'FR': "FR",
            'ES': "ES",
            'NL': "NL",
            'DE': "DE",
        },
        ('type',): {
            'DEPOSITORY': "DEPOSITORY",
            'CREDIT': "CREDIT",
            'INVESTMENT': "INVESTMENT",
            'MICRO_DEPOSIT': "MICRO_DEPOSIT",
        },
        ('sdk_type',): {
            'WEB': "WEB",
            'IOS': "IOS",
            'ANDROID': "ANDROID",
        },
    }

    validations = {
        ('country_codes',): {
            'min_items': 1,
        },
        ('vendor_institution_id',): {
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'client_name': (str,),  # noqa: E501
            'country_codes': ([str],),  # noqa: E501
            'language': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'business_id': (str,),  # noqa: E501
            'customer_id': (str,),  # noqa: E501
            'expiration': (datetime,),  # noqa: E501
            'link_customization_name': (str,),  # noqa: E501
            'link_token': (str,),  # noqa: E501
            'redirect_uri': (str,),  # noqa: E501
            'request_id': (str,),  # noqa: E501
            'sdk_type': (str,),  # noqa: E501
            'vendor_access_token': (str,),  # noqa: E501
            'vendor_institution_id': (str,),  # noqa: E501
            'verify_owner': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'client_name': 'client_name',  # noqa: E501
        'country_codes': 'country_codes',  # noqa: E501
        'language': 'language',  # noqa: E501
        'type': 'type',  # noqa: E501
        'business_id': 'business_id',  # noqa: E501
        'customer_id': 'customer_id',  # noqa: E501
        'expiration': 'expiration',  # noqa: E501
        'link_customization_name': 'link_customization_name',  # noqa: E501
        'link_token': 'link_token',  # noqa: E501
        'redirect_uri': 'redirect_uri',  # noqa: E501
        'request_id': 'request_id',  # noqa: E501
        'sdk_type': 'sdk_type',  # noqa: E501
        'vendor_access_token': 'vendor_access_token',  # noqa: E501
        'vendor_institution_id': 'vendor_institution_id',  # noqa: E501
        'verify_owner': 'verify_owner',  # noqa: E501
    }

    read_only_vars = {
        'expiration',  # noqa: E501
        'link_token',  # noqa: E501
        'request_id',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, client_name, country_codes, language, type, *args, **kwargs):  # noqa: E501
        """ExternalAccountLinkToken - a model defined in OpenAPI

        Args:
            client_name (str): The name of your application, as it should be displayed in Link. Maximum length of 30 characters.
            country_codes ([str]): Country codes in the ISO-3166-1 alpha-2 country code standard.
            language (str): The language that corresponds to the link token. For Plaid, see their [documentation](https://plaid.com/docs/api/tokens/#link-token-create-request-language) for a list of allowed values. 
            type (str): The type of the link token. DEPOSITORY for checking and savings accounts, CREDIT for credit card type accounts, INVESTMENT for investment accounts, and MICRO_DEPOSIT for depository accounts with support for micro-deposits verification.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            business_id (str): The identifier for the business customer associated with this external account. Exactly one of `business_id` or `customer_id` must be specified. . [optional]  # noqa: E501
            customer_id (str): The identifier for the personal customer associated with this external account. Exactly one of `customer_id` or `business_id` must be specified. . [optional]  # noqa: E501
            expiration (datetime): The expiration date for the link_token. Expires in 4 hours.. [optional]  # noqa: E501
            link_customization_name (str): The name of the Link customization from the Plaid Dashboard to be applied to Link. If not specified, the default customization will be used. When using a Link customization, the language in the customization must match the language selected via the language parameter, and the countries in the customization should match the country codes selected via country_codes. . [optional]  # noqa: E501
            link_token (str): A link_token, which can be supplied to Link in order to initialize it and receive a public_token, which can be exchanged for an access_token. . [optional]  # noqa: E501
            redirect_uri (str): A URI indicating the destination where a user should be forwarded after completing the Link flow; used to support OAuth authentication flows when launching Link in the browser or via a webview. . [optional]  # noqa: E501
            request_id (str): A unique identifier for the request, which can be used for troubleshooting.. [optional]  # noqa: E501
            sdk_type (str): Describes the environment of the client code running a vendor-supplied SDK. [optional] if omitted the server will use the default value of "WEB"  # noqa: E501
            vendor_access_token (str): The access token associated with the Item data is being requested for.. [optional]  # noqa: E501
            vendor_institution_id (str): The ID of the institution the access token is requested for. If present the link token will be created in an update mode. . [optional]  # noqa: E501
            verify_owner (bool): If true, Synctera will attempt to verify that the external account owner is the same as the customer by comparing external account data to customer data. At least 2 of the following fields must match: name, phone number, email, address. Verification is disabled by default. . [optional] if omitted the server will use the default value of False  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.client_name = client_name
        self.country_codes = country_codes
        self.language = language
        self.type = type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, client_name, country_codes, language, type, *args, **kwargs):  # noqa: E501
        """ExternalAccountLinkToken - a model defined in OpenAPI

        Args:
            client_name (str): The name of your application, as it should be displayed in Link. Maximum length of 30 characters.
            country_codes ([str]): Country codes in the ISO-3166-1 alpha-2 country code standard.
            language (str): The language that corresponds to the link token. For Plaid, see their [documentation](https://plaid.com/docs/api/tokens/#link-token-create-request-language) for a list of allowed values. 
            type (str): The type of the link token. DEPOSITORY for checking and savings accounts, CREDIT for credit card type accounts, INVESTMENT for investment accounts, and MICRO_DEPOSIT for depository accounts with support for micro-deposits verification.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            business_id (str): The identifier for the business customer associated with this external account. Exactly one of `business_id` or `customer_id` must be specified. . [optional]  # noqa: E501
            customer_id (str): The identifier for the personal customer associated with this external account. Exactly one of `customer_id` or `business_id` must be specified. . [optional]  # noqa: E501
            expiration (datetime): The expiration date for the link_token. Expires in 4 hours.. [optional]  # noqa: E501
            link_customization_name (str): The name of the Link customization from the Plaid Dashboard to be applied to Link. If not specified, the default customization will be used. When using a Link customization, the language in the customization must match the language selected via the language parameter, and the countries in the customization should match the country codes selected via country_codes. . [optional]  # noqa: E501
            link_token (str): A link_token, which can be supplied to Link in order to initialize it and receive a public_token, which can be exchanged for an access_token. . [optional]  # noqa: E501
            redirect_uri (str): A URI indicating the destination where a user should be forwarded after completing the Link flow; used to support OAuth authentication flows when launching Link in the browser or via a webview. . [optional]  # noqa: E501
            request_id (str): A unique identifier for the request, which can be used for troubleshooting.. [optional]  # noqa: E501
            sdk_type (str): Describes the environment of the client code running a vendor-supplied SDK. [optional] if omitted the server will use the default value of "WEB"  # noqa: E501
            vendor_access_token (str): The access token associated with the Item data is being requested for.. [optional]  # noqa: E501
            vendor_institution_id (str): The ID of the institution the access token is requested for. If present the link token will be created in an update mode. . [optional]  # noqa: E501
            verify_owner (bool): If true, Synctera will attempt to verify that the external account owner is the same as the customer by comparing external account data to customer data. At least 2 of the following fields must match: name, phone number, email, address. Verification is disabled by default. . [optional] if omitted the server will use the default value of False  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.client_name = client_name
        self.country_codes = country_codes
        self.language = language
        self.type = type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
