"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from synctera_client.exceptions import ApiAttributeError


def lazy_import():
    from synctera_client.model.vendor_info1 import VendorInfo1
    globals()['VendorInfo1'] = VendorInfo1


class Deposit(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'SUBMITTED': "SUBMITTED",
            'PENDING': "PENDING",
            'FAILED': "FAILED",
            'REJECTED': "REJECTED",
        },
    }

    validations = {
        ('check_amount',): {
            'inclusive_minimum': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'account_id': (str,),  # noqa: E501
            'back_image_id': (str,),  # noqa: E501
            'check_amount': (int,),  # noqa: E501
            'date_captured': (datetime,),  # noqa: E501
            'date_processed': (datetime,),  # noqa: E501
            'deposit_amount': (int,),  # noqa: E501
            'deposit_currency': (str,),  # noqa: E501
            'front_image_id': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'transaction_id': (str,),  # noqa: E501
            'vendor_info': (VendorInfo1,),  # noqa: E501
            'business_id': (str,),  # noqa: E501
            'creation_time': (datetime,),  # noqa: E501
            'last_updated_time': (datetime,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'ocr_account_number': (str,),  # noqa: E501
            'ocr_check_number': (str,),  # noqa: E501
            'ocr_routing_number': (str,),  # noqa: E501
            'person_id': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'account_id': 'account_id',  # noqa: E501
        'back_image_id': 'back_image_id',  # noqa: E501
        'check_amount': 'check_amount',  # noqa: E501
        'date_captured': 'date_captured',  # noqa: E501
        'date_processed': 'date_processed',  # noqa: E501
        'deposit_amount': 'deposit_amount',  # noqa: E501
        'deposit_currency': 'deposit_currency',  # noqa: E501
        'front_image_id': 'front_image_id',  # noqa: E501
        'id': 'id',  # noqa: E501
        'status': 'status',  # noqa: E501
        'transaction_id': 'transaction_id',  # noqa: E501
        'vendor_info': 'vendor_info',  # noqa: E501
        'business_id': 'business_id',  # noqa: E501
        'creation_time': 'creation_time',  # noqa: E501
        'last_updated_time': 'last_updated_time',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'ocr_account_number': 'ocr_account_number',  # noqa: E501
        'ocr_check_number': 'ocr_check_number',  # noqa: E501
        'ocr_routing_number': 'ocr_routing_number',  # noqa: E501
        'person_id': 'person_id',  # noqa: E501
    }

    read_only_vars = {
        'date_captured',  # noqa: E501
        'date_processed',  # noqa: E501
        'deposit_amount',  # noqa: E501
        'id',  # noqa: E501
        'status',  # noqa: E501
        'transaction_id',  # noqa: E501
        'creation_time',  # noqa: E501
        'last_updated_time',  # noqa: E501
        'ocr_account_number',  # noqa: E501
        'ocr_check_number',  # noqa: E501
        'ocr_routing_number',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, account_id, back_image_id, check_amount, date_captured, date_processed, deposit_amount, deposit_currency, front_image_id, id, status, transaction_id, vendor_info, *args, **kwargs):  # noqa: E501
        """Deposit - a model defined in OpenAPI

        Args:
            account_id (str): The ID of the account
            back_image_id (str): ID of the uploaded image of the back of the check
            check_amount (int): Amount on check in ISO 4217 minor currency units
            date_captured (datetime): Date the deposit was captured, in RFC 3339 format
            date_processed (datetime): Date the deposit was processed, in RFC 3339 format
            deposit_amount (int): Amount deposited in ISO 4217 minor currency units
            deposit_currency (str): ISO 4217 currency code for the deposit amount
            front_image_id (str): ID of the uploaded image of the front of the check
            id (str): Remote Check Deposit ID
            status (str): The status of the deposit
            transaction_id (str): The ID of the transaction associated with this deposit
            vendor_info (VendorInfo1):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            business_id (str): Unique ID for the business. Exactly one of `business_id` or `person_id` must be set. . [optional]  # noqa: E501
            creation_time (datetime): [optional]  # noqa: E501
            last_updated_time (datetime): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. . [optional]  # noqa: E501
            ocr_account_number (str): Account number of the issuer of the check, included if OCR is successful. [optional]  # noqa: E501
            ocr_check_number (str): The unique check number for this check in the checkbook, included if OCR is successful and there is a check number on the check. [optional]  # noqa: E501
            ocr_routing_number (str): Routing number of the issuing bank, included if OCR is successful. [optional]  # noqa: E501
            person_id (str): Unique ID for the person. Exactly one of `person_id` or `business_id` must be set. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.account_id = account_id
        self.back_image_id = back_image_id
        self.check_amount = check_amount
        self.date_captured = date_captured
        self.date_processed = date_processed
        self.deposit_amount = deposit_amount
        self.deposit_currency = deposit_currency
        self.front_image_id = front_image_id
        self.id = id
        self.status = status
        self.transaction_id = transaction_id
        self.vendor_info = vendor_info
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, account_id, back_image_id, check_amount, deposit_currency, front_image_id, vendor_info, *args, **kwargs):  # noqa: E501
        """Deposit - a model defined in OpenAPI

        Args:
            account_id (str): The ID of the account
            back_image_id (str): ID of the uploaded image of the back of the check
            check_amount (int): Amount on check in ISO 4217 minor currency units
            deposit_currency (str): ISO 4217 currency code for the deposit amount
            front_image_id (str): ID of the uploaded image of the front of the check
            vendor_info (VendorInfo1):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            business_id (str): Unique ID for the business. Exactly one of `business_id` or `person_id` must be set. . [optional]  # noqa: E501
            creation_time (datetime): [optional]  # noqa: E501
            last_updated_time (datetime): [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. . [optional]  # noqa: E501
            ocr_account_number (str): Account number of the issuer of the check, included if OCR is successful. [optional]  # noqa: E501
            ocr_check_number (str): The unique check number for this check in the checkbook, included if OCR is successful and there is a check number on the check. [optional]  # noqa: E501
            ocr_routing_number (str): Routing number of the issuing bank, included if OCR is successful. [optional]  # noqa: E501
            person_id (str): Unique ID for the person. Exactly one of `person_id` or `business_id` must be set. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.account_id = account_id
        self.back_image_id = back_image_id
        self.check_amount = check_amount
        self.deposit_currency = deposit_currency
        self.front_image_id = front_image_id
        self.vendor_info = vendor_info
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
