"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from synctera_client.exceptions import ApiAttributeError


def lazy_import():
    from synctera_client.model.address1 import Address1
    from synctera_client.model.external_payment_date import ExternalPaymentDate
    globals()['Address1'] = Address1
    globals()['ExternalPaymentDate'] = ExternalPaymentDate


class ApplicationRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('business_type',): {
            'INDIVIDUAL_SOLE_PROPRIETORSHIP': "INDIVIDUAL_SOLE_PROPRIETORSHIP",
            'CORPORATION': "CORPORATION",
            'LIMITED_LIABILITY_COMPANY': "LIMITED_LIABILITY_COMPANY",
            'PARTNERSHIP': "PARTNERSHIP",
            'ASSOCIATION_ESTATE_TRUST': "ASSOCIATION_ESTATE_TRUST",
            'TAX_EXEMPT_ORGANIZATION': "TAX_EXEMPT_ORGANIZATION",
            'INTERNATIONAL_ORGANIZATION': "INTERNATIONAL_ORGANIZATION",
            'GOVERNMENT_AGENCY': "GOVERNMENT_AGENCY",
        },
    }

    validations = {
        ('business_tax_id',): {
            'max_length': 9,
            'min_length': 9,
        },
        ('tax_id',): {
            'max_length': 9,
            'min_length': 9,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'bank_id': (int,),  # noqa: E501
            'business_address': (Address1,),  # noqa: E501
            'business_name': (str,),  # noqa: E501
            'business_phone': (str,),  # noqa: E501
            'business_tax_id': (str,),  # noqa: E501
            'business_type': (str,),  # noqa: E501
            'doing_business_as': (str,),  # noqa: E501
            'enabled': (bool,),  # noqa: E501
            'max_transaction_amount': (int,),  # noqa: E501
            'partner_id': (int,),  # noqa: E501
            'dob': (ExternalPaymentDate,),  # noqa: E501
            'email': (str,),  # noqa: E501
            'first_name': (str,),  # noqa: E501
            'incorporation_date': (ExternalPaymentDate,),  # noqa: E501
            'last_name': (str,),  # noqa: E501
            'personal_address': (Address1,),  # noqa: E501
            'phone': (str,),  # noqa: E501
            'principal_percentage_ownership': (str,),  # noqa: E501
            'tax_id': (str,),  # noqa: E501
            'title': (str,),  # noqa: E501
            'url': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'bank_id': 'bank_id',  # noqa: E501
        'business_address': 'business_address',  # noqa: E501
        'business_name': 'business_name',  # noqa: E501
        'business_phone': 'business_phone',  # noqa: E501
        'business_tax_id': 'business_tax_id',  # noqa: E501
        'business_type': 'business_type',  # noqa: E501
        'doing_business_as': 'doing_business_as',  # noqa: E501
        'enabled': 'enabled',  # noqa: E501
        'max_transaction_amount': 'max_transaction_amount',  # noqa: E501
        'partner_id': 'partner_id',  # noqa: E501
        'dob': 'dob',  # noqa: E501
        'email': 'email',  # noqa: E501
        'first_name': 'first_name',  # noqa: E501
        'incorporation_date': 'incorporation_date',  # noqa: E501
        'last_name': 'last_name',  # noqa: E501
        'personal_address': 'personal_address',  # noqa: E501
        'phone': 'phone',  # noqa: E501
        'principal_percentage_ownership': 'principal_percentage_ownership',  # noqa: E501
        'tax_id': 'tax_id',  # noqa: E501
        'title': 'title',  # noqa: E501
        'url': 'url',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, bank_id, business_address, business_name, business_phone, business_tax_id, business_type, doing_business_as, enabled, max_transaction_amount, partner_id, *args, **kwargs):  # noqa: E501
        """ApplicationRequest - a model defined in OpenAPI

        Args:
            bank_id (int): Bank ID
            business_address (Address1):
            business_name (str):
            business_phone (str):
            business_tax_id (str):
            business_type (str):
            doing_business_as (str):
            enabled (bool): To enable or disable aft/oct feature
            max_transaction_amount (int): Maximum amount that can be transacted for a single transaction in cents
            partner_id (int): Partner ID

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            dob (ExternalPaymentDate): [optional]  # noqa: E501
            email (str): [optional]  # noqa: E501
            first_name (str): [optional]  # noqa: E501
            incorporation_date (ExternalPaymentDate): [optional]  # noqa: E501
            last_name (str): [optional]  # noqa: E501
            personal_address (Address1): [optional]  # noqa: E501
            phone (str): [optional]  # noqa: E501
            principal_percentage_ownership (str): [optional]  # noqa: E501
            tax_id (str): [optional]  # noqa: E501
            title (str): [optional]  # noqa: E501
            url (str): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.bank_id = bank_id
        self.business_address = business_address
        self.business_name = business_name
        self.business_phone = business_phone
        self.business_tax_id = business_tax_id
        self.business_type = business_type
        self.doing_business_as = doing_business_as
        self.enabled = enabled
        self.max_transaction_amount = max_transaction_amount
        self.partner_id = partner_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, bank_id, business_address, business_name, business_phone, business_tax_id, business_type, doing_business_as, enabled, max_transaction_amount, partner_id, *args, **kwargs):  # noqa: E501
        """ApplicationRequest - a model defined in OpenAPI

        Args:
            bank_id (int): Bank ID
            business_address (Address1):
            business_name (str):
            business_phone (str):
            business_tax_id (str):
            business_type (str):
            doing_business_as (str):
            enabled (bool): To enable or disable aft/oct feature
            max_transaction_amount (int): Maximum amount that can be transacted for a single transaction in cents
            partner_id (int): Partner ID

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            dob (ExternalPaymentDate): [optional]  # noqa: E501
            email (str): [optional]  # noqa: E501
            first_name (str): [optional]  # noqa: E501
            incorporation_date (ExternalPaymentDate): [optional]  # noqa: E501
            last_name (str): [optional]  # noqa: E501
            personal_address (Address1): [optional]  # noqa: E501
            phone (str): [optional]  # noqa: E501
            principal_percentage_ownership (str): [optional]  # noqa: E501
            tax_id (str): [optional]  # noqa: E501
            title (str): [optional]  # noqa: E501
            url (str): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.bank_id = bank_id
        self.business_address = business_address
        self.business_name = business_name
        self.business_phone = business_phone
        self.business_tax_id = business_tax_id
        self.business_type = business_type
        self.doing_business_as = doing_business_as
        self.enabled = enabled
        self.max_transaction_amount = max_transaction_amount
        self.partner_id = partner_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
