"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from synctera_client.exceptions import ApiAttributeError


def lazy_import():
    from synctera_client.model.account_access_status import AccountAccessStatus
    from synctera_client.model.account_charge_secured import AccountChargeSecured
    from synctera_client.model.account_depository import AccountDepository
    from synctera_client.model.account_line_of_credit import AccountLineOfCredit
    from synctera_client.model.account_type import AccountType
    from synctera_client.model.balance import Balance
    from synctera_client.model.balance_ceiling import BalanceCeiling
    from synctera_client.model.balance_floor import BalanceFloor
    from synctera_client.model.customer_type import CustomerType
    from synctera_client.model.minimum_payment_partial import MinimumPaymentPartial
    from synctera_client.model.security import Security
    from synctera_client.model.spend_control_ids import SpendControlIds
    from synctera_client.model.spending_limits import SpendingLimits
    from synctera_client.model.status import Status
    globals()['AccountAccessStatus'] = AccountAccessStatus
    globals()['AccountChargeSecured'] = AccountChargeSecured
    globals()['AccountDepository'] = AccountDepository
    globals()['AccountLineOfCredit'] = AccountLineOfCredit
    globals()['AccountType'] = AccountType
    globals()['Balance'] = Balance
    globals()['BalanceCeiling'] = BalanceCeiling
    globals()['BalanceFloor'] = BalanceFloor
    globals()['CustomerType'] = CustomerType
    globals()['MinimumPaymentPartial'] = MinimumPaymentPartial
    globals()['Security'] = Security
    globals()['SpendControlIds'] = SpendControlIds
    globals()['SpendingLimits'] = SpendingLimits
    globals()['Status'] = Status


class Account(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('account_number',): {
            'max_length': 50,
        },
        ('account_number_masked',): {
            'max_length': 50,
        },
        ('bank_routing',): {
            'max_length': 9,
        },
        ('currency',): {
            'regex': {
                'pattern': r'^[A-Z]{3}$',  # noqa: E501
            },
        },
        ('exchange_rate_type',): {
            'max_length': 10,
        },
        ('iban',): {
            'max_length': 34,
        },
        ('swift_code',): {
            'max_length': 11,
            'min_length': 8,
        },
        ('overdraft_limit',): {
            'inclusive_minimum': 0,
        },
        ('chargeoff_period',): {
            'inclusive_minimum': 0,
        },
        ('credit_limit',): {
            'inclusive_minimum': 0,
        },
        ('delinquency_period',): {
            'inclusive_minimum': 0,
        },
        ('grace_period',): {
            'inclusive_minimum': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'access_status': (AccountAccessStatus,),  # noqa: E501
            'account_number': (str,),  # noqa: E501
            'account_number_masked': (str,),  # noqa: E501
            'account_purpose': (str,),  # noqa: E501
            'account_type': (AccountType,),  # noqa: E501
            'application_id': (str,),  # noqa: E501
            'balances': ([Balance],),  # noqa: E501
            'bank_routing': (str,),  # noqa: E501
            'creation_time': (datetime,),  # noqa: E501
            'currency': (str,),  # noqa: E501
            'customer_ids': ([str],),  # noqa: E501
            'customer_type': (CustomerType,),  # noqa: E501
            'exchange_rate_type': (str,),  # noqa: E501
            'iban': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'is_account_pool': (bool,),  # noqa: E501
            'is_ach_enabled': (bool,),  # noqa: E501
            'is_card_enabled': (bool,),  # noqa: E501
            'is_p2p_enabled': (bool,),  # noqa: E501
            'is_wire_enabled': (bool,),  # noqa: E501
            'last_updated_time': (datetime,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'nickname': (str,),  # noqa: E501
            'status': (Status,),  # noqa: E501
            'swift_code': (str,),  # noqa: E501
            'tenant': (str,),  # noqa: E501
            'balance_ceiling': (BalanceCeiling,),  # noqa: E501
            'balance_floor': (BalanceFloor,),  # noqa: E501
            'fee_product_ids': ([str],),  # noqa: E501
            'interest_product_id': (str,),  # noqa: E501
            'overdraft_limit': (int,),  # noqa: E501
            'spend_control_ids': (SpendControlIds,),  # noqa: E501
            'spending_limits': (SpendingLimits,),  # noqa: E501
            'chargeoff_period': (int,),  # noqa: E501
            'credit_limit': (int,),  # noqa: E501
            'delinquency_period': (int,),  # noqa: E501
            'grace_period': (int,),  # noqa: E501
            'minimum_payment': (MinimumPaymentPartial,),  # noqa: E501
            'security': (Security,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'access_status': 'access_status',  # noqa: E501
        'account_number': 'account_number',  # noqa: E501
        'account_number_masked': 'account_number_masked',  # noqa: E501
        'account_purpose': 'account_purpose',  # noqa: E501
        'account_type': 'account_type',  # noqa: E501
        'application_id': 'application_id',  # noqa: E501
        'balances': 'balances',  # noqa: E501
        'bank_routing': 'bank_routing',  # noqa: E501
        'creation_time': 'creation_time',  # noqa: E501
        'currency': 'currency',  # noqa: E501
        'customer_ids': 'customer_ids',  # noqa: E501
        'customer_type': 'customer_type',  # noqa: E501
        'exchange_rate_type': 'exchange_rate_type',  # noqa: E501
        'iban': 'iban',  # noqa: E501
        'id': 'id',  # noqa: E501
        'is_account_pool': 'is_account_pool',  # noqa: E501
        'is_ach_enabled': 'is_ach_enabled',  # noqa: E501
        'is_card_enabled': 'is_card_enabled',  # noqa: E501
        'is_p2p_enabled': 'is_p2p_enabled',  # noqa: E501
        'is_wire_enabled': 'is_wire_enabled',  # noqa: E501
        'last_updated_time': 'last_updated_time',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'nickname': 'nickname',  # noqa: E501
        'status': 'status',  # noqa: E501
        'swift_code': 'swift_code',  # noqa: E501
        'tenant': 'tenant',  # noqa: E501
        'balance_ceiling': 'balance_ceiling',  # noqa: E501
        'balance_floor': 'balance_floor',  # noqa: E501
        'fee_product_ids': 'fee_product_ids',  # noqa: E501
        'interest_product_id': 'interest_product_id',  # noqa: E501
        'overdraft_limit': 'overdraft_limit',  # noqa: E501
        'spend_control_ids': 'spend_control_ids',  # noqa: E501
        'spending_limits': 'spending_limits',  # noqa: E501
        'chargeoff_period': 'chargeoff_period',  # noqa: E501
        'credit_limit': 'credit_limit',  # noqa: E501
        'delinquency_period': 'delinquency_period',  # noqa: E501
        'grace_period': 'grace_period',  # noqa: E501
        'minimum_payment': 'minimum_payment',  # noqa: E501
        'security': 'security',  # noqa: E501
    }

    read_only_vars = {
        'account_number',  # noqa: E501
        'account_number_masked',  # noqa: E501
        'balances',  # noqa: E501
        'bank_routing',  # noqa: E501
        'creation_time',  # noqa: E501
        'customer_ids',  # noqa: E501
        'id',  # noqa: E501
        'is_ach_enabled',  # noqa: E501
        'is_card_enabled',  # noqa: E501
        'is_p2p_enabled',  # noqa: E501
        'is_wire_enabled',  # noqa: E501
        'last_updated_time',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Account - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_status (AccountAccessStatus): [optional]  # noqa: E501
            account_number (str): Account number. [optional]  # noqa: E501
            account_number_masked (str): The response will contain the bank fintech ID (3 or 6 digits) plus the last 4 digits, with the digits in between replaced with * characters. Shadow mode account numbers will not be masked.. [optional]  # noqa: E501
            account_purpose (str): Purpose of the account. [optional]  # noqa: E501
            account_type (AccountType): [optional]  # noqa: E501
            application_id (str): The application ID for this account. . [optional]  # noqa: E501
            balances ([Balance]): A list of balances for account based on different type. [optional]  # noqa: E501
            bank_routing (str): Bank routing number. [optional]  # noqa: E501
            creation_time (datetime): Account creation timestamp in RFC3339 format. [optional]  # noqa: E501
            currency (str): Account currency or account settlement currency. ISO 4217 alphabetic currency code. Default USD. [optional]  # noqa: E501
            customer_ids ([str]): A list of the customer IDs of the account holders.. [optional]  # noqa: E501
            customer_type (CustomerType): [optional]  # noqa: E501
            exchange_rate_type (str): Exchange rate type. [optional]  # noqa: E501
            iban (str): International bank account number. [optional]  # noqa: E501
            id (str): Account ID. [optional]  # noqa: E501
            is_account_pool (bool): Account is investment (variable balance) account or a multi-balance account pool. Default false. [optional]  # noqa: E501
            is_ach_enabled (bool): A flag to indicate whether ACH transactions are enabled.. [optional]  # noqa: E501
            is_card_enabled (bool): A flag to indicate whether card transactions are enabled.. [optional]  # noqa: E501
            is_p2p_enabled (bool): A flag to indicate whether P2P transactions are enabled.. [optional]  # noqa: E501
            is_wire_enabled (bool): A flag to indicate whether wire transactions are enabled.. [optional]  # noqa: E501
            last_updated_time (datetime): Timestamp of the last account modification in RFC3339 format. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): User provided account metadata. [optional]  # noqa: E501
            nickname (str): User provided account nickname. [optional]  # noqa: E501
            status (Status): [optional]  # noqa: E501
            swift_code (str): SWIFT code. [optional]  # noqa: E501
            tenant (str): The id of the tenant containing the resource. . [optional]  # noqa: E501
            balance_ceiling (BalanceCeiling): [optional]  # noqa: E501
            balance_floor (BalanceFloor): [optional]  # noqa: E501
            fee_product_ids ([str]): A list of fee account products that the current account associates with.. [optional]  # noqa: E501
            interest_product_id (str): An interest account product that the current account associates with. The account product must have its calculation_method set to COMPOUNDED_DAILY. . [optional]  # noqa: E501
            overdraft_limit (int): Account's overdraft limit. [optional]  # noqa: E501
            spend_control_ids (SpendControlIds): [optional]  # noqa: E501
            spending_limits (SpendingLimits): [optional]  # noqa: E501
            chargeoff_period (int): The number of days an account can stay delinquent before marking an account as charged-off. . [optional] if omitted the server will use the default value of 90  # noqa: E501
            credit_limit (int): The credit limit for this line of credit account in cents. Minimum is 0. . [optional]  # noqa: E501
            delinquency_period (int): The number of days past the due date to wait for a minimum payment before marking an account as delinquent. . [optional] if omitted the server will use the default value of 30  # noqa: E501
            grace_period (int): The number of days past the billing period to allow for payment before it is considered due. This directly infers the due date for a payment. . [optional]  # noqa: E501
            minimum_payment (MinimumPaymentPartial): [optional]  # noqa: E501
            security (Security): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Account - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_status (AccountAccessStatus): [optional]  # noqa: E501
            account_number (str): Account number. [optional]  # noqa: E501
            account_number_masked (str): The response will contain the bank fintech ID (3 or 6 digits) plus the last 4 digits, with the digits in between replaced with * characters. Shadow mode account numbers will not be masked.. [optional]  # noqa: E501
            account_purpose (str): Purpose of the account. [optional]  # noqa: E501
            account_type (AccountType): [optional]  # noqa: E501
            application_id (str): The application ID for this account. . [optional]  # noqa: E501
            balances ([Balance]): A list of balances for account based on different type. [optional]  # noqa: E501
            bank_routing (str): Bank routing number. [optional]  # noqa: E501
            creation_time (datetime): Account creation timestamp in RFC3339 format. [optional]  # noqa: E501
            currency (str): Account currency or account settlement currency. ISO 4217 alphabetic currency code. Default USD. [optional]  # noqa: E501
            customer_ids ([str]): A list of the customer IDs of the account holders.. [optional]  # noqa: E501
            customer_type (CustomerType): [optional]  # noqa: E501
            exchange_rate_type (str): Exchange rate type. [optional]  # noqa: E501
            iban (str): International bank account number. [optional]  # noqa: E501
            id (str): Account ID. [optional]  # noqa: E501
            is_account_pool (bool): Account is investment (variable balance) account or a multi-balance account pool. Default false. [optional]  # noqa: E501
            is_ach_enabled (bool): A flag to indicate whether ACH transactions are enabled.. [optional]  # noqa: E501
            is_card_enabled (bool): A flag to indicate whether card transactions are enabled.. [optional]  # noqa: E501
            is_p2p_enabled (bool): A flag to indicate whether P2P transactions are enabled.. [optional]  # noqa: E501
            is_wire_enabled (bool): A flag to indicate whether wire transactions are enabled.. [optional]  # noqa: E501
            last_updated_time (datetime): Timestamp of the last account modification in RFC3339 format. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): User provided account metadata. [optional]  # noqa: E501
            nickname (str): User provided account nickname. [optional]  # noqa: E501
            status (Status): [optional]  # noqa: E501
            swift_code (str): SWIFT code. [optional]  # noqa: E501
            tenant (str): The id of the tenant containing the resource. . [optional]  # noqa: E501
            balance_ceiling (BalanceCeiling): [optional]  # noqa: E501
            balance_floor (BalanceFloor): [optional]  # noqa: E501
            fee_product_ids ([str]): A list of fee account products that the current account associates with.. [optional]  # noqa: E501
            interest_product_id (str): An interest account product that the current account associates with. The account product must have its calculation_method set to COMPOUNDED_DAILY. . [optional]  # noqa: E501
            overdraft_limit (int): Account's overdraft limit. [optional]  # noqa: E501
            spend_control_ids (SpendControlIds): [optional]  # noqa: E501
            spending_limits (SpendingLimits): [optional]  # noqa: E501
            chargeoff_period (int): The number of days an account can stay delinquent before marking an account as charged-off. . [optional] if omitted the server will use the default value of 90  # noqa: E501
            credit_limit (int): The credit limit for this line of credit account in cents. Minimum is 0. . [optional]  # noqa: E501
            delinquency_period (int): The number of days past the due date to wait for a minimum payment before marking an account as delinquent. . [optional] if omitted the server will use the default value of 30  # noqa: E501
            grace_period (int): The number of days past the billing period to allow for payment before it is considered due. This directly infers the due date for a payment. . [optional]  # noqa: E501
            minimum_payment (MinimumPaymentPartial): [optional]  # noqa: E501
            security (Security): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
              AccountChargeSecured,
              AccountDepository,
              AccountLineOfCredit,
          ],
          'allOf': [
          ],
          'oneOf': [
          ],
        }
