"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.document import Document
from synctera_client.model.document_list import DocumentList
from synctera_client.model.document_type import DocumentType
from synctera_client.model.encryption import Encryption
from synctera_client.model.error import Error
from synctera_client.model.patch_document import PatchDocument
from synctera_client.model.related_resource_type import RelatedResourceType


class DocumentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_document_endpoint = _Endpoint(
            settings={
                'response_type': (Document,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents',
                'operation_id': 'create_document',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'file',
                    'description',
                    'encryption',
                    'is_restricted',
                    'metadata',
                    'name',
                    'related_resource_id',
                    'related_resource_type',
                    'tenant',
                    'type',
                ],
                'required': [
                    'file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'file':
                        (file_type,),
                    'description':
                        (str,),
                    'encryption':
                        (Encryption,),
                    'is_restricted':
                        (bool,),
                    'metadata':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                    'name':
                        (str,),
                    'related_resource_id':
                        (str,),
                    'related_resource_type':
                        (RelatedResourceType,),
                    'tenant':
                        (str,),
                    'type':
                        (DocumentType,),
                },
                'attribute_map': {
                    'file': 'file',
                    'description': 'description',
                    'encryption': 'encryption',
                    'is_restricted': 'is_restricted',
                    'metadata': 'metadata',
                    'name': 'name',
                    'related_resource_id': 'related_resource_id',
                    'related_resource_type': 'related_resource_type',
                    'tenant': 'tenant',
                    'type': 'type',
                },
                'location_map': {
                    'file': 'form',
                    'description': 'form',
                    'encryption': 'form',
                    'is_restricted': 'form',
                    'metadata': 'form',
                    'name': 'form',
                    'related_resource_id': 'form',
                    'related_resource_type': 'form',
                    'tenant': 'form',
                    'type': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_document_version_endpoint = _Endpoint(
            settings={
                'response_type': (Document,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents/{document_id}/versions',
                'operation_id': 'create_document_version',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_id',
                    'file',
                    'description',
                    'encryption',
                    'name',
                    'type',
                ],
                'required': [
                    'document_id',
                    'file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_id':
                        (str,),
                    'file':
                        (file_type,),
                    'description':
                        (str,),
                    'encryption':
                        (Encryption,),
                    'name':
                        (str,),
                    'type':
                        (DocumentType,),
                },
                'attribute_map': {
                    'document_id': 'document_id',
                    'file': 'file',
                    'description': 'description',
                    'encryption': 'encryption',
                    'name': 'name',
                    'type': 'type',
                },
                'location_map': {
                    'document_id': 'path',
                    'file': 'form',
                    'description': 'form',
                    'encryption': 'form',
                    'name': 'form',
                    'type': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.get_document_endpoint = _Endpoint(
            settings={
                'response_type': (Document,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents/{document_id}',
                'operation_id': 'get_document',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_id',
                ],
                'required': [
                    'document_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_id':
                        (str,),
                },
                'attribute_map': {
                    'document_id': 'document_id',
                },
                'location_map': {
                    'document_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_document_contents_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents/{document_id}/contents',
                'operation_id': 'get_document_contents',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_id',
                ],
                'required': [
                    'document_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_id':
                        (str,),
                },
                'attribute_map': {
                    'document_id': 'document_id',
                },
                'location_map': {
                    'document_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_document_version_endpoint = _Endpoint(
            settings={
                'response_type': (Document,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents/{document_id}/versions/{document_version}',
                'operation_id': 'get_document_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_id',
                    'document_version',
                ],
                'required': [
                    'document_id',
                    'document_version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_id':
                        (str,),
                    'document_version':
                        (int,),
                },
                'attribute_map': {
                    'document_id': 'document_id',
                    'document_version': 'document_version',
                },
                'location_map': {
                    'document_id': 'path',
                    'document_version': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_document_version_contents_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents/{document_id}/versions/{document_version}/contents',
                'operation_id': 'get_document_version_contents',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_id',
                    'document_version',
                ],
                'required': [
                    'document_id',
                    'document_version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_id':
                        (str,),
                    'document_version':
                        (int,),
                },
                'attribute_map': {
                    'document_id': 'document_id',
                    'document_version': 'document_version',
                },
                'location_map': {
                    'document_id': 'path',
                    'document_version': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_documents_endpoint = _Endpoint(
            settings={
                'response_type': (DocumentList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents',
                'operation_id': 'list_documents',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'limit',
                    'page_token',
                    'related_resource_type',
                    'related_resource_id',
                    'encryption',
                    'type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'encryption',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('encryption',): {

                        "REQUIRED": "REQUIRED",
                        "NOT_REQUIRED": "NOT_REQUIRED"
                    },
                },
                'openapi_types': {
                    'id':
                        ([str],),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                    'related_resource_type':
                        (RelatedResourceType,),
                    'related_resource_id':
                        (str,),
                    'encryption':
                        (str,),
                    'type':
                        (DocumentType,),
                },
                'attribute_map': {
                    'id': 'id',
                    'limit': 'limit',
                    'page_token': 'page_token',
                    'related_resource_type': 'related_resource_type',
                    'related_resource_id': 'related_resource_id',
                    'encryption': 'encryption',
                    'type': 'type',
                },
                'location_map': {
                    'id': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                    'related_resource_type': 'query',
                    'related_resource_id': 'query',
                    'encryption': 'query',
                    'type': 'query',
                },
                'collection_format_map': {
                    'id': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_document_endpoint = _Endpoint(
            settings={
                'response_type': (Document,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/documents/{document_id}',
                'operation_id': 'update_document',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_id',
                    'patch_document',
                ],
                'required': [
                    'document_id',
                    'patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_id':
                        (str,),
                    'patch_document':
                        (PatchDocument,),
                },
                'attribute_map': {
                    'document_id': 'document_id',
                },
                'location_map': {
                    'document_id': 'path',
                    'patch_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_document(
        self,
        file,
        **kwargs
    ):
        """Create a document  # noqa: E501

        Docs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_document(file, async_req=True)
        >>> result = thread.get()

        Args:
            file (file_type): The file contents

        Keyword Args:
            description (str): A description of the attached document. [optional]
            encryption (Encryption): [optional]
            is_restricted (bool): whether this document should be restricted (special permissions will be used to access restricted documents). [optional]
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. . [optional]
            name (str): A user-friendly name for the document. [optional]
            related_resource_id (str): The ID of the resource related to the document. [optional]
            related_resource_type (RelatedResourceType): [optional]
            tenant (str): The id of the tenant containing the resource. . [optional]
            type (DocumentType): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Document
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['file'] = \
            file
        return self.create_document_endpoint.call_with_http_info(**kwargs)

    def create_document_version(
        self,
        document_id,
        file,
        **kwargs
    ):
        """Create a new document version  # noqa: E501

        Docs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_document_version(document_id, file, async_req=True)
        >>> result = thread.get()

        Args:
            document_id (str): The unique identifier of the document.
            file (file_type): The file contents

        Keyword Args:
            description (str): A description of the attached document. [optional]
            encryption (Encryption): [optional]
            name (str): A user-friendly name for the document. [optional]
            type (DocumentType): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Document
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['document_id'] = \
            document_id
        kwargs['file'] = \
            file
        return self.create_document_version_endpoint.call_with_http_info(**kwargs)

    def get_document(
        self,
        document_id,
        **kwargs
    ):
        """Get a document  # noqa: E501

        Returns the document attributes. Use /documents/{document_id}/contents to get the contents.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document(document_id, async_req=True)
        >>> result = thread.get()

        Args:
            document_id (str): The unique identifier of the document.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Document
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['document_id'] = \
            document_id
        return self.get_document_endpoint.call_with_http_info(**kwargs)

    def get_document_contents(
        self,
        document_id,
        **kwargs
    ):
        """Get contents of latest document version  # noqa: E501

        Returns the bytes of the requested document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_contents(document_id, async_req=True)
        >>> result = thread.get()

        Args:
            document_id (str): The unique identifier of the document.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['document_id'] = \
            document_id
        return self.get_document_contents_endpoint.call_with_http_info(**kwargs)

    def get_document_version(
        self,
        document_id,
        document_version,
        **kwargs
    ):
        """Get a document by version  # noqa: E501

        Returns the document (attributes). Use /documents/{document_id}/versions/{version}/contents to get the contents.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_version(document_id, document_version, async_req=True)
        >>> result = thread.get()

        Args:
            document_id (str): The unique identifier of the document.
            document_version (int): The document version.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Document
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['document_id'] = \
            document_id
        kwargs['document_version'] = \
            document_version
        return self.get_document_version_endpoint.call_with_http_info(**kwargs)

    def get_document_version_contents(
        self,
        document_id,
        document_version,
        **kwargs
    ):
        """Get document contents by version  # noqa: E501

        Returns the bytes of the requested document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_version_contents(document_id, document_version, async_req=True)
        >>> result = thread.get()

        Args:
            document_id (str): The unique identifier of the document.
            document_version (int): The document version.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['document_id'] = \
            document_id
        kwargs['document_version'] = \
            document_version
        return self.get_document_version_contents_endpoint.call_with_http_info(**kwargs)

    def list_documents(
        self,
        **kwargs
    ):
        """List documents  # noqa: E501

        Returns a paginated list of documents (metadata only, not contents).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_documents(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            id ([str]): Unique resource identifier. [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            related_resource_type (RelatedResourceType): Return documents that are related to resources of the specified type. [optional]
            related_resource_id (str): Return documents that are related to resources with the specified ID. [optional]
            encryption (str): Whether the file should be encrypted and access restricted, e.g. if the file contains PII. [optional]
            type (DocumentType): The type of documents. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DocumentList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_documents_endpoint.call_with_http_info(**kwargs)

    def update_document(
        self,
        document_id,
        patch_document,
        **kwargs
    ):
        """Update a document  # noqa: E501

        Update attributes of the latest document version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_document(document_id, patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            document_id (str): The unique identifier of the document.
            patch_document (PatchDocument):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Document
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['document_id'] = \
            document_id
        kwargs['patch_document'] = \
            patch_document
        return self.update_document_endpoint.call_with_http_info(**kwargs)

