"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.account import Account
from synctera_client.model.account_creation import AccountCreation
from synctera_client.model.account_generic_response import AccountGenericResponse
from synctera_client.model.account_list import AccountList
from synctera_client.model.account_product import AccountProduct
from synctera_client.model.account_product_list import AccountProductList
from synctera_client.model.account_template import AccountTemplate
from synctera_client.model.account_template_response import AccountTemplateResponse
from synctera_client.model.account_type import AccountType
from synctera_client.model.customer_type import CustomerType
from synctera_client.model.delete_response import DeleteResponse
from synctera_client.model.error import Error
from synctera_client.model.patch_account_product import PatchAccountProduct
from synctera_client.model.relationship import Relationship
from synctera_client.model.relationship_list import RelationshipList
from synctera_client.model.status import Status
from synctera_client.model.template_list import TemplateList


class AccountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountGenericResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts',
                'operation_id': 'create_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_creation',
                    'idempotency_key',
                ],
                'required': [
                    'account_creation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_creation':
                        (AccountCreation,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'account_creation': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_account_relationship_endpoint = _Endpoint(
            settings={
                'response_type': (Relationship,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}/relationships',
                'operation_id': 'create_account_relationship',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'relationship',
                    'idempotency_key',
                ],
                'required': [
                    'account_id',
                    'relationship',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'relationship':
                        (Relationship,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'account_id': 'path',
                    'relationship': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_account_resource_product_endpoint = _Endpoint(
            settings={
                'response_type': (AccountProduct,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/products',
                'operation_id': 'create_account_resource_product',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_product',
                    'idempotency_key',
                ],
                'required': [
                    'account_product',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_product':
                        (AccountProduct,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'account_product': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_account_template_endpoint = _Endpoint(
            settings={
                'response_type': (AccountTemplateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/templates',
                'operation_id': 'create_account_template',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_template',
                    'idempotency_key',
                ],
                'required': [
                    'account_template',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_template':
                        (AccountTemplate,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'account_template': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_account_relationship_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}/relationships/{relationship_id}',
                'operation_id': 'delete_account_relationship',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'relationship_id',
                ],
                'required': [
                    'account_id',
                    'relationship_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'relationship_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'relationship_id': 'relationship_id',
                },
                'location_map': {
                    'account_id': 'path',
                    'relationship_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_account_template_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/templates/{template_id}',
                'operation_id': 'delete_account_template',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'template_id',
                ],
                'required': [
                    'template_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'template_id':
                        (str,),
                },
                'attribute_map': {
                    'template_id': 'template_id',
                },
                'location_map': {
                    'template_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountGenericResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}',
                'operation_id': 'get_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                },
                'location_map': {
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_account_relationship_endpoint = _Endpoint(
            settings={
                'response_type': (Relationship,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}/relationships/{relationship_id}',
                'operation_id': 'get_account_relationship',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'relationship_id',
                ],
                'required': [
                    'account_id',
                    'relationship_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'relationship_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'relationship_id': 'relationship_id',
                },
                'location_map': {
                    'account_id': 'path',
                    'relationship_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_account_template_endpoint = _Endpoint(
            settings={
                'response_type': (AccountTemplateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/templates/{template_id}',
                'operation_id': 'get_account_template',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'template_id',
                ],
                'required': [
                    'template_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'template_id':
                        (str,),
                },
                'attribute_map': {
                    'template_id': 'template_id',
                },
                'location_map': {
                    'template_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_account_relationship_endpoint = _Endpoint(
            settings={
                'response_type': (RelationshipList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}/relationships',
                'operation_id': 'list_account_relationship',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit',
                    'page_token',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'limit': 'limit',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_account_resource_products_endpoint = _Endpoint(
            settings={
                'response_type': (AccountProductList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/products',
                'operation_id': 'list_account_resource_products',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'product_type',
                    'limit',
                    'page_token',
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'product_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'product_type',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('product_type',): {

                        "FEE": "FEE",
                        "INTEREST": "INTEREST"
                    },
                },
                'openapi_types': {
                    'product_type':
                        (str,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                },
                'attribute_map': {
                    'product_type': 'product_type',
                    'limit': 'limit',
                    'page_token': 'page_token',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                },
                'location_map': {
                    'product_type': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_account_templates_endpoint = _Endpoint(
            settings={
                'response_type': (TemplateList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/templates',
                'operation_id': 'list_account_templates',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_type',
                    'limit',
                    'page_token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_type':
                        (AccountType,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'account_type': 'account_type',
                    'limit': 'limit',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'account_type': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (AccountList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts',
                'operation_id': 'list_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'account_type',
                    'linked_account_id',
                    'overdraft_account_id',
                    'overflow_account_id',
                    'account_number',
                    'status',
                    'interest_product_id',
                    'customer_type',
                    'spend_control_ids',
                    'customer_id',
                    'business_id',
                    'person_id',
                    'first_name',
                    'last_name',
                    'limit',
                    'page_token',
                    'sort_by',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort_by',
                ],
                'validation': [
                    'spend_control_ids',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('spend_control_ids',): {

                        'max_items': 10,
                    },
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort_by',): {

                        "ACCOUNT_NUMBER:ASC": "account_number:asc",
                        "ACCOUNT_NUMBER:DESC": "account_number:desc",
                        "ACCOUNT_TYPE:ASC": "account_type:asc",
                        "ACCOUNT_TYPE:DESC": "account_type:desc",
                        "FIRST_NAME:ASC": "first_name:asc",
                        "FIRST_NAME:DESC": "first_name:desc",
                        "LAST_NAME:ASC": "last_name:asc",
                        "LAST_NAME:DESC": "last_name:desc"
                    },
                },
                'openapi_types': {
                    'id':
                        ([str],),
                    'account_type':
                        (AccountType,),
                    'linked_account_id':
                        ([str],),
                    'overdraft_account_id':
                        ([str],),
                    'overflow_account_id':
                        ([str],),
                    'account_number':
                        ([str],),
                    'status':
                        (Status,),
                    'interest_product_id':
                        (str,),
                    'customer_type':
                        (CustomerType,),
                    'spend_control_ids':
                        (SpendControlIds,),
                    'customer_id':
                        (str,),
                    'business_id':
                        ([str],),
                    'person_id':
                        ([str],),
                    'first_name':
                        (str,),
                    'last_name':
                        (str,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                    'sort_by':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'account_type': 'account_type',
                    'linked_account_id': 'linked_account_id',
                    'overdraft_account_id': 'overdraft_account_id',
                    'overflow_account_id': 'overflow_account_id',
                    'account_number': 'account_number',
                    'status': 'status',
                    'interest_product_id': 'interest_product_id',
                    'customer_type': 'customer_type',
                    'spend_control_ids': 'spend_control_ids',
                    'customer_id': 'customer_id',
                    'business_id': 'business_id',
                    'person_id': 'person_id',
                    'first_name': 'first_name',
                    'last_name': 'last_name',
                    'limit': 'limit',
                    'page_token': 'page_token',
                    'sort_by': 'sort_by',
                },
                'location_map': {
                    'id': 'query',
                    'account_type': 'query',
                    'linked_account_id': 'query',
                    'overdraft_account_id': 'query',
                    'overflow_account_id': 'query',
                    'account_number': 'query',
                    'status': 'query',
                    'interest_product_id': 'query',
                    'customer_type': 'query',
                    'spend_control_ids': 'query',
                    'customer_id': 'query',
                    'business_id': 'query',
                    'person_id': 'query',
                    'first_name': 'query',
                    'last_name': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                    'sort_by': 'query',
                },
                'collection_format_map': {
                    'id': 'csv',
                    'linked_account_id': 'csv',
                    'overdraft_account_id': 'csv',
                    'overflow_account_id': 'csv',
                    'account_number': 'csv',
                    'spend_control_ids': 'csv',
                    'business_id': 'csv',
                    'person_id': 'csv',
                    'sort_by': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountGenericResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}',
                'operation_id': 'patch_account',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'account',
                    'idempotency_key',
                ],
                'required': [
                    'account_id',
                    'account',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'account':
                        (Account,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'account_id': 'path',
                    'account': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.patch_account_product_endpoint = _Endpoint(
            settings={
                'response_type': (AccountProduct,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/products/{product_id}',
                'operation_id': 'patch_account_product',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'product_id',
                    'patch_account_product',
                    'idempotency_key',
                ],
                'required': [
                    'product_id',
                    'patch_account_product',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'product_id':
                        (str,),
                    'patch_account_product':
                        (PatchAccountProduct,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'product_id': 'product_id',
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'product_id': 'path',
                    'patch_account_product': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountGenericResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}',
                'operation_id': 'update_account',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'account',
                ],
                'required': [
                    'account_id',
                    'account',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'account':
                        (Account,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                },
                'location_map': {
                    'account_id': 'path',
                    'account': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_account_relationship_endpoint = _Endpoint(
            settings={
                'response_type': (Relationship,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account_id}/relationships/{relationship_id}',
                'operation_id': 'update_account_relationship',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'relationship_id',
                    'relationship',
                ],
                'required': [
                    'account_id',
                    'relationship_id',
                    'relationship',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'relationship_id':
                        (str,),
                    'relationship':
                        (Relationship,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'relationship_id': 'relationship_id',
                },
                'location_map': {
                    'account_id': 'path',
                    'relationship_id': 'path',
                    'relationship': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_account_template_endpoint = _Endpoint(
            settings={
                'response_type': (AccountTemplateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/templates/{template_id}',
                'operation_id': 'update_account_template',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'template_id',
                    'account_template',
                ],
                'required': [
                    'template_id',
                    'account_template',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'template_id':
                        (str,),
                    'account_template':
                        (AccountTemplate,),
                },
                'attribute_map': {
                    'template_id': 'template_id',
                },
                'location_map': {
                    'template_id': 'path',
                    'account_template': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_account(
        self,
        account_creation,
        **kwargs
    ):
        """Create an account  # noqa: E501

        Create a shadow mode or lead mode account. You need to determine the mode according to integrator configuration, and specify the required fields accordingly.  Shadow mode required fields:   - account_number   - status  Lead mode required fields:   - account_template_id   - relationships   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account(account_creation, async_req=True)
        >>> result = thread.get()

        Args:
            account_creation (AccountCreation): Account to create

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountGenericResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_creation'] = \
            account_creation
        return self.create_account_endpoint.call_with_http_info(**kwargs)

    def create_account_relationship(
        self,
        account_id,
        relationship,
        **kwargs
    ):
        """Create account relationship  # noqa: E501

        Add a customer to an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_relationship(account_id, relationship, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.
            relationship (Relationship): Account relationship object

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Relationship
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['relationship'] = \
            relationship
        return self.create_account_relationship_endpoint.call_with_http_info(**kwargs)

    def create_account_resource_product(
        self,
        account_product,
        **kwargs
    ):
        """Create an account product  # noqa: E501

        Create an account product. Rates cannot be nil or empty.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_resource_product(account_product, async_req=True)
        >>> result = thread.get()

        Args:
            account_product (AccountProduct): Account product to create

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountProduct
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_product'] = \
            account_product
        return self.create_account_resource_product_endpoint.call_with_http_info(**kwargs)

    def create_account_template(
        self,
        account_template,
        **kwargs
    ):
        """Create an account template  # noqa: E501

        Create an account template. An account template is needed to create an account in a lead mode.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_template(account_template, async_req=True)
        >>> result = thread.get()

        Args:
            account_template (AccountTemplate): Account template to create

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountTemplateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_template'] = \
            account_template
        return self.create_account_template_endpoint.call_with_http_info(**kwargs)

    def delete_account_relationship(
        self,
        account_id,
        relationship_id,
        **kwargs
    ):
        """Delete account relationship  # noqa: E501

        Delete account relationship  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_account_relationship(account_id, relationship_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.
            relationship_id (str): Relationship ID of the account associate with the account entity

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['relationship_id'] = \
            relationship_id
        return self.delete_account_relationship_endpoint.call_with_http_info(**kwargs)

    def delete_account_template(
        self,
        template_id,
        **kwargs
    ):
        """Delete account template  # noqa: E501

        Delete account template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_account_template(template_id, async_req=True)
        >>> result = thread.get()

        Args:
            template_id (str): Account Template ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['template_id'] = \
            template_id
        return self.delete_account_template_endpoint.call_with_http_info(**kwargs)

    def get_account(
        self,
        account_id,
        **kwargs
    ):
        """Get account  # noqa: E501

        Get an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountGenericResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.get_account_endpoint.call_with_http_info(**kwargs)

    def get_account_relationship(
        self,
        account_id,
        relationship_id,
        **kwargs
    ):
        """Get account relationship  # noqa: E501

        Get account relationship by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_relationship(account_id, relationship_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.
            relationship_id (str): Relationship ID of the account associate with the account entity

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Relationship
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['relationship_id'] = \
            relationship_id
        return self.get_account_relationship_endpoint.call_with_http_info(**kwargs)

    def get_account_template(
        self,
        template_id,
        **kwargs
    ):
        """Get account template  # noqa: E501

        Get an account template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_template(template_id, async_req=True)
        >>> result = thread.get()

        Args:
            template_id (str): Account Template ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountTemplateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['template_id'] = \
            template_id
        return self.get_account_template_endpoint.call_with_http_info(**kwargs)

    def list_account_relationship(
        self,
        account_id,
        **kwargs
    ):
        """List account relationships  # noqa: E501

        List all customers of an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_relationship(account_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.

        Keyword Args:
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RelationshipList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        return self.list_account_relationship_endpoint.call_with_http_info(**kwargs)

    def list_account_resource_products(
        self,
        product_type,
        **kwargs
    ):
        """List account products  # noqa: E501

        List account Products   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_resource_products(product_type, async_req=True)
        >>> result = thread.get()

        Args:
            product_type (str): Type of account product

        Keyword Args:
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            start_date (date): Date range filtering for type INTEREST. All rates in interest resource have to have valid_from later or equal to start_date.. [optional]
            end_date (date): Date range filtering for type INTEREST. All rates in interest resource have to have valid_to earlier or equal to end_date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountProductList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['product_type'] = \
            product_type
        return self.list_account_resource_products_endpoint.call_with_http_info(**kwargs)

    def list_account_templates(
        self,
        **kwargs
    ):
        """List account templates  # noqa: E501

        List account templates   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_templates(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            account_type (AccountType): The type of the account . [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TemplateList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_account_templates_endpoint.call_with_http_info(**kwargs)

    def list_accounts(
        self,
        **kwargs
    ):
        """List accounts  # noqa: E501

        Get paginated list of Accounts associated  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_accounts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            id ([str]): Account ID(s). Multiple IDs can be provided as a comma-separated list. . [optional]
            account_type (AccountType): The type of the account . [optional]
            linked_account_id ([str]): Return only resources that are linked to the specified backing account in balance_floor or balance_ceiling. Multiple IDs can be provided as a comma-separated list. . [optional]
            overdraft_account_id ([str]): Overdraft account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. . [optional]
            overflow_account_id ([str]): Overflow account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. . [optional]
            account_number ([str]): Account number(s). Multiple account numbers can be provided as a comma-separated list. When only a single account number is provided, any * characters in the string are wildcards, and match any characters. . [optional]
            status (Status): [optional]
            interest_product_id (str): Interest product ID that accounts associate with. Multiple IDs can be provided as a comma-separated list.. [optional]
            customer_type (CustomerType): Customer type of the account, BUSINESS or PERSONAL . [optional]
            spend_control_ids (SpendControlIds): Spend Control ID(s). Multiple IDs can be provided as a comma-separated list. Return only resources that use the specified Spend Controls. . [optional]
            customer_id (str): The customer's unique identifier. [optional]
            business_id ([str]): Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. . [optional]
            person_id ([str]): Unique identifier for the person. Multiple IDs can be provided as a comma-separated list. . [optional]
            first_name (str): [optional]
            last_name (str): [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            sort_by ([str]): Specifies the sort order for the returned accounts. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_accounts_endpoint.call_with_http_info(**kwargs)

    def patch_account(
        self,
        account_id,
        account,
        **kwargs
    ):
        """Patch account  # noqa: E501

        Patch account.  Immutable fields:   - account_number   - account_type   - account_template_id   - customer_type  Please note:   - Other fields cannot be modified when access_status is FROZEN.   - access_status has to be patched individually without other fields.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_account(account_id, account, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.
            account (Account): Account fields to be patched

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountGenericResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['account'] = \
            account
        return self.patch_account_endpoint.call_with_http_info(**kwargs)

    def patch_account_product(
        self,
        product_id,
        patch_account_product,
        **kwargs
    ):
        """Patch account product  # noqa: E501

        Patch account product. Rates requires at minimum 1 entry if specified.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_account_product(product_id, patch_account_product, async_req=True)
        >>> result = thread.get()

        Args:
            product_id (str): Account Product ID
            patch_account_product (PatchAccountProduct): Account product fields to be patched

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountProduct
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['product_id'] = \
            product_id
        kwargs['patch_account_product'] = \
            patch_account_product
        return self.patch_account_product_endpoint.call_with_http_info(**kwargs)

    def update_account(
        self,
        account_id,
        account,
        **kwargs
    ):
        """Update account  # noqa: E501

        Update account  Shadow mode required fields:   - account_number   - status  Lead mode required fields:   - All fields are required.  Please note:   - access_status needs to be in ACTIVE.   - PUT request cannot change access_status.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account(account_id, account, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.
            account (Account): Account to update

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountGenericResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['account'] = \
            account
        return self.update_account_endpoint.call_with_http_info(**kwargs)

    def update_account_relationship(
        self,
        account_id,
        relationship_id,
        relationship,
        **kwargs
    ):
        """Update account relationship  # noqa: E501

        Update account relationship. Only relationship_type can be updated. customer_id should not be modified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_relationship(account_id, relationship_id, relationship, async_req=True)
        >>> result = thread.get()

        Args:
            account_id (str): Unique identifier for the account.
            relationship_id (str): Relationship ID of the account associate with the account entity
            relationship (Relationship): Account relationship to be updated

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Relationship
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_id'] = \
            account_id
        kwargs['relationship_id'] = \
            relationship_id
        kwargs['relationship'] = \
            relationship
        return self.update_account_relationship_endpoint.call_with_http_info(**kwargs)

    def update_account_template(
        self,
        template_id,
        account_template,
        **kwargs
    ):
        """Update account template  # noqa: E501

        Update account template   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_template(template_id, account_template, async_req=True)
        >>> result = thread.get()

        Args:
            template_id (str): Account Template ID
            account_template (AccountTemplate): Account template to update

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountTemplateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['template_id'] = \
            template_id
        kwargs['account_template'] = \
            account_template
        return self.update_account_template_endpoint.call_with_http_info(**kwargs)

