# synctera-client
<h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.32.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonPriorClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import synctera_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import synctera_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import synctera_client
from pprint import pprint
from synctera_client.api import ach_api
from synctera_client.model.error import Error
from synctera_client.model.outgoing_ach import OutgoingAch
from synctera_client.model.outgoing_ach_list import OutgoingAchList
from synctera_client.model.outgoing_ach_patch import OutgoingAchPatch
from synctera_client.model.outgoing_ach_request import OutgoingAchRequest
# Defining the host is optional and defaults to https://api.synctera.com/v0
# See configuration.py for a list of all supported configuration parameters.
configuration = synctera_client.Configuration(
    host = "https://api.synctera.com/v0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (api_key): bearerAuth
configuration = synctera_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with synctera_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ach_api.ACHApi(api_client)
    outgoing_ach_request = OutgoingAchRequest(
        amount=607,
        company_entry_description="PAYROLL",
        currency="USD",
        customer_id="e9061cf1-b472-4066-bf4b-2491b33fd182",
        dc_sign="debit",
        effective_date=dateutil_parser('Fri Mar 18 00:00:00 UTC 2022').date(),
        external_data={},
        final_customer_id="final_customer_id_example",
        hold=AchRequestHoldData(
            amount=1,
            duration=2,
        ),
        is_same_day=True,
        memo="memo_example",
        originating_account_id="b58b33b8-9629-4414-91ee-62c0b200c7b4",
        receiving_account_id="3110c3f4-7937-4010-bded-86917767f50b",
        reference_info="Tempore atque et cum.",
        risk=RiskData(
            client_ip="client_ip_example",
        ),
    ) # OutgoingAchRequest | Send ACH request
    idempotency_key = "7d943c51-e4ff-4e57-9558-08cab6b963c7" # str | An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry. (optional)

    try:
        # Send an ACH
        api_response = api_instance.add_transaction_out(outgoing_ach_request, idempotency_key=idempotency_key)
        pprint(api_response)
    except synctera_client.ApiException as e:
        print("Exception when calling ACHApi->add_transaction_out: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.synctera.com/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ACHApi* | [**add_transaction_out**](docs/ACHApi.md#add_transaction_out) | **POST** /ach | Send an ACH
*ACHApi* | [**get_transaction_out**](docs/ACHApi.md#get_transaction_out) | **GET** /ach/{transaction_id} | Get a sent ACH transaction
*ACHApi* | [**list_transactions_out**](docs/ACHApi.md#list_transactions_out) | **GET** /ach | List sent ACH transactions
*ACHApi* | [**patch_transaction_out**](docs/ACHApi.md#patch_transaction_out) | **PATCH** /ach/{transaction_id} | Update a sent ACH transaction
*ACHTransactionSimulationsApi* | [**ach_return_simulation**](docs/ACHTransactionSimulationsApi.md#ach_return_simulation) | **POST** /ach/transaction_simulations/receiving_return | Simulate receiving ACH return
*ACHTransactionSimulationsApi* | [**ach_transaction_simulation**](docs/ACHTransactionSimulationsApi.md#ach_transaction_simulation) | **POST** /ach/transaction_simulations/receiving_transaction | Simulate receiving ACH transaction
*AccountsApi* | [**create_account**](docs/AccountsApi.md#create_account) | **POST** /accounts | Create an account
*AccountsApi* | [**create_account_relationship**](docs/AccountsApi.md#create_account_relationship) | **POST** /accounts/{account_id}/relationships | Create account relationship
*AccountsApi* | [**create_account_resource_product**](docs/AccountsApi.md#create_account_resource_product) | **POST** /accounts/products | Create an account product
*AccountsApi* | [**create_account_template**](docs/AccountsApi.md#create_account_template) | **POST** /accounts/templates | Create an account template
*AccountsApi* | [**delete_account_relationship**](docs/AccountsApi.md#delete_account_relationship) | **DELETE** /accounts/{account_id}/relationships/{relationship_id} | Delete account relationship
*AccountsApi* | [**delete_account_template**](docs/AccountsApi.md#delete_account_template) | **DELETE** /accounts/templates/{template_id} | Delete account template
*AccountsApi* | [**get_account**](docs/AccountsApi.md#get_account) | **GET** /accounts/{account_id} | Get account
*AccountsApi* | [**get_account_relationship**](docs/AccountsApi.md#get_account_relationship) | **GET** /accounts/{account_id}/relationships/{relationship_id} | Get account relationship
*AccountsApi* | [**get_account_template**](docs/AccountsApi.md#get_account_template) | **GET** /accounts/templates/{template_id} | Get account template
*AccountsApi* | [**list_account_relationship**](docs/AccountsApi.md#list_account_relationship) | **GET** /accounts/{account_id}/relationships | List account relationships
*AccountsApi* | [**list_account_resource_products**](docs/AccountsApi.md#list_account_resource_products) | **GET** /accounts/products | List account products
*AccountsApi* | [**list_account_templates**](docs/AccountsApi.md#list_account_templates) | **GET** /accounts/templates | List account templates
*AccountsApi* | [**list_accounts**](docs/AccountsApi.md#list_accounts) | **GET** /accounts | List accounts
*AccountsApi* | [**patch_account**](docs/AccountsApi.md#patch_account) | **PATCH** /accounts/{account_id} | Patch account
*AccountsApi* | [**patch_account_product**](docs/AccountsApi.md#patch_account_product) | **PATCH** /accounts/products/{product_id} | Patch account product
*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PUT** /accounts/{account_id} | Update account
*AccountsApi* | [**update_account_relationship**](docs/AccountsApi.md#update_account_relationship) | **PUT** /accounts/{account_id}/relationships/{relationship_id} | Update account relationship
*AccountsApi* | [**update_account_template**](docs/AccountsApi.md#update_account_template) | **PUT** /accounts/templates/{template_id} | Update account template
*BusinessesApi* | [**create_business**](docs/BusinessesApi.md#create_business) | **POST** /businesses | Create a business
*BusinessesApi* | [**get_business**](docs/BusinessesApi.md#get_business) | **GET** /businesses/{business_id} | Get business
*BusinessesApi* | [**list_businesses**](docs/BusinessesApi.md#list_businesses) | **GET** /businesses | List business
*BusinessesApi* | [**update_business**](docs/BusinessesApi.md#update_business) | **PATCH** /businesses/{business_id} | Patch business
*CardTransactionSimulationsApi* | [**simulate_authorization**](docs/CardTransactionSimulationsApi.md#simulate_authorization) | **POST** /cards/transaction_simulations/authorization | Simulate authorization
*CardTransactionSimulationsApi* | [**simulate_authorization_advice**](docs/CardTransactionSimulationsApi.md#simulate_authorization_advice) | **POST** /cards/transaction_simulations/authorization/advice | Simulate authorization advice
*CardTransactionSimulationsApi* | [**simulate_balance_inquiry**](docs/CardTransactionSimulationsApi.md#simulate_balance_inquiry) | **POST** /cards/transaction_simulations/financial/balance_inquiry | Simulate balance inquiry
*CardTransactionSimulationsApi* | [**simulate_clearing**](docs/CardTransactionSimulationsApi.md#simulate_clearing) | **POST** /cards/transaction_simulations/clearing | Simulate clearing or refund
*CardTransactionSimulationsApi* | [**simulate_financial**](docs/CardTransactionSimulationsApi.md#simulate_financial) | **POST** /cards/transaction_simulations/financial | Simulate financial
*CardTransactionSimulationsApi* | [**simulate_financial_advice**](docs/CardTransactionSimulationsApi.md#simulate_financial_advice) | **POST** /cards/transaction_simulations/financial/advice | Simulate financial advice
*CardTransactionSimulationsApi* | [**simulate_original_credit**](docs/CardTransactionSimulationsApi.md#simulate_original_credit) | **POST** /cards/transaction_simulations/financial/original_credit | Simulate OCT
*CardTransactionSimulationsApi* | [**simulate_reversal**](docs/CardTransactionSimulationsApi.md#simulate_reversal) | **POST** /cards/transaction_simulations/reversal | Simulate reversal
*CardTransactionSimulationsApi* | [**simulate_withdrawal**](docs/CardTransactionSimulationsApi.md#simulate_withdrawal) | **POST** /cards/transaction_simulations/financial/withdrawal | Simulate ATM withdrawal
*CardWebhookSimulationsApi* | [**simulate_card_fulfillment_event**](docs/CardWebhookSimulationsApi.md#simulate_card_fulfillment_event) | **POST** /cards/{card_id}/webhook_simulations/fulfillment | Simulate Card Fulfillment Event
*CardsApi* | [**activate_card**](docs/CardsApi.md#activate_card) | **POST** /cards/activate | Activate a card
*CardsApi* | [**create_card_image**](docs/CardsApi.md#create_card_image) | **POST** /cards/images | Create Card Image
*CardsApi* | [**create_gateway**](docs/CardsApi.md#create_gateway) | **POST** /cards/gateways | Create Gateway
*CardsApi* | [**get_card**](docs/CardsApi.md#get_card) | **GET** /cards/{card_id} | Get Card
*CardsApi* | [**get_card_barcode**](docs/CardsApi.md#get_card_barcode) | **GET** /cards/{card_id}/barcodes | Get Card Barcode
*CardsApi* | [**get_card_image_data**](docs/CardsApi.md#get_card_image_data) | **GET** /cards/images/{card_image_id}/data | Get Card Image Data
*CardsApi* | [**get_card_image_details**](docs/CardsApi.md#get_card_image_details) | **GET** /cards/images/{card_image_id} | Get Card Image Details
*CardsApi* | [**get_card_widget_url**](docs/CardsApi.md#get_card_widget_url) | **GET** /cards/card_widget_url | Get card widget URL
*CardsApi* | [**get_client_access_token**](docs/CardsApi.md#get_client_access_token) | **POST** /cards/{card_id}/client_token | Get a client token
*CardsApi* | [**get_client_single_use_token**](docs/CardsApi.md#get_client_single_use_token) | **POST** /cards/single_use_token | Get single-use token
*CardsApi* | [**get_gateway**](docs/CardsApi.md#get_gateway) | **GET** /cards/gateways/{gateway_id} | Get Gateway
*CardsApi* | [**issue_card**](docs/CardsApi.md#issue_card) | **POST** /cards | Issue a Card
*CardsApi* | [**list_card_image_details**](docs/CardsApi.md#list_card_image_details) | **GET** /cards/images | List Card Image Details
*CardsApi* | [**list_card_products**](docs/CardsApi.md#list_card_products) | **GET** /cards/products | List Card Products
*CardsApi* | [**list_cards**](docs/CardsApi.md#list_cards) | **GET** /cards | List Cards
*CardsApi* | [**list_changes**](docs/CardsApi.md#list_changes) | **GET** /cards/{card_id}/changes | List Card Changes
*CardsApi* | [**list_gateways**](docs/CardsApi.md#list_gateways) | **GET** /cards/gateways | List Gateways
*CardsApi* | [**update_card**](docs/CardsApi.md#update_card) | **PATCH** /cards/{card_id} | Update Card
*CardsApi* | [**update_card_image_details**](docs/CardsApi.md#update_card_image_details) | **PATCH** /cards/images/{card_image_id} | Update Card Image Details
*CardsApi* | [**update_gateway**](docs/CardsApi.md#update_gateway) | **PATCH** /cards/gateways/{gateway_id} | Update Gateway
*CardsApi* | [**upload_card_image_data**](docs/CardsApi.md#upload_card_image_data) | **POST** /cards/images/{card_image_id}/data | Upload Card Image
*CashPickupsAlphaApi* | [**create_cash_pickup**](docs/CashPickupsAlphaApi.md#create_cash_pickup) | **POST** /cash_pickups | Create a cash pickup
*CashPickupsAlphaApi* | [**get_cash_pickup**](docs/CashPickupsAlphaApi.md#get_cash_pickup) | **GET** /cash_pickups/{cash_pickup_id} | Get a cash pickup
*CashPickupsAlphaApi* | [**list_cash_pickups**](docs/CashPickupsAlphaApi.md#list_cash_pickups) | **GET** /cash_pickups | List cash pickups
*CashPickupsAlphaApi* | [**patch_cash_pickup**](docs/CashPickupsAlphaApi.md#patch_cash_pickup) | **PATCH** /cash_pickups/{cash_pickup_id} | Update a cash pickup
*CustomersApi* | [**create_customer**](docs/CustomersApi.md#create_customer) | **POST** /customers | Create a Customer
*CustomersApi* | [**create_customer_employment**](docs/CustomersApi.md#create_customer_employment) | **POST** /customers/{customer_id}/employment | Create employment record
*CustomersApi* | [**create_customer_risk_rating**](docs/CustomersApi.md#create_customer_risk_rating) | **POST** /customers/{customer_id}/risk_ratings | Create customer risk rating
*CustomersApi* | [**get_all_customer_employment**](docs/CustomersApi.md#get_all_customer_employment) | **GET** /customers/{customer_id}/employment | List customer employment records
*CustomersApi* | [**get_all_customer_risk_ratings**](docs/CustomersApi.md#get_all_customer_risk_ratings) | **GET** /customers/{customer_id}/risk_ratings | List customer risk ratings
*CustomersApi* | [**get_customer**](docs/CustomersApi.md#get_customer) | **GET** /customers/{customer_id} | Get Customer
*CustomersApi* | [**get_customer_risk_rating**](docs/CustomersApi.md#get_customer_risk_rating) | **GET** /customers/{customer_id}/risk_ratings/{risk_rating_id} | Get customer risk rating
*CustomersApi* | [**get_party_employment**](docs/CustomersApi.md#get_party_employment) | **GET** /customers/{customer_id}/employment/{employment_id} | Get customer employment record
*CustomersApi* | [**list_customers**](docs/CustomersApi.md#list_customers) | **GET** /customers | List Customers
*CustomersApi* | [**patch_customer**](docs/CustomersApi.md#patch_customer) | **PATCH** /customers/{customer_id} | Patch Customer
*CustomersApi* | [**prefill_customer**](docs/CustomersApi.md#prefill_customer) | **POST** /customers/{customer_id}/prefill | Prefill customer
*CustomersApi* | [**update_customer**](docs/CustomersApi.md#update_customer) | **PUT** /customers/{customer_id} | Update Customer
*CustomersApi* | [**update_party_employment**](docs/CustomersApi.md#update_party_employment) | **PUT** /customers/{customer_id}/employment/{employment_id} | Update customer employment record
*DigitalWalletTokensApi* | [**create_digital_wallet_apple**](docs/DigitalWalletTokensApi.md#create_digital_wallet_apple) | **POST** /cards/{card_id}/digital_wallet_tokens/applepay | Create digital wallet token provision request for Apple Pay
*DigitalWalletTokensApi* | [**create_digital_wallet_google**](docs/DigitalWalletTokensApi.md#create_digital_wallet_google) | **POST** /cards/{card_id}/digital_wallet_tokens/googlepay | Create digital wallet token provision request for Google Pay
*DigitalWalletTokensApi* | [**get_digital_wallet_token**](docs/DigitalWalletTokensApi.md#get_digital_wallet_token) | **GET** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Get Digital Wallet Token
*DigitalWalletTokensApi* | [**list_digital_wallet_tokens**](docs/DigitalWalletTokensApi.md#list_digital_wallet_tokens) | **GET** /cards/digital_wallet_tokens | List Digital Wallet Tokens
*DigitalWalletTokensApi* | [**update_digital_wallet_token_status**](docs/DigitalWalletTokensApi.md#update_digital_wallet_token_status) | **PATCH** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Update Digital Wallet Token&#39;s life cycle status
*DisclosuresApi* | [**create_disclosure**](docs/DisclosuresApi.md#create_disclosure) | **POST** /disclosures | Create disclosure record
*DisclosuresApi* | [**get_disclosure**](docs/DisclosuresApi.md#get_disclosure) | **GET** /disclosures/{disclosure_id} | Get disclosure
*DisclosuresApi* | [**list_disclosures**](docs/DisclosuresApi.md#list_disclosures) | **GET** /disclosures | List disclosures
*DisclosuresDeprecatedApi* | [**create_disclosure1**](docs/DisclosuresDeprecatedApi.md#create_disclosure1) | **POST** /customers/{customer_id}/disclosures | Create a Disclosure
*DisclosuresDeprecatedApi* | [**list_disclosures1**](docs/DisclosuresDeprecatedApi.md#list_disclosures1) | **GET** /customers/{customer_id}/disclosures | List Disclosures
*DocumentsApi* | [**create_document**](docs/DocumentsApi.md#create_document) | **POST** /documents | Create a document
*DocumentsApi* | [**create_document_version**](docs/DocumentsApi.md#create_document_version) | **POST** /documents/{document_id}/versions | Create a new document version
*DocumentsApi* | [**get_document**](docs/DocumentsApi.md#get_document) | **GET** /documents/{document_id} | Get a document
*DocumentsApi* | [**get_document_contents**](docs/DocumentsApi.md#get_document_contents) | **GET** /documents/{document_id}/contents | Get contents of latest document version
*DocumentsApi* | [**get_document_version**](docs/DocumentsApi.md#get_document_version) | **GET** /documents/{document_id}/versions/{document_version} | Get a document by version
*DocumentsApi* | [**get_document_version_contents**](docs/DocumentsApi.md#get_document_version_contents) | **GET** /documents/{document_id}/versions/{document_version}/contents | Get document contents by version
*DocumentsApi* | [**list_documents**](docs/DocumentsApi.md#list_documents) | **GET** /documents | List documents
*DocumentsApi* | [**update_document**](docs/DocumentsApi.md#update_document) | **PATCH** /documents/{document_id} | Update a document
*ExternalAccountsApi* | [**add_external_accounts**](docs/ExternalAccountsApi.md#add_external_accounts) | **POST** /external_accounts | Add an external account
*ExternalAccountsApi* | [**add_vendor_external_accounts**](docs/ExternalAccountsApi.md#add_vendor_external_accounts) | **POST** /external_accounts/add_vendor_accounts | Add external accounts through a vendor, such as Plaid.
*ExternalAccountsApi* | [**create_access_token**](docs/ExternalAccountsApi.md#create_access_token) | **POST** /external_accounts/access_tokens | Create a permanent access token for an external account
*ExternalAccountsApi* | [**create_verification_link_token**](docs/ExternalAccountsApi.md#create_verification_link_token) | **POST** /external_accounts/link_tokens | Create a link token to verify an external account
*ExternalAccountsApi* | [**delete_external_account**](docs/ExternalAccountsApi.md#delete_external_account) | **DELETE** /external_accounts/{external_account_id} | Delete an external account
*ExternalAccountsApi* | [**get_external_account**](docs/ExternalAccountsApi.md#get_external_account) | **GET** /external_accounts/{external_account_id} | Get an external account
*ExternalAccountsApi* | [**get_external_account_balance**](docs/ExternalAccountsApi.md#get_external_account_balance) | **GET** /external_accounts/{external_account_id}/balance | Get an external account balance
*ExternalAccountsApi* | [**get_external_account_transactions**](docs/ExternalAccountsApi.md#get_external_account_transactions) | **GET** /external_accounts/{external_account_id}/transactions | List transactions of a given external account
*ExternalAccountsApi* | [**list_external_accounts**](docs/ExternalAccountsApi.md#list_external_accounts) | **GET** /external_accounts | List external accounts
*ExternalAccountsApi* | [**sync_vendor_external_accounts**](docs/ExternalAccountsApi.md#sync_vendor_external_accounts) | **POST** /external_accounts/sync_vendor_accounts | Sync external accounts through a vendor, such as Plaid.
*ExternalAccountsApi* | [**update_external_account**](docs/ExternalAccountsApi.md#update_external_account) | **PATCH** /external_accounts/{external_account_id} | Patch an external account
*ExternalCardsAlphaApi* | [**create_external_card_from_token**](docs/ExternalCardsAlphaApi.md#create_external_card_from_token) | **POST** /external_cards/tokens | Create External Card from token
*ExternalCardsAlphaApi* | [**create_external_card_transfer**](docs/ExternalCardsAlphaApi.md#create_external_card_transfer) | **POST** /external_cards/transfers | Create External Card Transfer
*ExternalCardsAlphaApi* | [**create_external_card_transfer_reversal**](docs/ExternalCardsAlphaApi.md#create_external_card_transfer_reversal) | **POST** /external_cards/transfers/{transfer_id}/reversals | Create External Card Transfer Reversal
*ExternalCardsAlphaApi* | [**get_external_card**](docs/ExternalCardsAlphaApi.md#get_external_card) | **GET** /external_cards/{external_card_id} | Get External Card
*ExternalCardsAlphaApi* | [**get_external_card_transfer**](docs/ExternalCardsAlphaApi.md#get_external_card_transfer) | **GET** /external_cards/transfers/{transfer_id} | Get External Card Transfer
*ExternalCardsAlphaApi* | [**list_external_card_transfers**](docs/ExternalCardsAlphaApi.md#list_external_card_transfers) | **GET** /external_cards/transfers | List External Card Transfers
*ExternalCardsAlphaApi* | [**list_external_cards**](docs/ExternalCardsAlphaApi.md#list_external_cards) | **GET** /external_cards | List External Cards
*InternalAccountsApi* | [**add_internal_accounts**](docs/InternalAccountsApi.md#add_internal_accounts) | **POST** /internal_accounts | Add internal accounts
*InternalAccountsApi* | [**get_internal_accounts**](docs/InternalAccountsApi.md#get_internal_accounts) | **GET** /internal_accounts/{internal_account_id} | Get internal account by id
*InternalAccountsApi* | [**list_internal_accounts**](docs/InternalAccountsApi.md#list_internal_accounts) | **GET** /internal_accounts | List internal accounts
*InternalAccountsApi* | [**patch_internal_account**](docs/InternalAccountsApi.md#patch_internal_account) | **PATCH** /internal_accounts/{internal_account_id} | Patch internal account
*InternalTransferApi* | [**create_internal_transfer**](docs/InternalTransferApi.md#create_internal_transfer) | **POST** /transactions/internal_transfer | Create an internal transfer
*InternalTransferApi* | [**get_internal_transfer_by_id**](docs/InternalTransferApi.md#get_internal_transfer_by_id) | **GET** /transactions/internal_transfer/{id} | Get an internal transfer
*InternalTransferApi* | [**update_internal_transfer_by_id**](docs/InternalTransferApi.md#update_internal_transfer_by_id) | **PATCH** /transactions/internal_transfer/{id} | Update an internal transfer
*KYCKYBVerificationsApi* | [**create_verification**](docs/KYCKYBVerificationsApi.md#create_verification) | **POST** /verifications | Create a verification
*KYCKYBVerificationsApi* | [**get_verification1**](docs/KYCKYBVerificationsApi.md#get_verification1) | **GET** /verifications/{verification_id} | Get verification
*KYCKYBVerificationsApi* | [**list_verifications1**](docs/KYCKYBVerificationsApi.md#list_verifications1) | **GET** /verifications | List verifications
*KYCKYBVerificationsApi* | [**verify**](docs/KYCKYBVerificationsApi.md#verify) | **POST** /verifications/verify | Verify a customer&#39;s identity
*KYCKYBVerificationsApi* | [**verify_ad_hoc**](docs/KYCKYBVerificationsApi.md#verify_ad_hoc) | **POST** /verifications/adhoc | Check if an individual is on any watchlists
*KYCVerificationDeprecatedApi* | [**create_customer_verification_result**](docs/KYCVerificationDeprecatedApi.md#create_customer_verification_result) | **POST** /customers/{customer_id}/verifications | Create a customer verification result
*KYCVerificationDeprecatedApi* | [**get_verification**](docs/KYCVerificationDeprecatedApi.md#get_verification) | **GET** /customers/{customer_id}/verifications/{verification_id} | Get verification result
*KYCVerificationDeprecatedApi* | [**list_verifications**](docs/KYCVerificationDeprecatedApi.md#list_verifications) | **GET** /customers/{customer_id}/verifications | List verification results
*KYCVerificationDeprecatedApi* | [**verify_customer**](docs/KYCVerificationDeprecatedApi.md#verify_customer) | **POST** /customers/{customer_id}/verify | Verify a customer&#39;s identity
*MonitoringApi* | [**create_subscription**](docs/MonitoringApi.md#create_subscription) | **POST** /monitoring/subscriptions | Subscribe a customer or business to monitoring
*MonitoringApi* | [**delete_subscription**](docs/MonitoringApi.md#delete_subscription) | **DELETE** /monitoring/subscriptions/{subscription_id} | Delete monitoring subscription
*MonitoringApi* | [**get_alert**](docs/MonitoringApi.md#get_alert) | **GET** /monitoring/alerts/{alert_id} | Retrieve a monitoring alert
*MonitoringApi* | [**get_subscription**](docs/MonitoringApi.md#get_subscription) | **GET** /monitoring/subscriptions/{subscription_id} | Retrieve monitoring subscription
*MonitoringApi* | [**list_alerts**](docs/MonitoringApi.md#list_alerts) | **GET** /monitoring/alerts | List monitoring alerts
*MonitoringApi* | [**list_subscriptions**](docs/MonitoringApi.md#list_subscriptions) | **GET** /monitoring/subscriptions | List monitoring subscriptions
*MonitoringApi* | [**update_alert**](docs/MonitoringApi.md#update_alert) | **PATCH** /monitoring/alerts/{alert_id} | Update a monitoring alert
*PaymentSchedulesApi* | [**create_payment_schedule**](docs/PaymentSchedulesApi.md#create_payment_schedule) | **POST** /payment_schedules | Create a payment schedule
*PaymentSchedulesApi* | [**list_payment_schedules**](docs/PaymentSchedulesApi.md#list_payment_schedules) | **GET** /payment_schedules | List payment schedules
*PaymentSchedulesApi* | [**list_payments**](docs/PaymentSchedulesApi.md#list_payments) | **GET** /payment_schedules/payments | List payments
*PaymentSchedulesApi* | [**patch_payment_schedule**](docs/PaymentSchedulesApi.md#patch_payment_schedule) | **PATCH** /payment_schedules/{payment_schedule_id} | Update a payment schedule
*PersonsApi* | [**create_person**](docs/PersonsApi.md#create_person) | **POST** /persons | Create a person
*PersonsApi* | [**get_person**](docs/PersonsApi.md#get_person) | **GET** /persons/{person_id} | Get person
*PersonsApi* | [**list_persons**](docs/PersonsApi.md#list_persons) | **GET** /persons | List persons
*PersonsApi* | [**prefill_person**](docs/PersonsApi.md#prefill_person) | **POST** /persons/{person_id}/prefill | Prefill person
*PersonsApi* | [**update_person**](docs/PersonsApi.md#update_person) | **PATCH** /persons/{person_id} | Update person
*ReconciliationsApi* | [**create_reconciliation**](docs/ReconciliationsApi.md#create_reconciliation) | **POST** /reconciliations | Create a reconciliation
*ReconciliationsApi* | [**get_reconciliation**](docs/ReconciliationsApi.md#get_reconciliation) | **GET** /reconciliations/{reconciliation_id} | Get reconciliation
*ReconciliationsApi* | [**list_reconciliations**](docs/ReconciliationsApi.md#list_reconciliations) | **GET** /reconciliations | List reconciliations
*RelationshipsApi* | [**create_relationship**](docs/RelationshipsApi.md#create_relationship) | **POST** /relationships | Create a relationship
*RelationshipsApi* | [**delete_relationship**](docs/RelationshipsApi.md#delete_relationship) | **DELETE** /relationships/{relationship_id} | Delete relationship
*RelationshipsApi* | [**get_relationship**](docs/RelationshipsApi.md#get_relationship) | **GET** /relationships/{relationship_id} | Get relationship
*RelationshipsApi* | [**list_relationships**](docs/RelationshipsApi.md#list_relationships) | **GET** /relationships | List relationships
*RelationshipsApi* | [**update_relationship**](docs/RelationshipsApi.md#update_relationship) | **PATCH** /relationships/{relationship_id} | Update relationship
*RemoteCheckDepositBetaApi* | [**create_rdc_deposit**](docs/RemoteCheckDepositBetaApi.md#create_rdc_deposit) | **POST** /rdc/deposits | Create a Remote Check Deposit
*RemoteCheckDepositBetaApi* | [**get_rdc_deposit**](docs/RemoteCheckDepositBetaApi.md#get_rdc_deposit) | **GET** /rdc/deposits/{deposit_id} | Get Remote Check Deposit
*RemoteCheckDepositBetaApi* | [**list_rdc_deposits**](docs/RemoteCheckDepositBetaApi.md#list_rdc_deposits) | **GET** /rdc/deposits | List Remote Check Deposits
*SandboxWipeAlphaApi* | [**wipe_workspace**](docs/SandboxWipeAlphaApi.md#wipe_workspace) | **POST** /wipe | Delete data
*SpendControlsBetaApi* | [**create_spend_control**](docs/SpendControlsBetaApi.md#create_spend_control) | **POST** /spend_controls | Create Spend Control
*SpendControlsBetaApi* | [**get_spend_control**](docs/SpendControlsBetaApi.md#get_spend_control) | **GET** /spend_controls/{spend_control_id} | Get Spend Control
*SpendControlsBetaApi* | [**list_spend_controls**](docs/SpendControlsBetaApi.md#list_spend_controls) | **GET** /spend_controls | List Spend Controls
*SpendControlsBetaApi* | [**update_spend_control**](docs/SpendControlsBetaApi.md#update_spend_control) | **PATCH** /spend_controls/{spend_control_id} | Update Spend Control
*StatementsApi* | [**get_statement**](docs/StatementsApi.md#get_statement) | **GET** /statements/{statement_id} | Get a statement
*StatementsApi* | [**list_statements**](docs/StatementsApi.md#list_statements) | **GET** /statements | List statements
*TransactionsApi* | [**get_pending_transaction_by_id**](docs/TransactionsApi.md#get_pending_transaction_by_id) | **GET** /transactions/pending/{id} | Get a pending transaction
*TransactionsApi* | [**get_posted_transaction_by_id**](docs/TransactionsApi.md#get_posted_transaction_by_id) | **GET** /transactions/posted/{id} | Get a posted transaction
*TransactionsApi* | [**list_pending_transactions**](docs/TransactionsApi.md#list_pending_transactions) | **GET** /transactions/pending | List pending transactions
*TransactionsApi* | [**list_posted_transactions**](docs/TransactionsApi.md#list_posted_transactions) | **GET** /transactions/posted | List posted transactions
*WatchlistDeprecatedApi* | [**get_watchlist_alert**](docs/WatchlistDeprecatedApi.md#get_watchlist_alert) | **GET** /customers/{customer_id}/watchlists/alerts/{alert_id} | Retrieve watchlist monitoring alert
*WatchlistDeprecatedApi* | [**get_watchlist_subscription**](docs/WatchlistDeprecatedApi.md#get_watchlist_subscription) | **GET** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Retrieve watchlist monitoring subscription
*WatchlistDeprecatedApi* | [**list_watchlist_alerts**](docs/WatchlistDeprecatedApi.md#list_watchlist_alerts) | **GET** /customers/{customer_id}/watchlists/alerts | List watchlist monitoring alerts for a customer
*WatchlistDeprecatedApi* | [**list_watchlist_subscriptions**](docs/WatchlistDeprecatedApi.md#list_watchlist_subscriptions) | **GET** /customers/{customer_id}/watchlists/subscriptions | List watchlist monitoring subscriptions for a customer
*WatchlistDeprecatedApi* | [**suppress_watchlist_entity_alert**](docs/WatchlistDeprecatedApi.md#suppress_watchlist_entity_alert) | **POST** /customers/{customer_id}/watchlists/suppressions | Suppress entity alert
*WatchlistDeprecatedApi* | [**update_watchlist_alert**](docs/WatchlistDeprecatedApi.md#update_watchlist_alert) | **PUT** /customers/{customer_id}/watchlists/alerts/{alert_id} | Update watchlist alert
*WatchlistDeprecatedApi* | [**update_watchlist_subscription**](docs/WatchlistDeprecatedApi.md#update_watchlist_subscription) | **PUT** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Update watchlist monitoring subscription
*WatchlistDeprecatedApi* | [**watchlist_subscribe**](docs/WatchlistDeprecatedApi.md#watchlist_subscribe) | **POST** /customers/{customer_id}/watchlists/subscriptions | Subscribe a customer to watchlist monitoring
*WebhooksApi* | [**create_webhook1**](docs/WebhooksApi.md#create_webhook1) | **POST** /webhooks | Create a webhook
*WebhooksApi* | [**delete_webhook**](docs/WebhooksApi.md#delete_webhook) | **DELETE** /webhooks/{webhook_id} | Delete a webhook
*WebhooksApi* | [**get_event**](docs/WebhooksApi.md#get_event) | **GET** /webhooks/{webhook_id}/events/{event_id} | Get webhook event
*WebhooksApi* | [**get_webhook1**](docs/WebhooksApi.md#get_webhook1) | **GET** /webhooks/{webhook_id} | Get a webhook
*WebhooksApi* | [**list_events**](docs/WebhooksApi.md#list_events) | **GET** /webhooks/{webhook_id}/events | List webhook events
*WebhooksApi* | [**list_webhooks1**](docs/WebhooksApi.md#list_webhooks1) | **GET** /webhooks | List webhooks
*WebhooksApi* | [**resend_event**](docs/WebhooksApi.md#resend_event) | **POST** /webhooks/{webhook_id}/events/{event_id}/resend | Resend an event
*WebhooksApi* | [**trigger_event**](docs/WebhooksApi.md#trigger_event) | **POST** /webhooks/trigger | Trigger an event
*WebhooksApi* | [**update_webhook**](docs/WebhooksApi.md#update_webhook) | **PUT** /webhooks/{webhook_id} | Update a webhook
*WiresAlphaApi* | [**cancel_wire**](docs/WiresAlphaApi.md#cancel_wire) | **PATCH** /wires/{wire_id} | Cancel an outgoing wire
*WiresAlphaApi* | [**create_wire**](docs/WiresAlphaApi.md#create_wire) | **POST** /wires | Send a wire
*WiresAlphaApi* | [**get_wire**](docs/WiresAlphaApi.md#get_wire) | **GET** /wires/{wire_id} | Get a wire by id
*WiresAlphaApi* | [**list_wires**](docs/WiresAlphaApi.md#list_wires) | **GET** /wires | List wires


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountAccessStatus](docs/AccountAccessStatus.md)
 - [AccountBase](docs/AccountBase.md)
 - [AccountChargeSecured](docs/AccountChargeSecured.md)
 - [AccountChargeSecuredAllOf](docs/AccountChargeSecuredAllOf.md)
 - [AccountCreation](docs/AccountCreation.md)
 - [AccountCreationAllOf](docs/AccountCreationAllOf.md)
 - [AccountDepository](docs/AccountDepository.md)
 - [AccountDepositoryAllOf](docs/AccountDepositoryAllOf.md)
 - [AccountGenericResponse](docs/AccountGenericResponse.md)
 - [AccountIdentifiers](docs/AccountIdentifiers.md)
 - [AccountLineOfCredit](docs/AccountLineOfCredit.md)
 - [AccountLineOfCreditAllOf](docs/AccountLineOfCreditAllOf.md)
 - [AccountList](docs/AccountList.md)
 - [AccountListAllOf](docs/AccountListAllOf.md)
 - [AccountProduct](docs/AccountProduct.md)
 - [AccountProductList](docs/AccountProductList.md)
 - [AccountProductListAllOf](docs/AccountProductListAllOf.md)
 - [AccountRange](docs/AccountRange.md)
 - [AccountRangeResponse](docs/AccountRangeResponse.md)
 - [AccountRangeResponseList](docs/AccountRangeResponseList.md)
 - [AccountRangeResponseListAllOf](docs/AccountRangeResponseListAllOf.md)
 - [AccountRangeUpdateRequest](docs/AccountRangeUpdateRequest.md)
 - [AccountRelationshipType](docs/AccountRelationshipType.md)
 - [AccountRouting](docs/AccountRouting.md)
 - [AccountSummary](docs/AccountSummary.md)
 - [AccountSummaryBalanceCeiling](docs/AccountSummaryBalanceCeiling.md)
 - [AccountSummaryBalanceFloor](docs/AccountSummaryBalanceFloor.md)
 - [AccountTemplate](docs/AccountTemplate.md)
 - [AccountTemplateResponse](docs/AccountTemplateResponse.md)
 - [AccountToAccountTransferRequest](docs/AccountToAccountTransferRequest.md)
 - [AccountType](docs/AccountType.md)
 - [AccountVerification](docs/AccountVerification.md)
 - [AccrualPayoutSchedule](docs/AccrualPayoutSchedule.md)
 - [AchInstruction](docs/AchInstruction.md)
 - [AchRequestHoldData](docs/AchRequestHoldData.md)
 - [AchReturnSimulationRequest](docs/AchReturnSimulationRequest.md)
 - [AchTransaction](docs/AchTransaction.md)
 - [AchTransactionAllOf](docs/AchTransactionAllOf.md)
 - [AchTransactionData](docs/AchTransactionData.md)
 - [AchTransactionSimulationRequest](docs/AchTransactionSimulationRequest.md)
 - [AchTransactionSubtypes](docs/AchTransactionSubtypes.md)
 - [AddAccountsRequest](docs/AddAccountsRequest.md)
 - [AddAccountsRequestAccountIdentifiers](docs/AddAccountsRequestAccountIdentifiers.md)
 - [AddAccountsRequestRoutingIdentifiers](docs/AddAccountsRequestRoutingIdentifiers.md)
 - [AddVendorAccountFailure](docs/AddVendorAccountFailure.md)
 - [AddVendorAccountsErrorReason](docs/AddVendorAccountsErrorReason.md)
 - [AddVendorAccountsRequest](docs/AddVendorAccountsRequest.md)
 - [AddVendorAccountsResponse](docs/AddVendorAccountsResponse.md)
 - [AdditionalData](docs/AdditionalData.md)
 - [AdditionalOwnerData](docs/AdditionalOwnerData.md)
 - [Address](docs/Address.md)
 - [Address1](docs/Address1.md)
 - [Address2](docs/Address2.md)
 - [AdhocVerificationRequest](docs/AdhocVerificationRequest.md)
 - [AdhocVerificationResponse](docs/AdhocVerificationResponse.md)
 - [Alias](docs/Alias.md)
 - [AliasList](docs/AliasList.md)
 - [AppleDigitalWalletProvisionRequest](docs/AppleDigitalWalletProvisionRequest.md)
 - [AppleDigitalWalletProvisionResponse](docs/AppleDigitalWalletProvisionResponse.md)
 - [ApplicationListResponse](docs/ApplicationListResponse.md)
 - [ApplicationListResponseAllOf](docs/ApplicationListResponseAllOf.md)
 - [ApplicationRequest](docs/ApplicationRequest.md)
 - [ApplicationResponse](docs/ApplicationResponse.md)
 - [ApplicationType](docs/ApplicationType.md)
 - [ApplicationUpdateRequest](docs/ApplicationUpdateRequest.md)
 - [AuthRequestModel](docs/AuthRequestModel.md)
 - [AuthorizationAdviceModel](docs/AuthorizationAdviceModel.md)
 - [Balance](docs/Balance.md)
 - [BalanceCeiling](docs/BalanceCeiling.md)
 - [BalanceFloor](docs/BalanceFloor.md)
 - [BalanceInquiryRequestModel](docs/BalanceInquiryRequestModel.md)
 - [BalanceType](docs/BalanceType.md)
 - [BanRule](docs/BanRule.md)
 - [BanRuleList](docs/BanRuleList.md)
 - [BanRuleListAllOf](docs/BanRuleListAllOf.md)
 - [BanRulePatch](docs/BanRulePatch.md)
 - [BanRuleStatus](docs/BanRuleStatus.md)
 - [BanStatus](docs/BanStatus.md)
 - [BankDebitNetworkResponse](docs/BankDebitNetworkResponse.md)
 - [BankDebitNetworkResponseAllOf](docs/BankDebitNetworkResponseAllOf.md)
 - [Base](docs/Base.md)
 - [BaseAccountVerification](docs/BaseAccountVerification.md)
 - [BaseCard](docs/BaseCard.md)
 - [BaseCardAllOf](docs/BaseCardAllOf.md)
 - [BaseCashPickup](docs/BaseCashPickup.md)
 - [BaseDisclosure](docs/BaseDisclosure.md)
 - [BaseMasterDisclosure](docs/BaseMasterDisclosure.md)
 - [BasePerson](docs/BasePerson.md)
 - [BasePerson1](docs/BasePerson1.md)
 - [BaseStatement](docs/BaseStatement.md)
 - [BaseStatementAllOf](docs/BaseStatementAllOf.md)
 - [BaseTemplateFields](docs/BaseTemplateFields.md)
 - [BaseTransaction](docs/BaseTransaction.md)
 - [BaseTransactionDecline](docs/BaseTransactionDecline.md)
 - [BillingAddress](docs/BillingAddress.md)
 - [BillingPeriod](docs/BillingPeriod.md)
 - [Bin](docs/Bin.md)
 - [BinAndDebitNetwork](docs/BinAndDebitNetwork.md)
 - [BinAndDebitNetworkList](docs/BinAndDebitNetworkList.md)
 - [BinAndDebitNetworkListAllOf](docs/BinAndDebitNetworkListAllOf.md)
 - [BinNetworkMapping](docs/BinNetworkMapping.md)
 - [BinNetworkMappingResponse](docs/BinNetworkMappingResponse.md)
 - [BinResponse](docs/BinResponse.md)
 - [BinResponseList](docs/BinResponseList.md)
 - [BinResponseListAllOf](docs/BinResponseListAllOf.md)
 - [BinStatus](docs/BinStatus.md)
 - [BinUpdateRequest](docs/BinUpdateRequest.md)
 - [BrandProductCode](docs/BrandProductCode.md)
 - [Business](docs/Business.md)
 - [Business1](docs/Business1.md)
 - [BusinessBusinessOwnerRelationship](docs/BusinessBusinessOwnerRelationship.md)
 - [BusinessList](docs/BusinessList.md)
 - [BusinessListAllOf](docs/BusinessListAllOf.md)
 - [CalculationMethod](docs/CalculationMethod.md)
 - [CardAcceptorModel](docs/CardAcceptorModel.md)
 - [CardActivationRequest](docs/CardActivationRequest.md)
 - [CardBrand](docs/CardBrand.md)
 - [CardCategory](docs/CardCategory.md)
 - [CardChange](docs/CardChange.md)
 - [CardChangeState](docs/CardChangeState.md)
 - [CardChangesList](docs/CardChangesList.md)
 - [CardChangesListAllOf](docs/CardChangesListAllOf.md)
 - [CardEditRequest](docs/CardEditRequest.md)
 - [CardFormat](docs/CardFormat.md)
 - [CardFulfillmentStatus](docs/CardFulfillmentStatus.md)
 - [CardImageDetails](docs/CardImageDetails.md)
 - [CardImageDetailsList](docs/CardImageDetailsList.md)
 - [CardImageDetailsListAllOf](docs/CardImageDetailsListAllOf.md)
 - [CardImageMode](docs/CardImageMode.md)
 - [CardImageRejectionReason](docs/CardImageRejectionReason.md)
 - [CardImageStatus](docs/CardImageStatus.md)
 - [CardIssuanceRequest](docs/CardIssuanceRequest.md)
 - [CardListResponse](docs/CardListResponse.md)
 - [CardListResponseAllOf](docs/CardListResponseAllOf.md)
 - [CardMetadata](docs/CardMetadata.md)
 - [CardOptions](docs/CardOptions.md)
 - [CardPin](docs/CardPin.md)
 - [CardPinStatus](docs/CardPinStatus.md)
 - [CardProduct](docs/CardProduct.md)
 - [CardProductAllOf](docs/CardProductAllOf.md)
 - [CardProductInternal](docs/CardProductInternal.md)
 - [CardProductInternalAllOf](docs/CardProductInternalAllOf.md)
 - [CardProductListResponse](docs/CardProductListResponse.md)
 - [CardProductListResponseAllOf](docs/CardProductListResponseAllOf.md)
 - [CardProductResponse](docs/CardProductResponse.md)
 - [CardProductType](docs/CardProductType.md)
 - [CardProductUpdateRequest](docs/CardProductUpdateRequest.md)
 - [CardProgram](docs/CardProgram.md)
 - [CardProgramResponse](docs/CardProgramResponse.md)
 - [CardProgramResponseList](docs/CardProgramResponseList.md)
 - [CardProgramResponseListAllOf](docs/CardProgramResponseListAllOf.md)
 - [CardProgramUpdateRequest](docs/CardProgramUpdateRequest.md)
 - [CardResponse](docs/CardResponse.md)
 - [CardStatus](docs/CardStatus.md)
 - [CardStatusObject](docs/CardStatusObject.md)
 - [CardStatusReasonCode](docs/CardStatusReasonCode.md)
 - [CardStatusReasonMemo](docs/CardStatusReasonMemo.md)
 - [CardStatusRequest](docs/CardStatusRequest.md)
 - [CardTransaction](docs/CardTransaction.md)
 - [CardTransactionAllOf](docs/CardTransactionAllOf.md)
 - [CardTransactionData](docs/CardTransactionData.md)
 - [CardTransactionDataCurrencyConversion](docs/CardTransactionDataCurrencyConversion.md)
 - [CardTransactionDataMerchant](docs/CardTransactionDataMerchant.md)
 - [CardTransactionDataPos](docs/CardTransactionDataPos.md)
 - [CardTransactionSubtypes](docs/CardTransactionSubtypes.md)
 - [CardWidgetUrlResponse](docs/CardWidgetUrlResponse.md)
 - [CashPickup](docs/CashPickup.md)
 - [CashPickupAllOf](docs/CashPickupAllOf.md)
 - [CashPickupList](docs/CashPickupList.md)
 - [CashPickupListAllOf](docs/CashPickupListAllOf.md)
 - [CashPickupPatchRequest](docs/CashPickupPatchRequest.md)
 - [CashPickupPatchRequestAllOf](docs/CashPickupPatchRequestAllOf.md)
 - [CashPickupPostRequest](docs/CashPickupPostRequest.md)
 - [CashPickupStatus](docs/CashPickupStatus.md)
 - [ChangeChannel](docs/ChangeChannel.md)
 - [ChangeType](docs/ChangeType.md)
 - [CheckTransaction](docs/CheckTransaction.md)
 - [CheckTransactionAllOf](docs/CheckTransactionAllOf.md)
 - [CheckTransactionData](docs/CheckTransactionData.md)
 - [CheckTransactionSubtypes](docs/CheckTransactionSubtypes.md)
 - [ClearingModel](docs/ClearingModel.md)
 - [ClientToken](docs/ClientToken.md)
 - [ContestAch](docs/ContestAch.md)
 - [CountryCode](docs/CountryCode.md)
 - [CreateCardImageRequest](docs/CreateCardImageRequest.md)
 - [CreateGatewayRequest](docs/CreateGatewayRequest.md)
 - [CreateWebhookRequest](docs/CreateWebhookRequest.md)
 - [CurrencyCode](docs/CurrencyCode.md)
 - [CustomHeaders](docs/CustomHeaders.md)
 - [Customer](docs/Customer.md)
 - [CustomerAlias](docs/CustomerAlias.md)
 - [CustomerAliasList](docs/CustomerAliasList.md)
 - [CustomerAliasListAllOf](docs/CustomerAliasListAllOf.md)
 - [CustomerAllOf](docs/CustomerAllOf.md)
 - [CustomerInBody](docs/CustomerInBody.md)
 - [CustomerKycStatus](docs/CustomerKycStatus.md)
 - [CustomerList](docs/CustomerList.md)
 - [CustomerListAllOf](docs/CustomerListAllOf.md)
 - [CustomerType](docs/CustomerType.md)
 - [CustomerVerification](docs/CustomerVerification.md)
 - [CustomerVerificationResult](docs/CustomerVerificationResult.md)
 - [CustomerVerificationResultList](docs/CustomerVerificationResultList.md)
 - [CustomerVerificationResultListAllOf](docs/CustomerVerificationResultListAllOf.md)
 - [CustomerVerifyResponse](docs/CustomerVerifyResponse.md)
 - [CustomerVerifyResponseAllOf](docs/CustomerVerifyResponseAllOf.md)
 - [DcSign](docs/DcSign.md)
 - [DebitNetwork](docs/DebitNetwork.md)
 - [DebitNetworkCreateRequest](docs/DebitNetworkCreateRequest.md)
 - [DebitNetworkResponse](docs/DebitNetworkResponse.md)
 - [DebitNetworkResponseList](docs/DebitNetworkResponseList.md)
 - [DebitNetworkResponseListAllOf](docs/DebitNetworkResponseListAllOf.md)
 - [DeleteResponse](docs/DeleteResponse.md)
 - [Deposit](docs/Deposit.md)
 - [DepositList](docs/DepositList.md)
 - [DepositListAllOf](docs/DepositListAllOf.md)
 - [DepositPatchRequest](docs/DepositPatchRequest.md)
 - [Detail](docs/Detail.md)
 - [Details](docs/Details.md)
 - [DeviceType](docs/DeviceType.md)
 - [DigitalWalletTokenAddressVerification](docs/DigitalWalletTokenAddressVerification.md)
 - [DigitalWalletTokenEditRequest](docs/DigitalWalletTokenEditRequest.md)
 - [DigitalWalletTokenResponse](docs/DigitalWalletTokenResponse.md)
 - [DigitalWalletTokenState](docs/DigitalWalletTokenState.md)
 - [DigitalWalletTokenization](docs/DigitalWalletTokenization.md)
 - [Disclosure](docs/Disclosure.md)
 - [Disclosure1](docs/Disclosure1.md)
 - [DisclosureList](docs/DisclosureList.md)
 - [DisclosureListAllOf](docs/DisclosureListAllOf.md)
 - [DisclosureResponse](docs/DisclosureResponse.md)
 - [DisclosureType](docs/DisclosureType.md)
 - [DishonorAch](docs/DishonorAch.md)
 - [Document](docs/Document.md)
 - [DocumentList](docs/DocumentList.md)
 - [DocumentListAllOf](docs/DocumentListAllOf.md)
 - [DocumentType](docs/DocumentType.md)
 - [DocumentVersions](docs/DocumentVersions.md)
 - [EmbossName](docs/EmbossName.md)
 - [Employment](docs/Employment.md)
 - [EmploymentList](docs/EmploymentList.md)
 - [EmploymentListAllOf](docs/EmploymentListAllOf.md)
 - [Encryption](docs/Encryption.md)
 - [EnhancedTransactionData](docs/EnhancedTransactionData.md)
 - [EnhancedTransactionDataEnhancedRawInner](docs/EnhancedTransactionDataEnhancedRawInner.md)
 - [Environment](docs/Environment.md)
 - [Error](docs/Error.md)
 - [EvaluationContext](docs/EvaluationContext.md)
 - [EvaluationContextCustomer](docs/EvaluationContextCustomer.md)
 - [EvaluationResponse](docs/EvaluationResponse.md)
 - [EvaluationResult](docs/EvaluationResult.md)
 - [Event](docs/Event.md)
 - [EventList](docs/EventList.md)
 - [EventListAllOf](docs/EventListAllOf.md)
 - [EventResend](docs/EventResend.md)
 - [EventTrigger](docs/EventTrigger.md)
 - [EventType](docs/EventType.md)
 - [EventType1](docs/EventType1.md)
 - [EventTypeExplicit](docs/EventTypeExplicit.md)
 - [EventTypeWildcard](docs/EventTypeWildcard.md)
 - [ExtAccountCustomerType](docs/ExtAccountCustomerType.md)
 - [ExternalAccount](docs/ExternalAccount.md)
 - [ExternalAccountAccessToken](docs/ExternalAccountAccessToken.md)
 - [ExternalAccountBalance](docs/ExternalAccountBalance.md)
 - [ExternalAccountLinkToken](docs/ExternalAccountLinkToken.md)
 - [ExternalAccountTransaction](docs/ExternalAccountTransaction.md)
 - [ExternalAccountVendorData](docs/ExternalAccountVendorData.md)
 - [ExternalAccountVendorValues](docs/ExternalAccountVendorValues.md)
 - [ExternalAccountsList](docs/ExternalAccountsList.md)
 - [ExternalAccountsListAllOf](docs/ExternalAccountsListAllOf.md)
 - [ExternalAccountsTransactionList](docs/ExternalAccountsTransactionList.md)
 - [ExternalCardListResponse](docs/ExternalCardListResponse.md)
 - [ExternalCardListResponseAllOf](docs/ExternalCardListResponseAllOf.md)
 - [ExternalCardRequest](docs/ExternalCardRequest.md)
 - [ExternalCardResponse](docs/ExternalCardResponse.md)
 - [ExternalCardTransaction](docs/ExternalCardTransaction.md)
 - [ExternalCardTransactionAllOf](docs/ExternalCardTransactionAllOf.md)
 - [ExternalCardTransactionSubtypes](docs/ExternalCardTransactionSubtypes.md)
 - [ExternalCardVerifications](docs/ExternalCardVerifications.md)
 - [ExternalPaymentDate](docs/ExternalPaymentDate.md)
 - [Fee](docs/Fee.md)
 - [FinancialInstitution](docs/FinancialInstitution.md)
 - [FinancialRequestModel](docs/FinancialRequestModel.md)
 - [FinicityAccountVerification](docs/FinicityAccountVerification.md)
 - [Form](docs/Form.md)
 - [FulfillmentDetails](docs/FulfillmentDetails.md)
 - [FundingSource](docs/FundingSource.md)
 - [FundingSourceResponse](docs/FundingSourceResponse.md)
 - [FundingSourceResponseList](docs/FundingSourceResponseList.md)
 - [GatewayCustomHeaders](docs/GatewayCustomHeaders.md)
 - [GatewayListResponse](docs/GatewayListResponse.md)
 - [GatewayListResponseAllOf](docs/GatewayListResponseAllOf.md)
 - [GatewayResponse](docs/GatewayResponse.md)
 - [GetCardBarcode200Response](docs/GetCardBarcode200Response.md)
 - [GetViralLoopWaitlists](docs/GetViralLoopWaitlists.md)
 - [GoogleDigitalWalletProvisionRequest](docs/GoogleDigitalWalletProvisionRequest.md)
 - [GoogleDigitalWalletProvisionResponse](docs/GoogleDigitalWalletProvisionResponse.md)
 - [HoldCancelRequest](docs/HoldCancelRequest.md)
 - [HoldCreateRequest](docs/HoldCreateRequest.md)
 - [HoldCreateRequestStatus](docs/HoldCreateRequestStatus.md)
 - [HoldData](docs/HoldData.md)
 - [HoldDeclineRequest](docs/HoldDeclineRequest.md)
 - [HoldModifyRequest](docs/HoldModifyRequest.md)
 - [HoldPatchRequest](docs/HoldPatchRequest.md)
 - [HoldPostingRequest](docs/HoldPostingRequest.md)
 - [InAppProvisioning](docs/InAppProvisioning.md)
 - [IngestionStatus](docs/IngestionStatus.md)
 - [Interest](docs/Interest.md)
 - [InternalAccount](docs/InternalAccount.md)
 - [InternalAccountPatch](docs/InternalAccountPatch.md)
 - [InternalAccountPurpose](docs/InternalAccountPurpose.md)
 - [InternalAccountType](docs/InternalAccountType.md)
 - [InternalAccountsList](docs/InternalAccountsList.md)
 - [InternalAccountsListAllOf](docs/InternalAccountsListAllOf.md)
 - [InternalTransfer](docs/InternalTransfer.md)
 - [InternalTransferInstruction](docs/InternalTransferInstruction.md)
 - [InternalTransferPatch](docs/InternalTransferPatch.md)
 - [InternalTransferResponse](docs/InternalTransferResponse.md)
 - [InternalTransferResponseAllOf](docs/InternalTransferResponseAllOf.md)
 - [InternalTransferTransaction](docs/InternalTransferTransaction.md)
 - [InternalTransferTransactionAllOf](docs/InternalTransferTransactionAllOf.md)
 - [InternalTransferTransactionData](docs/InternalTransferTransactionData.md)
 - [InternalTransferTransactionSubtypes](docs/InternalTransferTransactionSubtypes.md)
 - [ManualAccountVerification](docs/ManualAccountVerification.md)
 - [ManualEntry](docs/ManualEntry.md)
 - [MasterDisclosure](docs/MasterDisclosure.md)
 - [MasterDisclosureList](docs/MasterDisclosureList.md)
 - [MasterDisclosureListAllOf](docs/MasterDisclosureListAllOf.md)
 - [Merchant](docs/Merchant.md)
 - [MinimumPayment](docs/MinimumPayment.md)
 - [MinimumPaymentFull](docs/MinimumPaymentFull.md)
 - [MinimumPaymentPartial](docs/MinimumPaymentPartial.md)
 - [MinimumPaymentType](docs/MinimumPaymentType.md)
 - [MinimumPaymentTypeFull](docs/MinimumPaymentTypeFull.md)
 - [MinimumPaymentTypeRateOrAmount](docs/MinimumPaymentTypeRateOrAmount.md)
 - [MonitoringAlert](docs/MonitoringAlert.md)
 - [MonitoringAlertList](docs/MonitoringAlertList.md)
 - [MonitoringAlertListAllOf](docs/MonitoringAlertListAllOf.md)
 - [MonitoringStatus](docs/MonitoringStatus.md)
 - [MonitoringSubscription](docs/MonitoringSubscription.md)
 - [MonitoringSubscriptionList](docs/MonitoringSubscriptionList.md)
 - [MonitoringSubscriptionListAllOf](docs/MonitoringSubscriptionListAllOf.md)
 - [NetworkFeeModel](docs/NetworkFeeModel.md)
 - [NoteCreate](docs/NoteCreate.md)
 - [NoteList](docs/NoteList.md)
 - [NoteListAllOf](docs/NoteListAllOf.md)
 - [NoteResponse](docs/NoteResponse.md)
 - [OriginalCreditRequestModel](docs/OriginalCreditRequestModel.md)
 - [OriginalCreditSenderData](docs/OriginalCreditSenderData.md)
 - [OutgoingAch](docs/OutgoingAch.md)
 - [OutgoingAchList](docs/OutgoingAchList.md)
 - [OutgoingAchListAllOf](docs/OutgoingAchListAllOf.md)
 - [OutgoingAchPatch](docs/OutgoingAchPatch.md)
 - [OutgoingAchRequest](docs/OutgoingAchRequest.md)
 - [PaginatedResponse](docs/PaginatedResponse.md)
 - [PaginatedResponse1](docs/PaginatedResponse1.md)
 - [PaginatedTransactions](docs/PaginatedTransactions.md)
 - [PatchAccountProduct](docs/PatchAccountProduct.md)
 - [PatchAccountsRequestAccountIdentifiers](docs/PatchAccountsRequestAccountIdentifiers.md)
 - [PatchAccountsRequestRoutingIdentifiers](docs/PatchAccountsRequestRoutingIdentifiers.md)
 - [PatchBanStatus](docs/PatchBanStatus.md)
 - [PatchBusiness](docs/PatchBusiness.md)
 - [PatchBusinessBusinessOwnerRelationship](docs/PatchBusinessBusinessOwnerRelationship.md)
 - [PatchBusinessBusinessOwnerRelationshipAllOf](docs/PatchBusinessBusinessOwnerRelationshipAllOf.md)
 - [PatchCustomer](docs/PatchCustomer.md)
 - [PatchDocument](docs/PatchDocument.md)
 - [PatchExternalAccount](docs/PatchExternalAccount.md)
 - [PatchInterest](docs/PatchInterest.md)
 - [PatchPaymentSchedule](docs/PatchPaymentSchedule.md)
 - [PatchPerson](docs/PatchPerson.md)
 - [PatchPersonBusinessOwnerRelationship](docs/PatchPersonBusinessOwnerRelationship.md)
 - [PatchPersonBusinessOwnerRelationshipAllOf](docs/PatchPersonBusinessOwnerRelationshipAllOf.md)
 - [PatchPersonBusinessRelationship](docs/PatchPersonBusinessRelationship.md)
 - [PatchPersonBusinessRelationshipAllOf](docs/PatchPersonBusinessRelationshipAllOf.md)
 - [PatchRelationshipIn](docs/PatchRelationshipIn.md)
 - [Payment](docs/Payment.md)
 - [PaymentDate](docs/PaymentDate.md)
 - [PaymentErrorDetails](docs/PaymentErrorDetails.md)
 - [PaymentInstruction](docs/PaymentInstruction.md)
 - [PaymentList](docs/PaymentList.md)
 - [PaymentListAllOf](docs/PaymentListAllOf.md)
 - [PaymentSchedule](docs/PaymentSchedule.md)
 - [PaymentScheduleList](docs/PaymentScheduleList.md)
 - [PaymentScheduleListAllOf](docs/PaymentScheduleListAllOf.md)
 - [PaymentScheduleStatus](docs/PaymentScheduleStatus.md)
 - [PaymentStatus](docs/PaymentStatus.md)
 - [PaymentType](docs/PaymentType.md)
 - [PaymentTypeList](docs/PaymentTypeList.md)
 - [PendingTransaction](docs/PendingTransaction.md)
 - [PendingTransactionData](docs/PendingTransactionData.md)
 - [PendingTransactionHistory](docs/PendingTransactionHistory.md)
 - [PendingTransactionHistoryData](docs/PendingTransactionHistoryData.md)
 - [PendingTransactions](docs/PendingTransactions.md)
 - [Person](docs/Person.md)
 - [Person1](docs/Person1.md)
 - [PersonBusinessOwnerRelationship](docs/PersonBusinessOwnerRelationship.md)
 - [PersonBusinessRelationship](docs/PersonBusinessRelationship.md)
 - [PersonList](docs/PersonList.md)
 - [PersonListAllOf](docs/PersonListAllOf.md)
 - [PhysicalCard](docs/PhysicalCard.md)
 - [PhysicalCardAllOf](docs/PhysicalCardAllOf.md)
 - [PhysicalCardFormat](docs/PhysicalCardFormat.md)
 - [PhysicalCardIssuanceRequest](docs/PhysicalCardIssuanceRequest.md)
 - [PhysicalCardPlusStatus](docs/PhysicalCardPlusStatus.md)
 - [PhysicalCardResponse](docs/PhysicalCardResponse.md)
 - [PhysicalCardResponseAllOf](docs/PhysicalCardResponseAllOf.md)
 - [PhysicalCardResponseStatus](docs/PhysicalCardResponseStatus.md)
 - [PhysicalCardResponseStatusAllOf](docs/PhysicalCardResponseStatusAllOf.md)
 - [PingResponse](docs/PingResponse.md)
 - [PlaidAccountVerification](docs/PlaidAccountVerification.md)
 - [PostedTransaction](docs/PostedTransaction.md)
 - [PostedTransactionData](docs/PostedTransactionData.md)
 - [PostedTransactionReverseRequest](docs/PostedTransactionReverseRequest.md)
 - [PostedTransactions](docs/PostedTransactions.md)
 - [PrefillRequest](docs/PrefillRequest.md)
 - [Prospect](docs/Prospect.md)
 - [Prospect1](docs/Prospect1.md)
 - [Prospect1AllOf](docs/Prospect1AllOf.md)
 - [ProspectEditable](docs/ProspectEditable.md)
 - [ProspectStatus](docs/ProspectStatus.md)
 - [ProspectsList](docs/ProspectsList.md)
 - [ProspectsListAllOf](docs/ProspectsListAllOf.md)
 - [ProviderType](docs/ProviderType.md)
 - [ProvisioningAppVersion](docs/ProvisioningAppVersion.md)
 - [ProvisioningControls](docs/ProvisioningControls.md)
 - [PushTokenizeRequestData](docs/PushTokenizeRequestData.md)
 - [QuickstartT10](docs/QuickstartT10.md)
 - [QuickstartT10Response](docs/QuickstartT10Response.md)
 - [RateDetails](docs/RateDetails.md)
 - [Rates](docs/Rates.md)
 - [RawResponse](docs/RawResponse.md)
 - [RecipientName](docs/RecipientName.md)
 - [Reconciliation](docs/Reconciliation.md)
 - [ReconciliationInput](docs/ReconciliationInput.md)
 - [ReconciliationList](docs/ReconciliationList.md)
 - [ReconciliationListAllOf](docs/ReconciliationListAllOf.md)
 - [RelatedResourceType](docs/RelatedResourceType.md)
 - [RelatedResourceType1](docs/RelatedResourceType1.md)
 - [Relationship](docs/Relationship.md)
 - [Relationship1](docs/Relationship1.md)
 - [RelationshipIn](docs/RelationshipIn.md)
 - [RelationshipList](docs/RelationshipList.md)
 - [RelationshipListAllOf](docs/RelationshipListAllOf.md)
 - [RelationshipRole](docs/RelationshipRole.md)
 - [RelationshipsList](docs/RelationshipsList.md)
 - [RelationshipsListAllOf](docs/RelationshipsListAllOf.md)
 - [ResendResponse](docs/ResendResponse.md)
 - [ResourceType](docs/ResourceType.md)
 - [ResponseHistoryItem](docs/ResponseHistoryItem.md)
 - [ReturnAch](docs/ReturnAch.md)
 - [ReversalModel](docs/ReversalModel.md)
 - [RiskData](docs/RiskData.md)
 - [RiskRating](docs/RiskRating.md)
 - [RiskRatingList](docs/RiskRatingList.md)
 - [RiskRatingListAllOf](docs/RiskRatingListAllOf.md)
 - [SavingsSummary](docs/SavingsSummary.md)
 - [ScheduleConfig](docs/ScheduleConfig.md)
 - [Security](docs/Security.md)
 - [Shipping](docs/Shipping.md)
 - [SimulateCardFulfillment](docs/SimulateCardFulfillment.md)
 - [SingleUseTokenRequest](docs/SingleUseTokenRequest.md)
 - [SingleUseTokenResponse](docs/SingleUseTokenResponse.md)
 - [SocureEventBody](docs/SocureEventBody.md)
 - [SocureGlobalWatchlist](docs/SocureGlobalWatchlist.md)
 - [SocureMatch](docs/SocureMatch.md)
 - [SocureMatchComments](docs/SocureMatchComments.md)
 - [SocureMatchList](docs/SocureMatchList.md)
 - [SocureMatches](docs/SocureMatches.md)
 - [SocureWatchlistResult](docs/SocureWatchlistResult.md)
 - [SpendControl](docs/SpendControl.md)
 - [SpendControlDirection](docs/SpendControlDirection.md)
 - [SpendControlIds](docs/SpendControlIds.md)
 - [SpendControlResponse](docs/SpendControlResponse.md)
 - [SpendControlResponseAllOf](docs/SpendControlResponseAllOf.md)
 - [SpendControlResponseList](docs/SpendControlResponseList.md)
 - [SpendControlResponseListAllOf](docs/SpendControlResponseListAllOf.md)
 - [SpendControlRollingWindowDays](docs/SpendControlRollingWindowDays.md)
 - [SpendControlRollingWindowDaysAllOf](docs/SpendControlRollingWindowDaysAllOf.md)
 - [SpendControlTimeRange](docs/SpendControlTimeRange.md)
 - [SpendControlTimeRangeType](docs/SpendControlTimeRangeType.md)
 - [SpendControlUpdateRequest](docs/SpendControlUpdateRequest.md)
 - [SpendingLimitWithTime](docs/SpendingLimitWithTime.md)
 - [SpendingLimits](docs/SpendingLimits.md)
 - [SpendingLimitsTransaction](docs/SpendingLimitsTransaction.md)
 - [SsnSource](docs/SsnSource.md)
 - [Statement](docs/Statement.md)
 - [StatementAllOf](docs/StatementAllOf.md)
 - [StatementList](docs/StatementList.md)
 - [StatementListAllOf](docs/StatementListAllOf.md)
 - [StatementSummary](docs/StatementSummary.md)
 - [Status](docs/Status.md)
 - [Status1](docs/Status1.md)
 - [TemplateFields](docs/TemplateFields.md)
 - [TemplateFieldsChargeSecured](docs/TemplateFieldsChargeSecured.md)
 - [TemplateFieldsChargeSecuredAllOf](docs/TemplateFieldsChargeSecuredAllOf.md)
 - [TemplateFieldsDepository](docs/TemplateFieldsDepository.md)
 - [TemplateFieldsDepositoryAllOf](docs/TemplateFieldsDepositoryAllOf.md)
 - [TemplateFieldsGenericResponse](docs/TemplateFieldsGenericResponse.md)
 - [TemplateFieldsLineOfCredit](docs/TemplateFieldsLineOfCredit.md)
 - [TemplateFieldsLineOfCreditAllOf](docs/TemplateFieldsLineOfCreditAllOf.md)
 - [TemplateList](docs/TemplateList.md)
 - [TemplateListAllOf](docs/TemplateListAllOf.md)
 - [TokenList](docs/TokenList.md)
 - [TokenListResponse](docs/TokenListResponse.md)
 - [Transaction](docs/Transaction.md)
 - [Transaction1](docs/Transaction1.md)
 - [TransactionData](docs/TransactionData.md)
 - [TransactionDirectPostRequest](docs/TransactionDirectPostRequest.md)
 - [TransactionLine](docs/TransactionLine.md)
 - [TransactionLine1](docs/TransactionLine1.md)
 - [TransactionOptions](docs/TransactionOptions.md)
 - [TransactionUpdateMetaRequest](docs/TransactionUpdateMetaRequest.md)
 - [TransferListResponse](docs/TransferListResponse.md)
 - [TransferListResponseAllOf](docs/TransferListResponseAllOf.md)
 - [TransferRequest](docs/TransferRequest.md)
 - [TransferResponse](docs/TransferResponse.md)
 - [TransferReversalRequest](docs/TransferReversalRequest.md)
 - [TransferType](docs/TransferType.md)
 - [TransferTypeRequest](docs/TransferTypeRequest.md)
 - [TriggerEventRequest](docs/TriggerEventRequest.md)
 - [TxnEnhancer](docs/TxnEnhancer.md)
 - [UpdateCardImageRequest](docs/UpdateCardImageRequest.md)
 - [UpdateGatewayRequest](docs/UpdateGatewayRequest.md)
 - [UpdateTransfer](docs/UpdateTransfer.md)
 - [VendorInfo](docs/VendorInfo.md)
 - [VendorInfo1](docs/VendorInfo1.md)
 - [VendorJson](docs/VendorJson.md)
 - [VendorXml](docs/VendorXml.md)
 - [Verification](docs/Verification.md)
 - [VerificationAllOf](docs/VerificationAllOf.md)
 - [VerificationList](docs/VerificationList.md)
 - [VerificationListAllOf](docs/VerificationListAllOf.md)
 - [VerificationRequest](docs/VerificationRequest.md)
 - [VerificationRequestAllOf](docs/VerificationRequestAllOf.md)
 - [VerificationResult](docs/VerificationResult.md)
 - [VerificationStatus](docs/VerificationStatus.md)
 - [VerificationType](docs/VerificationType.md)
 - [VerificationType1](docs/VerificationType1.md)
 - [VerificationVendorInfo](docs/VerificationVendorInfo.md)
 - [VerificationVendorInfoDetail](docs/VerificationVendorInfoDetail.md)
 - [VerificationVendorJson](docs/VerificationVendorJson.md)
 - [VerificationVendorXml](docs/VerificationVendorXml.md)
 - [VerifyResponse](docs/VerifyResponse.md)
 - [VerifyResponseAllOf](docs/VerifyResponseAllOf.md)
 - [Version](docs/Version.md)
 - [ViralLoopWaitlists](docs/ViralLoopWaitlists.md)
 - [VirtualCard](docs/VirtualCard.md)
 - [VirtualCardIssuanceRequest](docs/VirtualCardIssuanceRequest.md)
 - [VirtualCardPlusStatus](docs/VirtualCardPlusStatus.md)
 - [VirtualCardResponse](docs/VirtualCardResponse.md)
 - [VirtualCardResponseAllOf](docs/VirtualCardResponseAllOf.md)
 - [VirtualCardResponseStatus](docs/VirtualCardResponseStatus.md)
 - [Waitlist](docs/Waitlist.md)
 - [WaitlistAllOf](docs/WaitlistAllOf.md)
 - [WaitlistAnalytics](docs/WaitlistAnalytics.md)
 - [WaitlistAnalyticsList](docs/WaitlistAnalyticsList.md)
 - [WaitlistEditable](docs/WaitlistEditable.md)
 - [WaitlistsList](docs/WaitlistsList.md)
 - [WaitlistsListAllOf](docs/WaitlistsListAllOf.md)
 - [WalletProviderCardOnFile](docs/WalletProviderCardOnFile.md)
 - [WatchlistAlert](docs/WatchlistAlert.md)
 - [WatchlistAlertList](docs/WatchlistAlertList.md)
 - [WatchlistAlertListAllOf](docs/WatchlistAlertListAllOf.md)
 - [WatchlistSubscription](docs/WatchlistSubscription.md)
 - [WatchlistSubscriptionList](docs/WatchlistSubscriptionList.md)
 - [WatchlistSubscriptionListAllOf](docs/WatchlistSubscriptionListAllOf.md)
 - [WatchlistSuppress](docs/WatchlistSuppress.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookConfig](docs/WebhookConfig.md)
 - [WebhookList](docs/WebhookList.md)
 - [WebhookListAllOf](docs/WebhookListAllOf.md)
 - [WebhookRequest](docs/WebhookRequest.md)
 - [WebhookRequestObject](docs/WebhookRequestObject.md)
 - [WebhookResponse](docs/WebhookResponse.md)
 - [WebhookResponseAllOf](docs/WebhookResponseAllOf.md)
 - [WidgetType](docs/WidgetType.md)
 - [Wire](docs/Wire.md)
 - [WireList](docs/WireList.md)
 - [WireListAllOf](docs/WireListAllOf.md)
 - [WireRequest](docs/WireRequest.md)
 - [WireTransaction](docs/WireTransaction.md)
 - [WireTransactionAllOf](docs/WireTransactionAllOf.md)
 - [WireTransactionData](docs/WireTransactionData.md)
 - [WireTransactionSubtypes](docs/WireTransactionSubtypes.md)
 - [WithdrawalRequestModel](docs/WithdrawalRequestModel.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceList](docs/WorkspaceList.md)
 - [WorkspaceListAllOf](docs/WorkspaceListAllOf.md)


## Documentation For Authorization


## bearerAuth

- **Type**: Bearer authentication (api_key)


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in synctera_client.apis and synctera_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from synctera_client.api.default_api import DefaultApi`
- `from synctera_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import synctera_client
from synctera_client.apis import *
from synctera_client.models import *
```

