from setuptools import setup, find_packages

setup(
    name="capcruncher",
    version="0.1.0a2",
    author="Alastair Smith",
    author_email="alastair.smith@ndcls.ox.ac.uk",
    packages=find_packages(),
    entry_points={
        "console_scripts": [
            "capcruncher = capcruncher.cli:cli",
        ]
    },
    include_package_data=True,
    url="https://github.com/sims-lab/CapCruncher.git",
    license="LICENSE",
    description="An end-to-end solution for processing Capture-C, Tri-C and Tiled-C data.",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    python_requires=">=3.8",
    install_requires=[
        "pandas>=1",
        "pybedtools>=0.8.1",
        "papermill>=2.1.1",
        "plotly>=4.8.0",
        "xopen>=0.7.3",
        "pysam>=0.15.3",
        "gevent",
        "paramiko>=2.7.1",
        "sqlalchemy>=1.3.18",
        "cgatcore>=0.6.7",
        "cooler",
        "apsw",
        "ruffus",
        "drmaa",
        "joblib",
        "ipykernel",
        "natsort",
        "iced",
        "click",
        "ujson",
        "xxhash",
    ],
    extras_require={"stats": ["diffxpy", ]},
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Environment :: Console",
        "Intended Audience :: Science/Research",
        "Operating System :: POSIX :: Linux",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
)
