

def show(filename):
    import importlib.resources as pkg_resources
    from IPython.display import display, Image
    package = "theory"
    filename += '.png'
    try:
        with pkg_resources.path(package, filename) as file_path:
            img = Image(filename=str(file_path))
            display(img)
    except Exception as e:
        print(f'Неправильное имя файла: {e}')
    return filename


def show_pdf(filename):
    import importlib.resources as pkg_resources
    from IPython.display import display, IFrame
    package = "numpyp.theory"
    filename += '.pdf'
    try:
        with pkg_resources.path(package, filename) as file_path:
            # Создаем IFrame для отображения PDF
            pdf_iframe = IFrame(src=str(file_path), width=1000, height=800)
            display(pdf_iframe)
    except Exception as e:
        print(f'Неправильное имя файла: {e}')
    return filename

def info():
    print('info1() code 1-10')
    print('info2() code 11-20')
    print('info3() code 21-29')

    print('info4() theory 30-40')
    print('info5() theory 41-42')
    print('info6() theory 51-60')
    print('info7() theory 61-70')
    print('info8() theory 71-80')
    print('info9() theory 81-90')


def info1():
    print("p1() p1t() 'Метод половинного деления (бисекции)'")
    print("p2() p2t() 'Методы функциональной итерации'")
    print("p3() p3t() 'Метод хорд (секущих)'")
    print("p4() p4t() 'Метод Ньютона (касательных)'")
    print("p5() p5t() 'Модифицированный метод Ньютона'")
    print("p6() p6t() 'Метод дихотомии'")
    print("p7() p7t() 'Метод функциональной итерации для систем нелинейных уравнений'")
    print("p8() p8t() 'Метод Гаусса–Зейделя'")
    print("p9() p9t() 'Метод Ньютона в двумерном случае'")
    print("p10() p10t() 'Модифицированный метод Ньютона в двумерном случае'")

def info2():
    print("p11() p11t() 'Линейная интерполяция'")
    print("p12() p12t() 'Интерполяционный многочлен Лагранжа'")
    print("p13() p13t() 'Кубическая сплайн-интерполяция'")
    print("p14() p14t() 'Наивный алгоритм перемножения матриц'")
    print("p15() p15t() 'Алгоритм Штрассена'")
    print("p16() p16t() 'Вычисление собственных значений с характеристическим многочленом'")
    print("p17() p17t() 'Степенной метод'")
    print("p18() p18t() 'Степенной метод со сдвигами'")
    print("p19() p19t() 'Метод вращений'")
    print("p20() p20t() 'QR алгоритм'")

def info3():
    print("p21() p21t() 'Разложение Шура, теорема Шура'")
    print("p22() p22t() 'QR разложение'")
    print("p23() p23t() 'Метод Эйлера'")
    print("p24() p24t() 'Метод предиктора-корректора Эйлера'")
    print("p25() p25t() 'Метод Рунге-Кутты 4-го порядка'")
    print("p26() p26t() 'Методы Адамса-Башфорта'")
    print("p27() p27t() 'Методы Адамса-Мултона'")
    print("p28() p28t() 'Дискретное и обратное преобразование Фурье'")
    print("p29() p29t() 'Быстрое преобразование Фурье'")

def info4():
    print("t1 'Работа с числами с плавающей точкой'")
    print("t2 'Архитектура памяти'")
    print("t3 'Переполнение (overflow), потеря точности (underflow)'")
    print("t4 'Ошибка округления в арифметике с плавающей точкой, накопление ошибок округления, потеря значимости'")
    print("t5 'Суммирование по Кахану'")
    print("t6 'Абсолютная и относительная погрешности'")
    print("t7 'Округление и значащие цифры в записи приближенного числа'")
    print("t8 'Верные в строгом (узком) смысле цифры числа, верные в широком смысле цифры числа'")
    print("t9 'Сложность алгоритмов и нотация big-O'")
    print("t10 'Профилирование кода в Python'")
    print("t11 'Представление чисел с плавающей точкой (стандарт IEEE 754), ошибки представления'")

def info5():
    print("t12 'Способы изолирования корней нелинейных функций'")
    print("t13 'Сжимающие отображения'")
    print("t14 'Погрешность и критерии сходимости, константа Липшица'")
    print("t15 'Скорость сходимости итерационного метода'")
    print("t16 'Стабильность и распространение ошибки в методах численного решения нелинейных уравнений'")
    print("t17 'Теория сжимающих отображений'")
    print("t18 'Интерполяция, экстраполяция, аппроксимация'")
    print("t19 'Глобальная и локальная интерполяция'")
    print("t20 'Ступенчатая и линейная интерполяция'")
    print("t21 'Интерполяционные полиномы'")

def info6():
    print("t22 'Квадратичная интерполяция'")
    print("t23 'Интерполяция сплайнами'")
    print("t24 'Интерполяционный полином Лагранжа'")
    print("t25 'Метод кубической сплайн-интерполяции'")
    print("t26 'Основные операции в вычислительной линейной алгебре'")
    print("t27 'Эффективная реализация алгоритмов вычисления произведения матриц'")
    print("t28 'Алгоритм Штрассена, сложность метода Штрассена'")
    print("t29 'Вычисление SVD'")
    print("t30 'Собственные векторы, собственные значения'")
    print("t31 'Разложение по собственным векторам'")

def info7():
    print("t32 'Задача Google PageRank'")
    print("t33 'Вычисление собственых значений с помощью характеристического многочлена'")
    print("t34 'Особенности степенного метода. Скорость сходимости.'")
    print("t35 'Круги Гершгорина, теорема Гершгорина.'")
    print("t36 'Теорема Шура'")
    print("t37 'Нормальные матрицы, унитарно диагонализуемые матрицы, унитарные матрицы, эрмитовы матрицы'")
    print("t38 'Верхне-гессенбергова форма матрицы'")
    print("t39 'Приведение произвольной матрицы к верхне-гессенберговой форме'")
    print("t40 'Отношение Релея'")
    print("t41 'Зазор между собственными значениями в матрице, алгоритмы со сдвигами.'")

def info8():
    print("t42 'Отражения Хаусхолдера'")
    print("t43 'Сходимость и сложность QR алгоритма'")
    print("t44 'Метод главных компонент и поиск сингулярных значений, прикладные аспекты'")
    print("t45 'Сингулярное разложение (SVD)'")
    print("t46 'Плотные и разреженные матрицы, способы хранения разреженных матриц'")
    print("t47 'ОДУ, численное дифференцирование, типы ОДУ'")
    print("t48 'Методы разностей: прямая, обратная, центральная'")
    print("t49 'Локальная и глобальная ошибка, правило Симпсона, ошибка округления'")
    print("t50 'Сетка дифференцирования'")
    print("t51 'Фазовые портреты и особые точки'")

def info9():
    print("t52 'Неявные и явные методы численного дифференцирования'")
    print("t53 'Многошаговые методы решения ОДУ'")
    print("t54 'Адаптивный шаг в численных методах'")
    print("t55 'Согласованность, устойчивость, сходимость алгоритмов'")
    print("t56 'Строгая и слабая устойчивость'")
    print("t57 'Детерминированный хаос, бифуркации, аттракторы'")
    print("t58 'Амплитуда, частота, фаза, угловая частота'")
    print("t59 'Амплитудный и частотный спектры'")
    print("t60 'Фильтрация сигналов'")
    print("t61 'Преобразование Фурье для анализа сезонности во временных рядах'")
    print("t62 'Дополнительные аспекты обработки сигналов (по необходимости)'")




