# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['sproc']
setup_kwargs = {
    'name': 'sproc',
    'version': '2.0.5',
    'description': '⛏️subprocesseses for subhumanses  ⛏',
    'long_description': '##################################################\n⛏️sproc: subprocesseses for subhumanses  ⛏\n##################################################\n\nRun a command in a subprocess and yield lines of text from stdout and stderr\n\n*********\nEXAMPLES\n*********\n\n.. code-block:: python\n\n    import sproc\n\n    CMD = \'my-unix-command "My Cool File.txt" No-file.txt\'\n\n    for ok, line in sproc.Sub(CMD) as sp:\n        if ok:\n             print(\' \', line)\n        else:\n             print(\'!\', line)\n\n    if sp.returncode:\n        print(\'Error code\', sp.returncode)\n\n    # Return two lists of text lines and a returncode\n    out_lines, err_lines, returncode = sproc.run(CMD)\n\n    # Call callback functions with lines of text read from stdout and stderr\n    returncode = sproc.call(CMD, save_results, print_errors)\n\n    # Log stdout and stderr, with prefixes\n    returncode = sproc.log(CMD)\n\n***\nAPI\n***\n\nMethods on ``class sproc.Sub:``\n===============================\n\n``Sub.__init__(self, cmd, **kwds)``\n-----------------------------------\n\n    Iterate over lines of text from a subprocess.\n\n    If ``kwargs[\'shell\']`` is true, ``Popen`` expects a string,\n    and so if ``cmd`` is not a string, it is joined using ``shlex``.\n\n    If ``kwargs[\'shell\']`` is false, ``Popen`` expects a list of strings,\n    and so if ``cmd`` is a string, it is split using ``shlex``.\n\n    ARGUMENTS\n      cmd:\n        The command to run in a subprocess: a string or a list or tuple of strings\n\n      kwargs:\n        Keyword arguments passed to subprocess.Popen()\n\n``Sub.__iter__(self)``\n----------------------\n\n            Yields a sequence of ``ok, line`` pairs from ``stdout`` and ``stderr`` of\n            a subprocess, where ``ok`` is ``True`` if ``line`` came from ``stdout``\n            and ``False`` if it came from ``stderr``.\n\n            After iteration is done, the ``.returncode`` property contains\n            the error code from the subprocess, an integer where 0 means no error.\n        \n\n``Sub.call(self, out=None, err=None)``\n--------------------------------------\n\n    Run the subprocess, and call function ``out`` with lines from\n    ``stdout`` and function ``err`` with lines from ``stderr``.\n\n    Blocks until the subprocess is complete: the callbacks to ``out`` and\n    \'err`` are on the current thread.\n\n    ARGUMENTS\n      out:\n        if not None, ``out`` is called for each line from the subprocess\'s stdout\n\n      err:\n        if not None, ``err`` is called for each line from the subprocess\'s stderr,\n\n``Sub.call_async(self, out=None, err=None)``\n--------------------------------------------\n\n    Run the subprocess, and asynchronously call function ``out`` with lines\n    from ``stdout``, and function ``err`` with lines from ``stderr``.\n\n    Does not block - immediately returns.\n\n    ARGUMENTS\n      out:\n        if not None, ``out`` is called for each line from the subprocess\'s stdout\n\n      err:\n        if not None, ``err`` is called for each line from the subprocess\'s stderr,\n\n``Sub.run(self)``\n-----------------\n\n    Reads lines from ``stdout`` and ``stderr`` into two lists ``out`` and ``err``,\n    then returns a tuple ``(out, err, returncode)``\n\n``Sub.log(self, out=\'  \', err=\'! \', print=<built-in function print>)``\n----------------------------------------------------------------------\n\n    Read lines from ``stdin`` and ``stderr`` and prints them with prefixes\n\n    Returns the shell integer error code from the subprocess, where 0 means\n    no error.\n\n    ARGUMENTS\n      out:\n        Prefix for printing lines from stdout\n\n      err:\n        Prefix for printing lines from stderr\n\n\nFunctions\n=========\n\n``sproc.call(cmd, out=None, err=None, **kwds)``\n-----------------------------------------------\n\n    Run the subprocess, and call function ``out`` with lines from\n    ``stdout`` and function ``err`` with lines from ``stderr``.\n\n    Blocks until the subprocess is complete: the callbacks to ``out`` and\n    \'err`` are on the current thread.\n\n    ARGUMENTS\n      cmd:\n        The command to run in a subprocess: a string or a list or tuple of strings\n\n      out:\n        if not None, ``out`` is called for each line from the subprocess\'s stdout\n\n      err:\n        if not None, ``err`` is called for each line from the subprocess\'s stderr,\n\n      kwargs:\n        Keyword arguments passed to subprocess.Popen()\n\n\n``sproc.call_async(cmd, out=None, err=None, **kwds)``\n-----------------------------------------------------\n\n    Run the subprocess, and asynchronously call function ``out`` with lines\n    from ``stdout``, and function ``err`` with lines from ``stderr``.\n\n    Does not block - immediately returns.\n\n    ARGUMENTS\n      cmd:\n        The command to run in a subprocess: a string or a list or tuple of strings\n\n      out:\n        if not None, ``out`` is called for each line from the subprocess\'s stdout\n\n      err:\n        if not None, ``err`` is called for each line from the subprocess\'s stderr,\n\n      kwargs:\n        Keyword arguments passed to subprocess.Popen()\n\n\n``sproc.run(cmd, **kwds)``\n--------------------------\n\n    Reads lines from ``stdout`` and ``stderr`` into two lists ``out`` and ``err``,\n    then returns a tuple ``(out, err, returncode)``\n\n    ARGUMENTS\n      cmd:\n        The command to run in a subprocess: a string or a list or tuple of strings\n\n      kwargs:\n        Keyword arguments passed to subprocess.Popen()\n\n\n``sproc.log(cmd, out=\'  \', err=\'! \', print=<built-in function print>, **kwds)``\n-------------------------------------------------------------------------------\n\n    Read lines from ``stdin`` and ``stderr`` and prints them with prefixes\n\n    Returns the shell integer error code from the subprocess, where 0 means\n    no error.\n\n    ARGUMENTS\n      cmd:\n        The command to run in a subprocess: a string or a list or tuple of strings\n\n      out:\n        Prefix for printing lines from stdout\n\n      err:\n        Prefix for printing lines from stderr\n\n      kwargs:\n        Keyword arguments passed to subprocess.Popen()',
    'author': 'Tom Ritchford',
    'author_email': 'tom@swirly.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'py_modules': modules,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
