# This is the `packages` folder in the standard SDLE git repository structure.

The `packages` folder is meant to contain R and python code packages, ready for installation by anyone with access to this repository. 

This folder is meant to be used for developing packages in code repositories.
An acceptable exception would be initially developing a prototypical first version of a package in a project repository, utilizing the content of scripts developed during work on the project.
Packages initially developed in a project repo in this way should be moved to their own code repository as soon as possible.

The `startrpack` package contains functions to assist with initializing a new R package, and creating new files within pre-existing R packages.

It can be installed with the following command:

`devtools::install_bitbucket("nrw16/startrpack/packages/startrpack/startrpack@master", auth_user = "sdle", password = "cwru")`


Some additional resources for working with R packages can be found at:

  - [Hadley Wickham R Packages](http://r-pkgs.had.co.nz/ "R Packages")

  - [Karl Broman R Package Primer](http://kbroman.org/pkg_primer/pages/minimal.html "The minimal R package")

  - [Hillary Parker R Package From Scratch](https://hilaryparker.com/2014/04/29/writing-an-r-package-from-scratch/ "Writing an R package from scratch")


Some resources for working with python packages can be found at:

  - [Official Documentation](https://packaging.python.org/installing/ "Official python package documentation")

  - [Python Package Example `funniest`](https://python-packaging.readthedocs.io/en/latest/ "minimal applied python package example")

This work is legally bound by the following software license: [CC-A-NS-SA-4.0][1] [^1]  
Please see the LICENSE.txt file, in the root of this repository, for further details.

[1]: https://creativecommons.org/licenses/by-nc-sa/4.0/ "CC-A-NS-SA-4.0"


[^1]: [CC-A-NS-SA-4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/)
