# Zero-Trust Architecture - Official Documentation & Resources

## Zero-Trust Security Model

1. [NIST Zero Trust Architecture (SP 800-207)](https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-207.pdf)
2. [Microsoft Zero Trust Architecture](https://www.microsoft.com/en-us/security/business/security-fundamentals/zero-trust)
3. [Google BeyondCorp](https://www.beyondcorp.com/)
4. [Gartner Zero Trust Architecture](https://www.gartner.com/smarterwithgartner/how-to-start-a-zero-trust-network)

## Kubernetes Network Policies

5. [Kubernetes NetworkPolicy Official](https://kubernetes.io/docs/concepts/services-networking/network-policies/)
6. [Kubernetes Network Policy Documentation](https://kubernetes.io/docs/tasks/administer-cluster/declare-network-policy/)
7. [Kubernetes Network Policy Provider](https://kubernetes.io/docs/tasks/administer-cluster/network-policy-provider/)

## Cilium eBPF Networking

8. [Cilium Official Documentation](https://docs.cilium.io/)
9. [Cilium Network Policies](https://docs.cilium.io/en/stable/network/kubernetes/policy/)
10. [Cilium Security Policies](https://docs.cilium.io/en/stable/security/policy-tutorial/)
11. [Cilium 1.18 Release Notes](https://github.com/cilium/cilium/releases/tag/v1.18.0)
12. [Cilium Host Policies](https://docs.cilium.io/en/stable/network/policies/host-policies/)
13. [eBPF Documentation](https://ebpf.io/what-is-ebpf/)

## Service Mesh (Istio)

14. [Istio Official Documentation](https://istio.io/latest/docs/)
15. [Istio Traffic Management](https://istio.io/latest/docs/concepts/traffic-management/)
16. [Istio Security Policies](https://istio.io/latest/docs/concepts/security/)
17. [Istio PeerAuthentication](https://istio.io/latest/docs/reference/config/security/peer-authentication/)

## mTLS & Certificates

18. [RFC 5246 - TLS 1.2](https://tools.ietf.org/html/rfc5246)
19. [RFC 8446 - TLS 1.3](https://tools.ietf.org/html/rfc8446)
20. [NIST Guidelines on mTLS](https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-52r2.pdf)
21. [CERT OpenSSL Best Practices](https://www.ssl.com/article/how-ssl-tls-works/)

## Device Trust & BeyondCorp

22. [Google BeyondCorp: Design to Deployment](https://www.usenix.org/system/files/login/articles/10_beyondcorp_usenix_security_17.pdf)
23. [BeyondCorp Enterprise](https://www.beyondcorp.com/)
24. [Teleport Zero Trust Access](https://goteleport.com/)
25. [Okta Zero Trust Architecture](https://www.okta.com/zero-trust/)

## Micro-Segmentation

26. [Gartner Micro-Segmentation Guide](https://www.gartner.com/smarterwithgartner/how-to-implement-a-zero-trust-network-segmentation-model)
27. [NIST Microsegmentation](https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-207.pdf#page=47)
28. [Cisco Micro-Segmentation](https://www.cisco.com/c/en/us/solutions/segmentation.html)

## Monitoring & Observability

29. [Cilium Hubble](https://docs.cilium.io/en/stable/observability/hubble/)
30. [Prometheus Kubernetes Monitoring](https://prometheus.io/docs/prometheus/latest/getting_started/)
31. [Grafana Kubernetes Dashboards](https://grafana.com/grafana/dashboards?search=kubernetes)

## Context7 MCP Integration

32. [Context7 Zero-Trust Policy Validation](https://context7.ai/zero-trust)
33. [Context7 Network Policy Enforcement](https://context7.ai/network-policies)
34. [Context7 Device Trust Assessment](https://context7.ai/device-trust)

