---
name: "moai-cc-memory"
version: "2.0.0"
created: 2025-10-22
updated: 2025-11-11
status: stable
description: Claude Code memory management, context persistence, and knowledge retention. Use when managing session memory, persisting context, or optimizing knowledge retention.
keywords: ['memory', 'context', 'persistence', 'knowledge-retention', 'session-management']
allowed-tools: 
  - Read
  - Bash
  - Grep
---

# Claude Code Memory Management

## Skill Metadata

| Field | Value |
| ----- | ----- |
| **Skill Name** | moai-cc-memory |
| **Version** | 2.0.0 (2025-11-11) |
| **Allowed tools** | Read, Bash, Grep |
| **Auto-load** | On demand when memory issues detected |
| **Tier** | Claude Code (Core) |

---

## What It Does

Claude Code memory management, context persistence, and knowledge retention.

**Key capabilities**:
- ✅ Session memory management
- ✅ Context persistence strategies
- ✅ Knowledge retention optimization
- ✅ Memory cleanup processes
- ✅ Context budgeting

---

## When to Use

- ✅ Managing session memory
- ✅ Persisting important context
- ✅ Optimizing knowledge retention
- ✅ Handling memory constraints

---

## Core Memory Patterns

### Memory Architecture
1. **Working Memory**: Current session context
2. **Long-term Memory**: Persistent knowledge storage
3. **Context Windows**: Token budget management
4. **Memory Compression**: Efficient information storage
5. **Retrieval Systems**: Quick knowledge access

### Management Strategies
- **Context Seeding**: Strategic context injection
- **Memory Consolidation**: Knowledge organization
- **Forgetting Policies**: Outdated content removal
- **Prioritization**: Important content retention
- **Cleanup Automation**: Memory maintenance

---

## Dependencies

- Claude Code session system
- File-based persistence
- Context management framework
- Memory optimization tools

---

## Works Well With

- `moai-cc-skills` (Knowledge capsules)
- `moai-context7-integration` (External knowledge)
- `moai-learning-optimizer` (Retention optimization)

---

## Changelog

- **v2.0.0** (2025-11-11): Added complete metadata, memory management patterns
- **v1.0.0** (2025-10-22): Initial memory management

---

**End of Skill** | Updated 2025-11-11
