# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubiops.configuration import Configuration


class PipelineRequestCreateResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'pipeline': 'str',
        'version': 'str',
        'deployment_requests': 'list[DirectPipelineRequestDeploymentRequest]',
        'operator_requests': 'list[DirectPipelineRequestOperatorRequest]',
        'result': 'object',
        'success': 'bool',
        'error_message': 'str'
    }

    attribute_map = {
        'id': 'id',
        'pipeline': 'pipeline',
        'version': 'version',
        'deployment_requests': 'deployment_requests',
        'operator_requests': 'operator_requests',
        'result': 'result',
        'success': 'success',
        'error_message': 'error_message'
    }

    def __init__(self, id=None, pipeline=None, version=None, deployment_requests=None, operator_requests=None, result=None, success=None, error_message=None, local_vars_configuration=None, **kwargs):  # noqa: E501
        """PipelineRequestCreateResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._pipeline = None
        self._version = None
        self._deployment_requests = None
        self._operator_requests = None
        self._result = None
        self._success = None
        self._error_message = None
        self.discriminator = None

        self.id = id
        self.pipeline = pipeline
        self.version = version
        self.deployment_requests = deployment_requests
        self.operator_requests = operator_requests
        self.result = result
        self.success = success
        self.error_message = error_message

    @property
    def id(self):
        """Gets the id of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The id of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PipelineRequestCreateResponse.


        :param id: The id of this PipelineRequestCreateResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and not isinstance(id, str)):
            raise ValueError("Parameter `id` must be a string")  # noqa: E501

        self._id = id

    @property
    def pipeline(self):
        """Gets the pipeline of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The pipeline of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: str
        """
        return self._pipeline

    @pipeline.setter
    def pipeline(self, pipeline):
        """Sets the pipeline of this PipelineRequestCreateResponse.


        :param pipeline: The pipeline of this PipelineRequestCreateResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                pipeline is not None and not isinstance(pipeline, str)):
            raise ValueError("Parameter `pipeline` must be a string")  # noqa: E501

        self._pipeline = pipeline

    @property
    def version(self):
        """Gets the version of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The version of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this PipelineRequestCreateResponse.


        :param version: The version of this PipelineRequestCreateResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                version is not None and not isinstance(version, str)):
            raise ValueError("Parameter `version` must be a string")  # noqa: E501

        if (self.local_vars_configuration.client_side_validation and
                version is not None and len(version) < 1):
            raise ValueError("Invalid value for `version`, length must be greater than or equal to `1`")  # noqa: E501

        self._version = version

    @property
    def deployment_requests(self):
        """Gets the deployment_requests of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The deployment_requests of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: list[DirectPipelineRequestDeploymentRequest]
        """
        return self._deployment_requests

    @deployment_requests.setter
    def deployment_requests(self, deployment_requests):
        """Sets the deployment_requests of this PipelineRequestCreateResponse.


        :param deployment_requests: The deployment_requests of this PipelineRequestCreateResponse.  # noqa: E501
        :type: list[DirectPipelineRequestDeploymentRequest]
        """
        if (self.local_vars_configuration.client_side_validation and
                deployment_requests is not None and not isinstance(deployment_requests, list)):
            raise ValueError("Parameter `deployment_requests` must be a list")  # noqa: E501
        if self.local_vars_configuration.client_side_validation and deployment_requests is not None:
            from ubiops.models.direct_pipeline_request_deployment_request import DirectPipelineRequestDeploymentRequest

            deployment_requests = [
                DirectPipelineRequestDeploymentRequest(**item) if isinstance(item, dict) else item  # noqa: E501
                for item in deployment_requests
            ]

        self._deployment_requests = deployment_requests

    @property
    def operator_requests(self):
        """Gets the operator_requests of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The operator_requests of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: list[DirectPipelineRequestOperatorRequest]
        """
        return self._operator_requests

    @operator_requests.setter
    def operator_requests(self, operator_requests):
        """Sets the operator_requests of this PipelineRequestCreateResponse.


        :param operator_requests: The operator_requests of this PipelineRequestCreateResponse.  # noqa: E501
        :type: list[DirectPipelineRequestOperatorRequest]
        """
        if (self.local_vars_configuration.client_side_validation and
                operator_requests is not None and not isinstance(operator_requests, list)):
            raise ValueError("Parameter `operator_requests` must be a list")  # noqa: E501
        if self.local_vars_configuration.client_side_validation and operator_requests is not None:
            from ubiops.models.direct_pipeline_request_operator_request import DirectPipelineRequestOperatorRequest

            operator_requests = [
                DirectPipelineRequestOperatorRequest(**item) if isinstance(item, dict) else item  # noqa: E501
                for item in operator_requests
            ]

        self._operator_requests = operator_requests

    @property
    def result(self):
        """Gets the result of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The result of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: object
        """
        return self._result

    @result.setter
    def result(self, result):
        """Sets the result of this PipelineRequestCreateResponse.


        :param result: The result of this PipelineRequestCreateResponse.  # noqa: E501
        :type: object
        """

        self._result = result

    @property
    def success(self):
        """Gets the success of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The success of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this PipelineRequestCreateResponse.


        :param success: The success of this PipelineRequestCreateResponse.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and success is None:  # noqa: E501
            raise ValueError("Invalid value for `success`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                success is not None and not isinstance(success, bool)):
            raise ValueError("Parameter `success` must be a boolean")  # noqa: E501

        self._success = success

    @property
    def error_message(self):
        """Gets the error_message of this PipelineRequestCreateResponse.  # noqa: E501


        :return: The error_message of this PipelineRequestCreateResponse.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this PipelineRequestCreateResponse.


        :param error_message: The error_message of this PipelineRequestCreateResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                error_message is not None and not isinstance(error_message, str)):
            raise ValueError("Parameter `error_message` must be a string")  # noqa: E501

        self._error_message = error_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PipelineRequestCreateResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PipelineRequestCreateResponse):
            return True

        return self.to_dict() != other.to_dict()
