# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class PipelineRequests(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a batch pipeline request  # noqa: E501

         ### Description Make a batch request to the default version of a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_version_requests_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create a batch pipeline version request  # noqa: E501

         ### Description Make a batch request to a pipeline version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline version request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_pipeline_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_batch_delete_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple pipeline requests  # noqa: E501

         ### Description Delete multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `pipeline_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_batch_get_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple pipeline requests  # noqa: E501

         ### Description Retrieve multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `deployment_requests`: A list of requests to the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `operator_requests`: A list of requests of the operators in the pipeline. With the operator request ids provided in this list, it's possible to collect the results of the operator requests separately.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\",         \"sequence_id\": \"16699092560130860\",         \"success\": true,         \"error_message\": null       }     ],     \"operator_requests\": [       {         \"id\": \"bd6d6ce5-ba9d-4c91-af61-0cf16f1f5452\",         \"pipeline_object\": \"function-1\",         \"operator\": \"function\",         \"sequence_id\": \"16699092560130861\",         \"success\": true,         \"error_message\": null       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"5fa86ad1-7949-48f5-8e2c-210cce78f427\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `pipeline_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a pipeline request  # noqa: E501

         ### Description  Make a direct request to the default version of a pipeline. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 (2 hours) and the default value is 3600 (1 hour). - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300  (5 minutes).   #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` example-plain-data ```  ### Response Structure  - `id`: Unique identifier for the pipeline request - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `success`: A boolean value that indicates whether the pipeline request was successful - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `deployment`: Name of the deployment the request was made to     - `version`: Name of the version the request was made to     - `success`: A boolean value that indicates whether the deployment request was successful     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  #### Response Examples ``` {   \"id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"success\": false,   \"error_message\": \"Error while processing a deployment request\",   \"deployment_requests\": [     {       \"id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"sequence_id\": \"16699092560130860\",       \"success\": true,       \"error_message\": null     },     {       \"id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"sequence_id\": \"16699092560130861\",       \"success\": false,       \"error_message\": \"Invalid message format\"      }   ],   \"operator_requests\": [     {       \"id\": \"bd6d6ce5-ba9d-4c91-af61-0cf16f1f5452\",       \"pipeline_object\": \"function-1\",       \"operator\": \"function\",       \"sequence_id\": \"16699092560130860\",       \"success\": true,       \"error_message\": null     }   ],   \"result\": {     \"output_field\": 23.5   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data', 'pipeline_timeout', 'deployment_timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_timeout' in local_var_params
            and local_var_params['pipeline_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_timeout` must be an integer when calling `pipeline_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_timeout' in local_var_params
            and local_var_params['deployment_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `deployment_timeout` must be an integer when calling `pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'pipeline_timeout' in local_var_params and local_var_params['pipeline_timeout'] is not None:  # noqa: E501
            query_params.append(('pipeline_timeout', local_var_params['pipeline_timeout']))  # noqa: E501
        if 'deployment_timeout' in local_var_params and local_var_params['deployment_timeout'] is not None:  # noqa: E501
            query_params.append(('deployment_timeout', local_var_params['deployment_timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_delete_with_http_info(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Delete a pipeline request  # noqa: E501

         ### Description Delete a request for the default version of a pipeline. This action deletes all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_delete_with_http_info(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `pipeline_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_get_with_http_info(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Get a pipeline request  # noqa: E501

         ### Description Get a request for the default version of a pipeline. With this method, the result of the request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `operator_requests`: A list of requests of the operators in the pipeline. With the operator request ids provided in this list, it's possible to collect the results of the operator requests separately.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the pipeline (and version) names if the request is directly made to the pipeline    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [     {       \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",       \"pipeline_object\": \"deployment-1-v1-object\",       \"deployment\": \"deployment-1\",       \"version\": \"v1\",       \"sequence_id\": \"16699092560130860\",       \"success\": true,       \"error_message\": null     }   ],   \"operator_requests\": [     {       \"id\": \"bd6d6ce5-ba9d-4c91-af61-0cf16f1f5452\",       \"pipeline_object\": \"function-1\",       \"operator\": \"function\",       \"sequence_id\": \"16699092560130861\",       \"success\": true,       \"error_message\": null     }   ],   \"result\": {     \"output_field\": 23.5   },   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"pipeline\": \"pipeline-1\",     \"pipeline\"_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_get_with_http_info(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `pipeline_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `pipeline_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline requests  # noqa: E501

         ### Description List all requests for the default version of a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'status', 'success', 'limit', 'offset', 'sort', 'request_schedule', 'start_date', 'end_date', 'search_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_schedule' in local_var_params
            and local_var_params['request_schedule'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_schedule'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_schedule` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `pipeline_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'search_id' in local_var_params
            and local_var_params['search_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['search_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `search_id` must be a string when calling `pipeline_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'request_schedule' in local_var_params and local_var_params['request_schedule'] is not None:  # noqa: E501
            query_params.append(('request_schedule', local_var_params['request_schedule']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'search_id' in local_var_params and local_var_params['search_id'] is not None:  # noqa: E501
            query_params.append(('search_id', local_var_params['search_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_requests_get_with_http_info(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Get an operator request  # noqa: E501

         ### Description Get a request for an operator object of a version of a pipeline. With this method, the result of the request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the operator request with the following fields:  - `id`: Unique identifier for the pipeline version object request  - `pipeline_request_id`: Unique identifier for the pipeline request to which the object request belongs  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `object`: Name of the pipeline version object for which the request was made  - `operator`: Name of the pipeline operator for which the request was made  - `status`: Status of the request. Can be 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the request was successful  - `time_created`: Server time that the request was made  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Request result value. NULL if the request failed.  - `error_message`: An error message explaining why the request has failed  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline_request_id\": \"ce488fed-04c2-4ce5-a839-f6e5580ad40f\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"object\": \"function-1\",   \"operator\": \"function\",   \"status\": \"completed\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"result\": {     \"output\": 23.5   },   \"error_message\": \"\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_requests_get_with_http_info(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OperatorRequestDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id', 'version', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `pipeline_version_object_requests_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `pipeline_version_object_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `pipeline_version_object_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/object-requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperatorRequestDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_requests_batch_delete_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple pipeline version requests  # noqa: E501

         ### Description Delete multiple requests for a pipeline version. If one of the given pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_batch_delete_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `pipeline_version_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_requests_batch_get_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple pipeline version requests  # noqa: E501

         ### Description Retrieve multiple requests for a pipeline version. If one of the given pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline version requests can be retrieved with this method. The pipeline version requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `deployment_requests`: A list of requests to the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"5fa86ad1-7949-48f5-8e2c-210cce78f427\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_batch_get_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `pipeline_version_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_requests_create_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create a pipeline version request  # noqa: E501

         ### Description  Make a direct request to a pipeline version. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 (2 hours) and the default value is 3600 (1 hour). - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).   #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` example-plain-data ```  ### Response Structure  - `id`: Unique identifier for the pipeline request - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `success`: A boolean value that indicates whether the pipeline request was successful - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `deployment`: Name of the deployment the request was made to     - `version`: Name of the version the request was made to     - `success`: A boolean value that indicates whether the deployment request was successful     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  #### Response Examples ``` {   \"id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"success\": false,   \"error_message\": \"Error while processing a deployment request\",   \"deployment_requests\": [     {       \"id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"error_message\": null     },     {       \"id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"error_message\": \"Invalid message format\"     }   ],   \"result\": {     \"output_field\": 23.5   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data', 'pipeline_timeout', 'deployment_timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_timeout' in local_var_params
            and local_var_params['pipeline_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_timeout` must be an integer when calling `pipeline_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_timeout' in local_var_params
            and local_var_params['deployment_timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `deployment_timeout` must be an integer when calling `pipeline_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'pipeline_timeout' in local_var_params and local_var_params['pipeline_timeout'] is not None:  # noqa: E501
            query_params.append(('pipeline_timeout', local_var_params['pipeline_timeout']))  # noqa: E501
        if 'deployment_timeout' in local_var_params and local_var_params['deployment_timeout'] is not None:  # noqa: E501
            query_params.append(('deployment_timeout', local_var_params['deployment_timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_requests_delete_with_http_info(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Delete a pipeline version request  # noqa: E501

         ### Description Delete a request for a pipeline version. This action deletes all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_delete_with_http_info(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `pipeline_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `pipeline_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_requests_get_with_http_info(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Get a pipeline version request  # noqa: E501

         ### Description Get a request for a pipeline version. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the pipeline version request with the following fields:  - `id`: Unique identifier for the pipeline version request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline version request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [     {       \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",       \"pipeline_object\": \"deployment-1-v1-object\",       \"deployment\": \"deployment-1\",       \"version\": \"v1\"     }   ],   \"result\": {     \"output_field\": 23.5   },   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_get_with_http_info(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'request_id', 'version', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `pipeline_version_requests_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `pipeline_version_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_requests_list_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline version requests  # noqa: E501

         ### Description List all requests for a pipeline version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline version request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request  - `success`: A boolean value that indicates whether the pipeline version request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_list_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'status', 'success', 'limit', 'offset', 'sort', 'request_schedule', 'start_date', 'end_date', 'search_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_requests_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_requests_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_schedule' in local_var_params
            and local_var_params['request_schedule'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_schedule'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_schedule` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'search_id' in local_var_params
            and local_var_params['search_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['search_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `search_id` must be a string when calling `pipeline_version_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'request_schedule' in local_var_params and local_var_params['request_schedule'] is not None:  # noqa: E501
            query_params.append(('request_schedule', local_var_params['request_schedule']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'search_id' in local_var_params and local_var_params['search_id'] is not None:  # noqa: E501
            query_params.append(('search_id', local_var_params['search_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
