# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ImportsAndExports(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def exports_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create an export  # noqa: E501

         ### Description Create an export by selecting the objects in the export  ### Optional Parameters - `deployments`: Dictionary containing the deployments to export - `pipelines`: Dictionary containing the pipelines to export - `environment_variables`: Dictionary containing the project-level environment variables to export  #### Request Examples  ``` {   \"deployments\": {     \"deployment-1\": {       \"versions\": {         \"version-1\": {           \"environment_variables\": {             \"VERSION_ENV_VAR_NAME_1\": {               \"include_value\": true             },             \"VERSION_ENV_VAR_NAME_2\": {               \"include_value\": false             }           }         },         \"version-2\": {}       },       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_NAME_1\": {           \"include_value\": false         }       }     },     \"deployment-2\": {       \"versions\": {}     }   },   \"pipelines\": {     \"pipeline-1\": {       \"versions\": {         \"version-1\": {},         \"version-2\": {}       }     },     \"pipeline-2\": {       \"versions\": {}     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_NAME_1\": {       \"include_value\": false     }   } } ```  ### Response Structure Details of the created export - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ExportCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExportList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `exports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.export_create import ExportCreate

                local_var_params['data'] = ExportCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExportList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_delete_with_http_info(self, project_name, export_id, **kwargs):  # noqa: E501
        """Delete an export  # noqa: E501

         ### Description Delete an export from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_delete_with_http_info(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'export_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_delete`")  # noqa: E501
        # verify the required parameter 'export_id' is set
        if self.api_client.client_side_validation and ('export_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['export_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `export_id` when calling `exports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'export_id' in local_var_params
            and local_var_params['export_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['export_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `export_id` must be a string when calling `exports_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'export_id' in local_var_params:
            path_params['export_id'] = local_var_params['export_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports/{export_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_download_with_http_info(self, project_name, export_id, **kwargs):  # noqa: E501
        """Download an export  # noqa: E501

         ### Description Download an export in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_download_with_http_info(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'export_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_download`")  # noqa: E501
        # verify the required parameter 'export_id' is set
        if self.api_client.client_side_validation and ('export_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['export_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `export_id` when calling `exports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'export_id' in local_var_params
            and local_var_params['export_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['export_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `export_id` must be a string when calling `exports_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'export_id' in local_var_params:
            path_params['export_id'] = local_var_params['export_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports/{export_id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_get_with_http_info(self, project_name, export_id, **kwargs):  # noqa: E501
        """Get an export  # noqa: E501

         ### Description Get the details of an export in a project  ### Response Structure - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes - `deployments`: Dictionary of the deployments in the export - `pipelines`: Dictionary of the pipelines in the export - `environment_variables`: Dictionary of the environment variables in the export   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_get_with_http_info(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExportDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'export_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_get`")  # noqa: E501
        # verify the required parameter 'export_id' is set
        if self.api_client.client_side_validation and ('export_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['export_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `export_id` when calling `exports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'export_id' in local_var_params
            and local_var_params['export_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['export_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `export_id` must be a string when calling `exports_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'export_id' in local_var_params:
            path_params['export_id'] = local_var_params['export_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports/{export_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExportDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def exports_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List exports  # noqa: E501

         ### Description List all exports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the export. Can be 'pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the exports in the project  - `id`: Unique identifier for the export (UUID)  - `creation_date`: Time the export was created  - `status`: The status of the export  - `error_message`: The error message in case of a failure  - `size`: Size of the export in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": null   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"completed\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ExportList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exports_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `exports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `exports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `exports_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/exports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExportList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_create_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """Create an import  # noqa: E501

         ### Description Create an import by uploading a zip file, providing a link to an import file or by giving an export id. Only one of the fields `file`, `import_link` or `export_id` may be given at a time.  When providing a link to an import file, make sure it is publicly downloadable.   ### Required Parameters  Only one of the following fields should be given: - `file`: A zip file - `import_link`: url to a publicly downloadable zip file - `export_id`: UUID of a previously created export in the same project  ### Optional Parameters - `skip_confirmation`: Whether to skip the confirmation step, default to False  ### Response Structure Details of the created import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": 28391 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_create_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file:
        :param str import_link:
        :param str export_id:
        :param bool skip_confirmation:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'file', 'import_link', 'export_id', 'skip_confirmation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_link' in local_var_params
            and local_var_params['import_link'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_link'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_link` must be a string when calling `imports_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'skip_confirmation' in local_var_params
            and local_var_params['skip_confirmation'] is not None):  # noqa: E501
            if not isinstance(local_var_params['skip_confirmation'], bool):  # noqa: E501
                raise ApiValueError("Parameter `skip_confirmation` must be a boolean when calling `imports_create`")  # noqa: E501

        if self.api_client.client_side_validation and ('import_link' in local_var_params and  # noqa: E501
                                                        len(local_var_params['import_link']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `import_link` when calling `imports_create`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'import_link' in local_var_params:
            form_params.append(('import_link', local_var_params['import_link']))  # noqa: E501
        if 'export_id' in local_var_params:
            form_params.append(('export_id', local_var_params['export_id']))  # noqa: E501
        if 'skip_confirmation' in local_var_params:
            form_params.append(('skip_confirmation', local_var_params['skip_confirmation']))  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_delete_with_http_info(self, project_name, import_id, **kwargs):  # noqa: E501
        """Delete an import  # noqa: E501

         ### Description Delete an import from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_delete_with_http_info(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_delete`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_download_with_http_info(self, project_name, import_id, **kwargs):  # noqa: E501
        """Download an import  # noqa: E501

         ### Description Download an import in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_download_with_http_info(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_download`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_get_with_http_info(self, project_name, import_id, **kwargs):  # noqa: E501
        """Get an import  # noqa: E501

         ### Description Get the details of an import in a project  ### Response Structure - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes - `deployments`: Dictionary of the deployments in the import - `pipelines`: Dictionary of the pipelines in the import - `environment_variables`: Dictionary of the environment variables in the import   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_get_with_http_info(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_get`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List imports  # noqa: E501

         ### Description List all imports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the import. Can be 'pending', 'scanning', 'confirmation', 'confirmation_pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the imports in the project  - `id`: Unique identifier for the import (UUID)  - `creation_date`: Time the import was created  - `status`: The status of the import  - `error_message`: The error message in case of a failure  - `size`: Size of the import in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 126832   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ImportList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `imports_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ImportList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def imports_update_with_http_info(self, project_name, import_id, data, **kwargs):  # noqa: E501
        """Confirm an import  # noqa: E501

         ### Description Confirm (and update) an import by selecting the objects in the import  ### Optional Parameters - `deployments`: Dictionary containing the deployments to create - `pipelines`: Dictionary containing the pipelines to create - `environment_variables`: Dictionary containing the project-level environment variables to create  #### Request Examples  ``` {     \"deployments\": {     \"deployment-1: {       \"description\": \"\",       \"labels\": {         \"my-label\": \"my-value\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"zip\": \"deployments/deployment_deployment-1/versions/deployment_deployment-1_version_v1.zip\",           \"description\": \"\",           \"labels\": {},           \"language\": \"python3.7\",           \"maximum_idle_time\": 300,           \"maximum_instances\": 5,           \"instance_type\": \"256mb\",           \"minimum_instances\": 0,           \"environment_variables\": {             \"VERSION_ENV_VAR_1\": {               \"value\": \"my-secret-value\",               \"secret\": true             },             \"VERSION_ENV_VAR_2\": {               \"value\": \"test2\"             }           },           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ],       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_1\": {           \"value\": \"my-secret-value\",           \"secret\": true         },         \"DEPLOYMENT_ENV_VAR_2\": {           \"value\": \"test\"         }       }     }   },   \"pipelines\": {     \"pipeline-1: {       \"description\": \"\",       \"labels\": {         \"test\": \"label\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"description\": \"\",           \"labels\": {},           \"objects\": [             {               \"name\": \"obj-1\",               \"reference_name\": \"deployment-1\",               \"reference_version\": \"v1\"             }           ],           \"attachments\": [             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"input\",                       \"destination_field_name\": \"input\"                     }                   ],                   \"source_name\": \"pipeline_start\"                 }               ],               \"destination_name\": \"obj-1\"             },             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"output\",                       \"destination_field_name\": \"output\"                     }                   ],                   \"source_name\": \"obj-1\"                 }               ],               \"destination_name\": \"pipeline_end\"             }           ],           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ]     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_1\": {       \"value\": \"value1\",       \"secret\": true     },     \"PROJECT_ENV_VAR_2\": {       \"value\": \"value2\"     }   } } ```  ### Response Structure Details of the updated import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_update_with_http_info(project_name, import_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param ImportUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'import_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method imports_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `imports_update`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if self.api_client.client_side_validation and ('import_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_id` when calling `imports_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `imports_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `imports_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'import_id' in local_var_params
            and local_var_params['import_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['import_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `import_id` must be a string when calling `imports_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.import_update import ImportUpdate

                local_var_params['data'] = ImportUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'import_id' in local_var_params:
            path_params['import_id'] = local_var_params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/imports/{import_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
