# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class Deployments(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def builds_get_with_http_info(self, project_name, build_id, deployment_name, version, **kwargs):  # noqa: E501
        """Get build  # noqa: E501

         ### Description  Retrieve details of a single build of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\",   \"has_request_method\": true,   \"has_requests_method\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_get_with_http_info(project_name, build_id, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BuildList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'build_id', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method builds_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'build_id' is set
        if self.api_client.client_side_validation and ('build_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['build_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `build_id` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `builds_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'build_id' in local_var_params
            and local_var_params['build_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['build_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `build_id` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `builds_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `builds_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'build_id' in local_var_params:
            path_params['build_id'] = local_var_params['build_id']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds/{build_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def builds_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List builds  # noqa: E501

         ### Description  List all builds associated with a version. A build is triggered when a new deployment file is uploaded.  ### Response Structure  A list of details of the builds - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` [   {     \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",     \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",     \"status\": \"failed\",     \"error_message\": \"Could not find the deployment file\",     \"trigger\": \"Deployment file upload\",     \"has_request_method\": true,     \"has_requests_method\": false   },   {     \"id\": \"baf88570-d884-4bc6-9308-01068b051f5f\",     \"revision\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"creation_date\": \"2020-12-23T16:35:13.088+00:00\",     \"status\": \"queued\",     \"error_message\": \"\",     \"trigger\": \"Deployment file upload\",     \"has_request_method\": true,     \"has_requests_method\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BuildList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method builds_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `builds_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `builds_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `builds_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `builds_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BuildList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def builds_update_with_http_info(self, project_name, build_id, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update build  # noqa: E501

         ### Description  Cancel a build of a version  ### Required Parameters - `status`: Status that the build will be updated to. It can only be cancelled.  #### Request Examples ``` {     \"status\": \"cancelled\" } ```  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success', 'failed' or 'cancelled'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"cancelled\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\",   \"has_request_method\": true,   \"has_requests_method\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_update_with_http_info(project_name, build_id, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param BuildUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BuildList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'build_id', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method builds_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `builds_update`")  # noqa: E501
        # verify the required parameter 'build_id' is set
        if self.api_client.client_side_validation and ('build_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['build_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `build_id` when calling `builds_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `builds_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `builds_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `builds_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `builds_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'build_id' in local_var_params
            and local_var_params['build_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['build_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `build_id` must be a string when calling `builds_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `builds_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `builds_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.build_update import BuildUpdate

                local_var_params['data'] = BuildUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'build_id' in local_var_params:
            path_params['build_id'] = local_var_params['build_id']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds/{build_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_audit_events_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_audit_events_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'action' in local_var_params
            and local_var_params['action'] is not None):  # noqa: E501
            if not isinstance(local_var_params['action'], str):  # noqa: E501
                raise ApiValueError("Parameter `action` must be a string when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `deployment_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `deployment_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_copy_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_copy import EnvironmentVariableCopy

                local_var_params['data'] = EnvironmentVariableCopy(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_get_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_update_with_http_info(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_copy_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy deployment version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment version. Variables of the deployment version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a deployment version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_copy`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_copy import EnvironmentVariableCopy

                local_var_params['data'] = EnvironmentVariableCopy(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete deployment version environment variable  # noqa: E501

         ### Description Delete an environment variable of a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_get_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get deployment version environment variable  # noqa: E501

         ### Description Retrieve details of a deployment version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment version. Includes environment variables defined at project level and deployment level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_environment_variables_update_with_http_info(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update deployment version environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the deployment version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_environment_variables_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.environment_variable_create import EnvironmentVariableCreate

                local_var_params['data'] = EnvironmentVariableCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment versions  # noqa: E501

         ### Description  Create a version for a deployment. The first version of a deployment is set as default. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. Python 3.7-3.11 and R4.0 are supported. The default value is python3.7. - `instance_type`: Reserved instance type for the version. This value determines the allocation of memory to the version: it should be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048mb. The minimum and maximum values are 256mb and 16384mb respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 (300 for GPU deployments) and the maximum value is 3600. A high value means that the version stays available longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version. It defaults to 604800 seconds (1 week). - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP. It defaults to False. - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption. It defaults to False.  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.8\" } ```  ``` {   \"version\": \"version-1\",   \"language\": \"r4.0\",   \"instance_type\": \"512mb\" } ```  ```   \"version\": \"version-1\",   \"language\": \"python3.6_cuda\",   \"instance_type\": \"16384mb_t4\",   \"maximum_instances\": 1 ```  ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: Active revision of the version. It is initialised as None since there are no deployment files uploaded for the version yet. - `latest_build`: Latest build of the version. It is initialised as None since no build is triggered for the version yet. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*. - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"language_description\": \"Python 3.8\",   \"status\": \"unavailable\",   \"active_revision\": null,   \"latest_build\": null,   \"instance_type\": \"512mb\",   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"maximum_queue_size_express\": 100,   \"maximum_queue_size_batch\": 100000,   \"static_ip\": false,   \"restart_request_interruption\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentVersionCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_version_create import DeploymentVersionCreate

                local_var_params['data'] = DeploymentVersionCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_delete_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete deployment version  # noqa: E501

         ### Description  Delete a deployment version. The version cannot be deleted if: - It is referenced in a pipeline, it must be removed from the pipeline first. - It is the default version of its deployment and is referenced in a request schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_delete_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_get_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get deployment version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `has_request_method`: Whether the latest build of the version has a 'request' method - `has_requests_method`: Whether the latest build of the version has a 'requests' method - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.7\",   \"language_description\": \"Python 3.7\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"9f7fd6ec-53b7-41c6-949e-09efc2ee2d31\",   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"maximum_queue_size_express\": 100,   \"maximum_queue_size_batch\": 100000,   \"has_request_method\": true,   \"has_requests_method\": false,   \"static_ip\": false,   \"restart_request_interruption\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_get_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"description\": \"\",     \"language\": \"python3.8\",     \"language_description\": \"Python 3.8\",     \"status\": \"available\",     \"active_revision\": \"da27ef7c-aa3f-4963-a815-6ebf1865638e\",     \"latest_build\": \"0f4a94c6-ec4c-4d1e-81d7-8f3e40471f75\",     \"instance_type\": \"512mb\",     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"monitoring\": \"notification-group-1\",     \"default_notification_group\": null,     \"request_retention_time\": 604800,     \"request_retention_mode\": \"full\",     \"maximum_queue_size_express\": 100,     \"maximum_queue_size_batch\": 100000,     \"static_ip\": false,     \"restart_request_interruption\": false   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"description\": \"\",     \"language\": \"r4.0\",     \"language_description\": \"R 4.0\",     \"status\": \"available\",     \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",     \"latest_build\": \"4534e479-ea2e-4161-876a-1d382191a031\",     \"instance_type\": \"256mb\",     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-2\",     \"default_notification_group\": \"notification-group-2\",     \"request_retention_time\": 86400,     \"request_retention_mode\": \"metadata\",     \"maximum_queue_size_express\": 100,     \"maximum_queue_size_batch\": 100000,     \"static_ip\": true,     \"restart_request_interruption\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentVersionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `deployment_versions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentVersionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_versions_update_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update deployment version  # noqa: E501

         ### Description  Update a version of a deployment in a project. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Optional Parameters  - `version`: New name for the version - `instance_type`: New instance type for the version - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Request Examples  ``` {   \"version\": \"new-version\" } ```  ``` {   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*. - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `has_request_method`: Whether the latest build of the version has a 'request' method - `has_requests_method`: Whether the latest build of the version has a 'requests' method - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"language_description\": \"Python 3.8\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"0d07337e-96d6-4ce6-8c63-c2f07edd2ce4\",   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"maximum_queue_size_express\": 100,   \"maximum_queue_size_batch\": 100000,   \"has_request_method\": true,   \"has_requests_method\": false,   \"static_ip\": false,   \"restart_request_interruption\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_update_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentVersionUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_versions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_versions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_version_update import DeploymentVersionUpdate

                local_var_params['data'] = DeploymentVersionUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create deployments  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **file**: a file field. This type of field can be used to pass files to the deployment. In deployment and pipeline requests, the path to the file in the bucket must be provided for this field.  Possible widgets for the input fields are: - **textbox**: textbox - **numberbox**: numberbox - **slider**: slider - **dropdown**: dropdown - **switch**: switch - **button**: upload button - **drawer**: drawer - **image_preview**: image upload with preview  Possible widgets for the output fields are: - **textbox**: textbox - **button**: download button - **image_preview**: image preview  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  A deployment with structured input and output type and field widgets ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {         \"type\": \"slider\",         \"configuration\": {\"min\": 0, \"max\": 10, \"default\": 4, \"step\": 2}       }     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"numberbox\",         \"configuration\": {\"min\": 0, \"max\": 1, \"default\": 0.5, \"step\": 0.1}       }     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     }   ] } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_create import DeploymentCreate

                local_var_params['data'] = DeploymentCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_delete_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_get_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of a deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and widget - `output_fields`: The list of deployment output fields containing name, data_type and widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List deployments  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `deployments_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_update_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment  ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `default_version`: Name of a version of this deployment which will be assigned as default. Only **available** versions can be assigned as default. - `input_fields`: New input fields for the deployment - `output_fields`: New output fields for the deployment  Input and output fields can be updated (name, data type or widget), added or removed. For deployments that are attached in a pipeline or contain any input/output widgets, fields must be updated one at a time so that the updates can be performed while preserving the mapping/widgets.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and (optional) widget - `output_fields`: The list of deployment output fields containing name, data_type and (optional) widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment. If it does not have a default version, it is not set.  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployments_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_update import DeploymentUpdate

                local_var_params['data'] = DeploymentUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_file_download_with_http_info(self, project_name, deployment_name, revision_id, version, **kwargs):  # noqa: E501
        """Download deployment file  # noqa: E501

         ### Description  Download the deployment file of a revision of a version  ### Response Structure   - `file`: Deployment file of the version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_file_download_with_http_info(project_name, deployment_name, revision_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str revision_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'revision_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_file_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `revisions_file_download`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `revisions_file_download`")  # noqa: E501
        # verify the required parameter 'revision_id' is set
        if self.api_client.client_side_validation and ('revision_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['revision_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `revision_id` when calling `revisions_file_download`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `revisions_file_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `revisions_file_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `revisions_file_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'revision_id' in local_var_params
            and local_var_params['revision_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['revision_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `revision_id` must be a string when calling `revisions_file_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `revisions_file_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'revision_id' in local_var_params:
            path_params['revision_id'] = local_var_params['revision_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions/{revision_id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_file_upload_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Upload deployment file  # noqa: E501

         ### Description  Upload a deployment file for a version. Uploading a deployment file will create a new revision and trigger a build. This file should contain the deployment that will be run. It should be provided as a zip and a template can be found on https://github.com/UbiOps/deployment-template. The file is saved under a directory in the storage specified in the settings.   It is **also possible** to provide a source version from which the deployment file will be copied. This will also create a new revision and trigger a build.  ### Optional Parameters - `file`: Deployment file - `source_deployment`: Name of the deployment from which the deployment file will be copied - `source_version`: Version from which the deployment file will be copied - `template_deployment_id`: UUID of a template deployment which will be used as the source of the deployment file  Either **file** or **source_deployment** and **source_version** must be provided. source_deployment and source_version must be provided together.  ### Response Structure - `success`: Boolean indicating whether the deployment file upload/copy succeeded or not - `revision`: UUID of the created revision for the file upload - `build`: UUID of the build created for the file upload   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_file_upload_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param file file:
        :param str source_deployment:
        :param str source_version:
        :param str template_deployment_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RevisionCreate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'file', 'source_deployment', 'source_version', 'template_deployment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_file_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `revisions_file_upload`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `revisions_file_upload`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `revisions_file_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `revisions_file_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `revisions_file_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `revisions_file_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'source_deployment' in local_var_params
            and local_var_params['source_deployment'] is not None):  # noqa: E501
            if not isinstance(local_var_params['source_deployment'], str):  # noqa: E501
                raise ApiValueError("Parameter `source_deployment` must be a string when calling `revisions_file_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'source_version' in local_var_params
            and local_var_params['source_version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['source_version'], str):  # noqa: E501
                raise ApiValueError("Parameter `source_version` must be a string when calling `revisions_file_upload`")  # noqa: E501

        if self.api_client.client_side_validation and ('source_deployment' in local_var_params and  # noqa: E501
                                                        len(local_var_params['source_deployment']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_deployment` when calling `revisions_file_upload`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('source_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['source_version']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `source_version` when calling `revisions_file_upload`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'source_deployment' in local_var_params:
            form_params.append(('source_deployment', local_var_params['source_deployment']))  # noqa: E501
        if 'source_version' in local_var_params:
            form_params.append(('source_version', local_var_params['source_version']))  # noqa: E501
        if 'template_deployment_id' in local_var_params:
            form_params.append(('template_deployment_id', local_var_params['template_deployment_id']))  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RevisionCreate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_get_with_http_info(self, project_name, deployment_name, revision_id, version, **kwargs):  # noqa: E501
        """Get revision  # noqa: E501

         ### Description  Retrieve details of a single revision of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the revision (UUID) - `version`: Version to which the revision is linked - `creation_date`: The date when the revision was created - `created_by`: The email of the user that uploaded the deployment file. In case the revision is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples ``` {   \"id\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",   \"version\": \"v1\",   \"creation_date\": \"2020-12-23T16:35:13.069+00:00\",   \"created_by\": \"test@example.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_get_with_http_info(project_name, deployment_name, revision_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str revision_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RevisionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'revision_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `revisions_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `revisions_get`")  # noqa: E501
        # verify the required parameter 'revision_id' is set
        if self.api_client.client_side_validation and ('revision_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['revision_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `revision_id` when calling `revisions_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `revisions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `revisions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `revisions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'revision_id' in local_var_params
            and local_var_params['revision_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['revision_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `revision_id` must be a string when calling `revisions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `revisions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'revision_id' in local_var_params:
            path_params['revision_id'] = local_var_params['revision_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions/{revision_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RevisionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List revisions  # noqa: E501

         ### Description  List all revisions associated with a version. A new revision is created every time a new deployment file is uploaded for a version.  ### Response Structure  A list of details of the revisions - `id`: Unique identifier for the revision (UUID) - `version`: Version to which the revision is linked - `creation_date`: The date when the revision was created - `created_by`: The email of the user that uploaded the deployment file. In case the revision is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples ``` [   {     \"id\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"version\": \"v1\",     \"creation_date\": \"2020-12-23T16:15:11.181+00:00\",     \"created_by\": \"UbiOps\"   },   {     \"id\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"version\": \"v1\",     \"creation_date\": \"2020-12-23T16:35:13.069+00:00\",     \"created_by\": \"test@example.com\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[RevisionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `revisions_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `revisions_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `revisions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `revisions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `revisions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `revisions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RevisionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_rebuild_with_http_info(self, project_name, deployment_name, revision_id, version, **kwargs):  # noqa: E501
        """Rebuild revision  # noqa: E501

         ### Description  Create a new build for a revision of a deployment version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\",   \"has_request_method\": true,   \"has_requests_method\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_rebuild_with_http_info(project_name, deployment_name, revision_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str revision_id: (required)
        :param str version: (required)
        :param object data:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BuildList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'revision_id', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_rebuild" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `revisions_rebuild`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `revisions_rebuild`")  # noqa: E501
        # verify the required parameter 'revision_id' is set
        if self.api_client.client_side_validation and ('revision_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['revision_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `revision_id` when calling `revisions_rebuild`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `revisions_rebuild`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `revisions_rebuild`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `revisions_rebuild`")  # noqa: E501
        if (self.api_client.client_side_validation and 'revision_id' in local_var_params
            and local_var_params['revision_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['revision_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `revision_id` must be a string when calling `revisions_rebuild`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `revisions_rebuild`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'revision_id' in local_var_params:
            path_params['revision_id'] = local_var_params['revision_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions/{revision_id}/rebuild', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
