# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from ubiops.api_client import ApiClient

from ubiops.api.blobs import Blobs
from ubiops.api.deployment_requests import DeploymentRequests
from ubiops.api.deployments import Deployments
from ubiops.api.files import Files
from ubiops.api.imports_and_exports import ImportsAndExports
from ubiops.api.monitoring import Monitoring
from ubiops.api.organizations import Organizations
from ubiops.api.pipeline_requests import PipelineRequests
from ubiops.api.pipelines import Pipelines
from ubiops.api.projects import Projects
from ubiops.api.request_schedules import RequestSchedules
from ubiops.api.roles import Roles
from ubiops.api.service_users import ServiceUsers
from ubiops.api.status import Status
from ubiops.api.user import User


class CoreApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.blobs = Blobs(api_client=api_client)
        self.deployment_requests = DeploymentRequests(api_client=api_client)
        self.deployments = Deployments(api_client=api_client)
        self.files = Files(api_client=api_client)
        self.imports_and_exports = ImportsAndExports(api_client=api_client)
        self.monitoring = Monitoring(api_client=api_client)
        self.organizations = Organizations(api_client=api_client)
        self.pipeline_requests = PipelineRequests(api_client=api_client)
        self.pipelines = Pipelines(api_client=api_client)
        self.projects = Projects(api_client=api_client)
        self.request_schedules = RequestSchedules(api_client=api_client)
        self.roles = Roles(api_client=api_client)
        self.service_users = ServiceUsers(api_client=api_client)
        self.status = Status(api_client=api_client)
        self.user = User(api_client=api_client)
        
    def blobs_create(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The uploaded blob file can be retrieved by passing the blob_id. The returned blob_id may be passed in a deployment or pipeline request as input.  ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs.blobs_create_with_http_info(project_name, file, **kwargs)  # noqa: E501

    def blobs_delete(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs.blobs_delete_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_get(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs.blobs_get_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_list(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `last_updated`: Time the blob was last updated  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BlobList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs.blobs_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def blobs_update(self, project_name, blob_id, file, **kwargs):  # noqa: E501
        """Update a blob  # noqa: E501

         ### Description  Overwrite a blob with given blob id. The uploaded blob file can be retrieved by passing the blob_id.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_update(project_name, blob_id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs.blobs_update_with_http_info(project_name, blob_id, file, **kwargs)  # noqa: E501

    def batch_deployment_requests_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a batch deployment request  # noqa: E501

         ### Description Request multiple predictions from the default version of a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.batch_deployment_requests_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def batch_deployment_version_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a batch deployment version request  # noqa: E501

         ### Description Request multiple predictions from a deployment version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state).  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.batch_deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_requests_batch_delete(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Delete multiple deployment requests  # noqa: E501

         ### Description Delete multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_delete(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_requests_batch_delete_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_requests_batch_get(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_get(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_requests_batch_get_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_requests_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a direct deployment request  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for the default version of a deployment. When using the 'requests' function of a deployment a list should be provided as input, see the example below.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a file field ``` {   \"input-field-1\": 5.0,   \"file-input-field\": \"ubiops-file://my-bucket/file-1.jpg\" } ```  A plain deployment request ``` \"example-plain-data\" ```  Multiple structured deployment requests using the 'requests' function of a deployment ``` [     {         \"input-field-1\": 5.0     },     {         \"input-field-1\": 10.0     } ] ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param object data: (required)
        :param int timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_requests_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_requests_delete(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Delete a deployment request  # noqa: E501

         ### Description Delete a deployment request for the default version of a deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_delete(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, **kwargs)  # noqa: E501

    def deployment_requests_get(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Get a deployment request  # noqa: E501

         ### Description Get a request of the default version of a deployment. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the deployment (and version) names if the request is directly made to the deployment    - the pipeline (and version) names if the request is part of a pipeline request    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"deployment\": \"deployment-1\",     \"deployment_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_get(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_requests_get_with_http_info(project_name, deployment_name, request_id, **kwargs)  # noqa: E501

    def deployment_requests_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment requests  # noqa: E501

         ### Description List all requests for the default version of a deployment  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_requests_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_requests_update(self, project_name, deployment_name, request_id, data, **kwargs):  # noqa: E501
        """Update a deployment request  # noqa: E501

         ### Description Update a deployment request for the default version of a deployment. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_update(project_name, deployment_name, request_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_requests_update_with_http_info(project_name, deployment_name, request_id, data, **kwargs)  # noqa: E501

    def deployment_version_requests_batch_delete(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple deployment version requests  # noqa: E501

         ### Description Delete multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_delete(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_version_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_batch_get(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment version requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   - `retries`: Number of times that the request has been retried  #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null,     \"retries\": 0   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null,     \"retries\": 1   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_get(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestBatchDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_version_requests_batch_get_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a direct deployment version request  # noqa: E501

         ### Description  Request a prediction from a deployment version. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). When using the 'requests' function of a deployment a list should be provided as input, see the example below.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a file field ``` {   \"input-field-1\": 5.0,   \"file-input-field\": \"ubiops-file://my-bucket/file-1.jpg\" } ```  A plain deployment request ``` \"example-plain-data\" ```  Multiple structured deployment requests using the 'requests' function of a deployment version ``` [     {         \"input-field-1\": 5.0     },     {         \"input-field-1\": 10.0     } ] ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_requests_delete(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete a deployment version request  # noqa: E501

         ### Description Delete a deployment request for a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_delete(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_version_requests_delete_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def deployment_version_requests_get(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get a deployment version request  # noqa: E501

         ### Description Get a request for a deployment version. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  - `retries`: Number of times that the request has been retried  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"retries\": 0 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_get(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_version_requests_get_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def deployment_version_requests_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version requests  # noqa: E501

         ### Description List all requests for a deployment version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_version_requests_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_version_requests_update(self, project_name, deployment_name, request_id, version, data, **kwargs):  # noqa: E501
        """Update a deployment version request  # noqa: E501

         ### Description Update a deployment request for a deployment version. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_update(project_name, deployment_name, request_id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests.deployment_version_requests_update_with_http_info(project_name, deployment_name, request_id, version, data, **kwargs)  # noqa: E501

    def builds_get(self, project_name, build_id, deployment_name, version, **kwargs):  # noqa: E501
        """Get build  # noqa: E501

         ### Description  Retrieve details of a single build of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\",   \"has_request_method\": true,   \"has_requests_method\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_get(project_name, build_id, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BuildList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.builds_get_with_http_info(project_name, build_id, deployment_name, version, **kwargs)  # noqa: E501

    def builds_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List builds  # noqa: E501

         ### Description  List all builds associated with a version. A build is triggered when a new deployment file is uploaded.  ### Response Structure  A list of details of the builds - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` [   {     \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",     \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",     \"status\": \"failed\",     \"error_message\": \"Could not find the deployment file\",     \"trigger\": \"Deployment file upload\",     \"has_request_method\": true,     \"has_requests_method\": false   },   {     \"id\": \"baf88570-d884-4bc6-9308-01068b051f5f\",     \"revision\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"creation_date\": \"2020-12-23T16:35:13.088+00:00\",     \"status\": \"queued\",     \"error_message\": \"\",     \"trigger\": \"Deployment file upload\",     \"has_request_method\": true,     \"has_requests_method\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BuildList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.builds_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def builds_update(self, project_name, build_id, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update build  # noqa: E501

         ### Description  Cancel a build of a version  ### Required Parameters - `status`: Status that the build will be updated to. It can only be cancelled.  #### Request Examples ``` {     \"status\": \"cancelled\" } ```  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success', 'failed' or 'cancelled'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"cancelled\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\",   \"has_request_method\": true,   \"has_requests_method\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.builds_update(project_name, build_id, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str build_id: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param BuildUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BuildList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.builds_update_with_http_info(project_name, build_id, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_audit_events_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_audit_events_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_environment_variables_copy(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_delete(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_get(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_environment_variables_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_environment_variables_update(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_copy(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy deployment version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment version. Variables of the deployment version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the deployment from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a deployment version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_copy(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment version environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_delete(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete deployment version environment variable  # noqa: E501

         ### Description Delete an environment variable of a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_delete(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_get(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get deployment version environment variable  # noqa: E501

         ### Description Retrieve details of a deployment version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_get(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment version. Includes environment variables defined at project level and deployment level.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_version_environment_variables_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_version_environment_variables_update(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update deployment version environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the deployment version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"deployment_version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_environment_variables_update(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, **kwargs)  # noqa: E501

    def deployment_versions_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment versions  # noqa: E501

         ### Description  Create a version for a deployment. The first version of a deployment is set as default. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. Python 3.7-3.11 and R4.0 are supported. The default value is python3.7. - `instance_type`: Reserved instance type for the version. This value determines the allocation of memory to the version: it should be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048mb. The minimum and maximum values are 256mb and 16384mb respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 (300 for GPU deployments) and the maximum value is 3600. A high value means that the version stays available longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version. It defaults to 604800 seconds (1 week). - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP. It defaults to False. - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption. It defaults to False.  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.8\" } ```  ``` {   \"version\": \"version-1\",   \"language\": \"r4.0\",   \"instance_type\": \"512mb\" } ```  ```   \"version\": \"version-1\",   \"language\": \"python3.6_cuda\",   \"instance_type\": \"16384mb_t4\",   \"maximum_instances\": 1 ```  ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: Active revision of the version. It is initialised as None since there are no deployment files uploaded for the version yet. - `latest_build`: Latest build of the version. It is initialised as None since no build is triggered for the version yet. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*. - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"language_description\": \"Python 3.8\",   \"status\": \"unavailable\",   \"active_revision\": null,   \"latest_build\": null,   \"instance_type\": \"512mb\",   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"maximum_queue_size_express\": 100,   \"maximum_queue_size_batch\": 100000,   \"static_ip\": false,   \"restart_request_interruption\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentVersionCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_versions_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_versions_delete(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete deployment version  # noqa: E501

         ### Description  Delete a deployment version. The version cannot be deleted if: - It is referenced in a pipeline, it must be removed from the pipeline first. - It is the default version of its deployment and is referenced in a request schedule.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_delete(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_versions_delete_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_versions_get(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get deployment version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `has_request_method`: Whether the latest build of the version has a 'request' method - `has_requests_method`: Whether the latest build of the version has a 'requests' method - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.7\",   \"language_description\": \"Python 3.7\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"9f7fd6ec-53b7-41c6-949e-09efc2ee2d31\",   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"maximum_queue_size_express\": 100,   \"maximum_queue_size_batch\": 100000,   \"has_request_method\": true,   \"has_requests_method\": false,   \"static_ip\": false,   \"restart_request_interruption\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_get(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_versions_get_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def deployment_versions_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"description\": \"\",     \"language\": \"python3.8\",     \"language_description\": \"Python 3.8\",     \"status\": \"available\",     \"active_revision\": \"da27ef7c-aa3f-4963-a815-6ebf1865638e\",     \"latest_build\": \"0f4a94c6-ec4c-4d1e-81d7-8f3e40471f75\",     \"instance_type\": \"512mb\",     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"monitoring\": \"notification-group-1\",     \"default_notification_group\": null,     \"request_retention_time\": 604800,     \"request_retention_mode\": \"full\",     \"maximum_queue_size_express\": 100,     \"maximum_queue_size_batch\": 100000,     \"static_ip\": false,     \"restart_request_interruption\": false   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"description\": \"\",     \"language\": \"r4.0\",     \"language_description\": \"R 4.0\",     \"status\": \"available\",     \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",     \"latest_build\": \"4534e479-ea2e-4161-876a-1d382191a031\",     \"instance_type\": \"256mb\",     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-2\",     \"default_notification_group\": \"notification-group-2\",     \"request_retention_time\": 86400,     \"request_retention_mode\": \"metadata\",     \"maximum_queue_size_express\": 100,     \"maximum_queue_size_batch\": 100000,     \"static_ip\": true,     \"restart_request_interruption\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentVersionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_versions_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_versions_update(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update deployment version  # noqa: E501

         ### Description  Update a version of a deployment in a project. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Optional Parameters  - `version`: New name for the version - `instance_type`: New instance type for the version - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Request Examples  ``` {   \"version\": \"new-version\" } ```  ``` {   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"monitoring\": \"notification-group-1\" } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `description`: Description of the version - `language`: Language in which the version is provided - `language_description`: Human readable name of the language - `status`: The status of the version - `active_revision`: UUID of the active revision of the version. If no deployment files have been uploaded yet, it is None. - `latest_build`: UUID of the latest build of the version. If no build has been triggered yet, it is None. - `instance_type`: The reserved instance type for the version - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `last_file_upload`: The date when a deployment file was last uploaded for the version - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the version - `request_retention_mode`: Mode of request retention for requests to the version. It can be one of the following: *none*, *metadata* or *full*. - `maximum_queue_size_express`: Maximum number of queued express requests for all instances of this deployment version - `maximum_queue_size_batch`: Maximum number of queued batch requests for all instances of this deployment version - `has_request_method`: Whether the latest build of the version has a 'request' method - `has_requests_method`: Whether the latest build of the version has a 'requests' method - `static_ip`: A boolean indicating whether the deployment version should get a static IP - `restart_request_interruption`: A boolean indicating whether the requests should be restarted in case of an interruption  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"description\": \"\",   \"language\": \"python3.8\",   \"language_description\": \"Python 3.8\",   \"status\": \"available\",   \"active_revision\": \"a74662be-c938-4104-872a-8be1b85f64ff\",   \"latest_build\": \"0d07337e-96d6-4ce6-8c63-c2f07edd2ce4\",   \"instance_type\": \"512mb\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"last_file_uploaded\": \"2020-06-21T09:03:01.875391Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"maximum_queue_size_express\": 100,   \"maximum_queue_size_batch\": 100000,   \"has_request_method\": true,   \"has_requests_method\": false,   \"static_ip\": false,   \"restart_request_interruption\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_versions_update(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentVersionUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployment_versions_update_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployments_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create deployments  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **file**: a file field. This type of field can be used to pass files to the deployment. In deployment and pipeline requests, the path to the file in the bucket must be provided for this field.  Possible widgets for the input fields are: - **textbox**: textbox - **numberbox**: numberbox - **slider**: slider - **dropdown**: dropdown - **switch**: switch - **button**: upload button - **drawer**: drawer - **image_preview**: image upload with preview  Possible widgets for the output fields are: - **textbox**: textbox - **button**: download button - **image_preview**: image preview  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type, and it may contain the field: widget. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  A deployment with structured input and output type and field widgets ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {         \"type\": \"slider\",         \"configuration\": {\"min\": 0, \"max\": 10, \"default\": 4, \"step\": 2}       }     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"numberbox\",         \"configuration\": {\"min\": 0, \"max\": 1, \"default\": 0.5, \"step\": 0.1}       }     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     }   ] } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployments_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def deployments_delete(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployments_delete_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_get(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of a deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and widget - `output_fields`: The list of deployment output fields containing name, data_type and widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployments_get_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_list(self, project_name, **kwargs):  # noqa: E501
        """List deployments  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployments_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def deployments_update(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment  ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `default_version`: Name of a version of this deployment which will be assigned as default. Only **available** versions can be assigned as default. - `input_fields`: New input fields for the deployment - `output_fields`: New output fields for the deployment  Input and output fields can be updated (name, data type or widget), added or removed. For deployments that are attached in a pipeline or contain any input/output widgets, fields must be updated one at a time so that the updates can be performed while preserving the mapping/widgets.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name, data_type and (optional) widget - `output_fields`: The list of deployment output fields containing name, data_type and (optional) widget - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `default_version`: Default version of the deployment. If it does not have a default version, it is not set.  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.deployments_update_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def revisions_file_download(self, project_name, deployment_name, revision_id, version, **kwargs):  # noqa: E501
        """Download deployment file  # noqa: E501

         ### Description  Download the deployment file of a revision of a version  ### Response Structure   - `file`: Deployment file of the version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_file_download(project_name, deployment_name, revision_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str revision_id: (required)
        :param str version: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.revisions_file_download_with_http_info(project_name, deployment_name, revision_id, version, **kwargs)  # noqa: E501

    def revisions_file_upload(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Upload deployment file  # noqa: E501

         ### Description  Upload a deployment file for a version. Uploading a deployment file will create a new revision and trigger a build. This file should contain the deployment that will be run. It should be provided as a zip and a template can be found on https://github.com/UbiOps/deployment-template. The file is saved under a directory in the storage specified in the settings.   It is **also possible** to provide a source version from which the deployment file will be copied. This will also create a new revision and trigger a build.  ### Optional Parameters - `file`: Deployment file - `source_deployment`: Name of the deployment from which the deployment file will be copied - `source_version`: Version from which the deployment file will be copied - `template_deployment_id`: UUID of a template deployment which will be used as the source of the deployment file  Either **file** or **source_deployment** and **source_version** must be provided. source_deployment and source_version must be provided together.  ### Response Structure - `success`: Boolean indicating whether the deployment file upload/copy succeeded or not - `revision`: UUID of the created revision for the file upload - `build`: UUID of the build created for the file upload   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_file_upload(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param file file:
        :param str source_deployment:
        :param str source_version:
        :param str template_deployment_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RevisionCreate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.revisions_file_upload_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def revisions_get(self, project_name, deployment_name, revision_id, version, **kwargs):  # noqa: E501
        """Get revision  # noqa: E501

         ### Description  Retrieve details of a single revision of a version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the revision (UUID) - `version`: Version to which the revision is linked - `creation_date`: The date when the revision was created - `created_by`: The email of the user that uploaded the deployment file. In case the revision is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples ``` {   \"id\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",   \"version\": \"v1\",   \"creation_date\": \"2020-12-23T16:35:13.069+00:00\",   \"created_by\": \"test@example.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_get(project_name, deployment_name, revision_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str revision_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RevisionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.revisions_get_with_http_info(project_name, deployment_name, revision_id, version, **kwargs)  # noqa: E501

    def revisions_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List revisions  # noqa: E501

         ### Description  List all revisions associated with a version. A new revision is created every time a new deployment file is uploaded for a version.  ### Response Structure  A list of details of the revisions - `id`: Unique identifier for the revision (UUID) - `version`: Version to which the revision is linked - `creation_date`: The date when the revision was created - `created_by`: The email of the user that uploaded the deployment file. In case the revision is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples ``` [   {     \"id\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",     \"version\": \"v1\",     \"creation_date\": \"2020-12-23T16:15:11.181+00:00\",     \"created_by\": \"UbiOps\"   },   {     \"id\": \"a009d7c9-67e4-4d3c-89fd-d3c8b07c7242\",     \"version\": \"v1\",     \"creation_date\": \"2020-12-23T16:35:13.069+00:00\",     \"created_by\": \"test@example.com\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RevisionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.revisions_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def revisions_rebuild(self, project_name, deployment_name, revision_id, version, **kwargs):  # noqa: E501
        """Rebuild revision  # noqa: E501

         ### Description  Create a new build for a revision of a deployment version  ### Response Structure  A dictionary containing details of the build - `id`: Unique identifier for the build (UUID) - `revision`: UUID of the revision to which the build is linked - `creation_date`: The date when the build was created - `status`: Status of the build. Can be 'queued', 'building', 'validating', 'success' or 'failed'. - `error_message`: Error message which explains why the build has failed. It is empty if the build is successful. - `trigger`: Action that triggered the build - `has_request_method`: Whether the build has a 'request' method - `has_requests_method`: Whether the build has a 'requests' method  #### Response Examples ``` {   \"id\": \"49d857fd-39ca-48db-9547-0d5d1a91b62d\",   \"revision\": \"7ead8a18-c1d2-4751-80d2-d8e0e0e2fed6\",   \"creation_date\": \"2020-12-23T16:15:11.200+00:00\",   \"status\": \"building\",   \"error_message\": \"\",   \"trigger\": \"Deployment file upload\",   \"has_request_method\": true,   \"has_requests_method\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_rebuild(project_name, deployment_name, revision_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str revision_id: (required)
        :param str version: (required)
        :param object data:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BuildList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments.revisions_rebuild_with_http_info(project_name, deployment_name, revision_id, version, **kwargs)  # noqa: E501

    def buckets_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create bucket  # noqa: E501

         ### Description  Create a bucket in a project  ### Required Parameters  - `name`: Name of the bucket. It is unique within a project.  ### Optional Parameters - `provider`: Provider of the bucket. It can be 'ubiops', 'google_cloud_storage', 'amazon_s3' or 'azure_blob_storage'. The default is **ubiops**. - `credentials`: A dictionary for credentials to connect to the bucket. It is only required for providers other than *ubiops*. Each provider requires a different set of fields:   - For Amazon S3, provide the fields `access_key` and `secret_key`.   - For Azure Blob Storage, provide the field `connection_string` in the format: *DefaultEndpointsProtocol=https;AccountName=<account-name>;AccountKey=<account-key>;EndpointSuffix=core.windows.net*.   - For Google Cloud Storage, provide the field `json_key_file`. - `configuration`: A dictionary for additional configuration details for the bucket. It is only required for providers other than *ubiops*. Each provider requires a different set of fields:   - For Amazon S3, provide the fields `bucket` and `prefix`. One of the fields `region` or `endpoint_url` needs to be provided. The fields `verify` and `use_ssl` are optional.   - For Azure Blob Storage, provide the fields `container` and `prefix`.   - For Google Cloud Storage, provide the fields `bucket` and `prefix`.   UbiOps always makes sure that the prefix ends with a '/'. - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket. It must be a multiple of 604800 (1 week). Pass `null` to keep them forever.  #### Request Examples ``` {   \"name\": \"bucket-1\",   \"provider\": \"ubiops\",   \"credentials\": {},   \"configuration\": {},   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\" } ```  ### Response Structure  Details of the created bucket - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is created - `provider`: Provider of the bucket - `credentials`: Credentials to connect to the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"bucket-1\",   \"project\": \"project-1\",   \"provider\": \"ubiops\",   \"credentials\": {},   \"configuration\": {},   \"creation_date\": \"2022-05-12T16:23:15.456812Z\",   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\",   \"ttl\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param BucketCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BucketList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.buckets_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def buckets_delete(self, project_name, bucket_name, **kwargs):  # noqa: E501
        """Delete a bucket  # noqa: E501

         ### Description  Delete a bucket. If the bucket provider is UbiOps, the files in the bucket will be deleted together with the bucket. For other providers, the files in the bucket are not removed but just the connection from UbiOps to the bucket.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_delete(project_name, bucket_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.buckets_delete_with_http_info(project_name, bucket_name, **kwargs)  # noqa: E501

    def buckets_get(self, project_name, bucket_name, **kwargs):  # noqa: E501
        """Get details of a bucket  # noqa: E501

         ### Description  Retrieve details of a bucket in a project  ### Response Structure  Details of a bucket - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is defined - `provider`: Provider of the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket - `size`: Size of the bucket according to the last measurement date - `size_measurement_date`: Last measurement date of the size of the bucket  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"bucket-1\",   \"project\": \"project-1\",   \"provider\": \"ubiops\",   \"configuration\": {},   \"creation_date\": \"2022-05-12T16:23:15.456812Z\",   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\",   \"ttl\": null,   \"size\": 2048,   \"size_measurement_date\": \"2022-05-24T02:23:15.456812Z\", } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_get(project_name, bucket_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BucketDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.buckets_get_with_http_info(project_name, bucket_name, **kwargs)  # noqa: E501

    def buckets_list(self, project_name, **kwargs):  # noqa: E501
        """List buckets  # noqa: E501

         ### Description List buckets in a project  ### Optional Parameters - `labels`: Filter on labels of the buckets. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). Buckets that have at least one of the labels in the filter are returned. This parameter should be given as query parameter.  ### Response Structure  A list of details of the buckets in the project - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is defined - `provider`: Provider of the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"bucket-1\",     \"project\": \"project-1\",     \"provider\": \"ubiops\",     \"creation_date\": \"2022-05-12T16:23:15.456812Z\",     \"configuration\": {},     \"labels\": {       \"type\": \"bucket\"     },     \"description\": \"My bucket description\",     \"ttl\": null   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"bucket-2\",     \"project\": \"project-1\",     \"provider\": \"ubiops\",     \"creation_date\": \"2022-05-12T16:23:15.456812Z\",     \"configuration\": {},     \"labels\": {},     \"description\": \"My bucket 2 description\",     \"ttl\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BucketList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.buckets_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def buckets_update(self, project_name, bucket_name, data, **kwargs):  # noqa: E501
        """Update a bucket  # noqa: E501

         ### Description  Update a bucket  ### Optional Parameters - `credentials`: Credentials to connect to the bucket - `configuration`: Additional configuration details for the bucket  - `description`: New description for the bucket - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `ttl`: Time to live for the files in the bucket. It must be a multiple of 604800 (1 week).  #### Request Examples ``` {   \"description\": \"New description for the bucket\" } ```  ### Response Structure  Details of the updated bucket - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is defined - `provider`: Provider of the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket - `size`: Size of the bucket according to the last measurement date - `size_measurement_date`: Last measurement date of the size of the bucket  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-bucket-name\",   \"project\": \"project-1\",   \"provider\": \"ubiops\",   \"configuration\": {},   \"creation_date\": \"2022-05-12T16:23:15.456812Z\",   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\",   \"ttl\": null,   \"size\": 2048,   \"size_measurement_date\": \"2022-05-24T02:23:15.456812Z\", } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_update(project_name, bucket_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param BucketUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BucketDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.buckets_update_with_http_info(project_name, bucket_name, data, **kwargs)  # noqa: E501

    def files_delete(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Delete a file  # noqa: E501

         ### Description Delete a file from a bucket   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_delete(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.files_delete_with_http_info(project_name, bucket_name, file, **kwargs)  # noqa: E501

    def files_download(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Download a file  # noqa: E501

         ### Description Generate a signed url to download a file. Request body should be an empty dictionary.  ### Response Structure  - `url`: A url which can be used to download the file from bucket. Make a GET request to this url to download the file. - `provider`: Provider of the bucket where the file will be uploaded  #### Response Examples ``` {   \"url\": \"https://storage.apis.com/my-bucket/my-file.jpg...\",   \"provider\": \"ubiops\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_download(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.files_download_with_http_info(project_name, bucket_name, file, **kwargs)  # noqa: E501

    def files_get(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Get a file  # noqa: E501

         ### Description Get the details of a file in the bucket  ### Response Structure  - `file`: Name of the file - `size`: Size of the file - `time_created`: The time that the file was created  #### Response Examples ``` {   \"file\": \"my-file-1\",   \"size\": 123,   \"time_created\": \"2022-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_get(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.files_get_with_http_info(project_name, bucket_name, file, **kwargs)  # noqa: E501

    def files_list(self, project_name, bucket_name, **kwargs):  # noqa: E501
        """List files  # noqa: E501

         ### Description List files in a bucket  ### Optional Parameters The following parameters should be given as query parameters: - `prefix`: Prefix to filter files - `delimiter`: Delimiter used with prefix to emulate hierarchy to filter files - `limit`: The maximum number of files returned, default is 100 - `continuation_token`: A token that indicates the start point of the returned the files  ### Response Structure  A dictionary containing the details of files and prefixes in the bucket - `continuation_token`: Next token to get the next set of files - `files`: A list of dictionaries containing the details of the files. It contains the file name ('file'), size of the file ('size') and the creation time of the file ('time_created'). - `prefixes`: A list of directories  #### Response Examples ``` {   \"continuation_token\": \"1234\",   \"files\": [     {       \"file\": \"my-file-1\",       \"size\": 123,       \"time_created\": \"2022-05-12T16:23:15.456812Z\"     },     {       \"file\": \"my-file-2\",       \"size\": 456,       \"time_created\": \"2022-06-05T10:56:12.186046Z\"     }   ],   \"prefixes\": [     \"my-dir-1\",     \"my-dir-2\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_list(project_name, bucket_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str prefix:
        :param str delimiter:
        :param str continuation_token:
        :param int limit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.files_list_with_http_info(project_name, bucket_name, **kwargs)  # noqa: E501

    def files_upload(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Upload a file  # noqa: E501

         ### Description Generate a signed url to upload a file. Request body should be an empty dictionary.  Note: When using the url generated by this endpoint for Azure Blob Storage, the following headers must be added to the upload request to Azure Blob Storage: - `x-ms-version`: '2020-04-08' - `x-ms-blob-type`: 'BlockBlob'  ### Response Structure  - `url`: A url which can be used to upload the file to bucket. Make a PUT request to this url with the file content to upload the file. - `provider`: Provider of the bucket where the file will be uploaded  #### Response Examples ``` {   \"url\": \"https://storage.apis.com/my-bucket/my-file.jpg...\",   \"provider\": \"ubiops\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_upload(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param object data:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files.files_upload_with_http_info(project_name, bucket_name, file, **kwargs)  # noqa: E501

    def exports_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create an export  # noqa: E501

         ### Description Create an export by selecting the objects in the export  ### Optional Parameters - `deployments`: Dictionary containing the deployments to export - `pipelines`: Dictionary containing the pipelines to export - `environment_variables`: Dictionary containing the project-level environment variables to export  #### Request Examples  ``` {   \"deployments\": {     \"deployment-1\": {       \"versions\": {         \"version-1\": {           \"environment_variables\": {             \"VERSION_ENV_VAR_NAME_1\": {               \"include_value\": true             },             \"VERSION_ENV_VAR_NAME_2\": {               \"include_value\": false             }           }         },         \"version-2\": {}       },       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_NAME_1\": {           \"include_value\": false         }       }     },     \"deployment-2\": {       \"versions\": {}     }   },   \"pipelines\": {     \"pipeline-1\": {       \"versions\": {         \"version-1\": {},         \"version-2\": {}       }     },     \"pipeline-2\": {       \"versions\": {}     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_NAME_1\": {       \"include_value\": false     }   } } ```  ### Response Structure Details of the created export - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ExportCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExportList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.exports_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def exports_delete(self, project_name, export_id, **kwargs):  # noqa: E501
        """Delete an export  # noqa: E501

         ### Description Delete an export from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_delete(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.exports_delete_with_http_info(project_name, export_id, **kwargs)  # noqa: E501

    def exports_download(self, project_name, export_id, **kwargs):  # noqa: E501
        """Download an export  # noqa: E501

         ### Description Download an export in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_download(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.exports_download_with_http_info(project_name, export_id, **kwargs)  # noqa: E501

    def exports_get(self, project_name, export_id, **kwargs):  # noqa: E501
        """Get an export  # noqa: E501

         ### Description Get the details of an export in a project  ### Response Structure - `id`: Unique identifier for the export (UUID) - `status`: Status of the export - `error_message`: The error message in case of a failure - `creation_date`: The date when the export was created - `size`: Size of the export in bytes - `deployments`: Dictionary of the deployments in the export - `pipelines`: Dictionary of the pipelines in the export - `environment_variables`: Dictionary of the environment variables in the export   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_get(project_name, export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str export_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExportDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.exports_get_with_http_info(project_name, export_id, **kwargs)  # noqa: E501

    def exports_list(self, project_name, **kwargs):  # noqa: E501
        """List exports  # noqa: E501

         ### Description List all exports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the export. Can be 'pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the exports in the project  - `id`: Unique identifier for the export (UUID)  - `creation_date`: Time the export was created  - `status`: The status of the export  - `error_message`: The error message in case of a failure  - `size`: Size of the export in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": null   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"completed\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exports_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ExportList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.exports_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def imports_create(self, project_name, **kwargs):  # noqa: E501
        """Create an import  # noqa: E501

         ### Description Create an import by uploading a zip file, providing a link to an import file or by giving an export id. Only one of the fields `file`, `import_link` or `export_id` may be given at a time.  When providing a link to an import file, make sure it is publicly downloadable.   ### Required Parameters  Only one of the following fields should be given: - `file`: A zip file - `import_link`: url to a publicly downloadable zip file - `export_id`: UUID of a previously created export in the same project  ### Optional Parameters - `skip_confirmation`: Whether to skip the confirmation step, default to False  ### Response Structure Details of the created import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": 28391 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_create(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file:
        :param str import_link:
        :param str export_id:
        :param bool skip_confirmation:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.imports_create_with_http_info(project_name, **kwargs)  # noqa: E501

    def imports_delete(self, project_name, import_id, **kwargs):  # noqa: E501
        """Delete an import  # noqa: E501

         ### Description Delete an import from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_delete(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.imports_delete_with_http_info(project_name, import_id, **kwargs)  # noqa: E501

    def imports_download(self, project_name, import_id, **kwargs):  # noqa: E501
        """Download an import  # noqa: E501

         ### Description Download an import in a project  ### Response Structure - `file`: Zip file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_download(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.imports_download_with_http_info(project_name, import_id, **kwargs)  # noqa: E501

    def imports_get(self, project_name, import_id, **kwargs):  # noqa: E501
        """Get an import  # noqa: E501

         ### Description Get the details of an import in a project  ### Response Structure - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes - `deployments`: Dictionary of the deployments in the import - `pipelines`: Dictionary of the pipelines in the import - `environment_variables`: Dictionary of the environment variables in the import   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_get(project_name, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.imports_get_with_http_info(project_name, import_id, **kwargs)  # noqa: E501

    def imports_list(self, project_name, **kwargs):  # noqa: E501
        """List imports  # noqa: E501

         ### Description List all imports in a project  ### Optional Parameters The following parameter should be given as query parameter: - `status`: Status of the import. Can be 'pending', 'scanning', 'confirmation', 'confirmation_pending', 'processing', 'completed' and 'failed'.  ### Response Structure A list of details of the imports in the project  - `id`: Unique identifier for the import (UUID)  - `creation_date`: Time the import was created  - `status`: The status of the import  - `error_message`: The error message in case of a failure  - `size`: Size of the import in bytes  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 126832   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"status\": \"pending\",     \"error_message\": \"\",     \"size\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str status:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ImportList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.imports_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def imports_update(self, project_name, import_id, data, **kwargs):  # noqa: E501
        """Confirm an import  # noqa: E501

         ### Description Confirm (and update) an import by selecting the objects in the import  ### Optional Parameters - `deployments`: Dictionary containing the deployments to create - `pipelines`: Dictionary containing the pipelines to create - `environment_variables`: Dictionary containing the project-level environment variables to create  #### Request Examples  ``` {     \"deployments\": {     \"deployment-1: {       \"description\": \"\",       \"labels\": {         \"my-label\": \"my-value\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"zip\": \"deployments/deployment_deployment-1/versions/deployment_deployment-1_version_v1.zip\",           \"description\": \"\",           \"labels\": {},           \"language\": \"python3.7\",           \"maximum_idle_time\": 300,           \"maximum_instances\": 5,           \"instance_type\": \"256mb\",           \"minimum_instances\": 0,           \"environment_variables\": {             \"VERSION_ENV_VAR_1\": {               \"value\": \"my-secret-value\",               \"secret\": true             },             \"VERSION_ENV_VAR_2\": {               \"value\": \"test2\"             }           },           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ],       \"environment_variables\": {         \"DEPLOYMENT_ENV_VAR_1\": {           \"value\": \"my-secret-value\",           \"secret\": true         },         \"DEPLOYMENT_ENV_VAR_2\": {           \"value\": \"test\"         }       }     }   },   \"pipelines\": {     \"pipeline-1: {       \"description\": \"\",       \"labels\": {         \"test\": \"label\"       },       \"default_version\": \"v1\",       \"versions\": {         \"v1\": {           \"description\": \"\",           \"labels\": {},           \"objects\": [             {               \"name\": \"obj-1\",               \"reference_name\": \"deployment-1\",               \"reference_version\": \"v1\"             }           ],           \"attachments\": [             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"input\",                       \"destination_field_name\": \"input\"                     }                   ],                   \"source_name\": \"pipeline_start\"                 }               ],               \"destination_name\": \"obj-1\"             },             {               \"sources\": [                 {                   \"mapping\": [                     {                       \"source_field_name\": \"output\",                       \"destination_field_name\": \"output\"                     }                   ],                   \"source_name\": \"obj-1\"                 }               ],               \"destination_name\": \"pipeline_end\"             }           ],           \"request_retention_mode\": \"full\",           \"request_retention_time\": 604800         }       },       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"double\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"double\"         }       ]     }   },   \"environment_variables\": {     \"PROJECT_ENV_VAR_1\": {       \"value\": \"value1\",       \"secret\": true     },     \"PROJECT_ENV_VAR_2\": {       \"value\": \"value2\"     }   } } ```  ### Response Structure Details of the updated import - `id`: Unique identifier for the import (UUID) - `status`: Status of the import - `error_message`: The error message in case of a failure - `creation_date`: The date when the import was created - `size`: Size of the import in bytes  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"status\": \"pending\",   \"error_message\": \"\",   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"size\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.imports_update(project_name, import_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str import_id: (required)
        :param ImportUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.imports_and_exports.imports_update_with_http_info(project_name, import_id, data, **kwargs)  # noqa: E501

    def notification_groups_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create notification groups  # noqa: E501

         ### Description  Create a notification group by defining a name and a list of contacts  ### Required Parameters  - `name`: Name of the notification group. It is unique within a project.  ### Optional Parameters - `contacts`: A list of dictionaries containing the following keys:   - `type`: Type of the contact. It can be `email`.   - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```  ### Response Structure  Details of the created notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param NotificationGroupCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NotificationGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.monitoring.notification_groups_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def notification_groups_delete(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Delete notification group  # noqa: E501

         ### Description  Delete a notification group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_delete(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.monitoring.notification_groups_delete_with_http_info(project_name, notification_group_name, **kwargs)  # noqa: E501

    def notification_groups_get(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Get notification group  # noqa: E501

         ### Description  Retrieve details of a single notification group in a project  ### Response Structure  Details of a notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_get(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NotificationGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.monitoring.notification_groups_get_with_http_info(project_name, notification_group_name, **kwargs)  # noqa: E501

    def notification_groups_list(self, project_name, **kwargs):  # noqa: E501
        """List notification groups  # noqa: E501

         ### Description  List the notification groups in a project  ### Response Structure  A list of details of the notification groups in the project - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` [   {     \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",     \"name\": \"notification-group-1\",     \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user@ubiops.com\"         }       },       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.2@ubiops.com\"         }       }     ],   },   {     \"id\": \"7193ca09-d28b-4fce-a15a-11e0bc9f7f6f\",     \"name\": \"notification-group-2\",      \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.3@ubiops.com\"         }       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[NotificationGroupList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.monitoring.notification_groups_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def notification_groups_update(self, project_name, notification_group_name, data, **kwargs):  # noqa: E501
        """Update notification group  # noqa: E501

         ### Description  Update a notification group  ### Optional Parameters  - `name`: New name for the deployment - `contacts`: A list of dictionaries containing the following keys:  - `type`: Type of the contact. It can be `email`.  - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"new-notification-group-name\" } ```  ### Response Structure  Details of the updated notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"new-notification-group-name\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_update(project_name, notification_group_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param NotificationGroupUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NotificationGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.monitoring.notification_groups_update_with_http_info(project_name, notification_group_name, data, **kwargs)  # noqa: E501

    def organization_users_create(self, organization_name, data, **kwargs):  # noqa: E501
        """Add a user to an organization  # noqa: E501

         ### Description Add a user to an organization as admin or normal user. The user making the request must be admin of the organization. The user can later be assigned roles in the projects defined in the scope the organization, such as project-admin, project-viewer etc.  ### Required Parameters - `email`: Email of the user   - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"admin\": false } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_create(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organization_users_create_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organization_users_delete(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Delete a user from an organization  # noqa: E501

         ### Description  Delete a user from an organization. The user making the request must be admin of the organization. It is not possible to delete the last admin of an organization.  **When a user is deleted from an organization, all his roles from all projects defined in the scope of the organization are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_delete(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organization_users_delete_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_get(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Get details of a user in an organization  # noqa: E501

         ### Description  Get the details of a user in an organization. The user making the request must be admin of the organization.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_get(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organization_users_get_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_list(self, organization_name, **kwargs):  # noqa: E501
        """List the users in an organization  # noqa: E501

         ### Description  List users and their details in an organization  ### Response Structure  List of details of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": true   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_list(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationUserDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organization_users_list_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_users_update(self, organization_name, user_id, data, **kwargs):  # noqa: E501
        """Update details of a user in an organization  # noqa: E501

         ### Description  Update the admin status of a user in an organization. The user making the request must be admin of the organization. It is not possible to change the last admin of an organization to a regular user.  ### Required Parameters - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"admin\": true } ```  ### Response Structure Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_update(organization_name, user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param OrganizationUserUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organization_users_update_with_http_info(organization_name, user_id, data, **kwargs)  # noqa: E501

    def organizations_create(self, data, **kwargs):  # noqa: E501
        """Create organizations  # noqa: E501

         ### Description  Create a new organization. When a user creates an organization, s/he will automatically become an organization admin.  ### Required Parameters  - `name`: Name of the organization. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `subscription`: Name of the subscription for the organization  ### Optional Parameters  - `subscription_end_date`: End date of the subscription. The subscription will be cancelled on this date. A 'free' subscription cannot have a custom end_date as this subscription is always valid for a year. If you are going to use a subscription other than the free subscription, you should provide the end date.  #### Request Examples  ``` {   \"name\": \"test-organization\",   \"subscription\": \"premium\",   \"subscription_end_date\": \"2021-03-25\" } ```  ``` {   \"name\": \"test-organization\",   \"subscription\": \"premium\",   \"subscription_end_date\": \"2021-03-25\" } ```  ### Response Structure  Details of the created organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organizations_create_with_http_info(data, **kwargs)  # noqa: E501

    def organizations_get(self, organization_name, **kwargs):  # noqa: E501
        """Get details of an organization  # noqa: E501

         ### Description  Get the details of an organization  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription of the organization   - `subscription_self_service`: Boolean indicating if the organization subscription is self service    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\",   \"subscription_self_service\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organizations_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_list(self, **kwargs):  # noqa: E501
        """List organizations  # noqa: E501

         ### Description  List all organizations where the user making the request is a member  ### Response Structure A list of details of the organizations - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples ``` [   {     \"id\": \"45a1f903-4146-4f15-be4a-302455cd6f7e\",     \"name\": \"organization-name\",     \"creation_date\": \"2020-03-23T11:47:15.436240Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organizations_list_with_http_info(**kwargs)  # noqa: E501

    def organizations_resource_usage(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  List the total number of resources used by this organization  ### Response Structure A list containing the number of - projects   - users   - deployments   - deployment_versions   - pipelines   - pipeline_versions   currently used by the organization.  #### Response Examples ``` {   \"projects\": 5,   \"users\": 3,   \"deployments\": 30,   \"deployment_versions\": 47,   \"pipelines\": 2,   \"pipeline_versions\": 4 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_resource_usage(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organizations_resource_usage_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_update(self, organization_name, data, **kwargs):  # noqa: E501
        """Update details of an organization  # noqa: E501

         ### Description  Update an organization. The user making the request must be admin of the organization. Users are able to update the name of the organization, but changes to the subscription can only be done by Dutch Analytics. To delete the end date of the current subscription, give the 'subscription_end_date' parameter with value null.  ### Optional Parameters  - `name`: New organization name - `subscription`: New subscription - `subscription_end_date`: End date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will be cancelled on this date. If you are going to update the subscription plan of the organization to a subscription other than free, you have to provide the end date. - `subscription_start_date`: Start date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will start from the provided date. If you are going to update the subscription of the organization or schedule a subscription for a time in future, you have to provide the start date.  #### Request Examples   ``` {   \"name\": \"new-organization-name\" } ``` ``` {   \"subscription\": \"premium\",   \"subscription_end_date\": \"2020-08-30\",   \"subscription_start_date\": \"2020-07-30\" } ``` ``` {   \"subscription_end_date\": \"2020-08-30\",   \"subscription_start_date\": \"2020-07-30\" } ```  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_update(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organizations_update_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organizations_usage_get(self, organization_name, **kwargs):  # noqa: E501
        """Get organization usage  # noqa: E501

         ### Description  Get resource usage for the organization. It contains **the details of each metric aggregated per month.**   ### Optional Parameters  - `start_date`: date indicating the start date to fetch usage data from. If omitted, results are generated for current subscription period. - `end_date`: date indicating the end date to fetch usage data until. If omitted, results are generated for current subscription period. - `interval`: interval for which the usage data is fetched. It can be 'day' or 'month'. It defaults to 'month'.  If no **start_date** or **end_date** is given, the current subscription period is used, e.g. if the usage details are requested on 01-12-2020 and the subscription started on 20-11-2020, the results will contain data from 20-11-2020 to 20-12-2020. When **start_date** and **end_date** are given, this month period is used, e.g. if 12-11-2020 is given as start date and 12-12-2020 as end date, the results will contain data from 12-11-2020 to 12-12-2020.  ### Response Structure - `metric`: Metric name - `object_type`: Type of object the metric was measured for (deployment_version or pipeline_version) - `usage`: an array of objects each containing the following:   - `start_date`: Timestamp denoting the start of the current subscription period or the provided date   - `end_date`: Timestamp denoting the end of the current subscription period or the provided date   - `value`: Aggregated metric value for the given unit over the given month   #### Response Examples 2019-08-01 as start date and 2019-09-01 as end date ``` [   {     \"object_type\": \"deployment_version\",     \"metric\": \"credits\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1484124       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1204       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1598       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 1840       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 400       }       ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_usage_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param datetime start_date:
        :param datetime end_date:
        :param str interval:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Usage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations.organizations_usage_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def batch_pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a batch pipeline request  # noqa: E501

         ### Description Make a batch request to the default version of a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_version_requests_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create a batch pipeline version request  # noqa: E501

         ### Description Make a batch request to a pipeline version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline version request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). The deployment request timeouts default to 14400 seconds for deployments in the pipeline. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch pipeline requests ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch pipeline requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request, which can be used to collect the result  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request is made  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_version_requests_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestBatchCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.batch_pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_requests_batch_delete(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple pipeline requests  # noqa: E501

         ### Description Delete multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_delete(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_batch_get(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple pipeline requests  # noqa: E501

         ### Description Retrieve multiple pipeline requests for the default version of a pipeline. If one of the given pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `deployment_requests`: A list of requests to the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `operator_requests`: A list of requests of the operators in the pipeline. With the operator request ids provided in this list, it's possible to collect the results of the operator requests separately.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\",         \"sequence_id\": \"16699092560130860\",         \"success\": true,         \"error_message\": null       }     ],     \"operator_requests\": [       {         \"id\": \"bd6d6ce5-ba9d-4c91-af61-0cf16f1f5452\",         \"pipeline_object\": \"function-1\",         \"operator\": \"function\",         \"sequence_id\": \"16699092560130861\",         \"success\": true,         \"error_message\": null       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"5fa86ad1-7949-48f5-8e2c-210cce78f427\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_batch_get(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create a pipeline request  # noqa: E501

         ### Description  Make a direct request to the default version of a pipeline. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 (2 hours) and the default value is 3600 (1 hour). - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300  (5 minutes).   #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` example-plain-data ```  ### Response Structure  - `id`: Unique identifier for the pipeline request - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `success`: A boolean value that indicates whether the pipeline request was successful - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `deployment`: Name of the deployment the request was made to     - `version`: Name of the version the request was made to     - `success`: A boolean value that indicates whether the deployment request was successful     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  #### Response Examples ``` {   \"id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"success\": false,   \"error_message\": \"Error while processing a deployment request\",   \"deployment_requests\": [     {       \"id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"sequence_id\": \"16699092560130860\",       \"success\": true,       \"error_message\": null     },     {       \"id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"sequence_id\": \"16699092560130861\",       \"success\": false,       \"error_message\": \"Invalid message format\"      }   ],   \"operator_requests\": [     {       \"id\": \"bd6d6ce5-ba9d-4c91-af61-0cf16f1f5452\",       \"pipeline_object\": \"function-1\",       \"operator\": \"function\",       \"sequence_id\": \"16699092560130860\",       \"success\": true,       \"error_message\": null     }   ],   \"result\": {     \"output_field\": 23.5   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_delete(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Delete a pipeline request  # noqa: E501

         ### Description Delete a request for the default version of a pipeline. This action deletes all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_delete(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_requests_delete_with_http_info(project_name, pipeline_name, request_id, **kwargs)  # noqa: E501

    def pipeline_requests_get(self, project_name, pipeline_name, request_id, **kwargs):  # noqa: E501
        """Get a pipeline request  # noqa: E501

         ### Description Get a request for the default version of a pipeline. With this method, the result of the request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `operator_requests`: A list of requests of the operators in the pipeline. With the operator request ids provided in this list, it's possible to collect the results of the operator requests separately.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the pipeline (and version) names if the request is directly made to the pipeline    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [     {       \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",       \"pipeline_object\": \"deployment-1-v1-object\",       \"deployment\": \"deployment-1\",       \"version\": \"v1\",       \"sequence_id\": \"16699092560130860\",       \"success\": true,       \"error_message\": null     }   ],   \"operator_requests\": [     {       \"id\": \"bd6d6ce5-ba9d-4c91-af61-0cf16f1f5452\",       \"pipeline_object\": \"function-1\",       \"operator\": \"function\",       \"sequence_id\": \"16699092560130861\",       \"success\": true,       \"error_message\": null     }   ],   \"result\": {     \"output_field\": 23.5   },   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"pipeline\": \"pipeline-1\",     \"pipeline\"_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_get(project_name, pipeline_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_requests_get_with_http_info(project_name, pipeline_name, request_id, **kwargs)  # noqa: E501

    def pipeline_requests_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline requests  # noqa: E501

         ### Description List all requests for the default version of a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_requests_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_version_object_requests_get(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Get an operator request  # noqa: E501

         ### Description Get a request for an operator object of a version of a pipeline. With this method, the result of the request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the operator request with the following fields:  - `id`: Unique identifier for the pipeline version object request  - `pipeline_request_id`: Unique identifier for the pipeline request to which the object request belongs  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `object`: Name of the pipeline version object for which the request was made  - `operator`: Name of the pipeline operator for which the request was made  - `status`: Status of the request. Can be 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the request was successful  - `time_created`: Server time that the request was made  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Request result value. NULL if the request failed.  - `error_message`: An error message explaining why the request has failed  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline_request_id\": \"ce488fed-04c2-4ce5-a839-f6e5580ad40f\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"object\": \"function-1\",   \"operator\": \"function\",   \"status\": \"completed\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"result\": {     \"output\": 23.5   },   \"error_message\": \"\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_requests_get(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OperatorRequestDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_version_object_requests_get_with_http_info(project_name, pipeline_name, request_id, version, **kwargs)  # noqa: E501

    def pipeline_version_requests_batch_delete(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple pipeline version requests  # noqa: E501

         ### Description Delete multiple requests for a pipeline version. If one of the given pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_batch_delete(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_version_requests_batch_delete_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_requests_batch_get(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple pipeline version requests  # noqa: E501

         ### Description Retrieve multiple requests for a pipeline version. If one of the given pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline version requests can be retrieved with this method. The pipeline version requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids of the requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `deployment_requests`: A list of requests to the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   },   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-063-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input_field\": 23.5     },     \"deployment_requests\": [       {         \"id\": \"5fa86ad1-7949-48f5-8e2c-210cce78f427\",         \"pipeline_object\": \"deployment-1-v1-object\",         \"deployment\": \"deployment-1\",         \"version\": \"v1\"       }     ],     \"result\": {       \"output_field\": 23.5     },     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_batch_get(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_version_requests_batch_get_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_requests_create(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Create a pipeline version request  # noqa: E501

         ### Description  Make a direct request to a pipeline version. This method returns all the results of the deployment requests made within the pipeline version.  ### Required Parameters  The input for the request. In case of a structured pipeline, this is a dictionary which contains the input fields of the pipeline as keys. In case of a plain pipeline, give a string or list of strings.  ### Optional Parameters The following parameters should be given as query parameters:  - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 (2 hours) and the default value is 3600 (1 hour). - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).   #### Request Examples A structured pipeline request ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  A plain pipeline request ``` example-plain-data ```  ### Response Structure  - `id`: Unique identifier for the pipeline request - `pipeline`: Name of the pipeline for which the request is made - `version`: Name of the pipeline version for which the request is made - `success`: A boolean value that indicates whether the pipeline request was successful - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `deployment`: Name of the deployment the request was made to     - `version`: Name of the version the request was made to     - `success`: A boolean value that indicates whether the deployment request was successful     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  #### Response Examples ``` {   \"id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"success\": false,   \"error_message\": \"Error while processing a deployment request\",   \"deployment_requests\": [     {       \"id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"error_message\": null     },     {       \"id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"error_message\": \"Invalid message format\"     }   ],   \"result\": {     \"output_field\": 23.5   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_create(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_version_requests_create_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipeline_version_requests_delete(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Delete a pipeline version request  # noqa: E501

         ### Description Delete a request for a pipeline version. This action deletes all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_delete(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_version_requests_delete_with_http_info(project_name, pipeline_name, request_id, version, **kwargs)  # noqa: E501

    def pipeline_version_requests_get(self, project_name, pipeline_name, request_id, version, **kwargs):  # noqa: E501
        """Get a pipeline version request  # noqa: E501

         ### Description Get a request for a pipeline version. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the pipeline version request with the following fields:  - `id`: Unique identifier for the pipeline version request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline version request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary (structured input type) or string (plain input type) containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. With the deployment request ids provided in this list, it's possible to collect the results of the deployment requests separately.  - `result`: A dictionary (structured output type) or string (plain output type) containing the data connected to the pipeline end  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [     {       \"id\": \"4b9c8a81-b3ef-437a-8d35-187490eda3e4\",       \"pipeline_object\": \"deployment-1-v1-object\",       \"deployment\": \"deployment-1\",       \"version\": \"v1\"     }   ],   \"result\": {     \"output_field\": 23.5   },   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_get(project_name, pipeline_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_version_requests_get_with_http_info(project_name, pipeline_name, request_id, version, **kwargs)  # noqa: E501

    def pipeline_version_requests_list(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline version requests  # noqa: E501

         ### Description List all requests for a pipeline version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline version request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the pipeline version requests with the following fields:  - `id`: Unique identifier for the pipeline version request  - `pipeline`: Name of the pipeline for which the request is made  - `version`: Name of the pipeline version for which the request was made  - `status`: Status of the request  - `success`: A boolean value that indicates whether the pipeline version request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_requests_list(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests.pipeline_version_requests_list_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def expressions_evaluate(self, data, **kwargs):  # noqa: E501
        """Evaluate expression  # noqa: E501

         ### Description Evaluate a pipeline version operator expression.  ### Required Parameters  - `expression`: The expression to evaluate. - `input_fields`: A list of input fields with name, data_type. - `request_data`: Data to test the expression with. All its keys must be defined in 'input_fields'.  #### Request Examples ``` {   \"expression\": \"var1 + 10\",   \"input_fields\": [     {       \"name\": \"var1\",       \"data_type\": \"int\"     }   ],   \"request_data\": {     \"var1\": 123   } } ```  ### Response Structure - `result`: The result of the expression  #### Response Examples ``` {   \"result\": 133 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.expressions_evaluate(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ExpressionEvaluate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExpressionEvaluateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.expressions_evaluate_with_http_info(data, **kwargs)  # noqa: E501

    def pipeline_audit_events_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 in version v1 of pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object in version v1 of pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_version_object_environment_variables_list(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline version  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_environment_variables_list(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipeline_version_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_versions_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create pipeline versions  # noqa: E501

         ### Description  Create a version for a pipeline. The first version of a pipeline is set as default. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Required Parameters  - `version`: Name of the version of the pipeline  ### Optional Parameters - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version. It defaults to 604800 seconds (1 week). - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Request Examples  ``` {   \"version\": \"v1\" } ```  ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": \"notification-group-1\",   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```  A pipeline version with objects and attachments ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\"     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```  ### Response Structure  Details of the created pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following: *none*, *metadata* or *full*. - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [],   \"attachments\": [] } ```  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"id\": \"38549ff5-5bf0-4803-8571-236077c77e62\",       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\",       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"configuration\": {},       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"int\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"int\"         }       ]     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineVersionCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipeline_versions_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_versions_delete(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete pipeline version  # noqa: E501

         ### Description  Delete a pipeline version. This will also delete all objects and attachments in the pipeline version.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_delete(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipeline_versions_delete_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_versions_get(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Get pipeline version  # noqa: E501

         ### Description  Get the details of a single pipeline version  ### Response Structure  Details of the pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [],   \"attachments\": [] } ```  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"id\": \"38549ff5-5bf0-4803-8571-236077c77e62\",       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\",       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"configuration\": {},       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"int\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"int\"         }       ]     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_get(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipeline_versions_get_with_http_info(project_name, pipeline_name, version, **kwargs)  # noqa: E501

    def pipeline_versions_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline versions  # noqa: E501

         ### Description  Pipeline versions can be filtered according to the labels they have by giving labels as a query parameter. Pipeline versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions of the pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored   #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-1\",     \"default_notification_group\": null,     \"request_retention_time\": 604800,     \"request_retention_mode\": \"full\"   },   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-2\",     \"default_notification_group\": \"notification-group-2\",     \"request_retention_time\": 86400,     \"request_retention_mode\": \"metadata\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineVersionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipeline_versions_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_versions_update(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Update pipeline version  # noqa: E501

         ### Description  Update a pipeline version. When updating labels, the labels will replace the existing value for labels.  Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  **Attention:** *In case either the `objects` or `attachments` parameter is null or an empty list, all of the objects or attachments of the pipeline will be removed.*  ### Optional Parameters - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Request Examples  ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": \"notification-group-1\" } ```  Updating a pipeline version with new objects and attachments ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\"     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```  Updating a pipeline version by removing objects and attachments ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": [\"test@example.com\"],   \"objects\": null,   \"attachments\": null } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following: *none*, *metadata* or *full*. - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [],   \"attachments\": [] } ```  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"id\": \"38549ff5-5bf0-4803-8571-236077c77e62\",       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\",       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"configuration\": {},       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"int\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"int\"         }       ]     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_update(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineVersionDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipeline_versions_update_with_http_info(project_name, pipeline_name, version, data, **kwargs)  # noqa: E501

    def pipelines_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create pipelines  # noqa: E501

         ### Description  Create a pipeline in a project.   The input_fields represent the fields that the input data for pipeline requests should contain. When an object is attached to the pipeline, it means that the input data will be forwarded to these objects.  ### Required Parameters  - `name`: Name of the pipeline. It is unique within a project. - `input_type`: Type of the pipeline input. It can be either structured or plain. - `input_fields`: A list of input fields with name, data_type and (optional) widget. In case of plain pipelines, the input_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty. - `output_type`: Type of the pipeline output. It can be either structured or plain. - `output_fields`: A list of output fields with name, data_type and (optional) widget. In case of plain pipelines, the output_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty.  ### Optional Parameters - `description`: Description of the pipeline - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A structured pipeline ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ],   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ] } ```  A plain pipeline ``` {   \"name\": \"pipeline-2\",   \"input_type\": \"plain\",   \"output_type\": \"plain\",   \"description\": \"my description\" } ```  A structured pipeline with input/output field widgets ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\",       \"widget\": {         \"type\": \"slider\",         \"configuration\": {\"min\": 0, \"max\": 10, \"default\": 4, \"step\": 2}       }     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"numberbox\",         \"configuration\": {\"min\": 0, \"max\": 1, \"default\": 0.5, \"step\": 0.1}       }     }   ],   \"output_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     }   ] } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description`: Description of the pipeline - `project`: Project name in which the pipeline is created - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name, data_type and widget - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name, data_type and widget - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"name\": \"pipeline-1\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-03-24T09:43:51.791253Z\" } ```  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"output_type\": \"plain\",   \"output_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param PipelineCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipelines_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def pipelines_delete(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Delete a pipeline  # noqa: E501

         ### Description  Delete a pipeline. This will also delete all versions of the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_delete(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipelines_delete_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipelines_get(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Get details of a pipeline  # noqa: E501

         ### Description  Get the details of a single pipeline  ### Response Structure  Details of the pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description` Description of the pipeline - `project`: Project name in which the pipeline is defined - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name, data_type and widget - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name, data_type and widget - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"output_type\": \"plain\",   \"output_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_get(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipelines_get_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipelines_list(self, project_name, **kwargs):  # noqa: E501
        """List pipelines  # noqa: E501

         ### Description  Pipelines can be filtered according to the labels they have by giving labels as a query parameter. Pipelines that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the pipelines in the project - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description of the pipeline - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name and data_type - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"name\": \"pipeline-1\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"output_type\": \"structured\",     \"output_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",     \"name\": \"pipeline-2\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"plain\",     \"input_fields\": [],     \"output_type\": \"plain\",     \"output_fields\": [],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipelines_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def pipelines_update(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update a pipeline  # noqa: E501

         ### Description  Update a pipeline. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the pipeline - `description`: New description for the pipeline - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `input_type`: New type for the pipeline input. It is possible to change the type from plain to structured and vice versa. - `input_fields`: New input fields for the pipeline - `output_type`: New type for the pipeline output. It is possible to change the type from plain to structured and vice versa. - `output_fields`: New output fields for the pipeline - `default_version`: Name of a version of this pipeline which will be assigned as default  If the input type of pipeline is updated to plain, the input fields are deleted. In this case, input_fields should either be omitted or provided as en empty list. If the input type of pipeline is updated to structured, the old input fields are deleted, if there existed any. The new fields are created, if any is provided. If one or more old fields need to be kept, they must be provided again. The same goes for updating the pipeline output.  **To delete the input/output fields of a pipeline**, provide an empty list for input_fields/output_fields field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-name\" } ```  ``` {   \"description\": \"New pipeline description\",   \"labels\": {     \"tag\": \"production\"   } } ```  ``` {   \"input_type\": \"plain\" } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ] } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [] } ```  ``` {   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ] } ```  ### Response Structure  Details of the updated pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description for the pipeline - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name, data_type and widget - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name, data_type and widget - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"new-pipeline-name\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ],   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_update(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines.pipelines_update_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def instance_types_list(self, project_name, **kwargs):  # noqa: E501
        """List instance types  # noqa: E501

         ### Description  Get list of available deployment instance types for a project  ### Response Structure  Details of the instance type - `id`: Unique identifier for the instance type (UUID)   - `name`: Name of the deployment instance type   - `display_name`: Readable name of the deployment instance type   - `memory_allocation`: Integer indicating memory allocation for this instance type (Mi)   - `cpu_allocation`: Integer indicating CPU allocation for this instance type (milliCPU)   - `gpu_allocation`: Integer indicating number of GPU cores for this instance type   - `storage_allocation`: Integer indicating the maximum storage that can be used by this instance type (MB)    #### Response Examples  ``` [   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"name\": \"512mb\",     \"display_name\": \"512 MB\",     \"memory_allocation\": 512,     \"cpu_allocation\": 125,     \"gpu_allocation\": 0,     \"storage_allocation\": 2048   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.instance_types_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentInstanceType]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.instance_types_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def metrics_get(self, project_name, metric, start_date, end_date, object_type, **kwargs):  # noqa: E501
        """Get metrics  # noqa: E501

         ### Description  Get metrics for the project or a specified object. The following metrics are available:  Metrics on pipeline version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `request_duration`: Average time in seconds for a pipeline request to complete  - `input_volume`: Volume of incoming data in bytes  - `object_requests`: Number of requests made to objects in the pipeline version  - `object_failed_requests`: Number of failed requests made to deployments in a pipeline  Metrics on deployment version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `output_volume`: Volume of outgoing data in bytes  - `outputs`: Number of outgoing data items   - `compute`: Average time in seconds for a request to complete  - `memory_peak`: Peak memory used during a request  - `instances`: Number of active deployment instances  - `credits`: Usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours the deployments are running  - `active_time`: Time in seconds that the deployment is active  - `express_queue_size`: Average number of queued express requests  - `batch_queue_size`: Average number of queued batch requests  - `express_queue_time`: Average time in seconds for an express request to start processing  - `batch_queue_time`: Average time in seconds for a batch request to start processing  ### Required Parameters  - `start_date`: Starting date for the metric values to be returned. It should be provided in datetime isoformat. - `end_date`: Ending date for the metric values to be returned. It should be provided in datetime isoformat. - `object_type`: The type of the object for which the metrics are requested. It can be either `deployment_version` or `pipeline_version`.  ### Optional Parameters  - `interval`: Interval for the metric value. It can be minute, hour, day or month. The metric values will be aggregated according to this interval. The default value is hour. - `object_id`: Uuid of the specific object for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type`. - `user_id`: Uuid of the user for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type` generated by all users.  ### Response Structure  - `start_date`: Timestamp denoting the start of the period over which the metric was measured - `end_date`: Timestamp denoting the end of the period over which the metric was measured - `value`: Aggregated metric value for the given interval  #### Response Examples With interval as minute, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-13 12:03:00 ``` [   {     \"start_date\": \"2019-11-13T12:00:00+00:00\",     \"end_date\": \"2019-11-13T12:01:00+00:00\",     \"value\": 100   },   {     \"start_date\": \"2019-11-13T12:01:00+00:00\",     \"end_date\": \"2019-11-13T12:02:00+00:00\",     \"value\": 134   },   {     \"start_date\": \"2019-11-13T12:02:00+00:00\",     \"end_date\": \"2019-11-13T12:03:00+00:00\",     \"value\": 112   } ]  ```  With interval as hour, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-13 14:00:00 ``` [   {    \"start_date\": \"2019-11-13T12:00:00+00:00\",    \"end_date\": \"2019-11-13T13:00:00+00:00\",    \"value\": 92   },   {     \"start_date\": \"2019-11-13T13:00:00+00:00\",     \"end_date\": \"2019-11-13T14:00:00+00:00\",     \"value\": 120   },   {     \"start_date\": \"2019-11-13T14:00:00+00:00\",     \"end_date\": \"2019-11-13T15:00:00+00:00\",     \"value\": 0   } ] ```  With interval as day, start_date as 2019-11-13 12:00:00 and end_date as 2019-11-14 12:00:00 ``` [   {    \"start_date\": \"2019-11-13T00:00:00+00:00\",    \"end_date\": \"2019-11-14T00:00:00+00:00\",    \"value\": 528   },   {     \"start_date\": \"2019-11-14T00:00:00+00:00\",     \"end_date\": \"2019-11-15T00:00:00+00:00\",     \"value\": 342   } ] ```  With interval as month, start_date as 2019-11-13 12:00:00 and end_date as 2019-12-13 12:00:00 ``` [   {    \"start_date\": \"2019-11-01T00:00:00+00:00\",    \"end_date\": \"2019-12-01T00:00:00+00:00\",    \"value\": 1983   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metrics_get(project_name, metric, start_date, end_date, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str metric: (required)
        :param str start_date: (required)
        :param str end_date: (required)
        :param str object_type: (required)
        :param str interval:
        :param str object_id:
        :param str user_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Metrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.metrics_get_with_http_info(project_name, metric, start_date, end_date, object_type, **kwargs)  # noqa: E501

    def project_audit_events_list(self, project_name, **kwargs):  # noqa: E501
        """List audit events in a project  # noqa: E501

         ### Description  List all audit events in a project including all objects  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events in the project - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"54c1ea23-5773-4821-8fd7-1b577cc301bc\",     \"date\": \"2020-05-23T11:53:02.873+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created project test-project\",     \"object_type\": \"project\",     \"object_name\": \"test-project\"   },   {     \"id\": \"764e254c-7402-4445-ac79-009d08b21caa\",     \"date\": \"2020-05-23T11:57:20.072+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_audit_events_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_audit_events_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def project_environment_variables_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create project environment variable  # noqa: E501

         ### Description Create an environment variable for the project. This variable will be inherited by all deployments in this project.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"database_schema\",   \"value\": \"public\",   \"secret\": false } ```  ``` {   \"name\": \"database_password\",   \"value\": \"password\",   \"secret\": true } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",   \"name\": \"database_schema\",   \"value\": \"public\",   \"secret\": false } ```  ``` {   \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"database_password\",   \"value\": null,   \"secret\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_environment_variables_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def project_environment_variables_delete(self, project_name, id, **kwargs):  # noqa: E501
        """Delete project environment variable  # noqa: E501

         ### Description Delete an environment variable of the project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_delete(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_environment_variables_delete_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def project_environment_variables_get(self, project_name, id, **kwargs):  # noqa: E501
        """Get project environment variable  # noqa: E501

         ### Description Retrieve details of a project environment variable.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_get(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_environment_variables_get_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def project_environment_variables_list(self, project_name, **kwargs):  # noqa: E501
        """List project environment variables  # noqa: E501

         ### Description List the environment variables defined for the project. These are the variables that are inherited by all deployments in this project.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_environment_variables_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def project_environment_variables_update(self, project_name, id, data, **kwargs):  # noqa: E501
        """Update project environment variable  # noqa: E501

         ### Description Update an environment variable for the projects  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore.  - `value`: The value of the variable as a string. It may be an empty string.  - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).   #### Request Examples ``` {   \"name\": \"database_schema\",   \"value\": \"new+schema\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",   \"name\": \"database_schema\",   \"value\": \"new_schema\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_update(project_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_environment_variables_update_with_http_info(project_name, id, data, **kwargs)  # noqa: E501

    def project_requests_list(self, project_name, object_type, **kwargs):  # noqa: E501
        """List requests in project  # noqa: E501

         ### Description List the deployment/pipeline requests of the given project  ### Required Parameters - `object_type`: The type of the object. It can be either deployment or pipeline.  ### Optional Parameters - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  ### Response Structure A list of dictionaries containing the metadata of the deployment/pipeline requests with the following fields: - `id`: The UUID of the object - `deployment`: Name of the deployment the request was made to (Optional: in case it's a deployment request. Else NULL) - `pipeline`: Name of the pipeline the request was made to (Optional: in case it's a pipeline request. Else NULL) - `version`: Name of the version the request was made to - `status`: Status of the request - `success`: A boolean value that indicates whether the deployment/pipeline request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed   #### Response Examples ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"pipeline\": null,     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": null,     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_requests_list(project_name, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str object_type: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RequestsOverview]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_requests_list_with_http_info(project_name, object_type, **kwargs)  # noqa: E501

    def project_users_create(self, project_name, data, **kwargs):  # noqa: E501
        """Add user to a project  # noqa: E501

         ### Description Add a user to a project. The user making the request must be admin of the organization. The user can later be assigned roles in the project, such as project-admin, project-viewer etc.  ### Required Parameters - `user_id`: UUID of the user    #### Request Examples  ``` {   \"user_id\": \"bd3e25a3-f77a-4cb5-92df-a7e614106e95\" } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_users_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ProjectUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectUserList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_users_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def project_users_delete(self, project_name, user_id, **kwargs):  # noqa: E501
        """Delete user from a project  # noqa: E501

         ### Description  Delete a user from a project. The user making the request must be admin of the organization.  **When a user is deleted from a project, all his roles defined in the scope of the project are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_users_delete(project_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_users_delete_with_http_info(project_name, user_id, **kwargs)  # noqa: E501

    def project_users_get(self, project_name, user_id, **kwargs):  # noqa: E501
        """Get user in a project  # noqa: E501

         ### Description  Get the details of a user in a project. The user making the request must also be a project user.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_users_get(project_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectUserList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_users_get_with_http_info(project_name, user_id, **kwargs)  # noqa: E501

    def project_users_list(self, project_name, **kwargs):  # noqa: E501
        """List users in a project  # noqa: E501

         ### Description  List users and their details in a project. The user making the request must also be a project user.  ### Response Structure  List of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\"   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_users_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str user_type:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ProjectUserList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.project_users_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_create(self, data, **kwargs):  # noqa: E501
        """Create projects  # noqa: E501

         ### Description  Create a new project with the provided name. **Only the organization admins have permission to make this request.** When a new project is created, the current organization admins are assigned project-admin role for the created project.  ### Required Parameters  - `name`: Name of the project. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter. - `organization_name`: Name of the organization in which the project is going to be created  ### Optional Parameters - `advanced_permissions`: A boolean to enable/disable advanced permissions for the project. It defaults to False. - `credits`: Maximum usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours they are running. It defaults to null, meaning that there are no limits.  #### Request Examples ``` {   \"name\": \"project-1\",   \"organization_name\": \"organization-1\" } ```  ### Response Structure  Details of the created project - `id`: Unique identifier for the project (UUID) - `name`: Name of the project - `creation_date`: Time the project was created - `advanced_permissions`: A boolean to enable/disable advanced permissions for the project - `organization_name`: Name of the organization in which the project is created - `credits`: Maximum usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours they are running - `suspended`: A boolean indicating whether the project is suspended due to going over the credits limit - `suspended_reason`: Description explaining why the project is suspended  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"advanced_permissions\": false,   \"organization_name\": \"organization-1\",   \"credits\": null,   \"suspended\": false,   \"suspended_reason\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProjectCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_create_with_http_info(data, **kwargs)  # noqa: E501

    def projects_delete(self, project_name, **kwargs):  # noqa: E501
        """Delete a project  # noqa: E501

         ### Description  Delete a project. The user making the request must have appropriate permissions. **When project is deleted, all the deployments and pipelines defined in it are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_delete(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_delete_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_get(self, project_name, **kwargs):  # noqa: E501
        """Get details of a project  # noqa: E501

         ### Description  Get the details of a single project. The user making the request must have appropriate permissions.  ### Response Structure  Details of a project - `id`: Unique identifier for the project (UUID) - `name`: Name of the project - `creation_date`: Time the project was created - `advanced_permissions`: A boolean to enable/disable advanced permissions for the project - `organization_name`: Name of the organization in which the project is created - `credits`: Maximum usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours they are running - `suspended`: A boolean indicating whether the project is suspended due to going over the credits limit - `suspended_reason`: Description explaining why the project is suspended  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"advanced_permissions\": false,   \"organization_name\": \"organization-1\",   \"credits\": 10000,   \"suspended\": false,   \"suspended_reason\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_get(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_get_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_list(self, **kwargs):  # noqa: E501
        """List projects  # noqa: E501

         ### Description  List all projects to which the user making request has access. The projects in organizations to which the user belongs are shown.  ### Response Structure A list of details of the projects - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `advanced_permissions`: A boolean to enable/disable advanced permissions for the project   - `organization_name`: Name of the organization in which the project is created  ### Optional Parameters These parameters should be given as query parameters - `organization`: Name of the organization whose projects should be obtained  #### Response Examples ``` [   {     \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",     \"name\": \"project-1\",     \"creation_date\": \"2018-10-26\",     \"advanced_permissions\": false,     \"organization_name\": \"organization-1\"   },   {     \"id\": \"e6a85cd7-94cc-44cf-9fa0-4b462d5a71ab\",     \"name\": \"project-2\",     \"creation_date\": \"2019-06-20\",     \"advanced_permissions\": false,     \"organization_name\": \"organization-2\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ProjectList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_list_with_http_info(**kwargs)  # noqa: E501

    def projects_log_list(self, project_name, **kwargs):  # noqa: E501
        """List logs for a project  # noqa: E501

         ### Description  Retrieve the logs of all objects in a project, including deployments, pipelines and requests. Using filters you can filter the logs on the objects and information of your choice.   ### Optional Parameters - `filters`: A dictionary containing information to filter logs on. It may contain zero or more of the following fields:       - `deployment_name`: name of a deployment       - `deployment_version`: name of a deployment version. If this field is present in the request, deployment_name must also be given. The deployment versions are only meaningful in combination with the deployments they are defined for.       - `build_id`: the UUID of a build. It does not have to be given in combination with the version and deployment name.       - `pipeline_name`: name of a pipeline       - `pipeline_version`: name of a pipeline version. If this field is present in the request, pipeline_name must also be given. The pipeline versions are only meaningful in combination with the pipelines they are defined for.       - `pipeline_object_name`: name of a pipeline object. If this field is present in the request, pipeline_name and pipeline_version must also be given. The pipeline objects are only meaningful in combination with the pipeline versions they are defined in.       - `deployment_request_id`: the UUID of a deployment request       - `pipeline_request_id`: the UUID of a pipeline request       - `system`: whether the log was generated by the system or user code (true / false)       - `level`: the level of the log (info / error)    Any combination of filters may be given in the request. For example, if only a deployment_name is provided, all logs for that deployment are returned. These logs can contain information from all the pipelines that deployment is referenced in. If the filters dictionary is empty, all logs for all objects in the project are returned. Either `date` or `id` should be provided, as they both refer to a starting point of the logs. If no `date` or `id` is specified, the API will use the current time as a starting point and try to fetch the logs starting from now minus date range seconds into the past.  - `date`: Starting date for the logs. If it is not provided and the `id` parameter is not set, the most recent logs are returned. It should be provided in ISO 8601 format. The results are inclusive of the given date.   - `id`: identifier for log lines. If specified, it will act as a starting point for the interval in which to query the logs. This can be useful when making multiple queries to obtain consecutive logs      It will include the log having the log id equal to the id value in the response, regardless of whether the date_range is positive or negative. - `limit`: Limit for the logs response. If specified, it will limit the total number of logs returned from the query to the specified number. Defaults to 50, the maximum is 500.   - `date_range`: The date range parameter sets the interval of time in which to query the logs, specified in seconds. It may be a positive or a negative value.       If it is positive, logs starting from the specified date / log id (both inclusive) plus date range seconds towards the present time are returned.       Otherwise, logs starting from the specified date / log id (both inclusive) minus date range seconds towards the past are returned.       The default value is -21600 (6 hours). The maximum value is -/+ 86400 seconds (24 hours).   #### Request Examples  ``` {   \"filters\": {     \"deployment_name\": \"deployment-1\",     \"deployment_version\": \"v1\"   },   \"date\": \"2020-01-01T00:00:00.000000Z\" } ```  ``` {   \"filters\": {     \"pipeline_name\": \"pipeline-1\",     \"pipeline_version\": \"v1\"   },   \"id\": \"41d7a7c5cd025e3501a00000\",   \"date_range\": -100 } ```  ``` {   \"filters\": {     \"pipeline_name\": \"pipeline-1\",     \"pipeline_version\": \"v1\",     \"deployment_name\": \"deployment-1\",     \"deployment_version\": \"v1\"   },   \"date\": \"2020-01-01T00:00:00.000000Z\",   \"date_range\": -86400,   \"limit\": 5 } ```  ### Response Structure  A list of log details - `id`: Unique UUID of the log line   - `log`: Log line text   - `date`: Time the log line was created  The following fields will be returned on response if they are set for the log line: - `deployment_name`:  The deployment which the log is related to   - `deployment_version`:  The deployment version which the log is related to   - `build_id`: The UUID of the build   - `pipeline_name`: The pipeline which the log is related to   - `pipeline_version`: The pipeline version which the log is related to   - `pipeline_object_name`: The pipeline object which the log is related to   - `deployment_request_id`:  The deployment request the log is related to   - `pipeline_request_id`:  The pipeline request the log is related to   - `system`:  Whether the log was generated by the system (true / false)   - `level`: The level of the log (info / error)   #### Response Examples  Logs for a specific deployment and version ``` [   {     \"id\": \"5dcad12ba76a2c6e4331f180\",     \"deployment_name\": \"deployment-1\",     \"deployment_version\": \"v1\",     \"date\": \"2020-01-01T00:00:00.000000Z\",     \"log\": \"[Info] Prediction result 0.14981\"   },   {     \"id\": \"5dcad12ba76a2c6e4331f181\",     \"deployment_name\": \"deployment-1\",     \"deployment_version\": \"v1\",     \"deployment_request_id\": \"ee63f938-ba81-438e-8482-9ac76037895f\",     \"pipeline_name\": \"pipeline-2\",     \"pipeline_version\": \"v2\",     \"pipeline_object_name\": \"deployment-1-v1-object\",     \"pipeline_request_id\": \"8bb6ed79-8606-4acf-acd2-90507130523c\",     \"date\": \"2020-01-01T00:00:01.000000Z\",     \"log\": \"[Error] Deployment call result (failed)\"   } ] ```  Logs for a specific pipeline ``` [   {     \"id\": \"5dcad12ba76a2c6e4331f192\",     \"deployment_name\": \"deployment-2\",     \"deployment_version\": \"v2\",     \"deployment_request_id\": \"6ee941d3-9905-49f5-95b4-cd9c4c23bb03\",     \"pipeline_name\": \"pipeline-1\",     \"pipeline_version\": \"v1\",     \"pipeline_object_name\": \"deployment-2-v2-object\",     \"pipeline_request_id\": \"4f75b10d-6012-47ab-ae68-cc9e69f35841\",     \"date\": \"2020-01-01T00:00:00.000000Z\",     \"log\": \"[Info] Deployment call result (success): 0.2316\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_log_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param LogsCreate data:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Logs]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_log_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_resource_usage(self, project_name, **kwargs):  # noqa: E501
        """List resource usage of a project  # noqa: E501

         ### Description  List the total number of resources used in a project  ### Response Structure A list containing the number of - deployments   - deployment_versions   - pipelines   - pipeline_versions   currently defined in the project.  #### Response Examples ``` {   \"deployments\": 30,   \"deployment_versions\": 47,   \"pipelines\": 2,   \"pipeline_versions\": 4 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_resource_usage(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectResourceUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_resource_usage_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_update(self, project_name, data, **kwargs):  # noqa: E501
        """Update a project  # noqa: E501

         ### Description  Update the name of a single project. The user making the request must have appropriate permissions.  ### Optional Parameters  - `name`: New project name - `advanced_permissions`: A boolean to enable/disable advanced permissions for the project - `credits`: Maximum usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours they are running - `suspend`: A boolean to suspend and activate projects. If the project is already suspended by UbiOps, it is not possible to suspend/activate the project.  #### Request Examples  ``` {   \"name\": \"project-name-example\" } ```  ### Response Structure  Details of a project - `id`: Unique identifier for the project (UUID) - `name`: Name of the project - `creation_date`: Time the project was created - `advanced_permissions`: A boolean to enable/disable advanced permissions for the project - `organization_name`: Name of the organization in which the project is created - `credits`: Maximum usage of credits, calculated by multiplying the credit rate of a deployment instance type by the number of hours they are running - `suspended`: A boolean indicating whether the project is suspended due to going over the credits limit - `suspended_reason`: Description explaining why the project is suspended  #### Response Examples ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"advanced_permissions\": false,   \"organization_name\": \"organization-1\",   \"credits\": 10000,   \"suspended\": false,   \"suspended_reason\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_update(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ProjectUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_update_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def projects_usage_get(self, project_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the project. It contains **the details of each metric aggregated per month.**   ### Optional Parameters  - `start_date`: date indicating the start date to fetch usage data from. If omitted, results are generated for current subscription period. - `end_date`: date indicating the end date to fetch usage data until. If omitted, results are generated for current subscription period. - `interval`: interval for which the usage data is fetched. It can be 'day' or 'month'. It defaults to 'month'.  If no **start_date** or **end_date** is given, the current subscription period is used, e.g. if the usage details are requested on 01-12-2020 and the subscription started on 20-11-2020, the results will contain data from 20-11-2020 to 20-12-2020. When **start_date** and **end_date** are given, this month period is used, e.g. if 12-11-2020 is given as start date and 12-12-2020 as end date, the results will contain data from 12-11-2020 to 12-12-2020.  ### Response Structure - `metric`: Metric name - `object_type`: Type of object the metric was measured for (deployment_version or pipeline_version) - `usage`: an array of objects each containing the following:   - `start_date`: Timestamp denoting the start of the current subscription period or the provided date   - `end_date`: Timestamp denoting the end of the current subscription period or the provided date   - `value`: Aggregated metric value for the given unit over the given month   #### Response Examples 2019-08-01 as start date and 2019-09-01 as end date ``` [   {     \"object_type\": \"deployment_version\",     \"metric\": \"credits\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 13543       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 136       }       ]   },   {     \"object_type\": \"deployment_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 468       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 125       }       ]   },   {     \"object_type\": \"pipeline_version\",     \"metric\": \"output_volume\",     \"usage\": [       {         \"start_date\": \"2019-08-01T00:00:00Z\",         \"end_date\": \"2019-09-01T00:00:00Z\",         \"value\": 135       }       ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_usage_get(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param datetime start_date:
        :param datetime end_date:
        :param str interval:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Usage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.projects_usage_get_with_http_info(project_name, **kwargs)  # noqa: E501

    def quotas_list(self, project_name, **kwargs):  # noqa: E501
        """List quotas  # noqa: E501

         ### Description  List the quotas defined for a project. Project members can see quotas.  ### Response Structure - `resource`: The resource for the quota - `quota`: Limit of how much the resource can be used in the project  #### Response Examples ``` [   {     \"resource\": \"memory_standard\",     \"quota\": 274877906944   },   {     \"resource\": \"cpu_standard\",     \"quota\": 62   },   {     \"resource\": \"gpu_standard\",     \"quota\": 0   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.quotas_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[QuotaDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects.quotas_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def request_schedules_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create request schedules  # noqa: E501

         ### Description Create a new request schedule with the provided name  ### Required Parameters - `name`: Name of the request. The name is unique per project. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter. - `object_type`: Type of object for which the request is made. Can be either 'deployment' or 'pipeline'. - `object_name`: Name of deployment or pipeline for which the request is made - `schedule`: Schedule in crontab format  ### Optional Parameters - `version`: Name of version for which the request schedule is made. If not provided, default version of the deployment/pipeline will be used. - `request_data`: Input data for the request schedule. For structured deployments/pipelines, it must be a dictionary. - `timeout`: Timeout of the request in seconds - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled. Default is 'True'. - `description`: Description of the request schedule - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  ``` {   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"timeout\": 300,   \"enabled\": true,   \"description\": \"Daily request schedule\",   \"labels\": {     \"type\": \"daily\"   } } ```  ### Response Structure Details of the created request schedule - `name`: Name of the request - `object_type`: Type of object for which the request is made - `object_name`: Name of deployment/pipeline for which the request schedule is made - `schedule`: Schedule in crontab format - `version`: Name of version for which the request schedule is made - `request_data`: Input data for the request schedule - `timeout`: Timeout of the request in seconds - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled - `creation_date`: The date when the request schedule was created - `description`: Description of the request schedule - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Response Examples ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"timeout\": 300,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\",   \"description\": \"Daily request schedule\",   \"labels\": {     \"type\": \"daily\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ScheduleCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules.request_schedules_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def request_schedules_delete(self, project_name, schedule_name, **kwargs):  # noqa: E501
        """Delete a request schedule  # noqa: E501

         ### Description Delete the request schedule from the project.  If you want to temporarily disable a request schedule, update the request with `enabled` set to False.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_delete(project_name, schedule_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules.request_schedules_delete_with_http_info(project_name, schedule_name, **kwargs)  # noqa: E501

    def request_schedules_get(self, project_name, schedule_name, **kwargs):  # noqa: E501
        """Get details of a request schedule  # noqa: E501

         ### Description Retrieve details of a single request schedule  ### Response Structure Details of a request schedule - `name`: Name of the request - `object_type`: Type of object for which the request is made - `object_name`: Name of deployment/pipeline for which the request is made - `schedule`: Schedule in crontab format - `version`: Name of version for which the request schedule is made - `request_data`: Input data for the request schedule - `timeout`: Timeout of the request in seconds - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled - `creation_date`: The date when the request schedule was created - `description`: Description of the request schedule - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Response Examples ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"timeout\": 200,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\",   \"description\": \"Daily request schedule\",   \"labels\": {     \"type\": \"daily\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_get(project_name, schedule_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules.request_schedules_get_with_http_info(project_name, schedule_name, **kwargs)  # noqa: E501

    def request_schedules_list(self, project_name, **kwargs):  # noqa: E501
        """List request schedules  # noqa: E501

         ### Description List the request schedules in a project. The user has to have 'requests.list' permission on either 'deployments.versions' or 'pipelines.versions' to list the request schedules.  ### Optional Parameters - `labels`: Filter on labels of the request schedules. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure A list of details of all request schedules in a project - `name`: Name of the request - `object_type`: Type of object for which the request is made - `object_name`: Name of deployment/pipeline for which the request is made - `schedule`: Schedule in crontab format - `version`: Name of version for which the request schedule is made - `request_data`: Input data for the request schedule - `timeout`: Timeout of the request in seconds - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled - `creation_date`: The date when the request schedule was created - `description`: Description of the request schedule - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Response Examples ``` [   {     \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",     \"name\": \"test-request\",     \"object_type\": \"deployment\",     \"object_name\": \"test-deployment\",     \"version\": \"v1\",     \"schedule\": \"0 * 3 * *\",     \"request_data\": {       \"input_field_1\": 2345,       \"input_field_2\": 8765     },     \"timeout\": 200,     \"enabled\": true,     \"creation_date\": \"2020-09-16T08:06:34.457679Z\",     \"description\": \"Daily request schedule\",     \"labels\": {       \"type\": \"daily\"     }   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ScheduleList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules.request_schedules_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def request_schedules_update(self, project_name, schedule_name, data, **kwargs):  # noqa: E501
        """Update a request schedule  # noqa: E501

         ### Description Update a request schedule in a project  ### Optional Parameters - `name`: Name of the request. The name is unique per project. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter. - `schedule`: Schedule in crontab format - `request_data`: Input data for the request schedule. For structured deployments/pipelines, it must be a dictionary. - `timeout`: Timeout of the request in seconds - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled. Default is 'True'. - `description`: Description of the request schedule - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples ``` {   \"name\": \"test-request\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"timeout\": 360,   \"enabled\": false } ```  ### Response Structure Details of the updated request schedule - `name`: Name of the request - `object_type`: Type of object for which the request is made - `object_name`: Name of deployment/pipeline for which the request is made - `schedule`: Schedule in crontab format - `version`: Name of version for which the request schedule is made - `request_data`: Input data for the request schedule - `timeout`: Timeout of the request in seconds - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled - `creation_date`: The date when the request schedule was created - `description`: Description of the request schedule - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Response Examples ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"timeout\": 360,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\",   \"description\": \"Daily request schedule\",   \"labels\": {     \"type\": \"daily\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_update(project_name, schedule_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param ScheduleUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules.request_schedules_update_with_http_info(project_name, schedule_name, data, **kwargs)  # noqa: E501

    def permissions_list(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PermissionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.permissions_list_with_http_info(**kwargs)  # noqa: E501

    def role_assignments_create(self, project_name, data, **kwargs):  # noqa: E501
        """Assign role to user/object  # noqa: E501

         ### Description  Assign a role to a user or an object in the scope of a project. This role can be assigned on either project level or on object level, which can be a deployment, pipeline or bucket.  ### Required Parameters  - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role to be assigned to the user   - `assignee`: UUID of the user or the name of the object for which the role will be assigned   - `assignee_type`: Type of the assignee. It can be user or deployment. - `resource`: Name of the object for which the role will be assigned   - `resource_type`: Type of the object for which the role will be assigned. It can be project, deployment, pipeline or bucket.  **resource and resource_type must be provided together. If neither of them is provided, the role is set on project level.**  #### Request Examples Setting the role deployment-admin on project level for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-admin\" } ```  Setting the role deployment-viewer on deployment-1 for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-viewer\",   \"resource\": \"deployment-1\",   \"resource_type\": \"deployment\" } ```  Setting the role files-reader on bucket-1 for deployment-1 ``` {   \"assignee\": \"deployment-1\",   \"assignee_type\": \"deployment\",   \"role\": \"file-reader\",   \"resource\": \"bucket-1\",   \"resource_type\": \"bucket\" } ```  ### Response Structure  Details of the created role assignment - `id`: Unique identifier for the role assignment (UUID) - `assignee`: UUID of the user or the name of the object - `assignee_type`: Type of the assignee - `role`: Name of the role assigned to the user - `resource`: Name of the object for which the role is assigned - `resource_type`: Type of the object for which the role is assigned  #### Response Examples ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-admin\",   \"resource\": \"project-1\",   \"resource_type\": \"project\" } ```  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"assignee\": \"deployment-1\",   \"assignee_type\": \"deployment\",   \"role\": \"file-reader\",   \"resource\": \"bucket-1\",   \"resource_type\": \"bucket\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleAssignmentCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleAssignmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.role_assignments_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def role_assignments_delete(self, project_name, id, **kwargs):  # noqa: E501
        """Delete role of user  # noqa: E501

         ### Description  Delete a role of a user.  It is possible for a user to delete their own role if they have permissions to do so.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_delete(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.role_assignments_delete_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def role_assignments_get(self, project_name, id, **kwargs):  # noqa: E501
        """Get role assignment  # noqa: E501

         ### Description  Get the details of a role assignment of a user/deployment.  ### Response Structure Details of the role assignment - `id`: Unique identifier for the role assignment (UUID) - `assignee`: UUID of the user or the name of the object - `assignee_type`: Type of the assignee - `role`: Name of the role assigned to the user/object - `resource`: Name of the object for which the role is assigned - `resource_type`: Type of the object for which the role is assigned  #### Response Examples ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-admin\",   \"resource\": \"project-1\",   \"resource_type\": \"project\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_get(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleAssignmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.role_assignments_get_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def role_assignments_per_object_list(self, project_name, **kwargs):  # noqa: E501
        """List roles on object/user  # noqa: E501

         ### Description  List the roles assigned to a user or on an object in the scope of a project.   ### Optional Parameters These parameters should be given as query parameters - `resource`: Name of the object on which the assigned roles will be listed - `resource_type`: Type of the object on which the assigned roles will be listed - `assignee`: UUID of the user or the name of the object for which the assigned roles will be listed - `assignee_type`: Type of the assignee for which the assigned roles will be listed  ### Response Structure - `id`: Unique identifier for the role assignment (UUID) - `assignee`: UUID of the user or the name of the object - `assignee_type`: Type of the assignee - `role`: Name of the role assigned to the user/object - `resource`: Name of the object for which the role is assigned - `resource_type`: Type of the object for which the role is assigned  #### Response Examples Roles assigned to user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` [   {     \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",     \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"assignee_type\": \"user\",     \"role\": \"deployment-admin\",     \"resource\": \"project-1\",     \"resource_type\": \"project\"   },   {     \"id\": \"13cf9dd7-7356-4797-b453-e0cb6b416162\",     \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"assignee_type\": \"user\",     \"role\": \"pipeline-admin\",     \"resource\": \"pipeline-1\",     \"resource_type\": \"pipeline\"   } ] ```  Roles assigned on deployment with name deployment-1 ``` [   {     \"id\": \"a24aabc2-c7df-4f7b-b177-f80827aea1bb\",     \"assignee\": \"258771bb-1bc4-4f2f-a3f4-9309cc64d1dd\",     \"assignee_type\": \"user\",     \"role\": \"deployment-admin\",     \"resource\": \"deployment-1\",     \"resource_type\": \"deployment\"   },   {     \"id\": \"dfd4e714-9c2d-446e-ae96-4db18f91d3de\",     \"assignee\": \"0ca8a61d-962e-48e3-b558-61e8ca2dae88\",     \"assignee_type\": \"user\",     \"role\": \"deployment-viewer\",     \"resource\": \"deployment-1\",     \"resource_type\": \"deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_per_object_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str resource:
        :param str resource_type:
        :param str assignee:
        :param str assignee_type:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RoleAssignmentList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.role_assignments_per_object_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def roles_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create a custom role scoped in a project  # noqa: E501

         ### Description  Create a custom role in the scope of a project. This role is not accessible from other projects.  The user making the request must have appropriate permissions.  ### Required Parameters  - `name`: Name of the role which will be created. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A list of permissions which the role will contain. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"custom-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```  ### Response Structure  Details of the created role - `id`: Unique identifier for the created role (UUID)   - `name`: Name of the created role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleDetailList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.roles_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def roles_delete(self, project_name, role_name, **kwargs):  # noqa: E501
        """Delete a role from a project  # noqa: E501

         ### Description  Delete a role from a project. The user making the request must have appropriate permissions. **Default roles cannot be deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_delete(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.roles_delete_with_http_info(project_name, role_name, **kwargs)  # noqa: E501

    def roles_get(self, project_name, role_name, **kwargs):  # noqa: E501
        """Get details of a role  # noqa: E501

         ### Description  Get the details of a role. The user making the request must have appropriate permissions.  ### Response Structure Details of the role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_get(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleDetailList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.roles_get_with_http_info(project_name, role_name, **kwargs)  # noqa: E501

    def roles_list(self, project_name, **kwargs):  # noqa: E501
        """List the available roles in a project  # noqa: E501

         ### Description  List the roles available in the scope of a project. Information on which permissions each role contains, can be obtained with a call to get details of a single role.  ### Response Structure - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not    #### Response Examples ``` [   {     \"id\": \"34e53855-9b50-47bc-b516-6cb971b1949c\",     \"name\": \"project-admin\",     \"default\": true   },   {     \"id\": \"00132911-b5dd-4017-b399-85f3ffd2a7c3\",     \"name\": \"project-editor\",     \"default\": true   },   {     \"id\": \"bf0d5823-8062-40f6-bbd2-21bc732f3c3b\",     \"name\": \"project-viewer\",     \"default\": true   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RoleList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.roles_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def roles_update(self, project_name, role_name, data, **kwargs):  # noqa: E501
        """Update a role in a project  # noqa: E501

         ### Description  Update a role in a project. The user making the request must have appropriate permissions. **Default roles cannot be updated.**  ### Optional Parameters  - `name`: New name for the role. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A new list of permissions which the role will contain. The previous permissions will be replaced with the given ones. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"new-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```  ### Response Structure  Details of the updated role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the updated role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"new-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_update(project_name, role_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param RoleUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleDetailList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles.roles_update_with_http_info(project_name, role_name, data, **kwargs)  # noqa: E501

    def service_users_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create a new service user  # noqa: E501

         ### Description  Create a new service user. A unique email is generated for the service user. Additionally, a token for this service user is generated. This token can be used to authorize requests sent to our API. It is possible to set an expiry date for this token. In addition, allowed cors origins can be configured for the service user. The service user will be allowed to make a deployment or pipeline request from these origins.   The token is **ONLY** returned on creation and will not be accessible afterwards.  ### Optional Parameters - `name`: Name of the service user   - `allowed_cors_origins`: List of origin url's of which the service user is allowed to make a request from   - `expiry_date`: Date when the service user account expires (UTC). If null is passed, the account will never expire.    #### Request Examples  ``` {   \"name\": \"service-user-1\" } ```  ``` {   \"name\": \"service-user-1\",   \"allowed_cors_origins\": [     \"https://test.com\"   ] } ```  ``` {   \"name\": \"service-user-1\",   \"expiry_date\": \"2020-01-01T00:00:00.000Z\" } ```  ### Response Structure  Details of the created service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `token`: The API token for the created service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created   - `allowed_cors_origins`: List of origin url's of which the service user is allowed to make a request from   - `expiry_date`: Date when the service user account will expire (UTC)    #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"token\": \"e962d9190348af7fa8d233d75cff7385b4335f81\",   \"name\": \"service-user-1\",   \"creation_date\": \"2020-03-24T09:16:27.504+00:00\",   \"allowed_cors_origins\": [     \"https://test.com\"   ],   \"expiry_date\": \"2021-03-24T00:00:00.000+00:00\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ServiceUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserTokenDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users.service_users_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def service_users_delete(self, project_name, service_user_id, **kwargs):  # noqa: E501
        """Delete service user  # noqa: E501

         ### Description  Delete a service user from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_delete(project_name, service_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users.service_users_delete_with_http_info(project_name, service_user_id, **kwargs)  # noqa: E501

    def service_users_get(self, project_name, service_user_id, **kwargs):  # noqa: E501
        """Retrieve details of a service user  # noqa: E501

         ### Description  Retrieve details of a service user  ### Response Structure  Details of the service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created   - `allowed_cors_origins`: List of origin url's of which the service user is allowed to make a request from   - `expiry_date`: Date when the service user account will expire (UTC)    #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"name\": \"new-service-user-name\",   \"creation_date\": \"2020-03-26T12:18:43.123+00:00\",   \"allowed_cors_origins\": [     \"https://test.com\"   ],   \"expiry_date\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_get(project_name, service_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users.service_users_get_with_http_info(project_name, service_user_id, **kwargs)  # noqa: E501

    def service_users_list(self, project_name, **kwargs):  # noqa: E501
        """List service users  # noqa: E501

         ### Description  List service users defined in a project  ### Response Structure  List of details of the service users: - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user   - `name`: Name of the service user   - `creation_date`: Date when the service user was created   - `allowed_cors_origins`: List of origin url's of which the service user is allowed to make a request from   - `expiry_date`: Date when the service user account will expire (UTC)    #### Response Examples  ``` [   {     \"id\": \"537bca64-5ab6-43eb-a7ef-1638bc30b6ed\",     \"email\": \"537bca64-5ab6-43eb-a7ef-1638bc30b6ed.project1@serviceuser.ubiops.com\",     \"name\": \"service-user-1\",     \"creation_date\": \"2020-03-24T09:16:27.504+00:00\",     \"allowed_cors_origins\": [       \"https://test.com\"     ],     \"expiry_date\": \"2021-03-24T00:00:00.000+00:00\"   },   {     \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",     \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",     \"name\": \"service-user-2\",     \"creation_date\": \"2020-03-26T12:18:43.123+00:00\",     \"allowed_cors_origins\": [       \"https://test.com\"     ],     \"expiry_date\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ServiceUserList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users.service_users_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def service_users_token(self, project_name, service_user_id, **kwargs):  # noqa: E501
        """Reset the token of a service user  # noqa: E501

         ### Description  Reset the token of a service user. The old token will be deleted and a new one will be created for the service user. No data should be sent in the body of the request.  It is not possible to reset the token of a service user whose expiry date has been reached.  ### Response Structure  Details of the new token for the service user - `token`: The new API token for the service user  #### Response Examples ``` {   \"token\": \"e962d9190348af7fa8d233d75cff7385b4335f81\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_token(project_name, service_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param object data:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserTokenList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users.service_users_token_with_http_info(project_name, service_user_id, **kwargs)  # noqa: E501

    def service_users_update(self, project_name, service_user_id, data, **kwargs):  # noqa: E501
        """Update service user details  # noqa: E501

         ### Description Update the name, expiry date and cors allowed origins of a service user. The new value for the cors_allowed_origin will replace the old value. Leave as an empty list to remove the previous list of allowed origins.  It is not possible to update a service user whose expiry date has been reached.  ### Optional Parameters - `name`: Name of the service user   - `allowed_cors_origins`: List of origin url's of which the service user is allowed to make a request from   - `expiry_date`: Date when the service user account will expire (UTC). If null is passed, the account will never expire.    #### Request Examples   ``` {   \"name\": \"new-service-user-name\", } ```  ``` {   \"name\": \"service-user-1\",   \"allowed_cors_origins\": [     \"https://test.com\"   ] } ```  ``` {   \"expiry_date\": \"2020-01-01T00:00:00.000Z\" } ```  ### Response Structure  Details of the updated service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created   - `allowed_cors_origins`: List of origin url's of which the service user is allowed to make a request from   - `expiry_date`: Date when the service user account will expire (UTC)    #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"name\": \"new-service-user-name\",   \"creation_date\": \"2020-03-26T12:18:43.123+00:00\",   \"allowed_cors_origins\": [     \"https://test.com\"   ],   \"expiry_date\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_update(project_name, service_user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param ServiceUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users.service_users_update_with_http_info(project_name, service_user_id, data, **kwargs)  # noqa: E501

    def service_status(self, **kwargs):  # noqa: E501
        """Service status  # noqa: E501

         ### Description Request the API status. It can be used to determine whether the API is online. You do not have to be authenticated to access this method.  ### Response Structure - `status`: API status, either ok or fail. The database connection is tested at each status request, to make sure that the API is online.  #### Response Examples ```  {   \"status\": \"ok\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.status.service_status_with_http_info(**kwargs)  # noqa: E501

    def user_create(self, data, **kwargs):  # noqa: E501
        """Create a new user  # noqa: E501

         ### Description  Create a new user with the given details. After creation, an email is send to the email address to activate the account. The user is required to accept the terms and conditions. The password needs to be at least 8 characters long.  ### Required Parameters - `email`: Email of the user - `password`: Password of the user - `terms_conditions`: A boolean indicating whether the user accepts terms and conditions  ### Optional Parameters - `name`: Name of the user - `surname`: Surname of the user - `newsletter`: A boolean indicating whether to subscribe to the newsletters  #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"password\": \"secret-password\",   \"name\": \"User name\",   \"surname\": \"User surname\",   \"terms_conditions\": true,   \"newsletter\": false } ```  ``` {   \"email\": \"test@example.com\",   \"password\": \"secret-password\",   \"terms_conditions\": true,   \"newsletter\": false } ```  ### Response Structure  Details of the created user  - `email`: Email of the user  - `name`: Name of the user  - `surname`: Surname of the user   #### Response Examples  ``` {   \"email\": \"test@example.com\",   \"name\": \"User name\",   \"surname\": \"User surname\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UserPendingCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UserPendingDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.user.user_create_with_http_info(data, **kwargs)  # noqa: E501

    def user_delete(self, **kwargs):  # noqa: E501
        """Delete user  # noqa: E501

         ### Description Delete the user that makes the request   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_delete(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.user.user_delete_with_http_info(**kwargs)  # noqa: E501
