# ubiops

[www.ubiops.com](https://ubiops.com)

Client Library to interact with the UbiOps API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v2.1
- Package version: 3.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

For more information, please visit [https://ubiops.com/docs](https://ubiops.com/docs)

## Requirements.

Python 3.5+

## Installation & Usage
### pip install

You can install directly using:

```sh
pip install ubiops
```
(you may need to run `pip` with root permission: `sudo pip install ubiops`)

Then import the package:
```python
import ubiops
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ubiops
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

- Use system environment variables
    ```python
    import ubiops

    # Set environment variables
    # - UBIOPS_API_TOKEN: "Token <YOUR_API_TOKEN>"
    # - UBIOPS_API_HOST: optional - default to "https://api.ubiops.com/v2.1"
    core_api = ubiops.CoreApi()

    api_response = core_api.service_status()
    print(api_response)

    # Close the connection
    core_api.api_client.close()
    ```

- Use authorization parameters
    ```python
    import ubiops

    configuration = ubiops.Configuration()
    # Configure API token authorization
    configuration.api_key['Authorization'] = "Token <YOUR_API_TOKEN>"
    # Defining host is optional and default to "https://api.ubiops.com/v2.1"
    configuration.host = "https://api.ubiops.com/v2.1"

    api_client = ubiops.ApiClient(configuration)
    core_api = ubiops.CoreApi(api_client)

    api_response = core_api.service_status()
    print(api_response)

    # Close the connection
    api_client.close()
    ```

## Documentation for API Endpoints

All URIs are relative to *https://api.ubiops.com/v2.1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*Blobs* | [**blobs_create**](docs/Blobs.md#blobs_create) | **POST** /projects/{project_name}/blobs | Upload a blob
*Blobs* | [**blobs_delete**](docs/Blobs.md#blobs_delete) | **DELETE** /projects/{project_name}/blobs/{blob_id} | Delete a blob
*Blobs* | [**blobs_get**](docs/Blobs.md#blobs_get) | **GET** /projects/{project_name}/blobs/{blob_id} | Get a blob
*Blobs* | [**blobs_list**](docs/Blobs.md#blobs_list) | **GET** /projects/{project_name}/blobs | List blobs
*Blobs* | [**blobs_update**](docs/Blobs.md#blobs_update) | **PUT** /projects/{project_name}/blobs/{blob_id} | Update a blob
*DeploymentRequests* | [**batch_deployment_requests_create**](docs/DeploymentRequests.md#batch_deployment_requests_create) | **POST** /projects/{project_name}/deployments/{deployment_name}/requests/batch | Create a batch deployment request
*DeploymentRequests* | [**batch_deployment_version_requests_create**](docs/DeploymentRequests.md#batch_deployment_version_requests_create) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/batch | Create a batch deployment version request
*DeploymentRequests* | [**deployment_requests_batch_delete**](docs/DeploymentRequests.md#deployment_requests_batch_delete) | **POST** /projects/{project_name}/deployments/{deployment_name}/requests/delete | Delete multiple deployment requests
*DeploymentRequests* | [**deployment_requests_batch_get**](docs/DeploymentRequests.md#deployment_requests_batch_get) | **POST** /projects/{project_name}/deployments/{deployment_name}/requests/collect | Retrieve multiple deployment requests
*DeploymentRequests* | [**deployment_requests_create**](docs/DeploymentRequests.md#deployment_requests_create) | **POST** /projects/{project_name}/deployments/{deployment_name}/requests | Create a direct deployment request
*DeploymentRequests* | [**deployment_requests_delete**](docs/DeploymentRequests.md#deployment_requests_delete) | **DELETE** /projects/{project_name}/deployments/{deployment_name}/requests/{request_id} | Delete a deployment request
*DeploymentRequests* | [**deployment_requests_get**](docs/DeploymentRequests.md#deployment_requests_get) | **GET** /projects/{project_name}/deployments/{deployment_name}/requests/{request_id} | Get a deployment request
*DeploymentRequests* | [**deployment_requests_list**](docs/DeploymentRequests.md#deployment_requests_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/requests | List deployment requests
*DeploymentRequests* | [**deployment_requests_update**](docs/DeploymentRequests.md#deployment_requests_update) | **PATCH** /projects/{project_name}/deployments/{deployment_name}/requests/{request_id} | Update a deployment request
*DeploymentRequests* | [**deployment_version_requests_batch_delete**](docs/DeploymentRequests.md#deployment_version_requests_batch_delete) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/delete | Delete multiple deployment version requests
*DeploymentRequests* | [**deployment_version_requests_batch_get**](docs/DeploymentRequests.md#deployment_version_requests_batch_get) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/collect | Retrieve multiple deployment version requests
*DeploymentRequests* | [**deployment_version_requests_create**](docs/DeploymentRequests.md#deployment_version_requests_create) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests | Create a direct deployment version request
*DeploymentRequests* | [**deployment_version_requests_delete**](docs/DeploymentRequests.md#deployment_version_requests_delete) | **DELETE** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id} | Delete a deployment version request
*DeploymentRequests* | [**deployment_version_requests_get**](docs/DeploymentRequests.md#deployment_version_requests_get) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id} | Get a deployment version request
*DeploymentRequests* | [**deployment_version_requests_list**](docs/DeploymentRequests.md#deployment_version_requests_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests | List deployment version requests
*DeploymentRequests* | [**deployment_version_requests_update**](docs/DeploymentRequests.md#deployment_version_requests_update) | **PATCH** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id} | Update a deployment version request
*Deployments* | [**builds_get**](docs/Deployments.md#builds_get) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds/{build_id} | Get build
*Deployments* | [**builds_list**](docs/Deployments.md#builds_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds | List builds
*Deployments* | [**builds_update**](docs/Deployments.md#builds_update) | **PATCH** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/builds/{build_id} | Update build
*Deployments* | [**deployment_audit_events_list**](docs/Deployments.md#deployment_audit_events_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/audit | List audit events for a deployment
*Deployments* | [**deployment_environment_variables_copy**](docs/Deployments.md#deployment_environment_variables_copy) | **POST** /projects/{project_name}/deployments/{deployment_name}/copy-environment-variables | Copy deployment environment variable
*Deployments* | [**deployment_environment_variables_create**](docs/Deployments.md#deployment_environment_variables_create) | **POST** /projects/{project_name}/deployments/{deployment_name}/environment-variables | Create deployment environment variable
*Deployments* | [**deployment_environment_variables_delete**](docs/Deployments.md#deployment_environment_variables_delete) | **DELETE** /projects/{project_name}/deployments/{deployment_name}/environment-variables/{id} | Delete deployment environment variable
*Deployments* | [**deployment_environment_variables_get**](docs/Deployments.md#deployment_environment_variables_get) | **GET** /projects/{project_name}/deployments/{deployment_name}/environment-variables/{id} | Get deployment environment variable
*Deployments* | [**deployment_environment_variables_list**](docs/Deployments.md#deployment_environment_variables_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/environment-variables | List deployment environment variables
*Deployments* | [**deployment_environment_variables_update**](docs/Deployments.md#deployment_environment_variables_update) | **PATCH** /projects/{project_name}/deployments/{deployment_name}/environment-variables/{id} | Update deployment environment variable
*Deployments* | [**deployment_version_environment_variables_copy**](docs/Deployments.md#deployment_version_environment_variables_copy) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/copy-environment-variables | Copy deployment version environment variable
*Deployments* | [**deployment_version_environment_variables_create**](docs/Deployments.md#deployment_version_environment_variables_create) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables | Create deployment version environment variable
*Deployments* | [**deployment_version_environment_variables_delete**](docs/Deployments.md#deployment_version_environment_variables_delete) | **DELETE** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id} | Delete deployment version environment variable
*Deployments* | [**deployment_version_environment_variables_get**](docs/Deployments.md#deployment_version_environment_variables_get) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id} | Get deployment version environment variable
*Deployments* | [**deployment_version_environment_variables_list**](docs/Deployments.md#deployment_version_environment_variables_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables | List deployment version environment variables
*Deployments* | [**deployment_version_environment_variables_update**](docs/Deployments.md#deployment_version_environment_variables_update) | **PATCH** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id} | Update deployment version environment variable
*Deployments* | [**deployment_versions_create**](docs/Deployments.md#deployment_versions_create) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions | Create deployment versions
*Deployments* | [**deployment_versions_delete**](docs/Deployments.md#deployment_versions_delete) | **DELETE** /projects/{project_name}/deployments/{deployment_name}/versions/{version} | Delete deployment version
*Deployments* | [**deployment_versions_get**](docs/Deployments.md#deployment_versions_get) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version} | Get deployment version
*Deployments* | [**deployment_versions_list**](docs/Deployments.md#deployment_versions_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions | List deployment versions
*Deployments* | [**deployment_versions_update**](docs/Deployments.md#deployment_versions_update) | **PATCH** /projects/{project_name}/deployments/{deployment_name}/versions/{version} | Update deployment version
*Deployments* | [**deployments_create**](docs/Deployments.md#deployments_create) | **POST** /projects/{project_name}/deployments | Create deployments
*Deployments* | [**deployments_delete**](docs/Deployments.md#deployments_delete) | **DELETE** /projects/{project_name}/deployments/{deployment_name} | Delete a deployment
*Deployments* | [**deployments_get**](docs/Deployments.md#deployments_get) | **GET** /projects/{project_name}/deployments/{deployment_name} | Get details of a deployment
*Deployments* | [**deployments_list**](docs/Deployments.md#deployments_list) | **GET** /projects/{project_name}/deployments | List deployments
*Deployments* | [**deployments_update**](docs/Deployments.md#deployments_update) | **PATCH** /projects/{project_name}/deployments/{deployment_name} | Update a deployment
*Deployments* | [**revisions_file_download**](docs/Deployments.md#revisions_file_download) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions/{revision_id}/download | Download deployment file
*Deployments* | [**revisions_file_upload**](docs/Deployments.md#revisions_file_upload) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions | Upload deployment file
*Deployments* | [**revisions_get**](docs/Deployments.md#revisions_get) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions/{revision_id} | Get revision
*Deployments* | [**revisions_list**](docs/Deployments.md#revisions_list) | **GET** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions | List revisions
*Deployments* | [**revisions_rebuild**](docs/Deployments.md#revisions_rebuild) | **POST** /projects/{project_name}/deployments/{deployment_name}/versions/{version}/revisions/{revision_id}/rebuild | Rebuild revision
*Files* | [**buckets_create**](docs/Files.md#buckets_create) | **POST** /projects/{project_name}/buckets | Create bucket
*Files* | [**buckets_delete**](docs/Files.md#buckets_delete) | **DELETE** /projects/{project_name}/buckets/{bucket_name} | Delete a bucket
*Files* | [**buckets_get**](docs/Files.md#buckets_get) | **GET** /projects/{project_name}/buckets/{bucket_name} | Get details of a bucket
*Files* | [**buckets_list**](docs/Files.md#buckets_list) | **GET** /projects/{project_name}/buckets | List buckets
*Files* | [**buckets_update**](docs/Files.md#buckets_update) | **PATCH** /projects/{project_name}/buckets/{bucket_name} | Update a bucket
*Files* | [**files_delete**](docs/Files.md#files_delete) | **DELETE** /projects/{project_name}/buckets/{bucket_name}/files/{file} | Delete a file
*Files* | [**files_download**](docs/Files.md#files_download) | **GET** /projects/{project_name}/buckets/{bucket_name}/files/{file}/download | Download a file
*Files* | [**files_get**](docs/Files.md#files_get) | **GET** /projects/{project_name}/buckets/{bucket_name}/files/{file} | Get a file
*Files* | [**files_list**](docs/Files.md#files_list) | **GET** /projects/{project_name}/buckets/{bucket_name}/files | List files
*Files* | [**files_upload**](docs/Files.md#files_upload) | **POST** /projects/{project_name}/buckets/{bucket_name}/files/{file} | Upload a file
*ImportsAndExports* | [**exports_create**](docs/ImportsAndExports.md#exports_create) | **POST** /projects/{project_name}/exports | Create an export
*ImportsAndExports* | [**exports_delete**](docs/ImportsAndExports.md#exports_delete) | **DELETE** /projects/{project_name}/exports/{export_id} | Delete an export
*ImportsAndExports* | [**exports_download**](docs/ImportsAndExports.md#exports_download) | **GET** /projects/{project_name}/exports/{export_id}/download | Download an export
*ImportsAndExports* | [**exports_get**](docs/ImportsAndExports.md#exports_get) | **GET** /projects/{project_name}/exports/{export_id} | Get an export
*ImportsAndExports* | [**exports_list**](docs/ImportsAndExports.md#exports_list) | **GET** /projects/{project_name}/exports | List exports
*ImportsAndExports* | [**imports_create**](docs/ImportsAndExports.md#imports_create) | **POST** /projects/{project_name}/imports | Create an import
*ImportsAndExports* | [**imports_delete**](docs/ImportsAndExports.md#imports_delete) | **DELETE** /projects/{project_name}/imports/{import_id} | Delete an import
*ImportsAndExports* | [**imports_download**](docs/ImportsAndExports.md#imports_download) | **GET** /projects/{project_name}/imports/{import_id}/download | Download an import
*ImportsAndExports* | [**imports_get**](docs/ImportsAndExports.md#imports_get) | **GET** /projects/{project_name}/imports/{import_id} | Get an import
*ImportsAndExports* | [**imports_list**](docs/ImportsAndExports.md#imports_list) | **GET** /projects/{project_name}/imports | List imports
*ImportsAndExports* | [**imports_update**](docs/ImportsAndExports.md#imports_update) | **PATCH** /projects/{project_name}/imports/{import_id} | Confirm an import
*Monitoring* | [**notification_groups_create**](docs/Monitoring.md#notification_groups_create) | **POST** /projects/{project_name}/monitoring/notification-groups | Create notification groups
*Monitoring* | [**notification_groups_delete**](docs/Monitoring.md#notification_groups_delete) | **DELETE** /projects/{project_name}/monitoring/notification-groups/{notification_group_name} | Delete notification group
*Monitoring* | [**notification_groups_get**](docs/Monitoring.md#notification_groups_get) | **GET** /projects/{project_name}/monitoring/notification-groups/{notification_group_name} | Get notification group
*Monitoring* | [**notification_groups_list**](docs/Monitoring.md#notification_groups_list) | **GET** /projects/{project_name}/monitoring/notification-groups | List notification groups
*Monitoring* | [**notification_groups_update**](docs/Monitoring.md#notification_groups_update) | **PATCH** /projects/{project_name}/monitoring/notification-groups/{notification_group_name} | Update notification group
*Organizations* | [**organization_users_create**](docs/Organizations.md#organization_users_create) | **POST** /organizations/{organization_name}/users | Add a user to an organization
*Organizations* | [**organization_users_delete**](docs/Organizations.md#organization_users_delete) | **DELETE** /organizations/{organization_name}/users/{user_id} | Delete a user from an organization
*Organizations* | [**organization_users_get**](docs/Organizations.md#organization_users_get) | **GET** /organizations/{organization_name}/users/{user_id} | Get details of a user in an organization
*Organizations* | [**organization_users_list**](docs/Organizations.md#organization_users_list) | **GET** /organizations/{organization_name}/users | List the users in an organization
*Organizations* | [**organization_users_update**](docs/Organizations.md#organization_users_update) | **PATCH** /organizations/{organization_name}/users/{user_id} | Update details of a user in an organization
*Organizations* | [**organizations_create**](docs/Organizations.md#organizations_create) | **POST** /organizations | Create organizations
*Organizations* | [**organizations_get**](docs/Organizations.md#organizations_get) | **GET** /organizations/{organization_name} | Get details of an organization
*Organizations* | [**organizations_list**](docs/Organizations.md#organizations_list) | **GET** /organizations | List organizations
*Organizations* | [**organizations_resource_usage**](docs/Organizations.md#organizations_resource_usage) | **GET** /organizations/{organization_name}/resources | Get resource usage
*Organizations* | [**organizations_update**](docs/Organizations.md#organizations_update) | **PATCH** /organizations/{organization_name} | Update details of an organization
*Organizations* | [**organizations_usage_get**](docs/Organizations.md#organizations_usage_get) | **GET** /organizations/{organization_name}/usage | Get organization usage
*PipelineRequests* | [**batch_pipeline_requests_create**](docs/PipelineRequests.md#batch_pipeline_requests_create) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/requests/batch | Create a batch pipeline request
*PipelineRequests* | [**batch_pipeline_version_requests_create**](docs/PipelineRequests.md#batch_pipeline_version_requests_create) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/batch | Create a batch pipeline version request
*PipelineRequests* | [**pipeline_requests_batch_delete**](docs/PipelineRequests.md#pipeline_requests_batch_delete) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/requests/delete | Delete multiple pipeline requests
*PipelineRequests* | [**pipeline_requests_batch_get**](docs/PipelineRequests.md#pipeline_requests_batch_get) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/requests/collect | Retrieve multiple pipeline requests
*PipelineRequests* | [**pipeline_requests_create**](docs/PipelineRequests.md#pipeline_requests_create) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/requests | Create a pipeline request
*PipelineRequests* | [**pipeline_requests_delete**](docs/PipelineRequests.md#pipeline_requests_delete) | **DELETE** /projects/{project_name}/pipelines/{pipeline_name}/requests/{request_id} | Delete a pipeline request
*PipelineRequests* | [**pipeline_requests_get**](docs/PipelineRequests.md#pipeline_requests_get) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/requests/{request_id} | Get a pipeline request
*PipelineRequests* | [**pipeline_requests_list**](docs/PipelineRequests.md#pipeline_requests_list) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/requests | List pipeline requests
*PipelineRequests* | [**pipeline_version_object_requests_get**](docs/PipelineRequests.md#pipeline_version_object_requests_get) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/object-requests/{request_id} | Get an operator request
*PipelineRequests* | [**pipeline_version_requests_batch_delete**](docs/PipelineRequests.md#pipeline_version_requests_batch_delete) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/delete | Delete multiple pipeline version requests
*PipelineRequests* | [**pipeline_version_requests_batch_get**](docs/PipelineRequests.md#pipeline_version_requests_batch_get) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/collect | Retrieve multiple pipeline version requests
*PipelineRequests* | [**pipeline_version_requests_create**](docs/PipelineRequests.md#pipeline_version_requests_create) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests | Create a pipeline version request
*PipelineRequests* | [**pipeline_version_requests_delete**](docs/PipelineRequests.md#pipeline_version_requests_delete) | **DELETE** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/{request_id} | Delete a pipeline version request
*PipelineRequests* | [**pipeline_version_requests_get**](docs/PipelineRequests.md#pipeline_version_requests_get) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests/{request_id} | Get a pipeline version request
*PipelineRequests* | [**pipeline_version_requests_list**](docs/PipelineRequests.md#pipeline_version_requests_list) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/requests | List pipeline version requests
*Pipelines* | [**expressions_evaluate**](docs/Pipelines.md#expressions_evaluate) | **POST** /expressions/evaluate | Evaluate expression
*Pipelines* | [**pipeline_audit_events_list**](docs/Pipelines.md#pipeline_audit_events_list) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/audit | List audit events for a pipeline
*Pipelines* | [**pipeline_version_object_environment_variables_list**](docs/Pipelines.md#pipeline_version_object_environment_variables_list) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{name}/environment-variables | List pipeline object environment variables
*Pipelines* | [**pipeline_versions_create**](docs/Pipelines.md#pipeline_versions_create) | **POST** /projects/{project_name}/pipelines/{pipeline_name}/versions | Create pipeline versions
*Pipelines* | [**pipeline_versions_delete**](docs/Pipelines.md#pipeline_versions_delete) | **DELETE** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version} | Delete pipeline version
*Pipelines* | [**pipeline_versions_get**](docs/Pipelines.md#pipeline_versions_get) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version} | Get pipeline version
*Pipelines* | [**pipeline_versions_list**](docs/Pipelines.md#pipeline_versions_list) | **GET** /projects/{project_name}/pipelines/{pipeline_name}/versions | List pipeline versions
*Pipelines* | [**pipeline_versions_update**](docs/Pipelines.md#pipeline_versions_update) | **PATCH** /projects/{project_name}/pipelines/{pipeline_name}/versions/{version} | Update pipeline version
*Pipelines* | [**pipelines_create**](docs/Pipelines.md#pipelines_create) | **POST** /projects/{project_name}/pipelines | Create pipelines
*Pipelines* | [**pipelines_delete**](docs/Pipelines.md#pipelines_delete) | **DELETE** /projects/{project_name}/pipelines/{pipeline_name} | Delete a pipeline
*Pipelines* | [**pipelines_get**](docs/Pipelines.md#pipelines_get) | **GET** /projects/{project_name}/pipelines/{pipeline_name} | Get details of a pipeline
*Pipelines* | [**pipelines_list**](docs/Pipelines.md#pipelines_list) | **GET** /projects/{project_name}/pipelines | List pipelines
*Pipelines* | [**pipelines_update**](docs/Pipelines.md#pipelines_update) | **PATCH** /projects/{project_name}/pipelines/{pipeline_name} | Update a pipeline
*Projects* | [**instance_types_list**](docs/Projects.md#instance_types_list) | **GET** /projects/{project_name}/instance-types | List instance types
*Projects* | [**metrics_get**](docs/Projects.md#metrics_get) | **GET** /projects/{project_name}/metrics/{metric} | Get metrics
*Projects* | [**project_audit_events_list**](docs/Projects.md#project_audit_events_list) | **GET** /projects/{project_name}/audit | List audit events in a project
*Projects* | [**project_environment_variables_create**](docs/Projects.md#project_environment_variables_create) | **POST** /projects/{project_name}/environment-variables | Create project environment variable
*Projects* | [**project_environment_variables_delete**](docs/Projects.md#project_environment_variables_delete) | **DELETE** /projects/{project_name}/environment-variables/{id} | Delete project environment variable
*Projects* | [**project_environment_variables_get**](docs/Projects.md#project_environment_variables_get) | **GET** /projects/{project_name}/environment-variables/{id} | Get project environment variable
*Projects* | [**project_environment_variables_list**](docs/Projects.md#project_environment_variables_list) | **GET** /projects/{project_name}/environment-variables | List project environment variables
*Projects* | [**project_environment_variables_update**](docs/Projects.md#project_environment_variables_update) | **PATCH** /projects/{project_name}/environment-variables/{id} | Update project environment variable
*Projects* | [**project_requests_list**](docs/Projects.md#project_requests_list) | **GET** /projects/{project_name}/requests | List requests in project
*Projects* | [**project_users_create**](docs/Projects.md#project_users_create) | **POST** /projects/{project_name}/users | Add user to a project
*Projects* | [**project_users_delete**](docs/Projects.md#project_users_delete) | **DELETE** /projects/{project_name}/users/{user_id} | Delete user from a project
*Projects* | [**project_users_get**](docs/Projects.md#project_users_get) | **GET** /projects/{project_name}/users/{user_id} | Get user in a project
*Projects* | [**project_users_list**](docs/Projects.md#project_users_list) | **GET** /projects/{project_name}/users | List users in a project
*Projects* | [**projects_create**](docs/Projects.md#projects_create) | **POST** /projects | Create projects
*Projects* | [**projects_delete**](docs/Projects.md#projects_delete) | **DELETE** /projects/{project_name} | Delete a project
*Projects* | [**projects_get**](docs/Projects.md#projects_get) | **GET** /projects/{project_name} | Get details of a project
*Projects* | [**projects_list**](docs/Projects.md#projects_list) | **GET** /projects | List projects
*Projects* | [**projects_log_list**](docs/Projects.md#projects_log_list) | **POST** /projects/{project_name}/logs | List logs for a project
*Projects* | [**projects_resource_usage**](docs/Projects.md#projects_resource_usage) | **GET** /projects/{project_name}/resources | List resource usage of a project
*Projects* | [**projects_update**](docs/Projects.md#projects_update) | **PATCH** /projects/{project_name} | Update a project
*Projects* | [**projects_usage_get**](docs/Projects.md#projects_usage_get) | **GET** /projects/{project_name}/usage | Get resource usage
*Projects* | [**quotas_list**](docs/Projects.md#quotas_list) | **GET** /projects/{project_name}/quotas | List quotas
*RequestSchedules* | [**request_schedules_create**](docs/RequestSchedules.md#request_schedules_create) | **POST** /projects/{project_name}/schedules | Create request schedules
*RequestSchedules* | [**request_schedules_delete**](docs/RequestSchedules.md#request_schedules_delete) | **DELETE** /projects/{project_name}/schedules/{schedule_name} | Delete a request schedule
*RequestSchedules* | [**request_schedules_get**](docs/RequestSchedules.md#request_schedules_get) | **GET** /projects/{project_name}/schedules/{schedule_name} | Get details of a request schedule
*RequestSchedules* | [**request_schedules_list**](docs/RequestSchedules.md#request_schedules_list) | **GET** /projects/{project_name}/schedules | List request schedules
*RequestSchedules* | [**request_schedules_update**](docs/RequestSchedules.md#request_schedules_update) | **PATCH** /projects/{project_name}/schedules/{schedule_name} | Update a request schedule
*Roles* | [**permissions_list**](docs/Roles.md#permissions_list) | **GET** /permissions | List the available permissions
*Roles* | [**role_assignments_create**](docs/Roles.md#role_assignments_create) | **POST** /projects/{project_name}/role-assignments | Assign role to user/object
*Roles* | [**role_assignments_delete**](docs/Roles.md#role_assignments_delete) | **DELETE** /projects/{project_name}/role-assignments/{id} | Delete role of user
*Roles* | [**role_assignments_get**](docs/Roles.md#role_assignments_get) | **GET** /projects/{project_name}/role-assignments/{id} | Get role assignment
*Roles* | [**role_assignments_per_object_list**](docs/Roles.md#role_assignments_per_object_list) | **GET** /projects/{project_name}/role-assignments | List roles on object/user
*Roles* | [**roles_create**](docs/Roles.md#roles_create) | **POST** /projects/{project_name}/roles | Create a custom role scoped in a project
*Roles* | [**roles_delete**](docs/Roles.md#roles_delete) | **DELETE** /projects/{project_name}/roles/{role_name} | Delete a role from a project
*Roles* | [**roles_get**](docs/Roles.md#roles_get) | **GET** /projects/{project_name}/roles/{role_name} | Get details of a role
*Roles* | [**roles_list**](docs/Roles.md#roles_list) | **GET** /projects/{project_name}/roles | List the available roles in a project
*Roles* | [**roles_update**](docs/Roles.md#roles_update) | **PATCH** /projects/{project_name}/roles/{role_name} | Update a role in a project
*ServiceUsers* | [**service_users_create**](docs/ServiceUsers.md#service_users_create) | **POST** /projects/{project_name}/service-users | Create a new service user
*ServiceUsers* | [**service_users_delete**](docs/ServiceUsers.md#service_users_delete) | **DELETE** /projects/{project_name}/service-users/{service_user_id} | Delete service user
*ServiceUsers* | [**service_users_get**](docs/ServiceUsers.md#service_users_get) | **GET** /projects/{project_name}/service-users/{service_user_id} | Retrieve details of a service user
*ServiceUsers* | [**service_users_list**](docs/ServiceUsers.md#service_users_list) | **GET** /projects/{project_name}/service-users | List service users
*ServiceUsers* | [**service_users_token**](docs/ServiceUsers.md#service_users_token) | **PUT** /projects/{project_name}/service-users/{service_user_id}/token | Reset the token of a service user
*ServiceUsers* | [**service_users_update**](docs/ServiceUsers.md#service_users_update) | **PATCH** /projects/{project_name}/service-users/{service_user_id} | Update service user details
*Status* | [**service_status**](docs/Status.md#service_status) | **GET** /status | Service status
*User* | [**user_create**](docs/User.md#user_create) | **POST** /user | Create a new user
*User* | [**user_delete**](docs/User.md#user_delete) | **DELETE** /user | Delete user


## Documentation For Models

 - [AttachmentFieldsList](docs/models/AttachmentFieldsList.md)
 - [AttachmentSourcesList](docs/models/AttachmentSourcesList.md)
 - [AttachmentsCreate](docs/models/AttachmentsCreate.md)
 - [AttachmentsList](docs/models/AttachmentsList.md)
 - [AuditList](docs/models/AuditList.md)
 - [BlobList](docs/models/BlobList.md)
 - [BucketCreate](docs/models/BucketCreate.md)
 - [BucketDetail](docs/models/BucketDetail.md)
 - [BucketList](docs/models/BucketList.md)
 - [BucketUpdate](docs/models/BucketUpdate.md)
 - [BuildList](docs/models/BuildList.md)
 - [BuildUpdate](docs/models/BuildUpdate.md)
 - [DeploymentCreate](docs/models/DeploymentCreate.md)
 - [DeploymentCreateResponse](docs/models/DeploymentCreateResponse.md)
 - [DeploymentDetail](docs/models/DeploymentDetail.md)
 - [DeploymentInputFieldCreate](docs/models/DeploymentInputFieldCreate.md)
 - [DeploymentInstanceType](docs/models/DeploymentInstanceType.md)
 - [DeploymentList](docs/models/DeploymentList.md)
 - [DeploymentOutputFieldCreate](docs/models/DeploymentOutputFieldCreate.md)
 - [DeploymentRequestBatchCreateResponse](docs/models/DeploymentRequestBatchCreateResponse.md)
 - [DeploymentRequestBatchDetail](docs/models/DeploymentRequestBatchDetail.md)
 - [DeploymentRequestCreateResponse](docs/models/DeploymentRequestCreateResponse.md)
 - [DeploymentRequestList](docs/models/DeploymentRequestList.md)
 - [DeploymentRequestSingleDetail](docs/models/DeploymentRequestSingleDetail.md)
 - [DeploymentRequestUpdate](docs/models/DeploymentRequestUpdate.md)
 - [DeploymentRequestUpdateResponse](docs/models/DeploymentRequestUpdateResponse.md)
 - [DeploymentUpdate](docs/models/DeploymentUpdate.md)
 - [DeploymentVersionCreate](docs/models/DeploymentVersionCreate.md)
 - [DeploymentVersionDetail](docs/models/DeploymentVersionDetail.md)
 - [DeploymentVersionList](docs/models/DeploymentVersionList.md)
 - [DeploymentVersionUpdate](docs/models/DeploymentVersionUpdate.md)
 - [DirectPipelineRequestDeploymentRequest](docs/models/DirectPipelineRequestDeploymentRequest.md)
 - [DirectPipelineRequestOperatorRequest](docs/models/DirectPipelineRequestOperatorRequest.md)
 - [EnvironmentVariableCopy](docs/models/EnvironmentVariableCopy.md)
 - [EnvironmentVariableCreate](docs/models/EnvironmentVariableCreate.md)
 - [EnvironmentVariableList](docs/models/EnvironmentVariableList.md)
 - [ExportCreate](docs/models/ExportCreate.md)
 - [ExportDetail](docs/models/ExportDetail.md)
 - [ExportList](docs/models/ExportList.md)
 - [ExpressionEvaluate](docs/models/ExpressionEvaluate.md)
 - [ExpressionEvaluateResponse](docs/models/ExpressionEvaluateResponse.md)
 - [ExpressionInputFieldCreate](docs/models/ExpressionInputFieldCreate.md)
 - [FileDetail](docs/models/FileDetail.md)
 - [FileItem](docs/models/FileItem.md)
 - [FileUploadResponse](docs/models/FileUploadResponse.md)
 - [ImportDetail](docs/models/ImportDetail.md)
 - [ImportList](docs/models/ImportList.md)
 - [ImportUpdate](docs/models/ImportUpdate.md)
 - [InheritedEnvironmentVariableList](docs/models/InheritedEnvironmentVariableList.md)
 - [InputFieldWidgetCreate](docs/models/InputFieldWidgetCreate.md)
 - [InputOutputFieldDetail](docs/models/InputOutputFieldDetail.md)
 - [InputOutputFieldList](docs/models/InputOutputFieldList.md)
 - [InputOutputWidgetList](docs/models/InputOutputWidgetList.md)
 - [Logs](docs/models/Logs.md)
 - [LogsCreate](docs/models/LogsCreate.md)
 - [Metrics](docs/models/Metrics.md)
 - [NotificationGroupContact](docs/models/NotificationGroupContact.md)
 - [NotificationGroupCreate](docs/models/NotificationGroupCreate.md)
 - [NotificationGroupList](docs/models/NotificationGroupList.md)
 - [NotificationGroupUpdate](docs/models/NotificationGroupUpdate.md)
 - [OperatorRequestDetail](docs/models/OperatorRequestDetail.md)
 - [OrganizationCreate](docs/models/OrganizationCreate.md)
 - [OrganizationDetail](docs/models/OrganizationDetail.md)
 - [OrganizationList](docs/models/OrganizationList.md)
 - [OrganizationUpdate](docs/models/OrganizationUpdate.md)
 - [OrganizationUserCreate](docs/models/OrganizationUserCreate.md)
 - [OrganizationUserDetail](docs/models/OrganizationUserDetail.md)
 - [OrganizationUserUpdate](docs/models/OrganizationUserUpdate.md)
 - [OutputFieldWidgetCreate](docs/models/OutputFieldWidgetCreate.md)
 - [PermissionList](docs/models/PermissionList.md)
 - [PipelineCreate](docs/models/PipelineCreate.md)
 - [PipelineCreateResponse](docs/models/PipelineCreateResponse.md)
 - [PipelineDetail](docs/models/PipelineDetail.md)
 - [PipelineInputFieldCreate](docs/models/PipelineInputFieldCreate.md)
 - [PipelineList](docs/models/PipelineList.md)
 - [PipelineOutputFieldCreate](docs/models/PipelineOutputFieldCreate.md)
 - [PipelineRequestBatchCreateResponse](docs/models/PipelineRequestBatchCreateResponse.md)
 - [PipelineRequestCreateResponse](docs/models/PipelineRequestCreateResponse.md)
 - [PipelineRequestDeploymentRequest](docs/models/PipelineRequestDeploymentRequest.md)
 - [PipelineRequestDetail](docs/models/PipelineRequestDetail.md)
 - [PipelineRequestList](docs/models/PipelineRequestList.md)
 - [PipelineRequestOperatorRequest](docs/models/PipelineRequestOperatorRequest.md)
 - [PipelineRequestSingleDetail](docs/models/PipelineRequestSingleDetail.md)
 - [PipelineUpdate](docs/models/PipelineUpdate.md)
 - [PipelineVersionCreate](docs/models/PipelineVersionCreate.md)
 - [PipelineVersionDetail](docs/models/PipelineVersionDetail.md)
 - [PipelineVersionList](docs/models/PipelineVersionList.md)
 - [PipelineVersionObjectCreate](docs/models/PipelineVersionObjectCreate.md)
 - [PipelineVersionObjectList](docs/models/PipelineVersionObjectList.md)
 - [PipelineVersionUpdate](docs/models/PipelineVersionUpdate.md)
 - [ProjectCreate](docs/models/ProjectCreate.md)
 - [ProjectDetail](docs/models/ProjectDetail.md)
 - [ProjectList](docs/models/ProjectList.md)
 - [ProjectResourceUsage](docs/models/ProjectResourceUsage.md)
 - [ProjectUpdate](docs/models/ProjectUpdate.md)
 - [ProjectUserCreate](docs/models/ProjectUserCreate.md)
 - [ProjectUserList](docs/models/ProjectUserList.md)
 - [QuotaDetail](docs/models/QuotaDetail.md)
 - [RequestsOverview](docs/models/RequestsOverview.md)
 - [ResourceUsage](docs/models/ResourceUsage.md)
 - [RevisionCreate](docs/models/RevisionCreate.md)
 - [RevisionList](docs/models/RevisionList.md)
 - [RoleAssignmentCreate](docs/models/RoleAssignmentCreate.md)
 - [RoleAssignmentList](docs/models/RoleAssignmentList.md)
 - [RoleCreate](docs/models/RoleCreate.md)
 - [RoleDetailList](docs/models/RoleDetailList.md)
 - [RoleList](docs/models/RoleList.md)
 - [RoleUpdate](docs/models/RoleUpdate.md)
 - [ScheduleCreate](docs/models/ScheduleCreate.md)
 - [ScheduleList](docs/models/ScheduleList.md)
 - [ScheduleUpdate](docs/models/ScheduleUpdate.md)
 - [ServiceUserCreate](docs/models/ServiceUserCreate.md)
 - [ServiceUserList](docs/models/ServiceUserList.md)
 - [ServiceUserTokenDetail](docs/models/ServiceUserTokenDetail.md)
 - [ServiceUserTokenList](docs/models/ServiceUserTokenList.md)
 - [Status](docs/models/Status.md)
 - [Usage](docs/models/Usage.md)
 - [UsageMetric](docs/models/UsageMetric.md)
 - [UserPendingCreate](docs/models/UserPendingCreate.md)
 - [UserPendingDetail](docs/models/UserPendingDetail.md)


## Documentation For Utils

See:
- [FileOperations](docs/utils/FileOperations.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


