"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'AwsCdkFsxLustre');
const vpc = new aws_ec2_1.Vpc(stack, 'VPC');
const storageCapacity = 1200;
const lustreConfiguration = {
    deploymentType: lib_1.LustreDeploymentType.SCRATCH_2,
};
const fs = new lib_1.LustreFileSystem(stack, 'FsxLustreFileSystem', {
    lustreConfiguration,
    storageCapacityGiB: storageCapacity,
    vpc,
    vpcSubnet: vpc.privateSubnets[0],
});
const inst = new aws_ec2_1.Instance(stack, 'inst', {
    instanceType: aws_ec2_1.InstanceType.of(aws_ec2_1.InstanceClass.T2, aws_ec2_1.InstanceSize.LARGE),
    machineImage: new aws_ec2_1.AmazonLinuxImage({
        generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
    }),
    vpc,
    vpcSubnets: {
        subnetType: aws_ec2_1.SubnetType.PUBLIC,
    },
});
fs.connections.allowDefaultPortFrom(inst);
app.synth();
//# sourceMappingURL=data:application/json;base64,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