# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sw360']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.12.0,<3.0.0']

setup_kwargs = {
    'name': 'sw360',
    'version': '1.0.0',
    'description': 'Python interface to the SW360 software component catalogue',
    'long_description': '# SW360 Base Library for Python\n\n[![License](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/tngraf/Python-GitHub-Example/blob/main/LICENSE)\n[![Python Version](https://img.shields.io/badge/python-3.6%2C3.7%2C3.8%2C3.9-yellow?logo=python)](https://www.python.org/doc/versions/)\n[![PyPI version](https://badge.fury.io/py/sw360.svg)](https://badge.fury.io/py/sw360)\n[![Static checks](https://github.com/sw360/sw360python/actions/workflows/python-package.yml/badge.svg)](https://github.com/sw360/sw360python/actions/workflows/python-package.yml)\n[![Unit tests](https://github.com/sw360/sw360python/actions/workflows/unit-test.yml/badge.svg)](https://github.com/sw360/sw360python/actions/workflows/unit-test.yml)\n\nThis Python project implements the REST API of [SW360](https://www.eclipse.org/sw360/)\nand allows an easy way to interact with SW360.\n\n## Documentation\n\nHave a look at the documentation: https://sw360.github.io/sw360python/\n\n\n## Usage\n\n### Installation\n\nThis project is available as [Python package on PyPi.org](https://pypi.org/project/sw360/).  \nInstall fossology and required dependencies:\n```shell\n  pip install sw360 requests\n  ```\n\n### Using the API\n\n* Get a REST API token from your SW360 server\n* Export required environment variables (optionally but recommended):\n\n  ```shell\n  export SW360ProductionToken=<your_api_token>\n  ```\n* Start using the API:\n\n  ```python\n  import sw360\n  client = sw360.SW360(sw360_url, sw360_api_token)\n  ```\n\n### Contribute\n\n* All contributions in form of bug reports, feature requests or merge requests!\n* Use proper [docstrings](https://realpython.com/documenting-python-code/) to document functions and classes\n* Extend the testsuite **poetry run pytest** with the new functions/classes\n* The **documentation website** can automatically be generated by the [Sphinx autodoc extension](https://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html)\n\n### Build\n\n#### Building the Documentation\n\nThe documentation of the project is built using Sphinx:\n\n```python\npoetry run sphinx-build .\\docs-source\\ .\\docs\\\n```\n\n#### Building Python package\n\nFor building the library, you need [Poetry](https://python-poetry.org/). The build is then triggered using\n\n```shell\npoetry build\n```\n\nThis creates the source and wheel files in ```dist/``` subdirectory -- which can then be uploaded or installed locally using ```pip```.\n\n## Test\n\nStart the complete test suite or a specific test case (and generate coverage report):\n```shell\npoetry run pytest\n```\n\nor\n```shell\npoetry run coverage run -m pytest\npoetry run coverage report -m --omit "*/site-packages/*.py"\npoetry run coverage html --omit "*/site-packages/*.py"\n```\n\n## Demo ##\n\nThe script ``check_project.py`` shows how to use the library to retrieve some information of a given project on SW360. This requires colorama>=0.4.1.\n\n## License ##\n\nThe project is licensed under the MIT license.\nSPDX-License-Identifier: MIT\n',
    'author': 'Thomas Graf',
    'author_email': 'thomas.graf@siemens.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sw360/sw360python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
