from mmisp.db.models.role import Role


def generate_site_admin_role() -> Role:
    return Role(
        name="Site Admin Role",
        perm_add=True,
        perm_modify=True,
        perm_modify_org=True,
        perm_publish=True,
        perm_delegate=True,
        perm_sync=True,
        perm_admin=True,
        perm_audit=True,
        perm_auth=True,
        perm_site_admin=True,
        perm_regexp_access=True,
        perm_tagger=True,
        perm_template=True,
        perm_sharing_group=True,
        perm_tag_editor=True,
        perm_sighting=True,
        perm_object_template=True,
        default_role=False,
        memory_limit="",
        max_execution_time="",
        restricted_to_site_admin=False,
        perm_publish_zmq=True,
        perm_publish_kafka=True,
        perm_decaying=True,
        enforce_rate_limit=False,
        rate_limit_count=0,
        perm_galaxy_editor=True,
        perm_warninglist=True,
        perm_view_feed_correlations=True,
    )


def generate_org_admin_role() -> Role:
    return Role(
        name="Org Admin Role",
        perm_add=True,
        perm_modify=True,
        perm_modify_org=True,
        perm_publish=True,
        perm_delegate=True,
        perm_sync=False,
        perm_admin=True,
        perm_audit=True,
        perm_auth=True,
        perm_site_admin=False,
        perm_regexp_access=False,
        perm_tagger=True,
        perm_template=True,
        perm_sharing_group=True,
        perm_tag_editor=True,
        perm_sighting=True,
        perm_object_template=False,
        default_role=False,
        memory_limit="",
        max_execution_time="",
        restricted_to_site_admin=False,
        perm_publish_zmq=True,
        perm_publish_kafka=True,
        perm_decaying=True,
        enforce_rate_limit=False,
        rate_limit_count=0,
        perm_galaxy_editor=True,
        perm_warninglist=False,
        perm_view_feed_correlations=True,
    )


def generate_read_only_role() -> Role:
    return Role(
        name="Read Only Role",
        perm_add=False,
        perm_modify=False,
        perm_modify_org=False,
        perm_publish=False,
        perm_delegate=False,
        perm_sync=False,
        perm_admin=False,
        perm_audit=True,
        perm_auth=True,
        perm_site_admin=False,
        perm_regexp_access=False,
        perm_tagger=False,
        perm_template=False,
        perm_sharing_group=False,
        perm_tag_editor=False,
        perm_sighting=False,
        perm_object_template=False,
        default_role=False,
        memory_limit="",
        max_execution_time="",
        restricted_to_site_admin=False,
        perm_publish_zmq=False,
        perm_publish_kafka=False,
        perm_decaying=False,
        enforce_rate_limit=False,
        rate_limit_count=0,
        perm_galaxy_editor=False,
        perm_warninglist=False,
        perm_view_feed_correlations=True,
    )
