# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class ApiRunDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'run': 'ApiRun',
        'pipeline_runtime': 'ApiPipelineRuntime'
    }

    attribute_map = {
        'run': 'run',
        'pipeline_runtime': 'pipeline_runtime'
    }

    def __init__(self, run=None, pipeline_runtime=None, local_vars_configuration=None):  # noqa: E501
        """ApiRunDetail - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._run = None
        self._pipeline_runtime = None
        self.discriminator = None

        if run is not None:
            self.run = run
        if pipeline_runtime is not None:
            self.pipeline_runtime = pipeline_runtime

    @property
    def run(self):
        """Gets the run of this ApiRunDetail.  # noqa: E501


        :return: The run of this ApiRunDetail.  # noqa: E501
        :rtype: ApiRun
        """
        return self._run

    @run.setter
    def run(self, run):
        """Sets the run of this ApiRunDetail.


        :param run: The run of this ApiRunDetail.  # noqa: E501
        :type run: ApiRun
        """

        self._run = run

    @property
    def pipeline_runtime(self):
        """Gets the pipeline_runtime of this ApiRunDetail.  # noqa: E501


        :return: The pipeline_runtime of this ApiRunDetail.  # noqa: E501
        :rtype: ApiPipelineRuntime
        """
        return self._pipeline_runtime

    @pipeline_runtime.setter
    def pipeline_runtime(self, pipeline_runtime):
        """Sets the pipeline_runtime of this ApiRunDetail.


        :param pipeline_runtime: The pipeline_runtime of this ApiRunDetail.  # noqa: E501
        :type pipeline_runtime: ApiPipelineRuntime
        """

        self._pipeline_runtime = pipeline_runtime

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiRunDetail):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApiRunDetail):
            return True

        return self.to_dict() != other.to_dict()
