"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbTarget = exports.AlbArnTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A single Application Load Balancer as the target for load balancing.
 */
class AlbArnTarget {
    /**
     * Create a new alb target
     *
     * @param albArn The ARN of the application load balancer to load balance to
     * @param port The port on which the target is listening
     */
    constructor(albArn, port) {
        this.albArn = albArn;
        this.port = port;
    }
    /**
     * Register this alb target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.ALB,
            targetJson: { id: this.albArn, port: this.port },
        };
    }
}
exports.AlbArnTarget = AlbArnTarget;
_a = JSII_RTTI_SYMBOL_1;
AlbArnTarget[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.AlbArnTarget", version: "1.147.0" };
/**
 * A single Application Load Balancer as the target for load balancing.
 */
class AlbTarget extends AlbArnTarget {
    /**
     * @param alb The application load balancer to load balance to
     * @param port The port on which the target is listening
     */
    constructor(alb, port) {
        super(alb.loadBalancerArn, port);
    }
}
exports.AlbTarget = AlbTarget;
_b = JSII_RTTI_SYMBOL_1;
AlbTarget[_b] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.AlbTarget", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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