# Generated by Django 5.2.1 on 2025-06-04 23:48

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SmsConversation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, editable=False)),
                ('is_deleted', models.BooleanField(default=False, editable=False)),
                ('created_datetime', models.DateTimeField(default=django.utils.timezone.localtime, editable=False)),
                ('phone_number', models.CharField(max_length=20)),
                ('last_message_datetime', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sms_conversations', related_query_name='sms_conversation', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'SMS Conversation',
                'verbose_name_plural': 'SMS Conversations',
                'db_table': 'django_spire_ai_sms_conversation',
                'ordering': ('-last_message_datetime',),
            },
        ),
        migrations.CreateModel(
            name='SmsMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, editable=False)),
                ('is_deleted', models.BooleanField(default=False, editable=False)),
                ('created_datetime', models.DateTimeField(default=django.utils.timezone.localtime, editable=False)),
                ('body', models.TextField()),
                ('is_inbound', models.BooleanField(default=False)),
                ('twilio_sid', models.CharField(blank=True, max_length=64, null=True)),
                ('is_processed', models.BooleanField(default=False)),
                ('conversation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', related_query_name='message', to='django_spire_ai_sms.smsconversation')),
            ],
            options={
                'verbose_name': 'SMS Message',
                'verbose_name_plural': 'SMS Messages',
                'db_table': 'django_spire_ai_sms_message',
                'ordering': ('-created_datetime',),
            },
        ),
    ]
