
/*
* Copyright (c) 2017, STMicroelectronics - All Rights Reserved
*
* This file is part of VL53L1 Core and is dual licensed,
* either 'STMicroelectronics
* Proprietary license'
* or 'BSD 3-clause "New" or "Revised" License' , at your option.
*
********************************************************************************
*
* 'STMicroelectronics Proprietary license'
*
********************************************************************************
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms at www.st.com/sla0081
*
* STMicroelectronics confidential
* Reproduction and Communication of this document is strictly prohibited unless
* specifically authorized in writing by STMicroelectronics.
*
*
********************************************************************************
*
* Alternatively, VL53L1 Core may be distributed under the terms of
* 'BSD 3-clause "New" or "Revised" License', in which case the following
* provisions apply instead of the ones mentioned above :
*
********************************************************************************
*
* License terms: BSD 3-clause "New" or "Revised" License.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* 1. Redistributions of source code must retain the above copyright notice, this
* list of conditions and the following disclaimer.
*
* 2. Redistributions in binary form must reproduce the above copyright notice,
* this list of conditions and the following disclaimer in the documentation
* and/or other materials provided with the distribution.
*
* 3. Neither the name of the copyright holder nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*
********************************************************************************
*
*/

#ifndef _VL53L1_PLATFORM_H_
#define _VL53L1_PLATFORM_H_

#include "vl53l1_ll_def.h"
#include "vl53l1_platform_log.h"

#define VL53L1_IPP_API
#include "vl53l1_platform_user_data.h"

#ifdef __cplusplus
extern "C"
{
#endif


void VL53L1_set_i2c(void *multi_func, void *read_func, void *write_func);

VL53L1_Error VL53L1_CommsInitialise(
	VL53L1_DEV pdev,
	uint8_t       comms_type,
	uint16_t      comms_speed_khz);

VL53L1_Error VL53L1_CommsClose(
	VL53L1_DEV pdev);

VL53L1_Error VL53L1_WriteMulti(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint8_t      *pdata,
		uint32_t      count);

VL53L1_Error VL53L1_ReadMulti(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint8_t      *pdata,
		uint32_t      count);

VL53L1_Error VL53L1_WrByte(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint8_t       VL53L1_PRM_00005);

VL53L1_Error VL53L1_WrWord(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint16_t      VL53L1_PRM_00005);

VL53L1_Error VL53L1_WrDWord(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint32_t      VL53L1_PRM_00005);

VL53L1_Error VL53L1_RdByte(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint8_t      *pdata);

VL53L1_Error VL53L1_RdWord(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint16_t     *pdata);

VL53L1_Error VL53L1_RdDWord(
		VL53L1_DEV pdev,
		uint16_t      index,
		uint32_t     *pdata);

VL53L1_Error VL53L1_WaitUs(
		VL53L1_DEV pdev,
		int32_t       wait_us);

VL53L1_Error VL53L1_WaitMs(
		VL53L1_DEV pdev,
		int32_t       wait_ms);

VL53L1_Error VL53L1_GetTimerFrequency(int32_t *ptimer_freq_hz);

VL53L1_Error VL53L1_GetTimerValue(int32_t *ptimer_count);

VL53L1_Error VL53L1_GpioSetMode(uint8_t pin, uint8_t mode);

VL53L1_Error VL53L1_GpioSetValue(uint8_t pin, uint8_t value);

VL53L1_Error VL53L1_GpioGetValue(uint8_t pin, uint8_t *pvalue);

VL53L1_Error VL53L1_GpioXshutdown(uint8_t value);

VL53L1_Error VL53L1_GpioCommsSelect(uint8_t value);

VL53L1_Error VL53L1_GpioPowerEnable(uint8_t value);

VL53L1_Error  VL53L1_GpioInterruptEnable(void (*function)(void), uint8_t edge_type);

VL53L1_Error  VL53L1_GpioInterruptDisable(void);

VL53L1_Error VL53L1_GetTickCount(
	uint32_t *ptime_ms);

VL53L1_Error VL53L1_WaitValueMaskEx(
		VL53L1_DEV pdev,
		uint32_t      timeout_ms,
		uint16_t      index,
		uint8_t       value,
		uint8_t       mask,
		uint32_t      poll_delay_ms);

#ifdef __cplusplus
}
#endif

#endif
