# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ProfilePreview(Model):
    """A preview about the profile with some of its properties.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A unique identifier of the profile
    :type id: str
    :param name: Required. The name of the profile
    :type name: str
    :param tags: Required. Profile tags
    :type tags: list[str]
    :param proxy: Required.
    :type proxy:
     ~kameleo.local_api_client.models.ProxyConnectionTypeServerMultiLevelChoice
    :param created_at: Required. Date when the profile was created.
    :type created_at: datetime
    :param last_known_path: An absolute path where the related .kameleo
     profile file was accessed lastly. This is updated when a profile is saved
     to a .kameleo file, or loaded from a .kameleo file.
    :type last_known_path: str
    :param device: Required.
    :type device: ~kameleo.local_api_client.models.Device
    :param os: Required.
    :type os: ~kameleo.local_api_client.models.Os
    :param browser: Required.
    :type browser: ~kameleo.local_api_client.models.Browser
    :param language: Required. Language of the profile. This is derived from
     the base profile. Using ISO 639-1 language codes.
    :type language: str
    :param launcher: Required. The mode how the profile should be launched. It
     determines which browser to launch. This cannot be modified after
     creation. Possible values are 'automatic', 'chrome', 'chromium',
     'firefox', 'edge', 'external'
    :type launcher: str
    :param status: Required.
    :type status: ~kameleo.local_api_client.models.StatusResponse
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'tags': {'required': True},
        'proxy': {'required': True},
        'created_at': {'required': True},
        'device': {'required': True},
        'os': {'required': True},
        'browser': {'required': True},
        'language': {'required': True},
        'launcher': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'proxy': {'key': 'proxy', 'type': 'ProxyConnectionTypeServerMultiLevelChoice'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_known_path': {'key': 'lastKnownPath', 'type': 'str'},
        'device': {'key': 'device', 'type': 'Device'},
        'os': {'key': 'os', 'type': 'Os'},
        'browser': {'key': 'browser', 'type': 'Browser'},
        'language': {'key': 'language', 'type': 'str'},
        'launcher': {'key': 'launcher', 'type': 'str'},
        'status': {'key': 'status', 'type': 'StatusResponse'},
    }

    def __init__(self, **kwargs):
        super(ProfilePreview, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.tags = kwargs.get('tags', None)
        self.proxy = kwargs.get('proxy', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_known_path = kwargs.get('last_known_path', None)
        self.device = kwargs.get('device', None)
        self.os = kwargs.get('os', None)
        self.browser = kwargs.get('browser', None)
        self.language = kwargs.get('language', None)
        self.launcher = kwargs.get('launcher', None)
        self.status = kwargs.get('status', None)
