# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UserTrunc(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'user_id': 'str',
        'preferred_gender': 'str',
        'role': 'str',
        'avatar': 'Avatar',
        'additional_users': 'list[UserTrunc]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'user_id': 'userId',
        'preferred_gender': 'preferredGender',
        'role': 'role',
        'avatar': 'avatar',
        'additional_users': 'additionalUsers'
    }

    def __init__(self, id=None, name=None, user_id=None, preferred_gender=None, role=None, avatar=None, additional_users=None):  # noqa: E501
        """UserTrunc - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._user_id = None
        self._preferred_gender = None
        self._role = None
        self._avatar = None
        self._additional_users = None
        self.discriminator = None
        if id is not None:
            self.id = id
        self.name = name
        self.user_id = user_id
        if preferred_gender is not None:
            self.preferred_gender = preferred_gender
        if role is not None:
            self.role = role
        if avatar is not None:
            self.avatar = avatar
        if additional_users is not None:
            self.additional_users = additional_users

    @property
    def id(self):
        """Gets the id of this UserTrunc.  # noqa: E501

        Optional Identifier other than userId to identify the user  # noqa: E501

        :return: The id of this UserTrunc.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UserTrunc.

        Optional Identifier other than userId to identify the user  # noqa: E501

        :param id: The id of this UserTrunc.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this UserTrunc.  # noqa: E501

        Name of the user  # noqa: E501

        :return: The name of this UserTrunc.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UserTrunc.

        Name of the user  # noqa: E501

        :param name: The name of this UserTrunc.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def user_id(self):
        """Gets the user_id of this UserTrunc.  # noqa: E501

        Unique Identifier for user, recommended to be human readable. Usually this should be username or email Id etc. that user is also aware of.  # noqa: E501

        :return: The user_id of this UserTrunc.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this UserTrunc.

        Unique Identifier for user, recommended to be human readable. Usually this should be username or email Id etc. that user is also aware of.  # noqa: E501

        :param user_id: The user_id of this UserTrunc.  # noqa: E501
        :type: str
        """
        if user_id is None:
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def preferred_gender(self):
        """Gets the preferred_gender of this UserTrunc.  # noqa: E501

        Optional. Preferred gender of the user.  # noqa: E501

        :return: The preferred_gender of this UserTrunc.  # noqa: E501
        :rtype: str
        """
        return self._preferred_gender

    @preferred_gender.setter
    def preferred_gender(self, preferred_gender):
        """Sets the preferred_gender of this UserTrunc.

        Optional. Preferred gender of the user.  # noqa: E501

        :param preferred_gender: The preferred_gender of this UserTrunc.  # noqa: E501
        :type: str
        """
        allowed_values = ["male", "female", "unknown"]  # noqa: E501
        if preferred_gender not in allowed_values:
            raise ValueError(
                "Invalid value for `preferred_gender` ({0}), must be one of {1}"  # noqa: E501
                .format(preferred_gender, allowed_values)
            )

        self._preferred_gender = preferred_gender

    @property
    def role(self):
        """Gets the role of this UserTrunc.  # noqa: E501

        String representing any role that this user may have  # noqa: E501

        :return: The role of this UserTrunc.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this UserTrunc.

        String representing any role that this user may have  # noqa: E501

        :param role: The role of this UserTrunc.  # noqa: E501
        :type: str
        """

        self._role = role

    @property
    def avatar(self):
        """Gets the avatar of this UserTrunc.  # noqa: E501


        :return: The avatar of this UserTrunc.  # noqa: E501
        :rtype: Avatar
        """
        return self._avatar

    @avatar.setter
    def avatar(self, avatar):
        """Sets the avatar of this UserTrunc.


        :param avatar: The avatar of this UserTrunc.  # noqa: E501
        :type: Avatar
        """

        self._avatar = avatar

    @property
    def additional_users(self):
        """Gets the additional_users of this UserTrunc.  # noqa: E501

        Users in addition to the primary user. This is useful in the message authors to capture overlapping speakers.  # noqa: E501

        :return: The additional_users of this UserTrunc.  # noqa: E501
        :rtype: list[UserTrunc]
        """
        return self._additional_users

    @additional_users.setter
    def additional_users(self, additional_users):
        """Sets the additional_users of this UserTrunc.

        Users in addition to the primary user. This is useful in the message authors to capture overlapping speakers.  # noqa: E501

        :param additional_users: The additional_users of this UserTrunc.  # noqa: E501
        :type: list[UserTrunc]
        """

        self._additional_users = additional_users

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserTrunc, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserTrunc):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
