# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EndpointConnectRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'connection_id': 'str',
        'operation': 'str',
        'endpoint': 'Endpoint',
        'intents': 'list[Intent]',
        'endpoint_webhook_url': 'str',
        'callback_url': 'str',
        'headers': 'object',
        'actions': 'list[Action]',
        'languages': 'list[Language]',
        'validation_token': 'str',
        'data': 'EndpointRequestData'
    }

    attribute_map = {
        'connection_id': 'connectionId',
        'operation': 'operation',
        'endpoint': 'endpoint',
        'intents': 'intents',
        'endpoint_webhook_url': 'endpointWebhookUrl',
        'callback_url': 'callbackUrl',
        'headers': 'headers',
        'actions': 'actions',
        'languages': 'languages',
        'validation_token': 'validationToken',
        'data': 'data'
    }

    def __init__(self, connection_id=None, operation=None, endpoint=None, intents=None, endpoint_webhook_url=None, callback_url=None, headers=None, actions=None, languages=None, validation_token=None, data=None):  # noqa: E501
        """EndpointConnectRequest - a model defined in Swagger"""  # noqa: E501
        self._connection_id = None
        self._operation = None
        self._endpoint = None
        self._intents = None
        self._endpoint_webhook_url = None
        self._callback_url = None
        self._headers = None
        self._actions = None
        self._languages = None
        self._validation_token = None
        self._data = None
        self.discriminator = None
        if connection_id is not None:
            self.connection_id = connection_id
        self.operation = operation
        self.endpoint = endpoint
        if intents is not None:
            self.intents = intents
        if endpoint_webhook_url is not None:
            self.endpoint_webhook_url = endpoint_webhook_url
        if callback_url is not None:
            self.callback_url = callback_url
        if headers is not None:
            self.headers = headers
        if actions is not None:
            self.actions = actions
        if languages is not None:
            self.languages = languages
        if validation_token is not None:
            self.validation_token = validation_token
        if data is not None:
            self.data = data

    @property
    def connection_id(self):
        """Gets the connection_id of this EndpointConnectRequest.  # noqa: E501


        :return: The connection_id of this EndpointConnectRequest.  # noqa: E501
        :rtype: str
        """
        return self._connection_id

    @connection_id.setter
    def connection_id(self, connection_id):
        """Sets the connection_id of this EndpointConnectRequest.


        :param connection_id: The connection_id of this EndpointConnectRequest.  # noqa: E501
        :type: str
        """

        self._connection_id = connection_id

    @property
    def operation(self):
        """Gets the operation of this EndpointConnectRequest.  # noqa: E501


        :return: The operation of this EndpointConnectRequest.  # noqa: E501
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """Sets the operation of this EndpointConnectRequest.


        :param operation: The operation of this EndpointConnectRequest.  # noqa: E501
        :type: str
        """
        if operation is None:
            raise ValueError("Invalid value for `operation`, must not be `None`")  # noqa: E501
        allowed_values = ["start", "stop"]  # noqa: E501
        if operation not in allowed_values:
            raise ValueError(
                "Invalid value for `operation` ({0}), must be one of {1}"  # noqa: E501
                .format(operation, allowed_values)
            )

        self._operation = operation

    @property
    def endpoint(self):
        """Gets the endpoint of this EndpointConnectRequest.  # noqa: E501


        :return: The endpoint of this EndpointConnectRequest.  # noqa: E501
        :rtype: Endpoint
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this EndpointConnectRequest.


        :param endpoint: The endpoint of this EndpointConnectRequest.  # noqa: E501
        :type: Endpoint
        """
        if endpoint is None:
            raise ValueError("Invalid value for `endpoint`, must not be `None`")  # noqa: E501

        self._endpoint = endpoint

    @property
    def intents(self):
        """Gets the intents of this EndpointConnectRequest.  # noqa: E501


        :return: The intents of this EndpointConnectRequest.  # noqa: E501
        :rtype: list[Intent]
        """
        return self._intents

    @intents.setter
    def intents(self, intents):
        """Sets the intents of this EndpointConnectRequest.


        :param intents: The intents of this EndpointConnectRequest.  # noqa: E501
        :type: list[Intent]
        """

        self._intents = intents

    @property
    def endpoint_webhook_url(self):
        """Gets the endpoint_webhook_url of this EndpointConnectRequest.  # noqa: E501

        Webhook URL which will be called with results.  # noqa: E501

        :return: The endpoint_webhook_url of this EndpointConnectRequest.  # noqa: E501
        :rtype: str
        """
        return self._endpoint_webhook_url

    @endpoint_webhook_url.setter
    def endpoint_webhook_url(self, endpoint_webhook_url):
        """Sets the endpoint_webhook_url of this EndpointConnectRequest.

        Webhook URL which will be called with results.  # noqa: E501

        :param endpoint_webhook_url: The endpoint_webhook_url of this EndpointConnectRequest.  # noqa: E501
        :type: str
        """

        self._endpoint_webhook_url = endpoint_webhook_url

    @property
    def callback_url(self):
        """Gets the callback_url of this EndpointConnectRequest.  # noqa: E501

        Callback URL which will be called with results.  # noqa: E501

        :return: The callback_url of this EndpointConnectRequest.  # noqa: E501
        :rtype: str
        """
        return self._callback_url

    @callback_url.setter
    def callback_url(self, callback_url):
        """Sets the callback_url of this EndpointConnectRequest.

        Callback URL which will be called with results.  # noqa: E501

        :param callback_url: The callback_url of this EndpointConnectRequest.  # noqa: E501
        :type: str
        """

        self._callback_url = callback_url

    @property
    def headers(self):
        """Gets the headers of this EndpointConnectRequest.  # noqa: E501

        Map of additional headers to be passed in the meetings context  # noqa: E501

        :return: The headers of this EndpointConnectRequest.  # noqa: E501
        :rtype: object
        """
        return self._headers

    @headers.setter
    def headers(self, headers):
        """Sets the headers of this EndpointConnectRequest.

        Map of additional headers to be passed in the meetings context  # noqa: E501

        :param headers: The headers of this EndpointConnectRequest.  # noqa: E501
        :type: object
        """

        self._headers = headers

    @property
    def actions(self):
        """Gets the actions of this EndpointConnectRequest.  # noqa: E501

        actions that should be performed while this connection is active. Currenly only one action is supported - 'sendSummaryEmail'  # noqa: E501

        :return: The actions of this EndpointConnectRequest.  # noqa: E501
        :rtype: list[Action]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """Sets the actions of this EndpointConnectRequest.

        actions that should be performed while this connection is active. Currenly only one action is supported - 'sendSummaryEmail'  # noqa: E501

        :param actions: The actions of this EndpointConnectRequest.  # noqa: E501
        :type: list[Action]
        """

        self._actions = actions

    @property
    def languages(self):
        """Gets the languages of this EndpointConnectRequest.  # noqa: E501


        :return: The languages of this EndpointConnectRequest.  # noqa: E501
        :rtype: list[Language]
        """
        return self._languages

    @languages.setter
    def languages(self, languages):
        """Sets the languages of this EndpointConnectRequest.


        :param languages: The languages of this EndpointConnectRequest.  # noqa: E501
        :type: list[Language]
        """

        self._languages = languages

    @property
    def validation_token(self):
        """Gets the validation_token of this EndpointConnectRequest.  # noqa: E501


        :return: The validation_token of this EndpointConnectRequest.  # noqa: E501
        :rtype: str
        """
        return self._validation_token

    @validation_token.setter
    def validation_token(self, validation_token):
        """Sets the validation_token of this EndpointConnectRequest.


        :param validation_token: The validation_token of this EndpointConnectRequest.  # noqa: E501
        :type: str
        """

        self._validation_token = validation_token

    @property
    def data(self):
        """Gets the data of this EndpointConnectRequest.  # noqa: E501


        :return: The data of this EndpointConnectRequest.  # noqa: E501
        :rtype: EndpointRequestData
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this EndpointConnectRequest.


        :param data: The data of this EndpointConnectRequest.  # noqa: E501
        :type: EndpointRequestData
        """

        self._data = data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EndpointConnectRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EndpointConnectRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
