# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ConversationActionItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'text': 'str',
        'type': 'str',
        'score': 'float',
        'message_ids': 'list[str]',
        'entities': 'list[Tag]',
        'assignee': 'MembersInfo',
        'due_by': 'DueBy'
    }

    attribute_map = {
        'id': 'id',
        'text': 'text',
        'type': 'type',
        'score': 'score',
        'message_ids': 'messageIds',
        'entities': 'entities',
        'assignee': 'assignee',
        'due_by': 'dueBy'
    }

    def __init__(self, id=None, text=None, type=None, score=None, message_ids=None, entities=None, assignee=None, due_by=None):  # noqa: E501
        """ConversationActionItem - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._text = None
        self._type = None
        self._score = None
        self._message_ids = None
        self._entities = None
        self._assignee = None
        self._due_by = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if text is not None:
            self.text = text
        if type is not None:
            self.type = type
        if score is not None:
            self.score = score
        if message_ids is not None:
            self.message_ids = message_ids
        if entities is not None:
            self.entities = entities
        if assignee is not None:
            self.assignee = assignee
        if due_by is not None:
            self.due_by = due_by

    @property
    def id(self):
        """Gets the id of this ConversationActionItem.  # noqa: E501


        :return: The id of this ConversationActionItem.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ConversationActionItem.


        :param id: The id of this ConversationActionItem.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def text(self):
        """Gets the text of this ConversationActionItem.  # noqa: E501


        :return: The text of this ConversationActionItem.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this ConversationActionItem.


        :param text: The text of this ConversationActionItem.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def type(self):
        """Gets the type of this ConversationActionItem.  # noqa: E501


        :return: The type of this ConversationActionItem.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ConversationActionItem.


        :param type: The type of this ConversationActionItem.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def score(self):
        """Gets the score of this ConversationActionItem.  # noqa: E501


        :return: The score of this ConversationActionItem.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this ConversationActionItem.


        :param score: The score of this ConversationActionItem.  # noqa: E501
        :type: float
        """

        self._score = score

    @property
    def message_ids(self):
        """Gets the message_ids of this ConversationActionItem.  # noqa: E501

        Array of message reference ids  # noqa: E501

        :return: The message_ids of this ConversationActionItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._message_ids

    @message_ids.setter
    def message_ids(self, message_ids):
        """Sets the message_ids of this ConversationActionItem.

        Array of message reference ids  # noqa: E501

        :param message_ids: The message_ids of this ConversationActionItem.  # noqa: E501
        :type: list[str]
        """

        self._message_ids = message_ids

    @property
    def entities(self):
        """Gets the entities of this ConversationActionItem.  # noqa: E501


        :return: The entities of this ConversationActionItem.  # noqa: E501
        :rtype: list[Tag]
        """
        return self._entities

    @entities.setter
    def entities(self, entities):
        """Sets the entities of this ConversationActionItem.


        :param entities: The entities of this ConversationActionItem.  # noqa: E501
        :type: list[Tag]
        """

        self._entities = entities

    @property
    def assignee(self):
        """Gets the assignee of this ConversationActionItem.  # noqa: E501


        :return: The assignee of this ConversationActionItem.  # noqa: E501
        :rtype: MembersInfo
        """
        return self._assignee

    @assignee.setter
    def assignee(self, assignee):
        """Sets the assignee of this ConversationActionItem.


        :param assignee: The assignee of this ConversationActionItem.  # noqa: E501
        :type: MembersInfo
        """

        self._assignee = assignee

    @property
    def due_by(self):
        """Gets the due_by of this ConversationActionItem.  # noqa: E501


        :return: The due_by of this ConversationActionItem.  # noqa: E501
        :rtype: DueBy
        """
        return self._due_by

    @due_by.setter
    def due_by(self, due_by):
        """Sets the due_by of this ConversationActionItem.


        :param due_by: The due_by of this ConversationActionItem.  # noqa: E501
        :type: DueBy
        """

        self._due_by = due_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConversationActionItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConversationActionItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
