# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AsyncMessagesFieldInner(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'payload': 'TextPayload',
        '_from': 'FromPayload',
        'duration': 'DurationPayload'
    }

    attribute_map = {
        'payload': 'payload',
        '_from': 'from',
        'duration': 'duration'
    }

    def __init__(self, payload=None, _from=None, duration=None):  # noqa: E501
        """AsyncMessagesFieldInner - a model defined in Swagger"""  # noqa: E501
        self._payload = None
        self.__from = None
        self._duration = None
        self.discriminator = None
        self.payload = payload
        if _from is not None:
            self._from = _from
        if duration is not None:
            self.duration = duration

    @property
    def payload(self):
        """Gets the payload of this AsyncMessagesFieldInner.  # noqa: E501


        :return: The payload of this AsyncMessagesFieldInner.  # noqa: E501
        :rtype: TextPayload
        """
        return self._payload

    @payload.setter
    def payload(self, payload):
        """Sets the payload of this AsyncMessagesFieldInner.


        :param payload: The payload of this AsyncMessagesFieldInner.  # noqa: E501
        :type: TextPayload
        """
        if payload is None:
            raise ValueError("Invalid value for `payload`, must not be `None`")  # noqa: E501

        self._payload = payload

    @property
    def _from(self):
        """Gets the _from of this AsyncMessagesFieldInner.  # noqa: E501


        :return: The _from of this AsyncMessagesFieldInner.  # noqa: E501
        :rtype: FromPayload
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this AsyncMessagesFieldInner.


        :param _from: The _from of this AsyncMessagesFieldInner.  # noqa: E501
        :type: FromPayload
        """

        self.__from = _from

    @property
    def duration(self):
        """Gets the duration of this AsyncMessagesFieldInner.  # noqa: E501


        :return: The duration of this AsyncMessagesFieldInner.  # noqa: E501
        :rtype: DurationPayload
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this AsyncMessagesFieldInner.


        :param duration: The duration of this AsyncMessagesFieldInner.  # noqa: E501
        :type: DurationPayload
        """

        self._duration = duration

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AsyncMessagesFieldInner, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AsyncMessagesFieldInner):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
