# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from symbl_rest.api_client import ApiClient


class ConversationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_action_items_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve action items from conversations  # noqa: E501

        Get all action-items by conversationId. Returns action-item object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_action_items_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: ActionItemListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_action_items_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_action_items_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_action_items_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve action items from conversations  # noqa: E501

        Get all action-items by conversationId. Returns action-item object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_action_items_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: ActionItemListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_action_items_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_action_items_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/action-items', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActionItemListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_conversation_by_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve Conversations  # noqa: E501

        Get a conversation by ID. Returns a conversation object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_by_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: Conversation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_conversation_by_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_conversation_by_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_conversation_by_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve Conversations  # noqa: E501

        Get a conversation by ID. Returns a conversation object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_by_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: Conversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Conversation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_follow_ups_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve follow ups from conversations  # noqa: E501

        Get all follow-ups by conversationId. Returns follow-ups object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_follow_ups_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: FollowUpListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_follow_ups_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_follow_ups_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_follow_ups_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve follow ups from conversations  # noqa: E501

        Get all follow-ups by conversationId. Returns follow-ups object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_follow_ups_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: FollowUpListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_follow_ups_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_follow_ups_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/follow-ups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FollowUpListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_insights_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve insights from Conversations  # noqa: E501

        Get all insights by conversationId. Returns a Insights object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_insights_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: InsightsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_insights_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_insights_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_insights_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve insights from Conversations  # noqa: E501

        Get all insights by conversationId. Returns a Insights object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_insights_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: InsightsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_insights_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_insights_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/insights', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InsightsListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_intents_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve intents from conversation  # noqa: E501

        Get all intents by ID. Returns intents object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_intents_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: IntentListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_intents_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_intents_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_intents_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve intents from conversation  # noqa: E501

        Get all intents by ID. Returns intents object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_intents_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: IntentListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_intents_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_intents_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/intents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IntentListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_members_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve members from Conversations  # noqa: E501

        Get all the members by conversationId. Returns a Members object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_members_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: MemberListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_members_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_members_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_members_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve members from Conversations  # noqa: E501

        Get all the members by conversationId. Returns a Members object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_members_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: MemberListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_members_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_members_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MemberListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_messages_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve messages from Conversations  # noqa: E501

        Get all the messages by conversationId. Returns a Messages object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_messages_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: MessageListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_messages_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_messages_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_messages_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve messages from Conversations  # noqa: E501

        Get all the messages by conversationId. Returns a Messages object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_messages_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: MessageListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_messages_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_messages_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_questions_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve questions from conversation  # noqa: E501

        Get all questions by conversationId. Returns questions object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_questions_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: QuestionListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_questions_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_questions_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_questions_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve questions from conversation  # noqa: E501

        Get all questions by conversationId. Returns questions object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_questions_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: QuestionListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_questions_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_questions_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/questions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuestionListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_topics_by_conversation_id(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve topics from conversation  # noqa: E501

        Get all topics by ID. Returns topics object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_topics_by_conversation_id(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: TopicListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_topics_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_topics_by_conversation_id_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def get_topics_by_conversation_id_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Retrieve topics from conversation  # noqa: E501

        Get all topics by ID. Returns topics object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_topics_by_conversation_id_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :return: TopicListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_topics_by_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_topics_by_conversation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/conversations/{conversationId}/topics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TopicListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
