/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResColorValue;
import brut.androlib.res.data.value.ResDimenValue;
import brut.androlib.res.data.value.ResEmptyValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResFloatValue;
import brut.androlib.res.data.value.ResFractionValue;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.util.Duo;

public class ResValueFactory {
    private final ResPackage mPackage;

    public ResValueFactory(ResPackage package_) {
        this.mPackage = package_;
    }

    public ResScalarValue factory(int type, int value, String rawValue) throws AndrolibException {
        switch (type) {
            case 0: {
                if (value == 0) {
                    return new ResStringValue(null, value);
                }
                if (value == 1) {
                    return new ResEmptyValue(value, rawValue, type);
                }
                return new ResReferenceValue(this.mPackage, 0, null);
            }
            case 1: {
                return this.newReference(value, null);
            }
            case 2: 
            case 8: {
                return this.newReference(value, rawValue, true);
            }
            case 3: {
                return new ResStringValue(rawValue, value);
            }
            case 4: {
                return new ResFloatValue(Float.intBitsToFloat(value), value, rawValue);
            }
            case 5: {
                return new ResDimenValue(value, rawValue);
            }
            case 6: {
                return new ResFractionValue(value, rawValue);
            }
            case 18: {
                return new ResBoolValue(value != 0, value, rawValue);
            }
            case 7: {
                return this.newReference(value, rawValue);
            }
        }
        if (type >= 28 && type <= 31) {
            return new ResColorValue(value, rawValue);
        }
        if (type >= 16 && type <= 31) {
            return new ResIntValue(value, rawValue, type);
        }
        throw new AndrolibException("Invalid value type: " + type);
    }

    public ResIntBasedValue factory(String value, int rawValue) {
        if (value == null) {
            return new ResFileValue("", rawValue);
        }
        if (value.startsWith("res/")) {
            return new ResFileValue(value, rawValue);
        }
        if (value.startsWith("r/") || value.startsWith("R/")) {
            return new ResFileValue(value, rawValue);
        }
        return new ResStringValue(value, rawValue);
    }

    public ResBagValue bagFactory(int parent, Duo<Integer, ResScalarValue>[] items, ResTypeSpec resTypeSpec) throws AndrolibException {
        ResReferenceValue parentVal = this.newReference(parent, null);
        if (items.length == 0) {
            return new ResBagValue(parentVal);
        }
        int key = (Integer)items[0].m1;
        if (key == 0x1000000) {
            return ResAttr.factory(parentVal, items, this, this.mPackage);
        }
        String resTypeName = resTypeSpec.getName();
        if ("array".equals(resTypeName) || key == 0x2000000 || key == 0) {
            return new ResArrayValue(parentVal, items);
        }
        if ("plurals".equals(resTypeName) || key >= 0x1000004 && key <= 0x1000009) {
            return new ResPluralsValue(parentVal, items);
        }
        if ("style".equals(resTypeName)) {
            return new ResStyleValue(parentVal, items, this);
        }
        if ("attr".equals(resTypeName)) {
            return new ResAttr(parentVal, 0, null, null, null);
        }
        throw new AndrolibException("unsupported res type name for bags. Found: " + resTypeName);
    }

    public ResReferenceValue newReference(int resID, String rawValue) {
        return this.newReference(resID, rawValue, false);
    }

    public ResReferenceValue newReference(int resID, String rawValue, boolean theme) {
        return new ResReferenceValue(this.mPackage, resID, rawValue, theme);
    }
}

