# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['for_runners',
 'for_runners.admin',
 'for_runners.gpx_tools',
 'for_runners.management',
 'for_runners.management.commands',
 'for_runners.managers',
 'for_runners.migrations',
 'for_runners.models',
 'for_runners.selectors',
 'for_runners.services',
 'for_runners.signal_handlers',
 'for_runners.tests',
 'for_runners.tests.fixture_files',
 'for_runners.views',
 'for_runners_project',
 'for_runners_project.for_runners_helper_app',
 'for_runners_project.for_runners_helper_app.fixtures',
 'for_runners_project.for_runners_helper_app.management',
 'for_runners_project.for_runners_helper_app.management.commands',
 'for_runners_project.settings',
 'for_runners_project.tests']

package_data = \
{'': ['*'],
 'for_runners': ['static/*',
                 'static/chartjs/*',
                 'static/dygraphs/*',
                 'static/leaflet/*',
                 'static/leaflet/images/*',
                 'templates/admin/for_runners/*',
                 'templates/admin/for_runners/eventmodel/*',
                 'templates/admin/for_runners/gpxmodel/*',
                 'templates/admin/for_runners/gpxmodel/include/*',
                 'templates/for_runners/*',
                 'templates/for_runners/includes/*'],
 'for_runners_project': ['templates/*', 'templates/admin/*']}

install_requires = \
['autotask',
 'bx_django_utils',
 'bx_py_utils',
 'click',
 'colorlog',
 'django-axes',
 'django-dbbackup',
 'django-debug-toolbar',
 'django-import-export',
 'django-processinfo',
 'django-tools',
 'django>=2.2.0,<2.3.0',
 'geopy',
 'gpxpy',
 'gunicorn',
 'lxml',
 'matplotlib',
 'requests',
 'svgwrite']

extras_require = \
{'docker': ['docker-compose'], 'postgres': ['psycopg2-binary']}

entry_points = \
{'console_scripts': ['manage = for_runners_project.manage:main',
                     'publish = for_runners_project.publish:publish',
                     'update_rst_readme = '
                     'for_runners_project.publish:update_readme']}

setup_kwargs = {
    'name': 'django-for-runners',
    'version': '0.12.1',
    'description': 'Store your GPX tracks of your running (or other sports activity) in django.',
    'long_description': '=================\nDjango-ForRunners\n=================\n\n|Logo| Store your GPX tracks of your running (or other sports activity) in django.\n\n.. |Logo| image:: https://raw.githubusercontent.com/jedie/django-for-runners/master/src/for_runners/static/Django-ForRunners128.png\n\n+-----------------------------------+------------------------------------------------+\n| |Build Status on github|          | `github.com/jedie/django-for-runners/actions`_ |\n+-----------------------------------+------------------------------------------------+\n| |Coverage Status on codecov.io|   | `codecov.io/gh/jedie/django-for-runners`_      |\n+-----------------------------------+------------------------------------------------+\n| |Coverage Status on coveralls.io| | `coveralls.io/r/jedie/django-for-runners`_     |\n+-----------------------------------+------------------------------------------------+\n\n.. |Build Status on github| image:: https://github.com/jedie/django-for-runners/workflows/test/badge.svg?branch=master\n.. _github.com/jedie/django-for-runners/actions: https://github.com/jedie/django-for-runners/actions\n.. |Coverage Status on codecov.io| image:: https://codecov.io/gh/jedie/django-for-runners/branch/master/graph/badge.svg\n.. _codecov.io/gh/jedie/django-for-runners: https://codecov.io/gh/jedie/django-for-runners\n.. |Coverage Status on coveralls.io| image:: https://coveralls.io/repos/jedie/django-for-runners/badge.svg\n.. _coveralls.io/r/jedie/django-for-runners: https://coveralls.io/r/jedie/django-for-runners\n\n(The name **Django-ForRunners** has the origin from the great Android tracking app **ForRunners** by Benoît Hervier: `http://rvier.fr/#forrunners <http://rvier.fr/#forrunners>`_ )\n\n---------\nFeatures:\n---------\n\n* GPX track management:\n\n    * Upload GPX tracks\n\n    * Import GPX tracks from commandline\n\n    * Track analysis:\n\n        * basics: Track length / Duration / Pace / Hart rate Up-/Downhill\n\n        * Display route on OpenStreetMap map\n\n        * Graphs with elevation / heart rate / cadence (if available in GPX data)\n\n    * Data that is automatically extracted from the web:\n\n        * Start/finish Address from OpenStreetMap\n\n        * Start/finish weather information from metaweather.com\n\n    * Store additional data:\n\n        * Ideal track distance (for easier grouping/filtering tracks)\n\n* sports competitions Management:\n\n    * Create a List of Sport Events\n\n        * Add participation to a event\n\n        * link GPX track with a event participation\n\n        * Store you event participation:\n\n            * official track length\n\n            * measured finisher time\n\n            * Number of participants who have finished in your discipline\n\n        * Add links to webpages relatet to this event\n\n        * Record costs (entry fee, T-shirt etc.)\n\n* common\n\n    * Multiple user support (However: no rights management and currently only suitable for a handful of users)\n\n-----------------\nProject structure\n-----------------\n\nThere are two main directories:\n\n+---------------------+---------------------------------------------------+\n| directory           | description                                       |\n+=====================+===================================================+\n| **`/src/`_**        | The main  Django-ForRunners source code           |\n+---------------------+---------------------------------------------------+\n| **`/deployment/`_** | deploy  Django-ForRunners for production use case |\n+---------------------+---------------------------------------------------+\n\n.. _/src/: https://github.com/jedie/django-for-runners/tree/master/src\n.. _/deployment/: https://github.com/jedie/django-for-runners/tree/master/deployment\n\n-------\ninstall\n-------\n\nThere exists two kind of installation/usage:\n\n* local development installation using poetry\n\n* production use with docker-compose\n\n* Install as `YunoHost <https://yunohost.org>`_ App via `django-for-runners_ynh <https://github.com/YunoHost-Apps/django-for-runners_ynh>`_\n\nThis README contains only the information about local development installation.\n\nRead `/deployment/README <https://github.com/jedie/django-for-runners/tree/master/deployment#readme>`_ for instruction to install  Django-ForRunners on a root server.\n\nprepare\n=======\n\n::\n\n    ~$ git clone https://github.com/jedie/django-for-runners.git\n    ~$ cd django-for-runners/\n    ~/django-for-runners$ make\n    _________________________________________________________________\n    DjangoForRunners - *dev* Makefile\n    \n    install-poetry         install or update poetry\n    install                install DjangoForRunners via poetry\n    manage-update          Collectstatic + makemigration + migrate\n    update                 update the sources and installation\n    lint                   Run code formatters and linter\n    fix-code-style         Fix code formatting\n    tox-listenvs           List all tox test environments\n    tox                    Run pytest via tox with all environments\n    tox-py36               Run pytest via tox with *python v3.6*\n    tox-py37               Run pytest via tox with *python v3.7*\n    tox-py38               Run pytest via tox with *python v3.8*\n    pytest                 Run pytest\n    update-rst-readme      update README.rst from README.creole\n    publish                Release new version to PyPi\n    run-dev-server         Run the django dev server in endless loop.\n    createsuperuser        Create super user\n    messages               Make and compile locales message files\n    dbbackup               Backup database\n    dbrestore              Restore a database backup\n    run-docker-dev-server  Start docker containers with current dev source code\n\nlocal development installation\n==============================\n\n::\n\n    # install or update Poetry:\n    ~/django-for-runners$ make install-poetry\n    \n    # install  Django-ForRunners via poetry:\n    ~/django-for-runners$ make install\n    ...\n    \n    # Collectstatic + makemigration + migrate:\n    ~/django-for-runners$ make manage-update\n    \n    # Create a django super user:\n    ~/django-for-runners$ ./manage.sh createsuperuser\n    \n    # start local dev. web server:\n    ~/django-for-runners$ make run-dev-server\n\nThe web page is available in Port 8000, e.g.: ``http://127.0.0.1:8000/``\n\nlocal docker dev run\n====================\n\nYou can run the deployment docker containers with current source code with:\n\n::\n\n    ~/django-for-runners$ make run-docker-dev-server\n\nJust hit Cntl-C to stop the containers\n\nThe web page is available on Port 80, e.g.: ``http://localhost/``\n\nimport GPX files\n================\n\ne.g.:\n\n::\n\n    ~/django-for-runners$ poetry run manage import_gpx --username <django_username> ~/backups/gpx_files\n\n**Note:** It is no problem to start **import_gpx** with the same GPX files: Duplicate entries are avoided. The start/finish (time/latitude/longitude) are compared.\n\nbackup\n======\n\nCreate a backup into ``.../backups/<timestamp>/`` e.g.:\n\n::\n\n    ~/django-for-runners$ poetry run for_runners backup\n\nThe backup does:\n\n* backup the database\n\n* export all GPX tracks\n\n* generate .csv files:\n\n* a complete file with all running tracks\n\n* one file for every user\n\nregenerate all SVG files\n========================\n\n::\n\n    ~/django-for-runners$ poetry run for_runners recreate-svg\n\n-----------\nScreenshots\n-----------\n\n(All screenshots are here: `github.com/jedie/jedie.github.io/tree/master/screenshots/django-for-runners <https://github.com/jedie/jedie.github.io/tree/master/screenshots/django-for-runners>`_)\n\n------------------------------------------\nfor-runers v0.6.0 2018-07-31 GPX Track.png\n------------------------------------------\n\n|for-runers v0.6.0 2018-07-31 GPX Track.png|\n\n.. |for-runers v0.6.0 2018-07-31 GPX Track.png| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runers v0.6.0 2018-07-31 GPX Track.png\n\n-----------------------------------------\nfor-runners v0.4.0 2018-6-26 GPX info.png\n-----------------------------------------\n\n|for-runners v0.4.0 2018-6-26 GPX info.png|\n\n.. |for-runners v0.4.0 2018-6-26 GPX info.png| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners v0.4.0 2018-6-26 GPX info.png\n\n---------------------------------------------\nfor-runners v0.6.0 2018-07-19 Event Costs.png\n---------------------------------------------\n\n|for-runners v0.6.0 2018-07-19 Event Costs.png|\n\n.. |for-runners v0.6.0 2018-07-19 Event Costs.png| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners v0.6.0 2018-07-19 Event Costs.png\n\n----------------------\nprint a small overview\n----------------------\n\n|for-runners v0.10.0 2010-06-26 print small overview 1.png|\n\n.. |for-runners v0.10.0 2010-06-26 print small overview 1.png| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners v0.10.0 2010-06-26 print small overview 1.png\n\n|for-runners v0.10.0 2010-06-26 print small overview 2.png|\n\n.. |for-runners v0.10.0 2010-06-26 print small overview 2.png| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners v0.10.0 2010-06-26 print small overview 2.png\n\n---------\nrun tests\n---------\n\n::\n\n    ~/Django-ForRunners$ make test\n    \n    or:\n    \n    ~/Django-ForRunners$ make tox\n\n**Note:**\n\nTo run all tests, you need:\n\n* **Chromium Browser WebDriver** e.g.: ``apt install chromium-chromedriver``\n\n* **Firefox Browser WebDriver** aka **geckodriver**\n\ninstall **geckodriver** e.g.:\n\n::\n\n    ~$ cd /tmp\n    /tmp$ wget https://github.com/mozilla/geckodriver/releases/download/v0.20.1/geckodriver-v0.20.1-linux64.tar.gz -O geckodriver.tar.gz\n    /tmp$ sudo sh -c \'tar -x geckodriver -zf geckodriver.tar.gz -O > /usr/bin/geckodriver\'\n    /tmp$ sudo chmod +x /usr/bin/geckodriver\n    /tmp$ rm geckodriver.tar.gz\n    /tmp$ geckodriver --version\n    geckodriver 0.20.1\n    ...\n\n----------\nsome notes\n----------\n\nGPX storage\n===========\n\nCurrently we store the unchanged GPX data in a TextField.\n\nstatic files\n============\n\nWe collect some JavaScript files, for easier startup. These files are:\n\n+------------------+--------------------------------+---------------------------------+\n| Project Homepage | License                        | storage directory               |\n+==================+================================+=================================+\n| `leafletjs.com`_ | `Leaflet licensed under BSD`_  | `for_runners/static/leaflet/`_  |\n+------------------+--------------------------------+---------------------------------+\n| `dygraphs.com`_  | `dygraphs licensed under MIT`_ | `for_runners/static/dygraphs/`_ |\n+------------------+--------------------------------+---------------------------------+\n| `chartjs.org`_   | `Chart.js licensed under MIT`_ | `for_runners/static/chartjs/`_  |\n+------------------+--------------------------------+---------------------------------+\n\n.. _leafletjs.com: http://leafletjs.com\n.. _Leaflet licensed under BSD: https://github.com/Leaflet/Leaflet/blob/master/LICENSE\n.. _for_runners/static/leaflet/: https://github.com/jedie/django-for-runners/tree/master/for_runners/static/leaflet\n.. _dygraphs.com: http://dygraphs.com\n.. _dygraphs licensed under MIT: https://github.com/danvk/dygraphs/blob/master/LICENSE.txt\n.. _for_runners/static/dygraphs/: https://github.com/jedie/django-for-runners/tree/master/for_runners/static/dygraphs\n.. _chartjs.org: http://www.chartjs.org\n.. _Chart.js licensed under MIT: https://github.com/chartjs/Chart.js/blob/master/LICENSE.md\n.. _for_runners/static/chartjs/: https://github.com/jedie/django-for-runners/tree/master/for_runners/static/chartjs\n\nPrecision of coordinates\n========================\n\nGPX files from Garmin (can) contain:\n\n* latitude with 29 decimal places\n\n* longitude with 28 decimal places\n\n* elevation with 19 decimal places\n\nThe route on OpenStreetMap does not look more detailed, with more than 5 decimal places.\n\nSee also: `https://wiki.openstreetmap.org/wiki/Precision_of_coordinates <https://wiki.openstreetmap.org/wiki/Precision_of_coordinates>`_\n\n--------------------\nDjango compatibility\n--------------------\n\n+--------------------+----------------+---------------+\n| django-for-runners | django version | python        |\n+====================+================+===============+\n| >=v0.11.0          | 2.2.x LTS      | 3.7, 3.8, 3.9 |\n+--------------------+----------------+---------------+\n| >=v0.7.1           | 2.1            | 3.5, 3.6, 3.7 |\n+--------------------+----------------+---------------+\n| v0.5.x             | 2.0            | 3.5, 3.6, 3.7 |\n+--------------------+----------------+---------------+\n\n(See also combinations in `tox.ini <https://github.com/jedie/django-for-runners/blob/master/tox.ini>`_ and `github actions <https://github.com/jedie/django-for-runners/blob/master/.github/workflows/pythonapp.yml>`_)\n\n------------------------------\nBackwards-incompatible changes\n------------------------------\n\nOlder changes, see:\n\n`https://github.com/jedie/django-for-runners/blob/v0.10.1/README.creole#backwards-incompatible-changes <https://github.com/jedie/django-for-runners/blob/v0.10.1/README.creole#backwards-incompatible-changes>`_\n\nv0.12.0\n=======\n\nMove main project sources into "/src/"\nAdd deployment setup into "/development/"\n\n-------\nhistory\n-------\n\n* `compare v0.12.1...master <https://github.com/jedie/django-for-runners/compare/v0.12.1...master>`_ **dev** \n\n    * tbc\n\n* `22.11.2021 - v0.12.1 <https://github.com/jedie/django-for-runners/compare/v0.12.0...v0.12.1>`_:\n\n    * update requirements\n\n* `17.01.2021 - v0.12.0 <https://github.com/jedie/django-for-runners/compare/v0.11.0...v0.12.0>`_:\n\n    * refactor project structure and add a deployment via docker-compose setup\n\n    * installation as YunoHost app: `https://github.com/YunoHost-Apps/django-for-runners_ynh <https://github.com/YunoHost-Apps/django-for-runners_ynh>`_\n\n    * Add django-axes and django-processinfo\n\n    * Mock requests in tests\n\n* `04.07.2020 - v0.11.0 <https://github.com/jedie/django-for-runners/compare/v0.10.1...v0.11.0>`_:\n\n    * refactor gpx import code\n\n    * update tests\n\n    * Use poetry and add Makefile\n\n    * update code style\n\n* `09.08.2019 - v0.10.1 <https://github.com/jedie/django-for-runners/compare/v0.10.0...v0.10.1>`_:\n\n    * Enhance "Event Participation" admin view: Add start date and costs in table\n\n* `26.06.2019 - v0.10.0 <https://github.com/jedie/django-for-runners/compare/v0.9.0...v0.10.0>`_:\n\n    * NEW: GPX Admin action to print a small overview from one or a few tracks\n\n    * Accept optional server bind address, e.g.: ``for_runners run-server 127.0.0.1:8080``\n\n* `02.04.2019 - v0.9.0 <https://github.com/jedie/django-for-runners/compare/v0.8.1...v0.9.0>`_:\n\n    * NEW: Update complete environment installation with: ``for_runners update``\n\n    * Move the SQlite database to virtualenv root dir, e.g.: ``~/Django-ForRunners/Django-ForRunners-database.sqlite3``\n\n    * NEW: save every gpx track to disk\n\n    * NEW: Backup/export via cli: ``$ for_runners backup``\n\n    * NEW: export GPX Data via ``django-import-export``\n\n    * Create xdg-open desktop starter under linux here: ``~/Django-ForRunners/Django-ForRunners``\n\n    * refactor the startup process:\n\n        * auto loop the server process\n\n        * open web browser on first start\n\n        * enable autotask\n\n    * rename ``for_runners_test_project`` to ``for_runners_project``\n\n* `03.09.2018 - v0.8.1 <https://github.com/jedie/django-for-runners/compare/v0.8.0...v0.8.1>`_:\n\n    * Fix "try-out" section in README, again ;(\n\n* `03.09.2018 - v0.8.0 <https://github.com/jedie/django-for-runners/compare/v0.7.1...v0.8.0>`_:\n\n    * NEW: shell script for easier boot/install, see above\n\n* `02.09.2018 - v0.7.1 <https://github.com/jedie/django-for-runners/compare/v0.7.0...v0.7.1>`_:\n\n    * Update to Django 2.1\n\n    * Bugfix Tests\n\n* `02.09.2018 - v0.7.0 <https://github.com/jedie/django-for-runners/compare/v0.6.0...v0.7.0>`_:\n\n    * Use dygraphs in GPX Track change admin view\n\n    * Sync mouse over from Elevation/Headrate/Cadence dygraphs to leaflet open streep map\n\n    * Fix "try-out" section in README (`Thanks adsworth for reporting <https://github.com/jedie/django-for-runners/pull/1>`_)\n\n    * Add links from gpx tracks to other admin change view\n\n    * Bugfixes\n\n    * internals:\n\n        * refactor stuff around track duration/length\n\n        * move manipluation of list_display and list_filter `contributed by adsworth <https://github.com/jedie/django-for-runners/pull/2>`_\n\n* `19.07.2018 - v0.6.0 <https://github.com/jedie/django-for-runners/compare/v0.5.0...v0.6.0>`_:\n\n    * NEW: event participation\n\n    * NEW: costs of event participation (e.g.: entry fee for the competition, cost of a T-Shirt etc.)\n\n    * NEW: Display statistics of events/costs per user and total\n\n* `04.07.2018 - v0.5.0 <https://github.com/jedie/django-for-runners/compare/v0.4.0...v0.5.0>`_:\n\n    * remove Django-CMS\n\n    * update to Django v2.0\n\n    * NOTE: The migrations are simply replaced! So you must delete your database, e.g.: ``src/django-for-runners$ rm test_project_db.sqlite3``\n\n    * Add \'net duration\' field, for the officially measured time and use it for calculations if available.\n\n    * Create django manage command to fill some base data: ``$ ./manage.py fill_basedata``\n\n    * speedup by deactivating some django debug toolbar panels\n\n* `26.06.2018 - v0.4.0 <https://github.com/jedie/django-for-runners/compare/v0.3.0...v0.4.0>`_:\n\n    * combine track filters with statistic views\n\n    * NEW: GPX info (See length, point count and Average distance in meters between the points)\n\n    * NEW: Display GPX metadata\n\n    * Add \'creator\' to every track and use it as changelist filter\n\n    * remove Streetmap image generated via `geotiler <https://pypi.org/project/geotiler/>`_\n\n    * Speedup by using a cache for gpxpy instances\n\n* `23.06.2018 - v0.3.0 <https://github.com/jedie/django-for-runners/compare/v0.2.0...v0.3.0>`_:\n\n    * Start adding statistics (See screenshot above)\n\n    * add weather information from `metaweather.com <https://www.metaweather.com/>`_ to every track\n\n* `21.06.2018 - v0.2.0 <https://github.com/jedie/django-for-runners/compare/v0.1.1...v0.2.0>`_:\n\n    * Display elevations, heart_rates and cadence_values if available\n\n    * Add kilometer markers to OpenStreetMap\n\n* `15.06.2018 - v0.1.1 <https://github.com/jedie/django-for-runners/compare/v0.1.0...v0.1.1>`_:\n\n    * a few bugfixes\n\n* `15.06.2018 - v0.1.0 <https://github.com/jedie/django-for-runners/compare/v0.0.4...v0.1.0>`_:\n\n    * Render interactive OpenStreetMap track map with Leaflet JS\n\n* `12.06.2018 - v0.0.4 <https://github.com/jedie/django-for-runners/compare/v0.0.3...v0.0.4>`_:\n\n    * Better Events model\n\n    * GPX error handling\n\n    * more tests\n\n    * Bugfix for Python 3.5 (Geotiler needs Python 3.6 or later)\n\n* `12.06.2018 - v0.0.3 <https://github.com/jedie/django-for-runners/compare/v0.0.2...v0.0.3>`_:\n\n    * display min/average/max heart rate\n\n    * use autotask to generate the MAP in background\n\n* `31.05.2018 - v0.0.2 <https://github.com/jedie/django-for-runners/compare/v0.0.1...v0.0.2>`_:\n\n    * generate SVG \'icon\' from GPX track\n\n* v0.0.1 - 30.05.2018\n\n    * Just create a pre-alpha release to save the PyPi package name ;)\n\n-----\nlinks\n-----\n\n+----------+-------------------------------------------------+\n| Homepage | `http://github.com/jedie/django-for-runners`_   |\n+----------+-------------------------------------------------+\n| PyPi     | `https://pypi.org/project/django-for-runners/`_ |\n+----------+-------------------------------------------------+\n\n.. _http://github.com/jedie/django-for-runners: http://github.com/jedie/django-for-runners\n.. _https://pypi.org/project/django-for-runners/: https://pypi.org/project/django-for-runners/\n\nactivity exporter\n=================\n\nIt\'s sometimes hard to find a working project for exporting activities.\nSo here tools that i use currently:\n\n* `Garmin-Connect-Export <https://github.com/rsjrny/Garmin-Connect-Export>`_ from rsjrny\n\nalternatives (OpenSource only)\n==============================\n\n* `https://github.com/pytrainer/pytrainer <https://github.com/pytrainer/pytrainer>`_ (Desktop Program)\n\n* `https://github.com/GoldenCheetah/GoldenCheetah/ <https://github.com/GoldenCheetah/GoldenCheetah/>`_ (Desktop Program)\n\nOnline tools:\n\n* `https://www.j-berkemeier.de/ShowGPX.html <https://www.j-berkemeier.de/ShowGPX.html>`_ (de)\n\n-------\ncredits\n-------\n\nThe whole thing is based on many excellent projects. Especially the following:\n\n* `gpxpy <https://pypi.org/project/gpxpy/>`_ GPX file parser\n\n* `Leaflet JS <https://leafletjs.com>`_ A JS library for interactive maps used to render the track on `OpenStreetMap <https://openstreetmap.org/>`_\n\n* `dygraphs <http://dygraphs.com>`_ open source JavaScript charting library\n\n* `Chart.js <https://www.chartjs.org>`_ HTML5 Charts\n\n* `geopy <https://pypi.org/project/geopy/>`_ Get geo location names of the GPX track start/end point\n\n* `matplotlib <https://pypi.org/project/matplotlib/>`_ plotting 2D graphics\n\n* `autotask <https://pypi.org/project/autotask/>`_ schedule background jobs\n\n* `svgwrite <https://pypi.org/project/svgwrite/>`_ Generating SVG file\n\n--------\ndonation\n--------\n\n* `paypal.me/JensDiemer <https://www.paypal.me/JensDiemer>`_\n\n* `Flattr This! <https://flattr.com/submit/auto?uid=jedie&url=https%3A%2F%2Fgithub.com%2Fjedie%2Fdjango-for-runners%2F>`_\n\n* Send `Bitcoins <http://www.bitcoin.org/>`_ to `1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F <https://blockexplorer.com/address/1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F>`_\n\n------------\n\n``Note: this file is generated from README.creole 2021-11-22 23:13:24 with "python-creole"``',
    'author': 'JensDiemer',
    'author_email': 'git@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jedie/django-for-runners',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0.0',
}


setup(**setup_kwargs)
