"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*
Definitions of the different workflow activation jobs returned from [crate::Core::poll_task]. The
lang SDK applies these activation jobs to drive workflows.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import temporalio.api.common.v1.message_pb2
import temporalio.api.enums.v1.workflow_pb2
import temporalio.api.failure.v1.message_pb2
import temporalio.bridge.proto.activity_result.activity_result_pb2
import temporalio.bridge.proto.child_workflow.child_workflow_pb2
import temporalio.bridge.proto.common.common_pb2
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class WorkflowActivation(google.protobuf.message.Message):
    """/ An instruction to the lang sdk to run some workflow code, whether for the first time or from
    / a cached state.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    IS_REPLAYING_FIELD_NUMBER: builtins.int
    HISTORY_LENGTH_FIELD_NUMBER: builtins.int
    JOBS_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """/ The id of the currently active run of the workflow. Also used as a cache key. There may
    / only ever be one active workflow task (and hence activation) of a run at one time.
    """
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """/ The current time as understood by the workflow, which is set by workflow task started events"""
    is_replaying: builtins.bool
    """/ Whether or not the activation is replaying past events"""
    history_length: builtins.int
    """/ Current history length as determined by the event id of the most recently processed event.
    / This ensures that the number is always deterministic
    """
    @property
    def jobs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WorkflowActivationJob
    ]:
        """/ The things to do upon activating the workflow"""
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_replaying: builtins.bool = ...,
        history_length: builtins.int = ...,
        jobs: collections.abc.Iterable[global___WorkflowActivationJob] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["timestamp", b"timestamp"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "history_length",
            b"history_length",
            "is_replaying",
            b"is_replaying",
            "jobs",
            b"jobs",
            "run_id",
            b"run_id",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___WorkflowActivation = WorkflowActivation

class WorkflowActivationJob(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_WORKFLOW_FIELD_NUMBER: builtins.int
    FIRE_TIMER_FIELD_NUMBER: builtins.int
    UPDATE_RANDOM_SEED_FIELD_NUMBER: builtins.int
    QUERY_WORKFLOW_FIELD_NUMBER: builtins.int
    CANCEL_WORKFLOW_FIELD_NUMBER: builtins.int
    SIGNAL_WORKFLOW_FIELD_NUMBER: builtins.int
    RESOLVE_ACTIVITY_FIELD_NUMBER: builtins.int
    NOTIFY_HAS_PATCH_FIELD_NUMBER: builtins.int
    RESOLVE_CHILD_WORKFLOW_EXECUTION_START_FIELD_NUMBER: builtins.int
    RESOLVE_CHILD_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    RESOLVE_SIGNAL_EXTERNAL_WORKFLOW_FIELD_NUMBER: builtins.int
    RESOLVE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_FIELD_NUMBER: builtins.int
    REMOVE_FROM_CACHE_FIELD_NUMBER: builtins.int
    @property
    def start_workflow(self) -> global___StartWorkflow:
        """/ Begin a workflow for the first time"""
    @property
    def fire_timer(self) -> global___FireTimer:
        """/ A timer has fired, allowing whatever was waiting on it (if anything) to proceed"""
    @property
    def update_random_seed(self) -> global___UpdateRandomSeed:
        """/ Workflow was reset. The randomness seed must be updated."""
    @property
    def query_workflow(self) -> global___QueryWorkflow:
        """/ A request to query the workflow was received."""
    @property
    def cancel_workflow(self) -> global___CancelWorkflow:
        """/ A request to cancel the workflow was received."""
    @property
    def signal_workflow(self) -> global___SignalWorkflow:
        """/ A request to signal the workflow was received."""
    @property
    def resolve_activity(self) -> global___ResolveActivity:
        """/ An activity was resolved, result could be completed, failed or cancelled"""
    @property
    def notify_has_patch(self) -> global___NotifyHasPatch:
        """/ A patch marker has been detected and lang is being told that change exists. This
        / job is strange in that it is sent pre-emptively to lang without any corresponding
        / command being sent first.
        """
    @property
    def resolve_child_workflow_execution_start(
        self,
    ) -> global___ResolveChildWorkflowExecutionStart:
        """/ A child workflow execution has started or failed to start"""
    @property
    def resolve_child_workflow_execution(
        self,
    ) -> global___ResolveChildWorkflowExecution:
        """/ A child workflow was resolved, result could be completed or failed"""
    @property
    def resolve_signal_external_workflow(
        self,
    ) -> global___ResolveSignalExternalWorkflow:
        """/ An attempt to signal an external workflow resolved"""
    @property
    def resolve_request_cancel_external_workflow(
        self,
    ) -> global___ResolveRequestCancelExternalWorkflow:
        """/ An attempt to cancel an external workflow resolved"""
    @property
    def remove_from_cache(self) -> global___RemoveFromCache:
        """/ Remove the workflow identified by the [WorkflowActivation] containing this job from the cache
        / after performing the activation.
        /
        / If other job variant are present in the list, this variant will be the last job in the
        / job list. The string value is a reason for eviction.
        """
    def __init__(
        self,
        *,
        start_workflow: global___StartWorkflow | None = ...,
        fire_timer: global___FireTimer | None = ...,
        update_random_seed: global___UpdateRandomSeed | None = ...,
        query_workflow: global___QueryWorkflow | None = ...,
        cancel_workflow: global___CancelWorkflow | None = ...,
        signal_workflow: global___SignalWorkflow | None = ...,
        resolve_activity: global___ResolveActivity | None = ...,
        notify_has_patch: global___NotifyHasPatch | None = ...,
        resolve_child_workflow_execution_start: global___ResolveChildWorkflowExecutionStart
        | None = ...,
        resolve_child_workflow_execution: global___ResolveChildWorkflowExecution
        | None = ...,
        resolve_signal_external_workflow: global___ResolveSignalExternalWorkflow
        | None = ...,
        resolve_request_cancel_external_workflow: global___ResolveRequestCancelExternalWorkflow
        | None = ...,
        remove_from_cache: global___RemoveFromCache | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "cancel_workflow",
            b"cancel_workflow",
            "fire_timer",
            b"fire_timer",
            "notify_has_patch",
            b"notify_has_patch",
            "query_workflow",
            b"query_workflow",
            "remove_from_cache",
            b"remove_from_cache",
            "resolve_activity",
            b"resolve_activity",
            "resolve_child_workflow_execution",
            b"resolve_child_workflow_execution",
            "resolve_child_workflow_execution_start",
            b"resolve_child_workflow_execution_start",
            "resolve_request_cancel_external_workflow",
            b"resolve_request_cancel_external_workflow",
            "resolve_signal_external_workflow",
            b"resolve_signal_external_workflow",
            "signal_workflow",
            b"signal_workflow",
            "start_workflow",
            b"start_workflow",
            "update_random_seed",
            b"update_random_seed",
            "variant",
            b"variant",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cancel_workflow",
            b"cancel_workflow",
            "fire_timer",
            b"fire_timer",
            "notify_has_patch",
            b"notify_has_patch",
            "query_workflow",
            b"query_workflow",
            "remove_from_cache",
            b"remove_from_cache",
            "resolve_activity",
            b"resolve_activity",
            "resolve_child_workflow_execution",
            b"resolve_child_workflow_execution",
            "resolve_child_workflow_execution_start",
            b"resolve_child_workflow_execution_start",
            "resolve_request_cancel_external_workflow",
            b"resolve_request_cancel_external_workflow",
            "resolve_signal_external_workflow",
            b"resolve_signal_external_workflow",
            "signal_workflow",
            b"signal_workflow",
            "start_workflow",
            b"start_workflow",
            "update_random_seed",
            b"update_random_seed",
            "variant",
            b"variant",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["variant", b"variant"]
    ) -> typing_extensions.Literal[
        "start_workflow",
        "fire_timer",
        "update_random_seed",
        "query_workflow",
        "cancel_workflow",
        "signal_workflow",
        "resolve_activity",
        "notify_has_patch",
        "resolve_child_workflow_execution_start",
        "resolve_child_workflow_execution",
        "resolve_signal_external_workflow",
        "resolve_request_cancel_external_workflow",
        "remove_from_cache",
    ] | None: ...

global___WorkflowActivationJob = WorkflowActivationJob

class StartWorkflow(google.protobuf.message.Message):
    """Start a new workflow"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: temporalio.api.common.v1.message_pb2.Payload | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    RANDOMNESS_SEED_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    PARENT_WORKFLOW_INFO_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    CONTINUED_FROM_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    CONTINUED_INITIATOR_FIELD_NUMBER: builtins.int
    CONTINUED_FAILURE_FIELD_NUMBER: builtins.int
    LAST_COMPLETION_RESULT_FIELD_NUMBER: builtins.int
    FIRST_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    CRON_SCHEDULE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_EXPIRATION_TIME_FIELD_NUMBER: builtins.int
    CRON_SCHEDULE_TO_SCHEDULE_INTERVAL_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    workflow_type: builtins.str
    """The identifier the lang-specific sdk uses to execute workflow code"""
    workflow_id: builtins.str
    """The workflow id used on the temporal server"""
    @property
    def arguments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]:
        """Inputs to the workflow code"""
    randomness_seed: builtins.int
    """The seed must be used to initialize the random generator used by SDK.
    RandomSeedUpdatedAttributes are used to deliver seed updates.
    """
    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        builtins.str, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """Used to add metadata e.g. for tracing and auth, meant to be read and written to by interceptors."""
    identity: builtins.str
    """Identity of the client who requested this execution"""
    @property
    def parent_workflow_info(
        self,
    ) -> temporalio.bridge.proto.common.common_pb2.NamespacedWorkflowExecution:
        """If this workflow is a child, information about the parent"""
    @property
    def workflow_execution_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Total workflow execution timeout including retries and continue as new."""
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow run."""
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow task."""
    continued_from_execution_run_id: builtins.str
    """Run id of the previous workflow which continued-as-new or retired or cron executed into this
    workflow, if any.
    """
    continued_initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType
    """If this workflow was a continuation, indicates the type of continuation."""
    @property
    def continued_failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """If this workflow was a continuation and that continuation failed, the details of that."""
    @property
    def last_completion_result(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """If this workflow was a continuation and that continuation completed, the details of that."""
    first_execution_run_id: builtins.str
    """This is the very first run id the workflow ever had, following continuation chains."""
    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy:
        """This workflow's retry policy"""
    attempt: builtins.int
    """Starting at 1, the number of times we have tried to execute this workflow"""
    cron_schedule: builtins.str
    """If this workflow runs on a cron schedule, it will appear here"""
    @property
    def workflow_execution_expiration_time(
        self,
    ) -> google.protobuf.timestamp_pb2.Timestamp:
        """The absolute time at which the workflow will be timed out.
        This is passed without change to the next run/retry of a workflow.
        """
    @property
    def cron_schedule_to_schedule_interval(
        self,
    ) -> google.protobuf.duration_pb2.Duration:
        """For a cron workflow, this contains the amount of time between when this iteration of
        the cron workflow was scheduled and when it should run next per its cron_schedule.
        """
    @property
    def memo(self) -> temporalio.api.common.v1.message_pb2.Memo:
        """User-defined memo"""
    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes:
        """Search attributes created/updated when this workflow was started"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the workflow execution started event was first written"""
    def __init__(
        self,
        *,
        workflow_type: builtins.str = ...,
        workflow_id: builtins.str = ...,
        arguments: collections.abc.Iterable[
            temporalio.api.common.v1.message_pb2.Payload
        ]
        | None = ...,
        randomness_seed: builtins.int = ...,
        headers: collections.abc.Mapping[
            builtins.str, temporalio.api.common.v1.message_pb2.Payload
        ]
        | None = ...,
        identity: builtins.str = ...,
        parent_workflow_info: temporalio.bridge.proto.common.common_pb2.NamespacedWorkflowExecution
        | None = ...,
        workflow_execution_timeout: google.protobuf.duration_pb2.Duration | None = ...,
        workflow_run_timeout: google.protobuf.duration_pb2.Duration | None = ...,
        workflow_task_timeout: google.protobuf.duration_pb2.Duration | None = ...,
        continued_from_execution_run_id: builtins.str = ...,
        continued_initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType = ...,
        continued_failure: temporalio.api.failure.v1.message_pb2.Failure | None = ...,
        last_completion_result: temporalio.api.common.v1.message_pb2.Payloads
        | None = ...,
        first_execution_run_id: builtins.str = ...,
        retry_policy: temporalio.api.common.v1.message_pb2.RetryPolicy | None = ...,
        attempt: builtins.int = ...,
        cron_schedule: builtins.str = ...,
        workflow_execution_expiration_time: google.protobuf.timestamp_pb2.Timestamp
        | None = ...,
        cron_schedule_to_schedule_interval: google.protobuf.duration_pb2.Duration
        | None = ...,
        memo: temporalio.api.common.v1.message_pb2.Memo | None = ...,
        search_attributes: temporalio.api.common.v1.message_pb2.SearchAttributes
        | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "continued_failure",
            b"continued_failure",
            "cron_schedule_to_schedule_interval",
            b"cron_schedule_to_schedule_interval",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "parent_workflow_info",
            b"parent_workflow_info",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "start_time",
            b"start_time",
            "workflow_execution_expiration_time",
            b"workflow_execution_expiration_time",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "arguments",
            b"arguments",
            "attempt",
            b"attempt",
            "continued_failure",
            b"continued_failure",
            "continued_from_execution_run_id",
            b"continued_from_execution_run_id",
            "continued_initiator",
            b"continued_initiator",
            "cron_schedule",
            b"cron_schedule",
            "cron_schedule_to_schedule_interval",
            b"cron_schedule_to_schedule_interval",
            "first_execution_run_id",
            b"first_execution_run_id",
            "headers",
            b"headers",
            "identity",
            b"identity",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "parent_workflow_info",
            b"parent_workflow_info",
            "randomness_seed",
            b"randomness_seed",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "start_time",
            b"start_time",
            "workflow_execution_expiration_time",
            b"workflow_execution_expiration_time",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_id",
            b"workflow_id",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___StartWorkflow = StartWorkflow

class FireTimer(google.protobuf.message.Message):
    """/ Notify a workflow that a timer has fired"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEQ_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Sequence number as provided by lang in the corresponding StartTimer command"""
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["seq", b"seq"]
    ) -> None: ...

global___FireTimer = FireTimer

class ResolveActivity(google.protobuf.message.Message):
    """/ Notify a workflow that an activity has been resolved"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEQ_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Sequence number as provided by lang in the corresponding ScheduleActivity command"""
    @property
    def result(
        self,
    ) -> temporalio.bridge.proto.activity_result.activity_result_pb2.ActivityResolution: ...
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        result: temporalio.bridge.proto.activity_result.activity_result_pb2.ActivityResolution
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["result", b"result", "seq", b"seq"]
    ) -> None: ...

global___ResolveActivity = ResolveActivity

class ResolveChildWorkflowExecutionStart(google.protobuf.message.Message):
    """/ Notify a workflow that a start child workflow execution request has succeeded, failed or was
    / cancelled.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEQ_FIELD_NUMBER: builtins.int
    SUCCEEDED_FIELD_NUMBER: builtins.int
    FAILED_FIELD_NUMBER: builtins.int
    CANCELLED_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Sequence number as provided by lang in the corresponding StartChildWorkflowExecution command"""
    @property
    def succeeded(self) -> global___ResolveChildWorkflowExecutionStartSuccess: ...
    @property
    def failed(self) -> global___ResolveChildWorkflowExecutionStartFailure: ...
    @property
    def cancelled(self) -> global___ResolveChildWorkflowExecutionStartCancelled: ...
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        succeeded: global___ResolveChildWorkflowExecutionStartSuccess | None = ...,
        failed: global___ResolveChildWorkflowExecutionStartFailure | None = ...,
        cancelled: global___ResolveChildWorkflowExecutionStartCancelled | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "cancelled",
            b"cancelled",
            "failed",
            b"failed",
            "status",
            b"status",
            "succeeded",
            b"succeeded",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cancelled",
            b"cancelled",
            "failed",
            b"failed",
            "seq",
            b"seq",
            "status",
            b"status",
            "succeeded",
            b"succeeded",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["status", b"status"]
    ) -> typing_extensions.Literal["succeeded", "failed", "cancelled"] | None: ...

global___ResolveChildWorkflowExecutionStart = ResolveChildWorkflowExecutionStart

class ResolveChildWorkflowExecutionStartSuccess(google.protobuf.message.Message):
    """/ Simply pass the run_id to lang"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["run_id", b"run_id"]
    ) -> None: ...

global___ResolveChildWorkflowExecutionStartSuccess = (
    ResolveChildWorkflowExecutionStartSuccess
)

class ResolveChildWorkflowExecutionStartFailure(google.protobuf.message.Message):
    """/ Provide lang the cause of failure"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    CAUSE_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """/ Lang should have this information but it's more convenient to pass it back
    / for error construction on the lang side.
    """
    workflow_type: builtins.str
    cause: temporalio.bridge.proto.child_workflow.child_workflow_pb2.StartChildWorkflowExecutionFailedCause.ValueType
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
        workflow_type: builtins.str = ...,
        cause: temporalio.bridge.proto.child_workflow.child_workflow_pb2.StartChildWorkflowExecutionFailedCause.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cause",
            b"cause",
            "workflow_id",
            b"workflow_id",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ResolveChildWorkflowExecutionStartFailure = (
    ResolveChildWorkflowExecutionStartFailure
)

class ResolveChildWorkflowExecutionStartCancelled(google.protobuf.message.Message):
    """/ `failure` should be ChildWorkflowFailure with cause set to CancelledFailure.
    / The failure is constructed in core for lang's convenience.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILURE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    def __init__(
        self,
        *,
        failure: temporalio.api.failure.v1.message_pb2.Failure | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> None: ...

global___ResolveChildWorkflowExecutionStartCancelled = (
    ResolveChildWorkflowExecutionStartCancelled
)

class ResolveChildWorkflowExecution(google.protobuf.message.Message):
    """/ Notify a workflow that a child workflow execution has been resolved"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEQ_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Sequence number as provided by lang in the corresponding StartChildWorkflowExecution command"""
    @property
    def result(
        self,
    ) -> temporalio.bridge.proto.child_workflow.child_workflow_pb2.ChildWorkflowResult: ...
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        result: temporalio.bridge.proto.child_workflow.child_workflow_pb2.ChildWorkflowResult
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["result", b"result", "seq", b"seq"]
    ) -> None: ...

global___ResolveChildWorkflowExecution = ResolveChildWorkflowExecution

class UpdateRandomSeed(google.protobuf.message.Message):
    """/ Update the workflow's random seed"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RANDOMNESS_SEED_FIELD_NUMBER: builtins.int
    randomness_seed: builtins.int
    def __init__(
        self,
        *,
        randomness_seed: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["randomness_seed", b"randomness_seed"],
    ) -> None: ...

global___UpdateRandomSeed = UpdateRandomSeed

class QueryWorkflow(google.protobuf.message.Message):
    """/ Query a workflow"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: temporalio.api.common.v1.message_pb2.Payload | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    QUERY_ID_FIELD_NUMBER: builtins.int
    QUERY_TYPE_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    query_id: builtins.str
    """/ For PollWFTResp `query` field, this will be set to the special value `legacy`. For the
    / `queries` field, the server provides a unique identifier. If it is a `legacy` query,
    / lang cannot issue any commands in response other than to answer the query.
    """
    query_type: builtins.str
    """/ The query's function/method/etc name"""
    @property
    def arguments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]: ...
    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        builtins.str, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Headers attached to the query"""
    def __init__(
        self,
        *,
        query_id: builtins.str = ...,
        query_type: builtins.str = ...,
        arguments: collections.abc.Iterable[
            temporalio.api.common.v1.message_pb2.Payload
        ]
        | None = ...,
        headers: collections.abc.Mapping[
            builtins.str, temporalio.api.common.v1.message_pb2.Payload
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "arguments",
            b"arguments",
            "headers",
            b"headers",
            "query_id",
            b"query_id",
            "query_type",
            b"query_type",
        ],
    ) -> None: ...

global___QueryWorkflow = QueryWorkflow

class CancelWorkflow(google.protobuf.message.Message):
    """/ Cancel a running workflow"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DETAILS_FIELD_NUMBER: builtins.int
    @property
    def details(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Information from the cancellation request"""
    def __init__(
        self,
        *,
        details: collections.abc.Iterable[temporalio.api.common.v1.message_pb2.Payload]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["details", b"details"]
    ) -> None: ...

global___CancelWorkflow = CancelWorkflow

class SignalWorkflow(google.protobuf.message.Message):
    """Send a signal to a workflow"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: temporalio.api.common.v1.message_pb2.Payload | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    SIGNAL_NAME_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    signal_name: builtins.str
    @property
    def input(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]: ...
    identity: builtins.str
    """Identity of the sender of the signal"""
    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        builtins.str, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """Headers attached to the signal"""
    def __init__(
        self,
        *,
        signal_name: builtins.str = ...,
        input: collections.abc.Iterable[temporalio.api.common.v1.message_pb2.Payload]
        | None = ...,
        identity: builtins.str = ...,
        headers: collections.abc.Mapping[
            builtins.str, temporalio.api.common.v1.message_pb2.Payload
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "headers",
            b"headers",
            "identity",
            b"identity",
            "input",
            b"input",
            "signal_name",
            b"signal_name",
        ],
    ) -> None: ...

global___SignalWorkflow = SignalWorkflow

class NotifyHasPatch(google.protobuf.message.Message):
    """Inform lang what the result of a call to `patched` or similar API should be -- this is always
    sent pre-emptively, so any time it is sent the change is present
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATCH_ID_FIELD_NUMBER: builtins.int
    patch_id: builtins.str
    def __init__(
        self,
        *,
        patch_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["patch_id", b"patch_id"]
    ) -> None: ...

global___NotifyHasPatch = NotifyHasPatch

class ResolveSignalExternalWorkflow(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEQ_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Sequence number as provided by lang in the corresponding SignalExternalWorkflowExecution
    / command
    """
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """/ If populated, this signal either failed to be sent or was cancelled depending on failure
        / type / info.
        """
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        failure: temporalio.api.failure.v1.message_pb2.Failure | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["failure", b"failure", "seq", b"seq"],
    ) -> None: ...

global___ResolveSignalExternalWorkflow = ResolveSignalExternalWorkflow

class ResolveRequestCancelExternalWorkflow(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEQ_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Sequence number as provided by lang in the corresponding
    / RequestCancelExternalWorkflowExecution command
    """
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """/ If populated, this signal either failed to be sent or was cancelled depending on failure
        / type / info.
        """
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        failure: temporalio.api.failure.v1.message_pb2.Failure | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["failure", b"failure", "seq", b"seq"],
    ) -> None: ...

global___ResolveRequestCancelExternalWorkflow = ResolveRequestCancelExternalWorkflow

class RemoveFromCache(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EvictionReason:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EvictionReasonEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            RemoveFromCache._EvictionReason.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: RemoveFromCache._EvictionReason.ValueType  # 0
        CACHE_FULL: RemoveFromCache._EvictionReason.ValueType  # 1
        """Workflow cache is full"""
        CACHE_MISS: RemoveFromCache._EvictionReason.ValueType  # 2
        """Workflow received a partial task but was not in the cache. Typically it won't be in the
        lang cache either at this point, but we send an eviction to be sure.
        """
        NONDETERMINISM: RemoveFromCache._EvictionReason.ValueType  # 3
        """The workflow produced results inconsistent with history."""
        LANG_FAIL: RemoveFromCache._EvictionReason.ValueType  # 4
        """The lang side completed the workflow activation with a failure."""
        LANG_REQUESTED: RemoveFromCache._EvictionReason.ValueType  # 5
        """The lang side explicitly requested this workflow be evicted."""
        TASK_NOT_FOUND: RemoveFromCache._EvictionReason.ValueType  # 6
        """The workflow task we tried to respond to didn't exist. The workflow might have already
        finished, or the WFT timed out but we didn't learn about that yet.
        """
        UNHANDLED_COMMAND: RemoveFromCache._EvictionReason.ValueType  # 7
        """There was new work that must be handled while we attempted to complete the WFT. Ex:
        a new signal came in while trying to complete the workflow.
        """
        FATAL: RemoveFromCache._EvictionReason.ValueType  # 8
        """There was some fatal error processing the workflow, typically an internal error, but
        can also happen if then network drops out while paginating. Check message string.
        """

    class EvictionReason(_EvictionReason, metaclass=_EvictionReasonEnumTypeWrapper): ...
    UNSPECIFIED: RemoveFromCache.EvictionReason.ValueType  # 0
    CACHE_FULL: RemoveFromCache.EvictionReason.ValueType  # 1
    """Workflow cache is full"""
    CACHE_MISS: RemoveFromCache.EvictionReason.ValueType  # 2
    """Workflow received a partial task but was not in the cache. Typically it won't be in the
    lang cache either at this point, but we send an eviction to be sure.
    """
    NONDETERMINISM: RemoveFromCache.EvictionReason.ValueType  # 3
    """The workflow produced results inconsistent with history."""
    LANG_FAIL: RemoveFromCache.EvictionReason.ValueType  # 4
    """The lang side completed the workflow activation with a failure."""
    LANG_REQUESTED: RemoveFromCache.EvictionReason.ValueType  # 5
    """The lang side explicitly requested this workflow be evicted."""
    TASK_NOT_FOUND: RemoveFromCache.EvictionReason.ValueType  # 6
    """The workflow task we tried to respond to didn't exist. The workflow might have already
    finished, or the WFT timed out but we didn't learn about that yet.
    """
    UNHANDLED_COMMAND: RemoveFromCache.EvictionReason.ValueType  # 7
    """There was new work that must be handled while we attempted to complete the WFT. Ex:
    a new signal came in while trying to complete the workflow.
    """
    FATAL: RemoveFromCache.EvictionReason.ValueType  # 8
    """There was some fatal error processing the workflow, typically an internal error, but
    can also happen if then network drops out while paginating. Check message string.
    """

    MESSAGE_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    message: builtins.str
    reason: global___RemoveFromCache.EvictionReason.ValueType
    def __init__(
        self,
        *,
        message: builtins.str = ...,
        reason: global___RemoveFromCache.EvictionReason.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "message", b"message", "reason", b"reason"
        ],
    ) -> None: ...

global___RemoveFromCache = RemoveFromCache
