"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Used internally to bootstrap the worker nodes
 * This sets the max pods based on the instanceType created
 * ref: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI
 */
const MAX_PODS = Object.freeze(new Map([
    ['c4.large', 29],
    ['c4.xlarge', 58],
    ['c4.2xlarge', 58],
    ['c4.4xlarge', 234],
    ['c4.8xlarge', 234],
    ['c5.large', 29],
    ['c5.xlarge', 58],
    ['c5.2xlarge', 58],
    ['c5.4xlarge', 234],
    ['c5.9xlarge', 234],
    ['c5.18xlarge', 737],
    ['i3.large', 29],
    ['i3.xlarge', 58],
    ['i3.2xlarge', 58],
    ['i3.4xlarge', 234],
    ['i3.8xlarge', 234],
    ['i3.16xlarge', 737],
    ['m3.medium', 12],
    ['m3.large', 29],
    ['m3.xlarge', 58],
    ['m3.2xlarge', 118],
    ['m4.large', 20],
    ['m4.xlarge', 58],
    ['m4.2xlarge', 58],
    ['m4.4xlarge', 234],
    ['m4.10xlarge', 234],
    ['m5.large', 29],
    ['m5.xlarge', 58],
    ['m5.2xlarge', 58],
    ['m5.4xlarge', 234],
    ['m5.12xlarge', 234],
    ['m5.24xlarge', 737],
    ['p2.xlarge', 58],
    ['p2.8xlarge', 234],
    ['p2.16xlarge', 234],
    ['p3.2xlarge', 58],
    ['p3.8xlarge', 234],
    ['p3.16xlarge', 234],
    ['r3.xlarge', 58],
    ['r3.2xlarge', 58],
    ['r3.4xlarge', 234],
    ['r3.8xlarge', 234],
    ['r4.large', 29],
    ['r4.xlarge', 58],
    ['r4.2xlarge', 58],
    ['r4.4xlarge', 234],
    ['r4.8xlarge', 234],
    ['r4.16xlarge', 735],
    ['t2.small', 8],
    ['t2.medium', 17],
    ['t2.large', 35],
    ['t2.xlarge', 44],
    ['t2.2xlarge', 44],
    ['x1.16xlarge', 234],
    ['x1.32xlarge', 234],
]));
function maxPodsForInstanceType(instanceType) {
    const num = MAX_PODS.get(instanceType.toString());
    if (num === undefined) {
        throw new Error(`Instance type not supported for EKS: ${instanceType.toString()}. Please pick a different instance type.`);
    }
    return num;
}
exports.maxPodsForInstanceType = maxPodsForInstanceType;
//# sourceMappingURL=data:application/json;base64,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